/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.sql.intentions.SqlIntentionActionBase;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQualifyIdentifierIntention
extends SqlIntentionActionBase {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Qualify identifier" == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(1);
        }
        return "Qualify identifier";
    }

    @Nullable
    private static SqlIdentifier getTopmostIdentifier(@NotNull PsiElement element) {
        SqlIdentifier identifier;
        if (element == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(2);
        }
        if ((identifier = SqlIntentionUtil.getIdentifier(element)) == null) {
            return null;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)identifier.getParent(), SqlReferenceExpression.class);
        while (ref != null && ref.getQualifierExpression() != null) {
            ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getQualifierExpression(), SqlReferenceExpression.class);
        }
        return ref == null ? identifier : ref.getIdentifier();
    }

    @Nullable
    private static String getName(@Nullable Object object) {
        DasObject obj = (DasObject)ObjectUtils.tryCast((Object)object, DasObject.class);
        if (obj != null && obj.getKind() != ObjectKind.NONE) {
            return StringUtil.nullize((String)obj.getName());
        }
        if (object instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)object).getName();
        }
        if (object instanceof SqlFunctionCallExpression) {
            SqlReferenceExpression element = ((SqlFunctionCallExpression)object).getNameElement();
            return element == null ? null : element.getName();
        }
        return null;
    }

    @NotNull
    private static Collection<String> getParentObjects(@Nullable SqlIdentifier identifier) {
        DasObject res;
        if (identifier == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                SqlQualifyIdentifierIntention.$$$reportNull$$$0(3);
            }
            return list;
        }
        LinkedHashSet parents = ContainerUtil.newLinkedHashSet();
        PsiElement parent = identifier.getParent();
        PsiPolyVariantReference ref = (PsiPolyVariantReference)ObjectUtils.tryCast((Object)parent.getReference(), PsiPolyVariantReference.class);
        if (ref != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ref.multiResolve(false)) {
                SqlResolveResult sqlResult = (SqlResolveResult)ObjectUtils.tryCast((Object)result2, SqlResolveResult.class);
                if (sqlResult == null) continue;
                if (sqlResult.getQualifier() != null) {
                    ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(sqlResult.getQualifier()));
                    continue;
                }
                DasObject object = (DasObject)ObjectUtils.tryCast((Object)sqlResult.getElement(), DasObject.class);
                if (object != null) {
                    object = object.getDbParent();
                }
                ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(object));
            }
        }
        if ((res = (DasObject)ObjectUtils.tryCast((Object)parent, DasObject.class)) != null) {
            res = res.getDbParent();
        }
        if (res != null) {
            ContainerUtil.addIfNotNull((Collection)parents, (Object)SqlQualifyIdentifierIntention.getName(res));
        }
        LinkedHashSet linkedHashSet = parents;
        if (linkedHashSet == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        SqlIdentifier identifier;
        Collection<String> objects;
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(6);
        }
        return !(objects = SqlQualifyIdentifierIntention.getParentObjects(identifier = SqlQualifyIdentifierIntention.getTopmostIdentifier(element))).isEmpty();
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlIdentifier identifier;
        if (project == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            SqlQualifyIdentifierIntention.$$$reportNull$$$0(8);
        }
        if ((identifier = SqlQualifyIdentifierIntention.getTopmostIdentifier(element)) == null) {
            return;
        }
        ArrayList objects = ContainerUtil.newArrayList(SqlQualifyIdentifierIntention.getParentObjects(identifier));
        SqlIntentionUtil.qualifyReference(JBIterable.from((Iterable)objects).transform(Collections::singleton).toList(), identifier, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlQualifyIdentifierIntention";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostIdentifier";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

