/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlAlterTableStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlSynonymDefinition;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImplUtil {
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element -> element.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element -> element.getName();
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        return syntaxTraverser;
    }

    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        return element -> {
            if (types == null) {
                SqlImplUtil.$$$reportNull$$$0(98);
            }
            return ArrayUtil.contains((Object)element.getNode().getElementType(), (Object[])types);
        };
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(3);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlElement> sqlElements(@NotNull PsiElement root2) {
        if (root2 == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root2).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root2), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(6);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        ASTNode node = element == null ? null : element.getNode();
        return node == null ? null : node.getElementType();
    }

    @NotNull
    public static ResolveState setQualified(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        PsiElement qual;
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        if ((qual = (PsiElement)state.get(CURRENT_QUALIFIER)) != null || qualifier == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(10);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(CURRENT_QUALIFIER, (Object)qualifier);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        return resolveState;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results;
        ResolveResult[] resolveResultArray = results = ref == null ? null : ref.multiResolve(false);
        if (results == null || results.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        ArrayList res = ContainerUtil.newArrayList();
        for (ResolveResult result2 : results) {
            SqlResolveResult item = (SqlResolveResult)ObjectUtils.tryCast((Object)result2, SqlResolveResult.class);
            res.add(Pair.create((Object)(item == null ? null : item.getQualifier()), (Object)result2.getElement()));
        }
        ArrayList arrayList = res;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<ObjectKind> result2) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(16);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result2.add(type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = ContainerUtil.newLinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = result2.add(cur);
            if (--curSize == 0 && minLevel > 0 && ++curLevel == minLevel - 1) {
                result2.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<DbDataSource> dataSources) {
        DbDataSource dataSource;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        if (dataSources == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        DasModel model = (dataSource = (DbDataSource)Iterables.getFirst(dataSources, null)) == null ? DasUtil.emptyModel() : dataSource.getModel();
        SqlLanguageDialectEx sqlLanguageDialectEx = model == DasUtil.emptyModel() ? dialect : model;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        return sqlLanguageDialectEx;
    }

    @Nullable
    public static String getActualName(Object o, @Nullable String name, boolean isPlain, @NotNull CasingProvider casing) {
        ObjectKind kind;
        if (casing == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        if (name == null || name == NULL_STRING) {
            return null;
        }
        ObjectKind objectKind = o instanceof DasObject ? ((DasObject)o).getKind() : (kind = o instanceof SqlReferenceExpression ? ((SqlReferenceExpression)o).getReferenceElementType().getTargetKind() : ObjectKind.TABLE);
        if (kind == ObjectKind.SCHEMA && StringUtil.isEmpty((String)name) && o instanceof DbElement) {
            return QNameUtil.getQualifiedName((DbElement)o);
        }
        Casing casing1 = casing.getCasing(kind, o instanceof DasObject ? (DasObject)o : null);
        return casing1.choose(isPlain).apply(name);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(21);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, @Nullable Condition<PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.FakeDefinition mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(24);
        }
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        Couple<SqlFileImpl.FakeDefinition> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.FakeDefinition fakeDefinition = mirrorPair.second != null ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.second) : (mirror = o.getKind() == ObjectKind.BODY ? (SqlFileImpl.FakeDefinition)((Object)mirrorPair.first) : null);
        if (mirror != null) {
            result2.add(mirror);
            mirror.delegates().addAllTo((Collection)result2);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult resolveResult : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = resolveResult.getElement();
                    result2.add(element);
                }
            } else {
                PsiElement element = reference.resolve();
                result2.add(element);
            }
        }
        return result2;
    }

    @NotNull
    public static Couple<SqlFileImpl.FakeDefinition> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.FakeDefinition> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(26);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        return couple;
    }

    public static boolean processObjectParents(PsiElement object, PsiScopeProcessor processor, ResolveState resolveState) {
        while (object != null) {
            if (!processor.execute(object, resolveState)) {
                return false;
            }
            if (!(object instanceof DasObject)) break;
            object = (PsiElement)ObjectUtils.tryCast((Object)((DasObject)object).getDbParent(), PsiElement.class);
        }
        return true;
    }

    public static boolean processQualifier(SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            return true;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, PsiScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(28);
        }
        ResolveResult[] results = reference.multiResolve(false);
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        SqlType type = reference.getSqlType();
        if (type instanceof SqlTableType) {
            SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, resolveState);
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected((PsiScopeProcessor)sqlProcessor);
        for (ResolveResult result2 : results) {
            DbNamespaceImpl schemaElement;
            PsiElement qualifier = result2.getElement();
            ResolveState qualifiedState = SqlImplUtil.setQualified(resolveState, qualifier);
            if (qualifier == null || !qualifier.isValid() || qualifier instanceof DasSynonym && ((qualifier = (PsiElement)DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)qualifier))) == null || !qualifier.isValid())) continue;
            if (qualifier != reference && !qualifier.processDeclarations(processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifier instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, qualifier)) {
                    return false;
                }
                PsiFile qualFile = qualifier.getContainingFile();
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, qualFile)) {
                    return false;
                }
                if (qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifier, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespaceImpl)((Object)ObjectUtils.tryCast((Object)qualifier, DbNamespaceImpl.class))) == null || schemaElement.getKind() != ObjectKind.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(sqlProcessor, schemaElement.createDeclarationProcessor(processor, qualifiedState, null, place), schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable PsiScopeProcessor processor) {
        SqlScopeProcessor sqlProcessor = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
        if (sqlProcessor == null) {
            return false;
        }
        Set<ObjectKind> expectedTypes = sqlProcessor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!sqlProcessor.dialect.isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((PsiElement)statement, resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(PsiScopeProcessor processor, ResolveState resolveState, PsiElement place, PsiElement qualifier) {
        return SqlImplUtil.processAlterStatements(qualifier.getContainingFile(), qualifier, (Processor<SqlAlterTableInstruction>)((Processor)instruction -> instruction.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement qualifierTarget, Processor<SqlAlterTableInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        PsiFile original = file.getOriginalFile();
        if (!(original instanceof SqlFile)) {
            return true;
        }
        return ContainerUtil.process((List)((SqlFile)original).getDdl(), statement -> {
            SqlAlterTableStatement o;
            SqlReferenceExpression target;
            return !(statement instanceof SqlAlterTableStatement) || (target = (o = (SqlAlterTableStatement)statement).getAlterTargetReference()) == null || !target.getReference().isReferenceTo(qualifierTarget) || ContainerUtil.process((Object[])o.getAlterTableInstructions(), (Processor)processor);
        });
    }

    public static List<PsiColumn> createColumnInfos(DasTable tableInfo, SqlTableType tableType) {
        assert (tableInfo instanceof PsiElement);
        int count = tableType.getColumnCount();
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)count);
        for (int i2 = 0; i2 < count; ++i2) {
            result2.add(new MyColumnInfo(tableInfo, i2, tableType));
        }
        return result2;
    }

    public static boolean isParentKind(@NotNull SqlElement e, ObjectKind child, ObjectKind parent) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        if (child instanceof SqlDbElementType && ((SqlDbElementType)child).parentType == parent) {
            return true;
        }
        for (Couple couple : SqlImplUtil.getSqlDialectSafe((PsiElement)e).getDatabaseDialect().getMetaModel().getKindCouples()) {
            if (couple.first != parent || couple.second != child) continue;
            return true;
        }
        return false;
    }

    public static boolean processFromReferences(PsiScopeProcessor processor, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        JBIterable iterable = fromExpression == null ? JBIterable.empty() : ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)fromExpression).expand(DasUtil.byClass(SqlJoinExpression.class))).filter(SqlReferenceExpression.class).filter(Conditions.notEqualTo((Object)lastParent));
        for (SqlReferenceExpression ref : iterable) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = ref.multiResolve(false)) {
                PsiElement element = result2.getElement();
                if (!(element instanceof DasTable)) continue;
                if (!processor.execute(element, state)) {
                    return false;
                }
                if (SqlImplUtil.processAlterStatements(processor, state, place, element)) continue;
                return false;
            }
        }
        SqlType type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        return !(type instanceof SqlTableType) || SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, state);
    }

    @NotNull
    public static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getSqlType(end) : (end != null && PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType());
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(31);
        }
        return object;
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<Column> result2, @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        SqlTableType sqlTableType = SqlImplUtil.createType(null, result2, qualifier);
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        return sqlTableType;
    }

    @NotNull
    public static SqlTableType createType(final String name, final @NotNull List<Column> result2, final @Nullable PsiElement qualifier) {
        if (result2 == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        StringBuilder args = new StringBuilder();
        for (Column column : result2) {
            if (args.length() != 0) {
                args.append(",");
            }
            if (column.name != null) {
                args.append(column.name).append(" ");
            }
            args.append(column.type.getDataType().getSpecification());
        }
        final DataType dataType = DataTypeFactory.of(null, "table", args.toString(), null);
        Object object = result2.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType getDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name;
            }

            public int getColumnCount() {
                return result2.size();
            }

            public String getColumnName(int i2) {
                return ((Column)result2.get((int)i2)).name;
            }

            public SqlType getColumnType(int i2) {
                return ((Column)result2.get((int)i2)).type;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i2) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i2) {
                PsiElement psiElement = ((Column)result2.get((int)i2)).element;
                if (psiElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i2) {
                return ((Column)result2.get((int)i2)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(35);
        }
        return object;
    }

    @NotNull
    public static SqlTableType getSelectType(@NotNull List<SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(36);
        }
        SqlTableType result2 = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression e : list) {
            String name;
            SqlType type = e.getSqlType();
            SqlTypeCastExpression cast = (SqlTypeCastExpression)ObjectUtils.tryCast((Object)e, SqlTypeCastExpression.class);
            if (cast != null) {
                e = cast.getExpression();
            }
            String string = e instanceof SqlNameElement ? e.getName() : (name = e instanceof SqlDefinition ? e.getName() : null);
            if ("*".equals(name)) {
                name = null;
            }
            SqlType asType = name != null ? SqlTableTypeBase.createType((SqlElement)e, type, name, qualifier) : type;
            result2 = result2.add(SqlTableTypeBase.ensureTableType(asType, (SqlElement)e, qualifier));
        }
        if (result2 != SqlTableTypeBase.EMPTY_TABLE) {
            result2 = result2.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result2;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        return sqlTableType;
    }

    public static boolean processDeclarationsInType(SqlTableType tableType, PsiScopeProcessor processor, ResolveState state) {
        for (int i2 = 0; i2 < tableType.getColumnCount(); ++i2) {
            ResolveResult[] results;
            PsiElement columnQualifier = tableType.getColumnQualifier(i2);
            ResolveState qualifiedState = columnQualifier == null ? state : SqlImplUtil.setQualified(state, columnQualifier);
            PsiElement element = tableType.getColumnElement(i2);
            PsiElement sourceElement = tableType.getSourceColumnElement(i2);
            PsiElement source = element instanceof SqlDefinition || sourceElement == null ? element : sourceElement;
            ResolveResult[] resolveResultArray = results = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results.length > 0) {
                for (ResolveResult result2 : results) {
                    PsiElement target = result2.getElement();
                    if (target == null || processor.execute(target, qualifiedState)) continue;
                    return false;
                }
                continue;
            }
            if (processor.execute(source, qualifiedState)) continue;
            return false;
        }
        return true;
    }

    public static void acceptChildren(SqlElement parent, SqlVisitor visitor) {
        for (PsiElement element : parent.getChildren()) {
            if (!(element instanceof SqlElement)) continue;
            ((SqlElement)element).accept(visitor);
        }
    }

    public static boolean isAssignable(SqlType target, SqlType candidate) {
        if (target.getCategory() == candidate.getCategory()) {
            return true;
        }
        if (target.getCategory() == SqlType.Category.REAL && candidate.getCategory() == SqlType.Category.INTEGER) {
            return true;
        }
        return target.getCategory() == SqlType.Category.DATE_TIME && (candidate.getCategory() == SqlType.Category.DATE || candidate.getCategory() == SqlType.Category.TIME || candidate.getCategory() == SqlType.Category.TIMESTAMP);
    }

    @NotNull
    public static SqlType getSqlType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        SqlType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        if ((type = definition.getSqlType()) == SqlType.UNKNOWN || type.getCategory() == SqlType.Category.RECORD) {
            SqlType res = dialect.getDefinitionType(definition, place);
            SqlType sqlType = res == SqlType.UNKNOWN ? type : res;
            if (sqlType == null) {
                SqlImplUtil.$$$reportNull$$$0(40);
            }
            return sqlType;
        }
        SqlType sqlType = type;
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        SqlType sqlType = SqlTypeFactory.of(object.getDataType(), dialect);
        if (sqlType == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        return sqlType;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull DasUserDefinedType type, @Nullable PsiElement element, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children;
        List columns2;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        Object object = (columns2 = (children = type.getDbChildren(DasTypedObject.class, ObjectKind.NONE)).filter(PsiObject.class).transform(e -> {
            if (dialect == null) {
                SqlImplUtil.$$$reportNull$$$0(97);
            }
            return new Column(e.getName(), SqlImplUtil.getSqlType((DasTypedObject)e, dialect), (PsiElement)e, (PsiElement)e);
        }).toList()).isEmpty() ? SqlTypeFactory.of(DataTypeFactory.of(type.getName()), dialect) : SqlImplUtil.createType(columns2, element);
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(47);
        }
        return object;
    }

    @NotNull
    public static SqlType getSqlType(@NotNull Project project, @NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement context) {
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(49);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(50);
        }
        SqlFile file = SqlReaderImpl.asPsi(new SqlReaderImpl(project).parseSql((SqlLanguageDialect)dialect, (IElementType)SqlCompositeElementTypes.SQL_TYPE_ELEMENT_EXT, dataType.getSpecification()), PsiManager.getInstance((Project)project), context);
        SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)file, (Object)true);
        SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)file, SqlTypeElement.class);
        Object object = type == null ? SqlType.UNKNOWN : type.findSqlType();
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        return object;
    }

    public static boolean processDeclarationsDefault(SqlElement element, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element, SqlImplUtil.childrenTreeIt((PsiElement)element), processChildrenDeclarations, processor, state, lastParent, place, !(element instanceof SqlExpression) && !(element instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element instanceof DasObject ? ((DasObject)element).getKind() : ObjectKind.NONE;
        boolean checkLastParent = kind != ObjectKind.PACKAGE && kind != ObjectKind.OBJECT_TYPE && kind != ObjectKind.BODY;
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof PsiNamedElement ? !processor.execute(psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && !psiElement.processDeclarations(processor, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state, lastParent, place);
        }
        if (element instanceof SqlImplicitDeclarationsProvider && lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element, (PsiElement)lastParent, (boolean)true)) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element;
            processor.handleEvent(SqlScopeProcessor.RESOLVE_CONTEXT, (Object)element);
            SqlScopeProcessor proc = (SqlScopeProcessor)((Object)ObjectUtils.tryCast((Object)processor, SqlScopeProcessor.class));
            boolean stopIfFound = proc != null && proc.resolve && proc.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
            boolean resume = provider.processImplicitContextDeclarations(processor, state, lastParent, place);
            return resume &= !stopIfFound || proc.isResultEmpty();
        }
        return true;
    }

    @NotNull
    public static <T> T[] toArray(@Nullable Collection<? extends T> c, @NotNull ArrayFactory<T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        Object[] objectArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(53);
        }
        return objectArray;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        List<SqlReferenceExpression> list2 = list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(55);
        }
        return list2;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        PsiFile containingFile = element.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(containingFile.getProject()).getDataSources(containingFile);
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element) {
        SqlLanguageDialect dialect = (SqlLanguageDialect)ObjectUtils.notNull((Object)DbSqlUtil.getSqlDialect(element), (Object)SqlDialectMappings.getDefaultSqlDialect());
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)dialect;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(58);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj) {
        if (obj instanceof SqlSynonymDefinition) {
            ObjectKind synonymTargetType;
            SqlReferenceExpression ref = ((SqlSynonymDefinition)obj).getTargetReference();
            ObjectKind objectKind = synonymTargetType = ref != null ? ref.getReferenceElementType().getTargetKind() : null;
            if (synonymTargetType != null && synonymTargetType != SqlDbElementType.ANY) {
                ObjectKind objectKind2 = synonymTargetType;
                if (objectKind2 == null) {
                    SqlImplUtil.$$$reportNull$$$0(59);
                }
                return objectKind2;
            }
        } else if (obj instanceof SqlAsExpression) {
            SqlType type = ((SqlAsExpression)obj).getSqlType();
            boolean isTable = type instanceof SqlTableType;
            if (type == SqlType.UNKNOWN) {
                PsiElement parent = ((SqlAsExpression)obj).getParent();
                isTable = parent instanceof SqlJoinExpression || parent instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? ObjectKind.TABLE : ObjectKind.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(60);
            }
            return objectKind;
        }
        DasObject target = obj instanceof DasSynonym ? DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)obj)) : obj;
        ObjectKind objectKind = target == null ? SqlDbElementType.ANY : target.getKind();
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(61);
        }
        return objectKind;
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element) {
        return JBIterable.from((Iterable)element.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element) {
        return SqlImplUtil.sqlChildren(element).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element) {
        StubElement stub;
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element);
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            if (element == null) {
                SqlImplUtil.$$$reportNull$$$0(96);
            }
            return CachedValueProvider.Result.create((Object)SqlImplUtil.sqlTraverser(element).filter(SqlLabelDefinitionImpl.class).toList(), (Object[])new Object[]{element});
        });
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        return list;
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<DbElement> wrapper, DbElement schemaElement) {
        Condition majorChildCondition = element -> processor.dialect.isMajorChild(element.getKind());
        for (DbTable child : schemaElement.getDbChildren(DbTable.class, ObjectKind.TABLE)) {
            if (ContainerUtil.process((Iterable)child.getDbChildren(DbElement.class, ObjectKind.NONE).filter(majorChildCondition), wrapper)) continue;
            return false;
        }
        return true;
    }

    public static void quoteIdentifier(Project project, final SqlIdentifier identifier, final SqlLanguageDialect dialect) {
        new WriteCommandAction(project, new PsiFile[]{identifier.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                identifier.setName(dialect.getDatabaseDialect().quoteIdentifier(identifier.getName(), true, false));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil$2", "run"));
            }
        }.execute();
    }

    public static void unquoteIdentifier(final Project project, final SqlIdentifier identifier, final SqlLanguageDialect dialect) {
        new WriteCommandAction(project, new PsiFile[]{identifier.getContainingFile()}){

            protected void run(@NotNull Result result2) throws Throwable {
                SqlIdentifier newId;
                if (result2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project)) != null) {
                    identifier.replace((PsiElement)newId);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/sql/psi/impl/SqlImplUtil$3", "run"));
            }
        }.execute();
    }

    public static boolean canUnquote(@NotNull String newText, @NotNull DatabaseDialect dialect) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        return StringUtil.equals((CharSequence)dialect.quoteIdentifier(newText, false, false), (CharSequence)newText);
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        if (tmpFile instanceof DummyHolder) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        SqlLanguageDialect fileDialect = parent instanceof SqlFile ? ((SqlFile)parent).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(68);
        }
        if ((tmpFile = file) instanceof DummyHolder) {
            PsiElement context = tmpFile.getContext();
            if (context != null) {
                tmpFile = context.getContainingFile();
            }
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            if (topLevelFile != null) {
                tmpFile = topLevelFile;
            }
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    public static PsiFile getContainingFile(@NotNull SqlElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        return SqlImplUtil.getTopLevelSqlFile(element.getContainingFile());
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(71);
            }
            return string;
        }
        ArrayList parts = ContainerUtil.newArrayList();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), casingProvider, tableRef, parts);
        for (Trinity part : parts) {
            if (part.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)part.second == false).apply((String)part.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(72);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        return string;
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element) {
        PsiElement target;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        PsiElement psiElement = target = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryClause.class) != null) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(75);
            }
            return objectKind;
        }
        ObjectKind objectKind = target instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target) : ObjectKind.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(76);
        }
        return objectKind;
    }

    @NotNull
    public static SqlType getQualifierType(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(77);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        Object object = qualifier != null ? qualifier.getSqlType() : SqlType.UNKNOWN;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        return object;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterarateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(80);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element -> element.getTextRange().getStartOffset() < offset && (!(element instanceof SqlStatement) || element.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        return jBIterable;
    }

    @NotNull
    public static List<PsiColumn> mergeColumnListInto(@NotNull List<PsiColumn> a, @NotNull List<? extends PsiColumn> b, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> mergeCheck) {
        if (a == null) {
            SqlImplUtil.$$$reportNull$$$0(82);
        }
        if (b == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        a.addAll(SqlImplUtil.processColumnList(b, a, caseSensitive, mergeCheck, true));
        List<PsiColumn> list = a;
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(84);
        }
        return list;
    }

    @NotNull
    public static List<PsiColumn> processColumnList(@NotNull List<? extends PsiColumn> tgt, @NotNull List<? extends PsiColumn> src, boolean caseSensitive, @Nullable PairFunction<PsiColumn, PsiColumn, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(86);
        }
        ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)tgt.size());
        Map tgtMap = DasUtil.newCaseAwareMap((boolean)caseSensitive);
        for (PsiColumn psiColumn : src) {
            tgtMap.put(psiColumn.getName(), psiColumn);
        }
        for (PsiColumn psiColumn : tgt) {
            boolean matched;
            PsiColumn old = (PsiColumn)tgtMap.remove(psiColumn.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)psiColumn) != false);
            if (matched && skip) continue;
            result2.add(matched ? old : psiColumn);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(87);
        }
        return arrayList;
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getDataType().equals(b.getDataType());
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    public static boolean equalsInsensetiveOrTrue(@Nullable String a, @Nullable String b, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b, (boolean)false);
    }

    @NotNull
    public static PsiElement[] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> {
            if (definition == null) {
                SqlImplUtil.$$$reportNull$$$0(95);
            }
            return CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(89);
        }
        return psiElementArray;
    }

    @NotNull
    private static PsiElement[] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(90);
        }
        if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(91);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(92);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results = newRef.multiResolve(false);
        if (results.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(93);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            related[i2] = results[i2].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(94);
        }
        return related;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 2: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 17: 
            case 39: 
            case 43: 
            case 46: 
            case 50: 
            case 65: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 38: 
            case 88: 
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 56: 
            case 62: 
            case 69: 
            case 74: 
            case 77: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 68: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlElements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setQualified";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 33: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 40: 
            case 41: 
            case 44: 
            case 47: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "iterarateStatementsBackward";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeColumnListInto";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sqlElements";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "sqlParents";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setQualified";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getActualName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isParentKind";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSqlType";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "iterarateStatementsBackward";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getRelatedElements$10";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLabels$6";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSqlType$5";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$byElementType$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 74: 
            case 77: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 90: 
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
            if (c instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c).isAutoIncrementColumn(c)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Column {
        public final String name;
        public final SqlType type;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name, SqlType type, @NotNull PsiElement element, PsiElement sourceElement) {
            if (element == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.type = type;
            this.element = element;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition {
        final DasTable myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        public MyColumnInfo(DasTable parent, int index, SqlTableType tableType) {
            super((PsiElement)((PsiElement)parent).getContainingFile());
            this.myTableInfo = parent;
            this.myIndex = index;
            this.myTableType = tableType;
            PsiElement columnElement = tableType.getSourceColumnElement(index);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        public boolean isNameQuoted() {
            if (this.myInfo != null) {
                return DbSqlUtil.isQuoted(this.myInfo);
            }
            return DbSqlUtil.isQuoted((SqlNameElement)ObjectUtils.tryCast((Object)this.myTableType.getColumnElement(this.myIndex), SqlNameElement.class));
        }

        public String getTableName() {
            return this.myTableInfo.getName();
        }

        public DasTable getTable() {
            return this.myTableInfo;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        public DasObject getDbParent() {
            return this.getTable();
        }

        @NotNull
        public DataType getDataType() {
            DataType dataType = this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDataType() : DataTypeFactory.of(this.myTableType.getColumnType(this.myIndex).getDisplayName());
            if (dataType == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return dataType;
        }

        @NotNull
        public SqlType getSqlType() {
            SqlType sqlType = this.myTableType.getColumnType(this.myIndex);
            if (sqlType == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return sqlType;
        }

        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return (PsiElement)this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentation.getPresentableName(this.getKind(), GenericDialect.INSTANCE);
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return psiElement;
        }

        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @NotNull
        public String getDisplayOrder() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor) {
            visitor.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataType";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

