/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.psi.JdbcProcedureCall;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTypeStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInfoElementType;
import com.intellij.sql.psi.SqlLabelHolder;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlResolveCache;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlSetAssignment;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.NameChecker;
import com.intellij.sql.psi.impl.SqlCompletionUtil;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlResolveResultImpl;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlReferenceImpl
implements PsiPolyVariantReference,
PsiQualifiedReference {
    public static final Key<Boolean> IGNORE_DATA_SOURCES = Key.create((String)"IGNORE_DATA_SOURCES");
    public static final Key<Boolean> IGNORE_LOCAL_DDL = Key.create((String)"IGNORE_LOCAL_DDL");
    static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"sqlTypeCalc");
    @NotNull
    private static final ResolveCache.PolyVariantResolver<SqlReferenceImpl> MY_RESOLVER = new ResolveCache.PolyVariantResolver<SqlReferenceImpl>(){

        @NotNull
        public ResolveResult[] resolve(@NotNull SqlReferenceImpl reference, boolean incompleteCode) {
            PsiFile file;
            if (reference == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((file = reference.getElement().getContainingFile()) instanceof SqlFileImpl && reference.getQualifier() == null) {
                SqlResolveCache cache = ((SqlFileImpl)file).getResolveCache();
                ResolveResult[] result2 = cache.getResult((PsiReference)reference);
                if (result2 != null) {
                    if (result2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result2;
                }
                ResolveResult[] computed = reference.resolveInner();
                cache.cacheResult((PsiReference)reference, computed);
                if (computed == null) {
                    1.$$$reportNull$$$0(2);
                }
                return computed;
            }
            ResolveResult[] resolveResultArray = reference.resolveInner();
            if (resolveResultArray == null) {
                1.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$1";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    @NotNull
    private static final ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType> MY_TYPE_RESOLVER = new ResolveCache.AbstractResolver<SqlReferenceImpl, SqlType>(){

        @NotNull
        public SqlType resolve(@NotNull SqlReferenceImpl reference, boolean incompleteCode) {
            if (reference == null) {
                2.$$$reportNull$$$0(0);
            }
            SqlType sqlType = reference.getSqlTypeInner();
            if (sqlType == null) {
                2.$$$reportNull$$$0(1);
            }
            return sqlType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl$2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$2";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "resolve";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final SqlElement myElement;

    public SqlReferenceImpl(@NotNull SqlElement element) {
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(0);
        }
        this.myElement = element;
    }

    @Nullable
    public SqlExpression getQualifier() {
        return this.getQualifierExpression();
    }

    @Nullable
    public abstract SqlExpression getQualifierExpression();

    @Nullable
    public abstract String getReferenceName();

    @NotNull
    public SqlType getSqlType() {
        SqlType type = (SqlType)ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiReference)this, MY_TYPE_RESOLVER, true, false);
        Object object = type == null ? SqlType.UNKNOWN : type;
        if (object == null) {
            SqlReferenceImpl.$$$reportNull$$$0(1);
        }
        return object;
    }

    public boolean resolveStrict() {
        if (SqlCompletionUtil.isDropTarget((PsiElement)this.myElement) || SqlCompletionUtil.isJoinUsingColumn((PsiElement)this.myElement)) {
            return true;
        }
        SqlSetAssignment assignment = (SqlSetAssignment)ObjectUtils.tryCast((Object)this.myElement.getParent(), SqlSetAssignment.class);
        return PsiTreeUtil.getParentOfType((PsiElement)assignment, SqlUpdateStatement.class) != null && assignment.getLValue() == this.myElement;
    }

    @NotNull
    private SqlType getSqlTypeInner() {
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement element = this.resolve();
        if (element == this.myElement && "*".equals(this.getReferenceName())) {
            SqlType sqlType = SqlReferenceImpl.getAsteriskType(this.myElement);
            if (sqlType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(2);
            }
            return sqlType;
        }
        if (this.getReferenceElementType().getTargetKind() == ObjectKind.SEQUENCE || element instanceof DasObject && ((DasObject)element).getKind() == ObjectKind.SEQUENCE) {
            SqlTableType sqlTableType = dialect.createSequenceType((PsiElement)this.myElement, element);
            if (sqlTableType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(3);
            }
            return sqlTableType;
        }
        if (element instanceof PsiTable) {
            SqlTableType sqlTableType = SqlTableTypeBase.createType((PsiTable)element, (PsiElement)this.myElement);
            if (sqlTableType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }
        if (element instanceof DasSynonym) {
            DasObject target = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)element));
            PsiTable info = target instanceof PsiTable ? (PsiTable)target : null;
            Object object = info != null ? SqlTableTypeBase.createType(info, (PsiElement)this.myElement) : SqlType.UNKNOWN;
            if (object == null) {
                SqlReferenceImpl.$$$reportNull$$$0(5);
            }
            return object;
        }
        if (element instanceof SqlTypedDefinition) {
            SqlTypedDefinition definition = (SqlTypedDefinition)element;
            SqlType type = SqlImplUtil.getSqlType(definition, dialect, this.getElement());
            SqlType sqlType = type == SqlType.UNKNOWN ? this.getReservedEntityType(definition.getName(), dialect, (SqlElement)definition) : type;
            if (sqlType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(6);
            }
            return sqlType;
        }
        if (element instanceof SqlCreateTypeStatement) {
            SqlTableType type = ((SqlCreateTypeStatement)element).getSqlType();
            SqlTableType sqlTableType = type == null ? SqlTableTypeBase.EMPTY_TABLE : type;
            if (sqlTableType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(7);
            }
            return sqlTableType;
        }
        if (element instanceof SqlFileImpl.FakeDefinition && ((SqlFileImpl.FakeDefinition)element).getKind() == ObjectKind.OBJECT_TYPE) {
            SqlCreateTypeStatement o = (SqlCreateTypeStatement)((SqlFileImpl.FakeDefinition)element).delegates().filter(SqlCreateTypeStatement.class).first();
            SqlTableType type = o == null ? null : o.getSqlType();
            SqlTableType sqlTableType = type == null ? SqlTableTypeBase.EMPTY_TABLE : type;
            if (sqlTableType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(8);
            }
            return sqlTableType;
        }
        if (element instanceof DasColumn) {
            SqlType sqlType = SqlTypeFactory.of(((DasColumn)element).getDataType(), dialect);
            if (sqlType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(9);
            }
            return sqlType;
        }
        if (element == null && DbImplUtil.isTypeKind(this.getReferenceElementType().getTargetKind())) {
            String name = this.getReferenceName();
            Object object = StringUtil.isEmpty((String)name) ? SqlType.UNKNOWN : SqlTypeFactory.of(DataTypeFactory.of(name), dialect);
            if (object == null) {
                SqlReferenceImpl.$$$reportNull$$$0(10);
            }
            return object;
        }
        if (element == this.myElement) {
            SqlType sqlType = this.getReservedEntityType(this.getReferenceName(), dialect, this.myElement);
            if (sqlType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(11);
            }
            return sqlType;
        }
        if (element instanceof SqlExpression) {
            SqlType sqlType = ((SqlExpression)element).getSqlType();
            if (sqlType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(12);
            }
            return sqlType;
        }
        if (element instanceof SqlDefinition && element.getParent() instanceof SqlSelectIntoClause) {
            SqlSelectClause clause = (SqlSelectClause)PsiTreeUtil.getPrevSiblingOfType((PsiElement)element.getParent(), SqlSelectClause.class);
            if (clause != null) {
                SqlTableType sqlTableType = SqlImplUtil.getSelectType(clause.getExpressions(), element);
                if (sqlTableType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(13);
                }
                return sqlTableType;
            }
        } else {
            if (this.getReferenceElementType().getTargetKind() == ObjectKind.TABLE) {
                SqlTableType sqlTableType = SqlTableTypeBase.createUnresolvedTableType((PsiReference)this);
                if (sqlTableType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(14);
                }
                return sqlTableType;
            }
            if (element instanceof DasUserDefinedType) {
                SqlType sqlType = SqlImplUtil.getSqlType((DasUserDefinedType)element, element, dialect);
                if (sqlType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(15);
                }
                return sqlType;
            }
            if (element instanceof DasTypedObject) {
                SqlType sqlType = SqlImplUtil.getSqlType((DasTypedObject)element, dialect);
                if (sqlType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(16);
                }
                return sqlType;
            }
        }
        SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
        if (sqlPrimitiveType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(17);
        }
        return sqlPrimitiveType;
    }

    private SqlType getReservedEntityType(@Nullable String name, @NotNull SqlLanguageDialectEx dialect, @NotNull SqlElement element) {
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(18);
        }
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(19);
        }
        final Ref ref = Ref.create();
        dialect.processReservedEntitiesWithType(name, (PsiElement)element, true, new SqlScopeProcessor(true, dialect, (Iterable)JBIterable.empty()){

            @Override
            public boolean isResultEmpty() {
                return ref.isNull();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement element, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (sqlType != null) {
                    ref.set((Object)sqlType);
                }
                return sqlType != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$3";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (!ref.isNull()) {
            return (SqlType)ref.get();
        }
        ObjectKind kind = this.getReferenceElementType().getTargetKind();
        if (kind == ObjectKind.TABLE) {
            return SqlTableTypeBase.EMPTY_TABLE;
        }
        if (StringUtil.isNotEmpty((String)name) && DbImplUtil.isTypeKind(kind)) {
            return SqlTypeFactory.of(DataTypeFactory.of(name), dialect);
        }
        return SqlType.UNKNOWN;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        SqlExpression qual;
        SqlIdentifier id = this.myElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)this.myElement).getIdentifier() : null;
        SqlExpression sqlExpression = qual = this.myElement instanceof SqlReferenceExpression ? ((SqlReferenceExpression)this.myElement).getQualifierExpression() : null;
        if (id != null && "*".equals(id.getText())) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(qual instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qual).resolve() : null, (PsiElement)this.myElement);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(20);
            }
            return sqlResolveResultArray;
        }
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof DummyHolder) {
            parent = parent.getContext();
        }
        if (parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == this.myElement) {
            SqlResolveResult[] sqlResolveResultArray = SqlResolveResultImpl.createSingleSqlResults(null, parent);
            if (sqlResolveResultArray == null) {
                SqlReferenceImpl.$$$reportNull$$$0(21);
            }
            return sqlResolveResultArray;
        }
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getElement().getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, incompleteCode);
        if (resolveResultArray == null) {
            SqlReferenceImpl.$$$reportNull$$$0(22);
        }
        return resolveResultArray;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 0 ? null : results[0].getElement();
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myElement.getText();
        if (string == null) {
            SqlReferenceImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(24);
        }
        if (this.isReferenceTo(element)) {
            return this.myElement;
        }
        if (element instanceof PsiNamedElement) {
            return this.handleElementRename(((PsiNamedElement)element).getName());
        }
        return this.myElement;
    }

    public boolean isReferenceTo(PsiElement e1) {
        if (SqlReferenceImpl.isEmptyReferenceTo((PsiElement)this.myElement, e1)) {
            return true;
        }
        SqlReferenceElementType refType = this.getReferenceElementType();
        for (ResolveResult result2 : this.multiResolve(false)) {
            PsiElement e2 = result2.getElement();
            if (this.myElement.getManager().areElementsEquivalent(e1, e2)) {
                return true;
            }
            if (refType != SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE || !(e2 instanceof SqlDefinition) || !SqlReferenceImpl.isEmptyReferenceTo((PsiElement)((SqlDefinition)e2).getNameElement(), e1)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEmptyReferenceTo(PsiElement element, PsiElement e1) {
        PsiElement lastChild;
        PsiElement psiElement = lastChild = element instanceof SqlReferenceExpression ? element.getLastChild() : null;
        if (element.getFirstChild() == lastChild && lastChild instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)lastChild;
            return refExpression.getReference().isReferenceTo(e1);
        }
        return false;
    }

    @NotNull
    public SqlReferenceElementType getReferenceElementType() {
        ASTNode astNode = this.myElement.getNode();
        IElementType elementType = astNode != null ? astNode.getElementType() : null;
        SqlReferenceElementType sqlReferenceElementType = elementType instanceof SqlReferenceElementType ? (SqlReferenceElementType)elementType : SqlCompositeElementTypes.SQL_REFERENCE;
        if (sqlReferenceElementType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(25);
        }
        return sqlReferenceElementType;
    }

    @NotNull
    public Object[] getVariants() {
        if (EMPTY_ARRAY == null) {
            SqlReferenceImpl.$$$reportNull$$$0(26);
        }
        return EMPTY_ARRAY;
    }

    private ResolveResult[] resolveInner() {
        boolean dontCheckName;
        NameChecker nameChecker;
        OrderedSet result2;
        List<DbDataSource> dataSources;
        String referenceName = this.getReferenceName();
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        SqlScopeProcessor processor = new SqlScopeProcessor(true, dialect, dataSources = SqlImplUtil.getDataSources((PsiElement)SqlImplUtil.getContainingFile(this.myElement)), (Collection)(result2 = new OrderedSet()), nameChecker = (dontCheckName = StringUtil.isEmpty((String)referenceName) && this.getQualifierExpression() != null) ? null : new NameChecker(this, dialect, SqlImplUtil.getCasingProvider(dialect, dataSources))){
            final /* synthetic */ Collection val$result;
            final /* synthetic */ NameChecker val$nameChecker;
            {
                this.val$result = collection;
                this.val$nameChecker = nameChecker;
                super(resolve, dialect, dataSources);
            }

            @Override
            public boolean isResultEmpty() {
                return this.val$result.isEmpty();
            }

            @Override
            public boolean executeTarget(@Nullable DasObject target, @NotNull PsiElement t, @Nullable SqlType sqlType, Boolean forcedCaseSens, @NotNull ResolveState state) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    4.$$$reportNull$$$0(1);
                }
                Object named = ObjectUtils.chooseNotNull((Object)target, (Object)ObjectUtils.tryCast((Object)t, SqlReferenceExpression.class));
                if (this.val$nameChecker != null && !this.val$nameChecker.checkName(named, forcedCaseSens)) {
                    return true;
                }
                if (!this.checkType(ObjectUtils.notNull((Object)target, (Object)t), sqlType)) {
                    return true;
                }
                PsiElement qualifier = SqlImplUtil.getQualifier(state);
                PsiElement delegate = target instanceof DbElement ? (PsiElement)ObjectUtils.tryCast((Object)((DbElement)target).getDelegate(), PsiElement.class) : null;
                this.val$result.add(Pair.create((Object)qualifier, (Object)ObjectUtils.chooseNotNull((Object)delegate, (Object)t)));
                return sqlType == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "t";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl$4";
                objectArray[2] = "executeTarget";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (this.initExpectedTargetTypes(processor)) {
            this.processResolveVariants(processor);
        } else {
            result2.add(Pair.create(null, (Object)this.myElement));
        }
        if (result2.isEmpty()) {
            dialect.processReservedEntitiesWithType(referenceName, (PsiElement)this.myElement, true, processor);
        }
        if (result2.isEmpty()) {
            SqlElement setLValue;
            PsiElement parent = this.myElement.getParent();
            SqlElement sqlElement = setLValue = parent instanceof SqlSetAssignment ? ((SqlSetAssignment)parent).getLValue() : null;
            if (setLValue instanceof SqlReferenceExpression && ((SqlReferenceExpression)setLValue).getReferenceElementType() == SqlCompositeElementTypes.SQL_SYSTEM_REFERENCE) {
                result2.add(Pair.create(null, (Object)this.getElement()));
            }
        }
        return SqlResolveResultImpl.createSqlResults((Collection<Pair<PsiElement, PsiElement>>)result2);
    }

    public boolean isSoft() {
        return false;
    }

    public boolean processResolveVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(27);
        }
        ResolveState state = ResolveState.initial();
        if (this.getReferenceElementType() == SqlCompositeElementTypes.SQL_LABEL_BACK_REFERENCE) {
            SqlElement def = (SqlElement)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, (Class[])new Class[]{SqlProcedureDefinitionImpl.class, SqlCreateStatement.class});
            return this.processLabels(processor) && (def == null || processor.execute((PsiElement)def, state));
        }
        SqlExpression qualifierExpression = this.getQualifierExpression();
        if (qualifierExpression == null) {
            return this.processUnqualifiedResolveVariants(processor, state);
        }
        if (qualifierExpression instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifierExpression, (PsiScopeProcessor)processor, state, (PsiElement)this.myElement)) {
            return false;
        }
        if (this.myElement.getParent() instanceof SqlFunctionCallExpression && processor.isResultEmpty()) {
            return this.processFunctionVariants(processor);
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)qualifierExpression.getSqlType(), SqlTableType.class);
        if (type != null) {
            return SqlImplUtil.processDeclarationsInType(type, (PsiScopeProcessor)processor, state);
        }
        return true;
    }

    public boolean initExpectedTargetTypes(@NotNull SqlScopeProcessor processor) {
        boolean strict;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(28);
        }
        PsiFile containingFile = this.myElement.getContainingFile();
        int maxLev = processor.resolve && containingFile == containingFile.getOriginalFile() ? 0 : -1;
        Set<ObjectKind> set = this.getExpectedTargetTypes(processor.resolve, processor.dialect, -1, maxLev, strict = this.resolveStrict());
        if (this.shouldNotBeChecked(set)) {
            return false;
        }
        processor.handleEvent(SqlScopeProcessor.EXPECTED_TYPE, set);
        processor.handleEvent(SqlScopeProcessor.STRICT_TYPE, strict);
        return true;
    }

    @NotNull
    private static SqlType getAsteriskType(@NotNull SqlElement element) {
        SqlQueryExpression queryExpression;
        SqlTableExpression tableExpression;
        if (element == null) {
            SqlReferenceImpl.$$$reportNull$$$0(29);
        }
        PsiElement parent = element.getParent();
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        SqlExpression targetExpr = (SqlExpression)ObjectUtils.chooseNotNull((Object)qualifier, (Object)(tableExpression = (queryExpression = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryExpression.class, (boolean)true)) == null ? null : queryExpression.getTableExpression()));
        if (targetExpr == null) {
            SqlTableType sqlTableType = SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlReferenceImpl.$$$reportNull$$$0(30);
            }
            return sqlTableType;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)element);
        DatabaseFamilyId familyId = dialect.getFamilyId();
        if (parent instanceof SqlExpressionList && parent.getParent() instanceof SqlFunctionCallExpression) {
            if (familyId.isPostgres() && qualifier != null) {
                SqlType sqlType = targetExpr.getSqlType();
                if (sqlType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(31);
                }
                return sqlType;
            }
            BuiltinFunction definition = ((SqlFunctionCallExpression)parent.getParent()).getFunctionDefinition();
            if (definition == null) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(32);
                }
                return sqlPrimitiveType;
            }
            if (qualifier != null && !dialect.getDatabaseDialect().supportsQualifiedAsteriskInCalls() || !Comparing.strEqual((String)definition.getName(), (String)"count", (boolean)false) && (!familyId.isMicrosoft() || !Comparing.strEqual((String)definition.getName(), (String)"count_big", (boolean)false))) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(33);
                }
                return sqlPrimitiveType;
            }
        } else {
            PsiElement curParent = parent;
            while (curParent instanceof SqlReferenceExpression) {
                curParent = curParent.getParent();
            }
            if (familyId.isPostgres() || familyId.isHsqldb() || familyId.isH2()) {
                while (curParent instanceof SqlParenthesizedExpression) {
                    curParent = curParent.getParent();
                }
            }
            if (!(curParent instanceof SqlSelectClause || curParent instanceof SqlDmlInstruction || curParent instanceof SqlFromClause && curParent.getParent() instanceof SqlDmlInstruction)) {
                SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
                if (sqlPrimitiveType == null) {
                    SqlReferenceImpl.$$$reportNull$$$0(34);
                }
                return sqlPrimitiveType;
            }
        }
        SqlType sqlType = targetExpr.getSqlType();
        if (sqlType == null) {
            SqlReferenceImpl.$$$reportNull$$$0(35);
        }
        return sqlType;
    }

    private boolean shouldNotBeChecked(@NotNull Set<ObjectKind> expectedTypes) {
        DatabaseFamilyId familyId;
        if (expectedTypes == null) {
            SqlReferenceImpl.$$$reportNull$$$0(36);
        }
        SqlLanguageDialectEx dialect = this.getSqlDialect();
        PsiElement parent = this.myElement.getParent();
        if (expectedTypes.contains(ObjectKind.ROUTINE) && parent != null && parent.getParent() instanceof JdbcProcedureCall) {
            return true;
        }
        if (expectedTypes.contains(ObjectKind.OBJECT_TYPE) && parent instanceof SqlTypeElement && this.getQualifierExpression() == null && PsiTreeUtil.getDeepestFirst((PsiElement)this.myElement).getNode().getElementType() == SqlTokens.SQL_IDENT_DELIMITED && ((familyId = dialect.getDatabaseDialect().getFamilyId()).isTransactSql() || familyId.isPostgres())) {
            String name = this.getReferenceName();
            return name == null || !dialect.shouldQuotedTypeReferenceBeChecked(name);
        }
        return false;
    }

    private boolean processFunctionVariants(@NotNull SqlScopeProcessor processor) {
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(37);
        }
        SqlLanguageDialectEx dialect = processor.dialect;
        if (!processor.resolve || !this.shouldProcessFunctionVariants()) {
            return true;
        }
        PsiElement parent = this.myElement.getParent();
        PsiElement target = parent instanceof SqlFunctionCallExpression ? parent : this.myElement;
        SqlFunctionDefinition builtin = dialect.getSupportedFunctions().get(this.getReferenceName());
        if (builtin != null) {
            String postfixType;
            SqlExpression qualifier = this.getQualifier();
            if (qualifier != null && (postfixType = builtin.getPostfixType()) == null) {
                return true;
            }
            if (!processor.executeTarget((DasObject)builtin, target, null, dialect.getFamilyId().isMysql() ? Boolean.valueOf(false) : null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private SqlLanguageDialectEx getSqlDialect() {
        return SqlImplUtil.getSqlDialectSafe((PsiElement)this.myElement);
    }

    protected boolean shouldProcessFunctionVariants() {
        return false;
    }

    boolean processUnqualifiedResolveVariants(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state) {
        SqlImportState importChecker;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(38);
        }
        if (state == null) {
            SqlReferenceImpl.$$$reportNull$$$0(39);
        }
        if (!this.myElement.isValid()) {
            return true;
        }
        PsiFile containingFile = SqlImplUtil.getContainingFile(this.myElement);
        PsiFile psiFile = containingFile.getOriginalFile();
        PsiElement maxScope = SqlImplUtil.getResolveScope(containingFile);
        boolean callableExpected = processor.getExpectedTypes().contains(ObjectKind.ROUTINE);
        if (callableExpected && !this.processFunctionVariants(processor)) {
            return false;
        }
        if (!(Boolean.TRUE.equals(IGNORE_LOCAL_DDL.get((UserDataHolder)psiFile)) || Boolean.TRUE.equals(IGNORE_LOCAL_DDL.get((UserDataHolder)this.myElement)) || PsiTreeUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElement, (PsiElement)maxScope, (ResolveState)state))) {
            return false;
        }
        ObjectKind targetType = this.getReferenceElementType().getTargetKind();
        if (targetType == SqlDbElementType.LABEL && !processor.dialect.getFamilyId().isMysql() && !this.processLabels(processor)) {
            return false;
        }
        if (targetType == ObjectKind.VARIABLE || targetType == SqlDbElementType.LABEL) {
            return true;
        }
        if (!(callableExpected || processor.resolve && !(this.myElement.getParent() instanceof SqlFunctionCallExpression) || this.processFunctionVariants(processor))) {
            return false;
        }
        SqlImportState sqlImportState = importChecker = psiFile instanceof SqlFile ? SqlDialectImplUtil.getImportCheckerAt((SqlFile)psiFile, (PsiElement)this.myElement) : null;
        if (!Boolean.TRUE.equals(IGNORE_DATA_SOURCES.get((UserDataHolder)psiFile))) {
            HashSet visited = ContainerUtil.newHashSet();
            LinkedList queue = ContainerUtil.newLinkedList(processor.dataSources);
            while (!queue.isEmpty()) {
                DbDataSource dataSource = (DbDataSource)queue.remove(0);
                if (!visited.add(dataSource.getUniqueId()) || importChecker != null && !importChecker.isImported(dataSource, null)) continue;
                DatabaseSystem d = dataSource.getDelegate();
                if (d instanceof SqlDataSource) {
                    SqlDataSource sqlDataSource = (SqlDataSource)d;
                    for (SqlFile file : sqlDataSource.getSqlFiles()) {
                        if (file.processDeclarations((PsiScopeProcessor)processor, state, (PsiElement)containingFile, (PsiElement)this.myElement)) continue;
                        return false;
                    }
                    ContainerUtil.addIfNotNull((Collection)queue, (Object)sqlDataSource.getParentDataSource());
                    continue;
                }
                Condition<DasObject> condition = psiFile instanceof SqlFile ? SqlFileImpl.importedCondition(importChecker, dataSource) : Conditions.alwaysTrue();
                if (SqlFileImpl.processDeclarationsImpl((PsiScopeProcessor)processor, state, (PsiObject)dataSource, condition)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processLabels(@NotNull SqlScopeProcessor processor) {
        SqlLabelHolder block;
        if (processor == null) {
            SqlReferenceImpl.$$$reportNull$$$0(40);
        }
        if ((block = (SqlLabelHolder)PsiTreeUtil.getTopmostParentOfType((PsiElement)this.myElement, SqlLabelHolder.class)) != null) {
            for (SqlDefinition label : block.getLabels()) {
                if (processor.execute((PsiElement)label, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private Set<ObjectKind> getExpectedTargetTypes(boolean resolve, SqlLanguageDialectEx dialect, int minLev, int maxLev, boolean strict) {
        THashSet expectedStrict = this.getExpectedTargetTypesStrict(dialect);
        boolean addCallable = false;
        PsiElement parent = this.myElement.getParent();
        DatabaseFamilyId familyId = dialect.getDatabaseDialect().getFamilyId();
        if (!strict && familyId.isPostgres() && parent instanceof SqlExpressionList && parent.getParent() instanceof SqlFunctionCallExpression && expectedStrict.contains(ObjectKind.COLUMN)) {
            expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
            expectedStrict.add(ObjectKind.TABLE);
        }
        if (!resolve && !strict && (expectedStrict.contains(ObjectKind.COLUMN) || expectedStrict.contains(ObjectKind.TABLE))) {
            PsiElement info = this.myElement.getNextSibling();
            while (info instanceof PsiWhiteSpace || info instanceof PsiComment) {
                info = info.getNextSibling();
            }
            boolean bl = addCallable = SqlInfoElementType.getValue(info, SqlFunctionDefinition.ReferenceParameter.class) == null;
        }
        if (maxLev == 0) {
            if (addCallable) {
                expectedStrict = SqlReferenceImpl.makeMutable(expectedStrict);
                expectedStrict.add((ObjectKind)ObjectKind.ROUTINE);
            }
        } else {
            THashSet parents = new THashSet();
            if (addCallable) {
                parents.add((Object)ObjectKind.ROUTINE);
            }
            for (ObjectKind type : expectedStrict) {
                this.getParentTypes(dialect, type, minLev, maxLev, (Set<ObjectKind>)parents);
            }
            expectedStrict = parents;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(41);
        }
        return tHashSet;
    }

    @NotNull
    private static Set<ObjectKind> makeMutable(Set<ObjectKind> expectedStrict) {
        if (!(expectedStrict instanceof THashSet)) {
            THashSet result2 = new THashSet();
            result2.addAll(expectedStrict);
            expectedStrict = result2;
        }
        THashSet tHashSet = expectedStrict;
        if (tHashSet == null) {
            SqlReferenceImpl.$$$reportNull$$$0(42);
        }
        return tHashSet;
    }

    private int getParentTypes(@NotNull SqlLanguageDialectEx dialect, ObjectKind type, int minLevel, int maxLevel, Set<ObjectKind> result2) {
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(43);
        }
        Set<ObjectKind> ignored = dialect.getIgnoredParentKinds((PsiElement)this.myElement, this.getReferenceElementType().getTargetKind());
        return SqlImplUtil.getParentTypes(dialect, type, minLevel, maxLevel, ignored, result2);
    }

    @NotNull
    Set<ObjectKind> getExpectedTargetTypesStrict(@NotNull SqlLanguageDialectEx dialect) {
        ObjectKind realLastRefType;
        if (dialect == null) {
            SqlReferenceImpl.$$$reportNull$$$0(44);
        }
        ObjectKind thisTargetType = this.getReferenceElementType().getTargetKind();
        SqlElement lastRefElement = this.myElement;
        SqlReferenceImpl lastRef = this;
        int inParentLevel = 0;
        int starCount = 0;
        boolean linkReached = false;
        PsiElement parent = this.myElement.getParent();
        while (parent instanceof SqlElement && parent.getReference() instanceof SqlReferenceImpl) {
            lastRefElement = (SqlElement)parent;
            lastRef = (SqlReferenceImpl)parent.getReference();
            if (!linkReached) {
                ++inParentLevel;
                if (Comparing.equal((String)"*", (String)lastRef.getReferenceName())) {
                    ++starCount;
                }
            }
            linkReached |= TreeUtil.findSibling((ASTNode)lastRefElement.getNode(), (IElementType)SqlCompositeElementTypes.SQL_GENERIC_AT_REFERENCE) != null;
            parent = parent.getParent();
        }
        if (thisTargetType == ObjectKind.OBJECT_TYPE) {
            Set set = ContainerUtil.immutableSet((Object[])new ObjectKind[]{ObjectKind.OBJECT_TYPE, ObjectKind.COLLECTION_TYPE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE});
            if (set == null) {
                SqlReferenceImpl.$$$reportNull$$$0(45);
            }
            return set;
        }
        if (thisTargetType != SqlDbElementType.ANY) {
            Set<ObjectKind> set = Collections.singleton(thisTargetType);
            if (set == null) {
                SqlReferenceImpl.$$$reportNull$$$0(46);
            }
            return set;
        }
        ObjectKind lastRefType = lastRef != this ? lastRef.getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
        ObjectKind objectKind = realLastRefType = lastRefType != SqlDbElementType.ANY || !(parent instanceof SqlCompositeElementImpl) ? lastRefType : ((SqlCompositeElementImpl)parent).getExpectedReferenceTargetType(lastRefElement);
        if (lastRefType != SqlDbElementType.ANY) {
            THashSet curType = new THashSet();
            this.getParentTypes(dialect, realLastRefType, inParentLevel - starCount, inParentLevel, (Set<ObjectKind>)curType);
            THashSet tHashSet = curType;
            if (tHashSet == null) {
                SqlReferenceImpl.$$$reportNull$$$0(47);
            }
            return tHashSet;
        }
        Set<ObjectKind> set = Collections.singleton(SqlDbElementType.ANY);
        if (set == null) {
            SqlReferenceImpl.$$$reportNull$$$0(48);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlReferenceImpl that = (SqlReferenceImpl)o;
        return this.myElement.equals(that.myElement);
    }

    public int hashCode() {
        return this.myElement.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 18: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 27: 
            case 28: 
            case 37: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlReferenceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeInner";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceElementType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsteriskType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypes";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "makeMutable";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReservedEntityType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "initExpectedTargetTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAsteriskType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldNotBeChecked";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionVariants";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolveVariants";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processLabels";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTargetTypesStrict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

