/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiTable;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.psi.SqlAlterTableInstruction;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBasedSqlTableTypeImpl
extends SqlTableTypeBase {
    private final List<? extends DasColumn> myColumns;
    private final PsiTable myDatabaseElement;
    private final String myTableName;
    private final PsiElement myQualifier;
    private final DataType myDataType;

    public TableBasedSqlTableTypeImpl(PsiTable databaseElement, @Nullable PsiElement place) {
        this.myDatabaseElement = databaseElement;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(place);
        PsiElement infoPsi = DbSqlUtil.getPsiDelegate((DasObject)databaseElement);
        this.myTableName = databaseElement.getName();
        this.myDataType = DataTypeFactory.of(this.myTableName);
        this.myColumns = infoPsi == null && place == null ? ContainerUtil.collect((Iterator)DasUtil.getColumns((DasObject)this.myDatabaseElement).iterator()) : (List)ObjectUtils.notNull((Object)SqlReferenceImpl.ourGuard.doPreventingRecursion((Object)databaseElement, true, () -> TableBasedSqlTableTypeImpl.calcColumns((DasTable)this.myDatabaseElement, infoPsi, place)), Collections.emptyList());
    }

    @NotNull
    public DataType getDataType() {
        DataType dataType = this.myDataType;
        if (dataType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(0);
        }
        return dataType;
    }

    public TableBasedSqlTableTypeImpl(List<? extends DasColumn> columns2, @Nullable PsiElement qualifier) {
        this.myDatabaseElement = null;
        this.myColumns = columns2;
        this.myTableName = null;
        this.myQualifier = TableBasedSqlTableTypeImpl.resolved(qualifier);
        this.myDataType = SqlTypeFactory.createTableDataType(columns2);
    }

    @Nullable
    private static PsiElement resolved(@Nullable PsiElement place) {
        return (PsiElement)ObjectUtils.chooseNotNull((Object)(place instanceof SqlReferenceExpression ? ((SqlReferenceExpression)place).resolve() : place), (Object)place);
    }

    @Override
    @Nullable
    public PsiElement getTypeElement() {
        return this.myDatabaseElement;
    }

    public int getColumnCount() {
        return this.myColumns.size();
    }

    public String getColumnName(int i2) {
        return this.myColumns.get(i2).getName();
    }

    public SqlType getColumnType(int i2) {
        DasColumn column = this.myColumns.get(i2);
        if (column instanceof SqlTypedDefinition) {
            return ((SqlTypedDefinition)column).getSqlType();
        }
        return SqlTypeFactory.of(this.getDataType(i2), SqlImplUtil.getSqlDialectSafe((PsiElement)this.myDatabaseElement));
    }

    @Nullable
    public PsiElement getColumnQualifier(int i2) {
        return this.myQualifier;
    }

    @NotNull
    public DataType getDataType(int i2) {
        DataType dataType = this.myColumns.get(i2).getDataType();
        if (dataType == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @NotNull
    public PsiElement getColumnElement(int i2) {
        PsiElement psiElement = (PsiElement)this.myColumns.get(i2);
        if (psiElement == null) {
            TableBasedSqlTableTypeImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public PsiElement getSourceColumnElement(int i2) {
        PsiElement element = (PsiElement)this.myColumns.get(i2);
        return element instanceof FakePsiElement ? element.getNavigationElement() : element;
    }

    public List<? extends DasColumn> getColumns() {
        return this.myColumns;
    }

    private static List<DasColumn> calcColumns(DasTable info, PsiElement infoPsi, PsiElement place) {
        ArrayList columns2 = ContainerUtil.newArrayList((Iterable)DasUtil.getColumns((DasObject)info));
        CasingProvider casingProvider = SqlImplUtil.getCasingProvider(SqlImplUtil.getSqlDialectSafe(place), place == null ? Collections.emptyList() : SqlImplUtil.getDataSources(place));
        Map named = DasUtil.newCaseAwareMap((boolean)DasUtil.isCaseSensitive((Casing)casingProvider.getCasing(ObjectKind.COLUMN, (DasObject)info)));
        for (DasColumn column : columns2) {
            named.put(column.getName(), column);
        }
        PsiFile file = infoPsi == null ? null : infoPsi.getContainingFile();
        PsiFile placeFile = place != null ? place.getContainingFile().getOriginalFile() : null;
        Ref checkPlace = Ref.create((Object)(file == placeFile ? 1 : 0));
        Processor processor = instruction -> {
            block10: {
                IElementType instructionType;
                block9: {
                    int idx;
                    if (((Boolean)checkPlace.get()).booleanValue() && !SqlDialectImplUtil.placeBefore((PsiElement)instruction, place)) {
                        return true;
                    }
                    instructionType = instruction.getInstructionType();
                    if (instructionType != SqlCommonKeywords.SQL_MODIFY && instructionType != SqlCommonKeywords.SQL_CHANGE && instructionType != SqlCommonKeywords.SQL_RENAME) break block9;
                    String fromName = null;
                    String toName = null;
                    SqlColumnDefinition to = null;
                    for (PsiElement element : SqlImplUtil.childrenIt((PsiElement)instruction)) {
                        SqlReferenceExpression ref;
                        if (element instanceof SqlColumnDefinition) {
                            to = (SqlColumnDefinition)element;
                            if (fromName == null) {
                                fromName = to.getName();
                            }
                            toName = to.getName();
                            break;
                        }
                        if (!(element instanceof SqlReferenceExpression) || (ref = (SqlReferenceExpression)element).getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) continue;
                        if (fromName != null) break;
                        fromName = ref.getName();
                    }
                    if (to == null || (idx = columns2.indexOf(named.get(fromName))) == -1) break block10;
                    columns2.set(idx, to);
                    named.remove(fromName);
                    named.put(toName, to);
                    break block10;
                }
                if (instructionType == SqlCommonKeywords.SQL_ADD) {
                    for (SqlColumnDefinition col : SqlImplUtil.childrenIt((PsiElement)instruction).filter(SqlColumnDefinition.class)) {
                        if (named.containsKey(col.getName())) continue;
                        columns2.add(col);
                        named.put(col.getName(), col);
                    }
                } else if (instructionType == SqlCommonKeywords.SQL_DROP) {
                    for (SqlReferenceExpression col : SqlImplUtil.childrenIt((PsiElement)instruction).filter(SqlReferenceExpression.class)) {
                        if (col.getReferenceElementType().getTargetKind() != ObjectKind.COLUMN) continue;
                        DasColumn toDrop = (DasColumn)named.get(col.getName());
                        columns2.remove(toDrop);
                        named.remove(col.getName());
                    }
                }
            }
            return true;
        };
        SqlImplUtil.processAlterStatements(file, (PsiElement)info, (Processor<SqlAlterTableInstruction>)processor);
        if (place != null && !((Boolean)checkPlace.get()).booleanValue()) {
            checkPlace.set((Object)true);
            SqlImplUtil.processAlterStatements(place.getContainingFile(), (PsiElement)info, (Processor<SqlAlterTableInstruction>)processor);
        }
        return columns2;
    }

    @Override
    @Nullable
    public String getColumnTypeAlias(int i2) {
        return this.myTableName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/psi/impl/TableBasedSqlTableTypeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnElement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

