/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AbstractAopInspection;
import com.intellij.aop.psi.AopPointcutExpressionHolder;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractArgNamesInspection
extends AbstractAopInspection {
    @Override
    protected void checkAopMethod(PsiMethod pointcutMethod, LocalAopModel model, ProblemsHolder holder, AopPointcutExpressionHolder aopFile) {
        ArgNamesManipulator manipulator = model.getArgNamesManipulator();
        if (manipulator != null) {
            this.checkAnnotation(pointcutMethod.getParameterList().getParameters(), holder, manipulator, pointcutMethod);
        }
    }

    @Override
    protected void checkElement(PsiElement element, ProblemsHolder holder) {
        super.checkElement(element, holder);
        for (AopProvider provider : (AopProvider[])Extensions.getExtensions(AopProvider.EXTENSION_POINT_NAME)) {
            Pair<? extends ArgNamesManipulator, PsiMethod> pair = provider.getCustomArgNamesManipulator(element);
            if (pair == null) continue;
            PsiMethod method = (PsiMethod)pair.second;
            this.checkAnnotation(method.getParameterList().getParameters(), holder, (ArgNamesManipulator)pair.first, method);
        }
    }

    protected abstract void checkAnnotation(PsiParameter[] var1, ProblemsHolder var2, ArgNamesManipulator var3, PsiMethod var4);

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = AopBundle.message("inspection.group.display.name.aop", new Object[0]);
        if (string == null) {
            AbstractArgNamesInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AbstractArgNamesInspection", "getGroupDisplayName"));
    }
}

