/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtilRt;
import gnu.trove.TIntLongHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BatchRecords
implements Serializable {
    public static final BatchRecords EMPTY = new BatchRecords((List<Object[]>)ContainerUtilRt.emptyList(), new TIntLongHashMap(), -1.0);
    protected final TIntLongHashMap myLines;
    protected final List<Object[]> myRecords;
    protected final double mySize;

    /*
     * WARNING - void declaration
     */
    public BatchRecords(@NotNull List<Object[]> objects, long startLine, double d) {
        void size;
        if (objects == null) {
            BatchRecords.$$$reportNull$$$0(0);
        }
        this(objects, BatchRecords.map(objects, startLine), (double)size);
    }

    public BatchRecords(@NotNull List<Object[]> records, @NotNull TIntLongHashMap map, double size) {
        if (records == null) {
            BatchRecords.$$$reportNull$$$0(1);
        }
        if (map == null) {
            BatchRecords.$$$reportNull$$$0(2);
        }
        this.myRecords = records;
        this.myLines = map;
        this.mySize = size;
    }

    @NotNull
    public List<Object[]> getRecords() {
        List<Object[]> list = this.myRecords;
        if (list == null) {
            BatchRecords.$$$reportNull$$$0(3);
        }
        return list;
    }

    public int getLinesCount() {
        return this.myRecords.size();
    }

    public double getBatchSize() {
        return this.mySize;
    }

    public boolean isEmpty() {
        return ((List)ObjectUtils.assertNotNull(this.myRecords)).isEmpty();
    }

    @NotNull
    public Builder builder() {
        Builder builder = new Builder(this.myLines, this.myRecords);
        if (builder == null) {
            BatchRecords.$$$reportNull$$$0(4);
        }
        return builder;
    }

    @NotNull
    public ErrorRecord getErrorRecord(@NotNull Exception e, int idx) {
        if (e == null) {
            BatchRecords.$$$reportNull$$$0(5);
        }
        ErrorRecord.ExceptionRecord exceptionRecord = new ErrorRecord.ExceptionRecord(e, this.getLineNumber(idx));
        if (exceptionRecord == null) {
            BatchRecords.$$$reportNull$$$0(6);
        }
        return exceptionRecord;
    }

    @NotNull
    public List<BatchRecords> split(int lines) {
        int batches = this.myRecords.size() / lines + (this.myRecords.size() % lines == 0 ? 0 : 1);
        int currentLineIndex = 0;
        ArrayList records = ContainerUtilRt.newArrayList();
        for (int i = 0; i < batches; ++i) {
            Builder builder = this.builder();
            int last = Math.min(currentLineIndex + lines, this.myRecords.size());
            for (int j = currentLineIndex; j < last; ++j) {
                builder.record(j);
            }
            double subBatchSize = this.mySize * (double)(last - currentLineIndex) / (double)this.myRecords.size();
            records.add(builder.size(subBatchSize).build());
            currentLineIndex += lines;
        }
        ArrayList arrayList = records;
        if (arrayList == null) {
            BatchRecords.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    protected long getLineNumber(int idx) {
        return this.myLines.get(idx);
    }

    @NotNull
    private static TIntLongHashMap map(@NotNull List<Object[]> objects, long line) {
        if (objects == null) {
            BatchRecords.$$$reportNull$$$0(8);
        }
        TIntLongHashMap map = new TIntLongHashMap();
        for (int i = 0; i < objects.size(); ++i) {
            map.put(i, line + (long)i + 1L);
        }
        TIntLongHashMap tIntLongHashMap = map;
        if (tIntLongHashMap == null) {
            BatchRecords.$$$reportNull$$$0(9);
        }
        return tIntLongHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/dbimport/BatchRecords";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/dbimport/BatchRecords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "builder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorRecord";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getErrorRecord";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        protected final TIntLongHashMap myOldLines;
        protected final List<Object[]> myOldRecords;
        protected final TIntLongHashMap myLines;
        protected final List<Object[]> myRecords;
        protected double mySize;

        protected Builder(@NotNull TIntLongHashMap lines, List<Object[]> records) {
            if (lines == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myOldLines = lines;
            this.myOldRecords = records;
            this.mySize = 0.0;
            this.myLines = new TIntLongHashMap();
            this.myRecords = ContainerUtilRt.newArrayList();
        }

        @NotNull
        public Builder size(double size) {
            this.mySize += size;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder record(@NotNull Object[] record, int oldIndex) {
            if (record == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myLines.put(this.myRecords.size(), this.myOldLines.get(oldIndex));
            this.myRecords.add(record);
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder record(int oldIndex) {
            Builder builder = this.record(this.myOldRecords.get(oldIndex), oldIndex);
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public BatchRecords build() {
            BatchRecords batchRecords = new BatchRecords(this.myRecords, this.myLines, this.mySize);
            if (batchRecords == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return batchRecords;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lines";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/dbimport/BatchRecords$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/dbimport/BatchRecords$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "size";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "record";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "record";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

