/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.CodeInsightTestData;
import com.intellij.codeInsight.EditorInfo;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.ProjectScope;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.LightPlatformCodeInsightTestCase;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeInsightTestCase
extends PsiTestCase {
    protected Editor myEditor;

    protected Editor createEditor(@NotNull VirtualFile file) {
        if (file == null) {
            CodeInsightTestCase.$$$reportNull$$$0(0);
        }
        FileEditorManager instance = FileEditorManager.getInstance(this.myProject);
        if (file.getFileType().isBinary()) {
            return null;
        }
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        Editor editor = instance.openTextEditor(new OpenFileDescriptor(this.myProject, file, 0), false);
        ((EditorImpl)editor).setCaretActive();
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        DaemonCodeAnalyzer.getInstance(this.getProject()).restart();
        return editor;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CodeInsightTestCase.fixTemplates();
    }

    public static void fixTemplates() {
        FileTemplateManager manager = FileTemplateManager.getDefaultInstance();
        block0: for (String tname : Arrays.asList("Class", "AnnotationType", "Enum", "Interface")) {
            for (FileTemplate template : manager.getInternalTemplates()) {
                if (!tname.equals(template.getName())) continue;
                String text = "package $PACKAGE_NAME$;\npublic " + manager.internalTemplateToSubject(tname) + " $NAME$ { }";
                template.setText(FileTemplateManagerImpl.normalizeText((String)text));
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myProject != null) {
                FileEditorManager editorManager = FileEditorManager.getInstance(this.myProject);
                for (VirtualFile openFile : editorManager.getOpenFiles()) {
                    editorManager.closeFile(openFile);
                }
            }
        }
        finally {
            this.myEditor = null;
            super.tearDown();
        }
    }

    @Override
    protected PsiTestData createData() {
        return new CodeInsightTestData();
    }

    protected void configureByFile(String filePath2) throws Exception {
        this.configureByFile(filePath2, null);
    }

    protected VirtualFile configureByFiles(@Nullable String projectRoot, String ... files) {
        if (files == null) {
            CodeInsightTestCase.$$$reportNull$$$0(1);
        }
        if (files.length == 0) {
            return null;
        }
        VirtualFile[] vFiles = new VirtualFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            vFiles[i2] = this.findVirtualFile(files[i2]);
            if (vFiles[i2] == null) continue;
            VfsTestUtil.assertFilePathEndsWithCaseSensitivePath((VirtualFile)vFiles[i2], (String)files[i2]);
        }
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        try {
            return this.configureByFiles(projectFile, vFiles);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void allowRootAccess(String filePath2) {
        VfsRootAccess.allowRootAccess((Disposable)this.getTestRootDisposable(), (String[])new String[]{filePath2});
    }

    protected VirtualFile configureByFile(String filePath2, @Nullable String projectRoot) throws Exception {
        VirtualFile vFile = this.findVirtualFile(filePath2);
        File projectFile = projectRoot == null ? null : new File(this.getTestDataPath() + projectRoot);
        return this.configureByFile(vFile, projectFile);
    }

    protected PsiFile configureByText(@NotNull FileType fileType, @NotNull String text) {
        if (fileType == null) {
            CodeInsightTestCase.$$$reportNull$$$0(2);
        }
        if (text == null) {
            CodeInsightTestCase.$$$reportNull$$$0(3);
        }
        return this.configureByText(fileType, text, null);
    }

    protected PsiFile configureByText(final @NotNull FileType fileType, final @NotNull String text, @Nullable String _extension) {
        if (fileType == null) {
            CodeInsightTestCase.$$$reportNull$$$0(4);
        }
        if (text == null) {
            CodeInsightTestCase.$$$reportNull$$$0(5);
        }
        try {
            final String extension = _extension == null ? fileType.getDefaultExtension() : _extension;
            File dir = this.createTempDirectory();
            File tempFile = FileUtil.createTempFile((File)dir, (String)"tempFile", (String)("." + extension), (boolean)true);
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            if (fileTypeManager.getFileTypeByExtension(extension) != fileType) {
                new WriteCommandAction(this.getProject(), new PsiFile[0]){

                    @Override
                    protected void run(@NotNull Result result) throws Exception {
                        if (result == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        fileTypeManager.associateExtension(fileType, extension);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/CodeInsightTestCase$1", "run"));
                    }
                }.execute();
            }
            final VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
            assert (vFile != null);
            new WriteAction(){

                @Override
                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    vFile.setCharset(CharsetToolkit.UTF8_CHARSET);
                    VfsUtil.saveText(vFile, text);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/CodeInsightTestCase$2", "run"));
                }
            }.execute();
            VirtualFile vdir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
            PsiTestUtil.addSourceRoot((Module)this.myModule, (VirtualFile)vdir);
            this.configureByExistingFile(vFile);
            CodeInsightTestCase.assertEquals((Object)fileType, (Object)this.myFile.getVirtualFile().getFileType());
            return this.myFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configureByFile(@NotNull VirtualFile vFile) throws IOException {
        if (vFile == null) {
            CodeInsightTestCase.$$$reportNull$$$0(6);
        }
        this.configureByFile(vFile, null);
    }

    protected void configureByExistingFile(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(7);
        }
        this.myFile = null;
        this.myEditor = null;
        Editor editor = this.createEditor(virtualFile2);
        Document document = editor.getDocument();
        EditorInfo editorInfo = new EditorInfo(document.getText());
        String newFileText = editorInfo.getNewFileText();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (virtualFile2 == null) {
                CodeInsightTestCase.$$$reportNull$$$0(49);
            }
            if (!document.getText().equals(newFileText)) {
                document.setText(newFileText);
            }
            PsiFile file = this.myPsiManager.findFile(virtualFile2);
            if (this.myFile == null) {
                this.myFile = file;
            }
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            editorInfo.applyToEditor(editor);
        });
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
    }

    protected VirtualFile configureByFiles(@Nullable File rawProjectRoot, VirtualFile ... vFiles) throws IOException {
        if (vFiles == null) {
            CodeInsightTestCase.$$$reportNull$$$0(8);
        }
        this.myFile = null;
        this.myEditor = null;
        File toDirIO = this.createTempDirectory();
        VirtualFile toDir = CodeInsightTestCase.getVirtualFile((File)toDirIO);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (vFiles == null) {
                CodeInsightTestCase.$$$reportNull$$$0(48);
            }
            try {
                LinkedHashMap<VirtualFile, EditorInfo> editorInfos;
                ModuleRootManager rootManager = ModuleRootManager.getInstance(this.myModule);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                if (this.clearModelBeforeConfiguring()) {
                    rootModel.clear();
                }
                Object[] reversed = (VirtualFile[])ArrayUtil.reverseArray((Object[])vFiles);
                if (rawProjectRoot != null) {
                    Object[] projectRoot = rawProjectRoot.getCanonicalFile();
                    FileUtil.copyDir((File)projectRoot, (File)toDirIO);
                    VirtualFile fromDir = CodeInsightTestCase.getVirtualFile((File)projectRoot);
                    editorInfos = this.copyFilesFillingEditorInfos(fromDir, toDir, (String[])ContainerUtil.map2Array((Object[])reversed, String.class, arg_0 -> CodeInsightTestCase.lambda$null$1((File)projectRoot, arg_0)));
                    toDir.refresh(false, true);
                } else {
                    editorInfos = new LinkedHashMap();
                    for (Object vFile : reversed) {
                        VirtualFile parent = ((VirtualFile)vFile).getParent();
                        assert (parent.isDirectory()) : parent;
                        editorInfos.putAll(this.copyFilesFillingEditorInfos(parent, toDir, ((VirtualFile)vFile).getName()));
                    }
                }
                boolean sourceRootAdded = false;
                if (this.isAddDirToContentRoot()) {
                    ContentEntry contentEntry = rootModel.addContentEntry(toDir);
                    if (this.isAddDirToSource()) {
                        sourceRootAdded = true;
                        contentEntry.addSourceFolder(toDir, this.isAddDirToTests());
                    }
                }
                this.doCommitModel(rootModel);
                if (sourceRootAdded) {
                    this.sourceRootAdded(toDir);
                }
                this.openEditorsAndActivateLast(editorInfos);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        });
        return toDir;
    }

    protected boolean isAddDirToTests() {
        return false;
    }

    protected void doCommitModel(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            CodeInsightTestCase.$$$reportNull$$$0(9);
        }
        rootModel.commit();
    }

    protected void sourceRootAdded(VirtualFile dir) {
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull String testDataFromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (testDataFromDir == null) {
            CodeInsightTestCase.$$$reportNull$$$0(10);
        }
        if (toDir == null) {
            CodeInsightTestCase.$$$reportNull$$$0(11);
        }
        if (relativePaths == null) {
            CodeInsightTestCase.$$$reportNull$$$0(12);
        }
        if (!testDataFromDir.startsWith("/")) {
            testDataFromDir = "/" + testDataFromDir;
        }
        Map<VirtualFile, EditorInfo> map = this.copyFilesFillingEditorInfos(LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getTestDataPath() + testDataFromDir), toDir, relativePaths);
        if (map == null) {
            CodeInsightTestCase.$$$reportNull$$$0(13);
        }
        return map;
    }

    @NotNull
    protected Map<VirtualFile, EditorInfo> copyFilesFillingEditorInfos(@NotNull VirtualFile fromDir, @NotNull VirtualFile toDir, String ... relativePaths) throws IOException {
        if (fromDir == null) {
            CodeInsightTestCase.$$$reportNull$$$0(14);
        }
        if (toDir == null) {
            CodeInsightTestCase.$$$reportNull$$$0(15);
        }
        if (relativePaths == null) {
            CodeInsightTestCase.$$$reportNull$$$0(16);
        }
        LinkedHashMap<VirtualFile, EditorInfo> editorInfos = new LinkedHashMap<VirtualFile, EditorInfo>();
        ArrayList<OutputStream> streamsToClose = new ArrayList<OutputStream>();
        for (String relativePath : relativePaths) {
            relativePath = StringUtil.trimStart((String)relativePath, (String)"/");
            VirtualFile fromFile = fromDir.findFileByRelativePath(relativePath);
            CodeInsightTestCase.assertNotNull((String)(fromDir.getPath() + "/" + relativePath), (Object)fromFile);
            VirtualFile toFile = toDir.findFileByRelativePath(relativePath);
            if (toFile == null) {
                File file = new File(toDir.getPath(), relativePath);
                FileUtil.createIfDoesntExist((File)file);
                toFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                CodeInsightTestCase.assertNotNull((String)file.getCanonicalPath(), (Object)toFile);
            }
            toFile.putUserData(VfsTestUtil.TEST_DATA_FILE_PATH, FileUtil.toSystemDependentName((String)fromFile.getPath()));
            editorInfos.put(toFile, this.copyContent(fromFile, toFile, streamsToClose));
        }
        for (int i2 = streamsToClose.size() - 1; i2 >= 0; --i2) {
            ((OutputStream)streamsToClose.get(i2)).close();
        }
        LinkedHashMap<VirtualFile, EditorInfo> linkedHashMap = editorInfos;
        if (linkedHashMap == null) {
            CodeInsightTestCase.$$$reportNull$$$0(17);
        }
        return linkedHashMap;
    }

    private EditorInfo copyContent(@NotNull VirtualFile from, @NotNull VirtualFile to, @NotNull List<OutputStream> streamsToClose) throws IOException {
        if (from == null) {
            CodeInsightTestCase.$$$reportNull$$$0(18);
        }
        if (to == null) {
            CodeInsightTestCase.$$$reportNull$$$0(19);
        }
        if (streamsToClose == null) {
            CodeInsightTestCase.$$$reportNull$$$0(20);
        }
        byte[] content = from.getFileType().isBinary() ? from.contentsToByteArray() : null;
        String fileText = from.getFileType().isBinary() ? null : StringUtil.convertLineSeparators((String)VfsUtilCore.loadText(from));
        EditorInfo editorInfo = fileText == null ? null : new EditorInfo(fileText);
        String newFileText = fileText == null ? null : editorInfo.getNewFileText();
        this.doWrite(newFileText, to, content, streamsToClose);
        return editorInfo;
    }

    protected final void setActiveEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(21);
        }
        this.myEditor = editor;
        this.myFile = this.getPsiFile(editor.getDocument());
    }

    @NotNull
    protected List<Editor> openEditorsAndActivateLast(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        if (editorInfos == null) {
            CodeInsightTestCase.$$$reportNull$$$0(22);
        }
        List<Editor> list = this.openEditors(editorInfos);
        this.setActiveEditor(list.get(list.size() - 1));
        List<Editor> list2 = list;
        if (list2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(23);
        }
        return list2;
    }

    @NotNull
    protected final List<Editor> openEditors(@NotNull Map<VirtualFile, EditorInfo> editorInfos) {
        if (editorInfos == null) {
            CodeInsightTestCase.$$$reportNull$$$0(24);
        }
        List list = ContainerUtil.map(editorInfos.keySet(), newVFile -> {
            EditorInfo editorInfo;
            if (editorInfos == null) {
                CodeInsightTestCase.$$$reportNull$$$0(47);
            }
            PsiFile file = this.myPsiManager.findFile(newVFile);
            if (this.myFile == null) {
                this.myFile = file;
            }
            Editor editor = this.createEditor((VirtualFile)newVFile);
            if (this.myEditor == null) {
                this.myEditor = editor;
            }
            if ((editorInfo = (EditorInfo)editorInfos.get(newVFile)) != null) {
                editorInfo.applyToEditor(editor);
            }
            return editor;
        });
        if (list == null) {
            CodeInsightTestCase.$$$reportNull$$$0(25);
        }
        return list;
    }

    private void doWrite(String newFileText, @NotNull VirtualFile newVFile, byte[] content, @NotNull List<OutputStream> streamsToClose) throws IOException {
        if (newVFile == null) {
            CodeInsightTestCase.$$$reportNull$$$0(26);
        }
        if (streamsToClose == null) {
            CodeInsightTestCase.$$$reportNull$$$0(27);
        }
        if (newFileText == null) {
            OutputStream outputStream = newVFile.getOutputStream((Object)this, -1L, -1L);
            outputStream.write(content);
            streamsToClose.add(outputStream);
        } else {
            CodeInsightTestCase.setFileText((VirtualFile)newVFile, (String)newFileText);
        }
    }

    protected boolean isAddDirToContentRoot() {
        return true;
    }

    protected boolean isAddDirToSource() {
        return true;
    }

    protected VirtualFile configureByFile(@NotNull VirtualFile vFile, File projectRoot) throws IOException {
        if (vFile == null) {
            CodeInsightTestCase.$$$reportNull$$$0(28);
        }
        return this.configureByFiles(projectRoot, vFile);
    }

    protected boolean clearModelBeforeConfiguring() {
        return false;
    }

    protected void setupCursorAndSelection(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(29);
        }
        Document document = editor.getDocument();
        EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)document);
        EditorTestUtil.setCaretsAndSelection((Editor)editor, (EditorTestUtil.CaretAndSelectionState)caretState);
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
    }

    @Override
    protected void configure(@NotNull String path2, String dataName) throws Exception {
        int selectionEnd;
        if (path2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(30);
        }
        super.configure(path2, dataName);
        this.myEditor = this.createEditor(this.myFile.getVirtualFile());
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataBefore;
        LogicalPosition pos = new LogicalPosition(data.getLineNumber() - 1, data.getColumnNumber() - 1);
        this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        int selectionStart = selectionEnd = this.myEditor.getCaretModel().getOffset();
        if (data.getSelectionStartColumnNumber() >= 0) {
            selectionStart = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionStartColumnNumber() - 1));
            selectionEnd = this.myEditor.logicalPositionToOffset(new LogicalPosition(data.getSelectionEndLineNumber() - 1, data.getSelectionEndColumnNumber() - 1));
        }
        this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
    }

    protected void checkResultByFile(@NotNull String filePath2) throws Exception {
        if (filePath2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(31);
        }
        this.checkResultByFile(filePath2, false);
    }

    protected void checkResultByFile(final @NotNull String filePath2, final boolean stripTrailingSpaces) throws Exception {
        if (filePath2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(32);
        }
        new WriteCommandAction<Document>(this.getProject(), new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<Document> result) throws Throwable {
                String expectedText;
                if (result == null) {
                    3.$$$reportNull$$$0(0);
                }
                this.getProject().getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
                if (stripTrailingSpaces) {
                    ((DocumentImpl)CodeInsightTestCase.this.myEditor.getDocument()).stripTrailingSpaces(this.getProject());
                }
                PsiDocumentManager.getInstance(CodeInsightTestCase.this.myProject).commitAllDocuments();
                VirtualFile vFile = CodeInsightTestCase.this.findVirtualFile(filePath2);
                VfsTestUtil.assertFilePathEndsWithCaseSensitivePath((VirtualFile)vFile, (String)filePath2);
                try {
                    expectedText = VfsUtilCore.loadText(vFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                expectedText = StringUtil.convertLineSeparators((String)expectedText);
                Document document = EditorFactory.getInstance().createDocument(expectedText);
                EditorTestUtil.CaretAndSelectionState caretState = EditorTestUtil.extractCaretAndSelectionMarkers((Document)document);
                expectedText = document.getText();
                if (stripTrailingSpaces) {
                    Document document1 = EditorFactory.getInstance().createDocument(expectedText);
                    ((DocumentImpl)document1).stripTrailingSpaces(this.getProject());
                    expectedText = document1.getText();
                }
                if (CodeInsightTestCase.this.myEditor instanceof EditorWindow) {
                    CodeInsightTestCase.this.myEditor = ((EditorWindow)CodeInsightTestCase.this.myEditor).getDelegate();
                }
                CodeInsightTestCase.this.myFile = PsiDocumentManager.getInstance(this.getProject()).getPsiFile(CodeInsightTestCase.this.myEditor.getDocument());
                String actualText = StringUtil.convertLineSeparators((String)CodeInsightTestCase.this.myFile.getText());
                if (!Comparing.equal((String)expectedText, (String)actualText)) {
                    throw new FileComparisonFailure("Text mismatch in file " + filePath2, expectedText, actualText, vFile.getPath());
                }
                EditorTestUtil.verifyCaretAndSelectionState((Editor)CodeInsightTestCase.this.myEditor, (EditorTestUtil.CaretAndSelectionState)caretState);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/CodeInsightTestCase$3", "run"));
            }
        }.execute();
    }

    @Override
    protected void checkResult(String dataName) throws Exception {
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        super.checkResult(dataName);
        CodeInsightTestData data = (CodeInsightTestData)this.myTestDataAfter;
        if (data.getColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretColumn"), (int)data.getColumnNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().column + 1));
        }
        if (data.getLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":caretLine"), (int)data.getLineNumber(), (int)(this.myEditor.getCaretModel().getLogicalPosition().line + 1));
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        LogicalPosition startPosition = this.myEditor.offsetToLogicalPosition(selectionStart);
        LogicalPosition endPosition = this.myEditor.offsetToLogicalPosition(selectionEnd);
        if (data.getSelectionStartColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartColumn"), (int)data.getSelectionStartColumnNumber(), (int)(startPosition.column + 1));
        }
        if (data.getSelectionStartLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionStartLine"), (int)data.getSelectionStartLineNumber(), (int)(startPosition.line + 1));
        }
        if (data.getSelectionEndColumnNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndColumn"), (int)data.getSelectionEndColumnNumber(), (int)(endPosition.column + 1));
        }
        if (data.getSelectionEndLineNumber() >= 0) {
            CodeInsightTestCase.assertEquals((String)(dataName + ":selectionEndLine"), (int)data.getSelectionEndLineNumber(), (int)(endPosition.line + 1));
        }
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NotNull String filePath2) {
        if (filePath2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(33);
        }
        VirtualFile virtualFile2 = this.findVirtualFile(filePath2);
        if (virtualFile2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(34);
        }
        return virtualFile2;
    }

    @NotNull
    protected VirtualFile findVirtualFile(@NotNull String filePath2) {
        if (filePath2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(35);
        }
        String absolutePath = this.getTestDataPath() + filePath2;
        this.allowRootAccess(absolutePath);
        VirtualFile virtualFile2 = VfsTestUtil.findFileByCaseSensitivePath((String)absolutePath);
        if (virtualFile2 == null) {
            CodeInsightTestCase.$$$reportNull$$$0(36);
        }
        return virtualFile2;
    }

    @NotNull
    protected String getTestRoot() {
        String string = FileUtil.toSystemIndependentName((String)this.getTestDataPath());
        if (string == null) {
            CodeInsightTestCase.$$$reportNull$$$0(37);
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type((char)c, (Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void undo() {
        UndoManager undoManager = UndoManager.getInstance(this.myProject);
        TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(this.getEditor());
        undoManager.undo(textEditor);
    }

    protected void caretLeft() {
        this.caretLeft(this.getEditor());
    }

    protected void caretLeft(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(38);
        }
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorLeft", (Editor)editor, (Project)this.getProject());
    }

    protected void caretRight() {
        this.caretRight(this.getEditor());
    }

    protected void caretRight(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(39);
        }
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorRight", (Editor)editor, (Project)this.getProject());
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.executeAction((String)"EditorUp", (Editor)this.myEditor, (Project)this.getProject());
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine((Editor)this.myEditor, (Project)this.getProject());
    }

    protected void type(@NotNull String s) {
        if (s == null) {
            CodeInsightTestCase.$$$reportNull$$$0(40);
        }
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void backspace() {
        this.backspace(this.getEditor());
    }

    protected void backspace(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(41);
        }
        LightPlatformCodeInsightTestCase.backspace((Editor)editor, (Project)this.getProject());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW((Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD((Editor)this.getEditor(), (Project)this.getProject());
    }

    protected void delete(@NotNull Editor editor) {
        if (editor == null) {
            CodeInsightTestCase.$$$reportNull$$$0(42);
        }
        LightPlatformCodeInsightTestCase.delete((Editor)editor, (Project)this.getProject());
    }

    @NotNull
    protected PsiClass findClass(@NotNull String name) {
        if (name == null) {
            CodeInsightTestCase.$$$reportNull$$$0(43);
        }
        PsiClass aClass = this.myJavaFacade.findClass(name, ProjectScope.getProjectScope(this.getProject()));
        CodeInsightTestCase.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            CodeInsightTestCase.$$$reportNull$$$0(44);
        }
        return psiClass;
    }

    @NotNull
    protected PsiPackage findPackage(@NotNull String name) {
        if (name == null) {
            CodeInsightTestCase.$$$reportNull$$$0(45);
        }
        PsiPackage aPackage = this.myJavaFacade.findPackage(name);
        CodeInsightTestCase.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        PsiPackage psiPackage = aPackage;
        if (psiPackage == null) {
            CodeInsightTestCase.$$$reportNull$$$0(46);
        }
        return psiPackage;
    }

    private static /* synthetic */ String lambda$null$1(File projectRoot, VirtualFile s) {
        return s.getPath().substring(projectRoot.getPath().length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 34: 
            case 36: 
            case 37: 
            case 44: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 34: 
            case 36: 
            case 37: 
            case 44: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 7: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataFromDir";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDir";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePaths";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 34: 
            case 36: 
            case 37: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/CodeInsightTestCase";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "streamsToClose";
                break;
            }
            case 21: 
            case 29: 
            case 38: 
            case 39: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: 
            case 24: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorInfos";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/CodeInsightTestCase";
                break;
            }
            case 13: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFilesFillingEditorInfos";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditorsAndActivateLast";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditors";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findVirtualFile";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoot";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "findClass";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "configureByFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureByText";
                break;
            }
            case 6: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "configureByFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureByExistingFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doCommitModel";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "copyFilesFillingEditorInfos";
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 34: 
            case 36: 
            case 37: 
            case 44: 
            case 46: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyContent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setActiveEditor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "openEditorsAndActivateLast";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "openEditors";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doWrite";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setupCursorAndSelection";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkResultByFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findVirtualFile";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "caretLeft";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "caretRight";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "type";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "backspace";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "delete";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openEditors$3";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureByFiles$2";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$configureByExistingFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 34: 
            case 36: 
            case 37: 
            case 44: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

