/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParenthesesInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    public static final ParenthesesInsertHandler<LookupElement> WITH_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return true;
        }
    };
    public static final ParenthesesInsertHandler<LookupElement> NO_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return false;
        }
    };
    private final boolean mySpaceBeforeParentheses;
    private final boolean mySpaceBetweenParentheses;
    private final boolean myMayInsertRightParenthesis;
    private final boolean myAllowParametersOnNextLine;
    private final char myLeftParenthesis;
    private final char myRightParenthesis;

    public static ParenthesesInsertHandler<LookupElement> getInstance(boolean hasParameters) {
        return hasParameters ? WITH_PARAMETERS : NO_PARAMETERS;
    }

    public static ParenthesesInsertHandler<LookupElement> getInstance(final boolean hasParameters, boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean insertRightParenthesis, boolean allowParametersOnNextLine) {
        return new ParenthesesInsertHandler<LookupElement>(spaceBeforeParentheses, spaceBetweenParentheses, insertRightParenthesis, allowParametersOnNextLine){

            @Override
            protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                return hasParameters;
            }
        };
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, false);
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, allowParametersOnNextLine, '(', ')');
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine, char leftParenthesis, char rightParenthesis) {
        this.mySpaceBeforeParentheses = spaceBeforeParentheses;
        this.mySpaceBetweenParentheses = spaceBetweenParentheses;
        this.myMayInsertRightParenthesis = mayInsertRightParenthesis;
        this.myAllowParametersOnNextLine = allowParametersOnNextLine;
        this.myLeftParenthesis = leftParenthesis;
        this.myRightParenthesis = rightParenthesis;
    }

    protected ParenthesesInsertHandler() {
        this(false, false, true);
    }

    private static boolean isToken(@Nullable PsiElement element, String text) {
        return element != null && text.equals(element.getText());
    }

    protected abstract boolean placeCaretInsideParentheses(InsertionContext var1, T var2);

    @Override
    public void handleInsert(InsertionContext context, T item) {
        int tail;
        boolean putCaretInside;
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        context.commitDocument();
        PsiElement lParen = this.findExistingLeftParenthesis(context);
        char completionChar = context.getCompletionChar();
        boolean bl = putCaretInside = completionChar == this.myLeftParenthesis || this.placeCaretInsideParentheses(context, item);
        if (completionChar == this.myLeftParenthesis) {
            context.setAddCompletionChar(false);
        }
        if (lParen != null) {
            int lparenthOffset = lParen.getTextRange().getStartOffset();
            if (this.mySpaceBeforeParentheses && lparenthOffset == context.getTailOffset()) {
                document.insertString(context.getTailOffset(), " ");
                ++lparenthOffset;
            }
            if (completionChar == this.myLeftParenthesis || completionChar == '\t') {
                editor.getCaretModel().moveToOffset(lparenthOffset + 1);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            context.setTailOffset(lparenthOffset + 1);
            PsiElement list = lParen.getParent();
            PsiElement last = list.getLastChild();
            if (ParenthesesInsertHandler.isToken(last, String.valueOf(this.myRightParenthesis))) {
                int rparenthOffset = last.getTextRange().getStartOffset();
                context.setTailOffset(rparenthOffset + 1);
                if (!putCaretInside) {
                    for (int i2 = lparenthOffset + 1; i2 < rparenthOffset; ++i2) {
                        if (Character.isWhitespace(document.getCharsSequence().charAt(i2))) continue;
                        return;
                    }
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                } else if (this.mySpaceBetweenParentheses && document.getCharsSequence().charAt(lparenthOffset) == ' ') {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 2);
                } else {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 1);
                }
                return;
            }
        } else {
            document.insertString(context.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBeforeParentheses) + this.myLeftParenthesis + ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses));
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (!this.myMayInsertRightParenthesis) {
            return;
        }
        if (context.getCompletionChar() == this.myLeftParenthesis && (tail = context.getTailOffset()) < document.getTextLength() && StringUtil.isJavaIdentifierPart((char)document.getCharsSequence().charAt(tail))) {
            return;
        }
        document.insertString(context.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses) + this.myRightParenthesis);
        if (!putCaretInside) {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
    }

    private static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }

    @Nullable
    protected PsiElement findExistingLeftParenthesis(@NotNull InsertionContext context) {
        PsiElement element;
        if (context == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(0);
        }
        return ParenthesesInsertHandler.isToken(element = this.findNextToken(context), String.valueOf(this.myLeftParenthesis)) ? element : null;
    }

    @Nullable
    protected PsiElement findNextToken(@NotNull InsertionContext context) {
        PsiFile file;
        PsiElement element;
        if (context == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(1);
        }
        if ((element = (file = context.getFile()).findElementAt(context.getTailOffset())) instanceof PsiWhiteSpace) {
            if (!this.myAllowParametersOnNextLine && element.getText().contains("\n")) {
                return null;
            }
            element = file.findElementAt(element.getTextRange().getEndOffset());
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/intellij/codeInsight/completion/util/ParenthesesInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingLeftParenthesis";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findNextToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

