/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(2);
        }
        super(element, textRange, icon, updatePass, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> var1);

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(3);
        }
        Function function = element -> {
            if (infos == null) {
                MergeableLineMarkerInfo.$$$reportNull$$$0(12);
            }
            HashSet tooltips = new HashSet(ContainerUtil.mapNotNull((Collection)infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (tooltip.length() > 0) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody((String)info2));
            }
            return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
        };
        if (function == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(4);
        }
        return function;
    }

    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(5);
        }
        return GutterIconRenderer.Alignment.LEFT;
    }

    public String getElementPresentation(PsiElement element) {
        return element.getText();
    }

    public int getCommonUpdatePass(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(6);
        }
        return this.updatePass;
    }

    public boolean configurePopupAndRenderer(@NotNull PopupChooserBuilder builder, @NotNull JBList list, @NotNull List<MergeableLineMarkerInfo> markers) {
        if (builder == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(7);
        }
        if (list == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(8);
        }
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(9);
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo> merge(@NotNull List<MergeableLineMarkerInfo> markers) {
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(10);
        }
        SmartList result = new SmartList();
        for (int i2 = 0; i2 < markers.size(); ++i2) {
            MergeableLineMarkerInfo marker = markers.get(i2);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i2; --k) {
                MergeableLineMarkerInfo current = markers.get(k);
                if (!marker.canMergeWith(current)) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result.add(new MyLineMarkerInfo((List)toMerge));
        }
        SmartList smartList = result;
        if (smartList == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTooltip";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTooltip";
                break;
            }
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIconAlignment";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommonUpdatePass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configurePopupAndRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getCommonTooltip$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyLineMarkerInfo(@NotNull List<MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(0);
            }
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<MergeableLineMarkerInfo> markers, @NotNull MergeableLineMarkerInfo template) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (template == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonUpdatePass(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        private static TextRange getCommonTextRange(List<MergeableLineMarkerInfo> markers) {
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(final @NotNull List<MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(3);
            }
            return new GutterIconNavigationHandler<PsiElement>(){

                @Override
                public void navigate(MouseEvent e, PsiElement elt) {
                    ArrayList<MergeableLineMarkerInfo> infos = new ArrayList<MergeableLineMarkerInfo>(markers);
                    Collections.sort(infos, (o1, o2) -> o1.startOffset - o2.startOffset);
                    JBList list = new JBList(infos);
                    list.setFixedCellHeight(20);
                    PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder(list);
                    if (!((MergeableLineMarkerInfo)markers.get(0)).configurePopupAndRenderer(builder, list, infos)) {
                        list.installCellRenderer(dom -> {
                            if (dom instanceof LineMarkerInfo) {
                                Icon icon = null;
                                GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                                if (renderer != null) {
                                    icon = renderer.getIcon();
                                }
                                Object element = ((LineMarkerInfo)dom).getElement();
                                assert (element != null);
                                String elementPresentation = dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element) : element.getText();
                                String text = StringUtil.first((String)elementPresentation, (int)100, (boolean)true).replace('\n', ' ');
                                JBLabel label = new JBLabel(text, icon, 2);
                                label.setBorder(JBUI.Borders.empty((int)2));
                                return label;
                            }
                            return new JBLabel();
                        });
                    }
                    builder.setItemChoosenCallback(() -> {
                        GutterIconNavigationHandler handler;
                        Object value = list.getSelectedValue();
                        if (value instanceof LineMarkerInfo && (handler = ((LineMarkerInfo)value).getNavigationHandler()) != null) {
                            handler.navigate(e, ((LineMarkerInfo)value).getElement());
                        }
                    }).createPopup().show(new RelativePoint(e));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCommonNavigationHandler";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

