/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PathsList;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleJavaParameters
extends SimpleProgramParameters {
    private static final Logger LOG = Logger.getInstance(SimpleJavaParameters.class);
    private Sdk myJdk;
    private String myMainClass;
    private final PathsList myClassPath = new PathsList();
    private String myModuleName;
    private final PathsList myModulePath = new PathsList();
    private final ParametersList myVmParameters = new ParametersList();
    private Charset myCharset = CharsetToolkit.getDefaultSystemCharset();
    private boolean myUseDynamicClasspath;
    private boolean myUseDynamicVMOptions;
    private boolean myUseDynamicParameters;
    private boolean myUseClasspathJar;
    private String myJarPath;

    @Nullable
    public Sdk getJdk() {
        return this.myJdk;
    }

    public void setJdk(Sdk jdk) {
        this.myJdk = jdk;
    }

    public String getMainClass() {
        return this.myMainClass;
    }

    public void setMainClass(String mainClass) {
        this.myMainClass = mainClass;
    }

    public PathsList getClassPath() {
        return this.myClassPath;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public void setModuleName(String moduleName) {
        this.myModuleName = moduleName;
    }

    public PathsList getModulePath() {
        return this.myModulePath;
    }

    public ParametersList getVMParametersList() {
        return this.myVmParameters;
    }

    @Nullable
    public Charset getCharset() {
        return this.myCharset;
    }

    public void setCharset(@Nullable Charset charset) {
        this.myCharset = charset;
    }

    public boolean isDynamicClasspath() {
        return this.myUseDynamicClasspath;
    }

    public void setUseDynamicClasspath(boolean useDynamicClasspath) {
        this.myUseDynamicClasspath = useDynamicClasspath;
    }

    public void setUseDynamicClasspath(@Nullable Project project) {
        this.myUseDynamicClasspath = JdkUtil.useDynamicClasspath(project);
    }

    public boolean isDynamicVMOptions() {
        return this.myUseDynamicVMOptions;
    }

    public void setUseDynamicVMOptions(boolean useDynamicVMOptions) {
        this.myUseDynamicVMOptions = useDynamicVMOptions;
    }

    public boolean isDynamicParameters() {
        return this.myUseDynamicParameters;
    }

    public void setUseDynamicParameters(boolean useDynamicParameters) {
        this.myUseDynamicParameters = useDynamicParameters;
    }

    public boolean isUseClasspathJar() {
        return this.myUseClasspathJar;
    }

    public void setUseClasspathJar(boolean useClasspathJar) {
        this.myUseClasspathJar = useClasspathJar;
    }

    public String getJarPath() {
        return this.myJarPath;
    }

    public void setJarPath(String jarPath) {
        this.myJarPath = jarPath;
    }

    @NotNull
    public GeneralCommandLine toCommandLine() throws CantRunException {
        GeneralCommandLine generalCommandLine = JdkUtil.setupJVMCommandLine(this);
        if (generalCommandLine == null) {
            SimpleJavaParameters.$$$reportNull$$$0(0);
        }
        return generalCommandLine;
    }

    @NotNull
    public OSProcessHandler createOSProcessHandler() throws ExecutionException {
        OSProcessHandler processHandler = new OSProcessHandler(this.toCommandLine());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        OSProcessHandler oSProcessHandler = processHandler;
        if (oSProcessHandler == null) {
            SimpleJavaParameters.$$$reportNull$$$0(1);
        }
        return oSProcessHandler;
    }

    public boolean isPassProgramParametersViaClasspathJar() {
        return this.isDynamicParameters();
    }

    public void setPassProgramParametersViaClasspathJar(boolean passProgramParametersViaClasspathJar) {
        LOG.assertTrue(this.myUseClasspathJar);
        this.setUseDynamicParameters(passProgramParametersViaClasspathJar);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/execution/configurations/SimpleJavaParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "toCommandLine";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOSProcessHandler";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

