/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FileEditorProvider;
import com.intellij.ide.SelectInContext;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorSelectInContext
implements SelectInContext {
    private final FileEditor myFileEditor;
    private final PsiFile myPsiFile;

    public FileEditorSelectInContext(@NotNull FileEditor fileEditor, @NotNull PsiFile psiFile) {
        if (fileEditor == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(1);
        }
        this.myFileEditor = fileEditor;
        this.myPsiFile = psiFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myPsiFile.getProject();
        if (project == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile2 = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile2 == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    @NotNull
    public FileEditor getFileEditor() {
        FileEditor fileEditor = this.myFileEditor;
        if (fileEditor == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(4);
        }
        return fileEditor;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            FileEditorSelectInContext.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @Override
    @Nullable
    public Object getSelectorInFile() {
        return ObjectUtils.notNull((Object)this.getElementAtCaret(false), (Object)this.myPsiFile);
    }

    @Nullable
    public PsiElement getElementAtCaret(boolean tryInjected) {
        InjectedLanguageManager manager;
        PsiElement injectedElementAt;
        if (!(this.myFileEditor instanceof TextEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)this.myFileEditor).getEditor();
        int offset = editor.getCaretModel().getOffset();
        if (tryInjected && (injectedElementAt = (manager = InjectedLanguageManager.getInstance(this.getProject())).findInjectedElementAt(this.myPsiFile, offset)) != null) {
            return injectedElementAt;
        }
        return this.myPsiFile.findElementAt(offset);
    }

    @Override
    @Nullable
    public FileEditorProvider getFileEditorProvider() {
        return new FileEditorProvider(){

            @Override
            public FileEditor openFileEditor() {
                return FileEditorSelectInContext.this.myFileEditor;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileEditorSelectInContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileEditorSelectInContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

