/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PresentableNodeDescriptor<E>
extends NodeDescriptor<E> {
    private PresentationData myTemplatePresentation;
    private PresentationData myUpdatedPresentation;

    protected PresentableNodeDescriptor(Project project, @Nullable NodeDescriptor parentDescriptor) {
        super(project, parentDescriptor);
    }

    @Override
    public final boolean update() {
        if (this.shouldUpdateData()) {
            PresentationData before = this.getPresentation().clone();
            PresentationData updated = this.getUpdatedPresentation();
            return this.shouldApply() && this.apply(updated, before);
        }
        return false;
    }

    protected final boolean apply(PresentationData presentation) {
        return this.apply(presentation, null);
    }

    @Override
    public void applyFrom(NodeDescriptor desc) {
        if (desc instanceof PresentableNodeDescriptor) {
            PresentableNodeDescriptor pnd = (PresentableNodeDescriptor)desc;
            this.apply(pnd.getPresentation());
        } else {
            super.applyFrom(desc);
        }
    }

    protected final boolean apply(PresentationData presentation, @Nullable PresentationData before) {
        boolean updated;
        this.setIcon(presentation.getIcon(false));
        this.myName = presentation.getPresentableText();
        this.myColor = presentation.getForcedTextForeground();
        boolean bl = updated = before == null || !presentation.equals(before);
        if (this.myUpdatedPresentation == null) {
            this.myUpdatedPresentation = this.createPresentation();
        }
        this.myUpdatedPresentation.copyFrom(presentation);
        if (this.myTemplatePresentation != null) {
            this.myUpdatedPresentation.applyFrom(this.myTemplatePresentation);
        }
        this.myUpdatedPresentation.setChanged(false);
        return updated |= this.myUpdatedPresentation.isChanged();
    }

    private PresentationData getUpdatedPresentation() {
        PresentationData presentation;
        this.myUpdatedPresentation = presentation = this.myUpdatedPresentation != null ? this.myUpdatedPresentation : this.createPresentation();
        presentation.clear();
        this.update(presentation);
        if (this.shouldPostprocess()) {
            this.postprocess(presentation);
        }
        return presentation;
    }

    @NotNull
    protected PresentationData createPresentation() {
        PresentationData presentationData = new PresentationData();
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(0);
        }
        return presentationData;
    }

    protected void postprocess(@NotNull PresentationData date) {
        if (date == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(1);
        }
    }

    protected boolean shouldPostprocess() {
        return true;
    }

    protected boolean shouldApply() {
        return true;
    }

    protected boolean shouldUpdateData() {
        return true;
    }

    protected abstract void update(PresentationData var1);

    @NotNull
    public final PresentationData getPresentation() {
        PresentationData result = this.myUpdatedPresentation == null ? this.getTemplatePresentation() : this.myUpdatedPresentation;
        PresentationData presentationData = result;
        if (presentationData == null) {
            PresentableNodeDescriptor.$$$reportNull$$$0(2);
        }
        return presentationData;
    }

    protected final PresentationData getTemplatePresentation() {
        if (this.myTemplatePresentation == null) {
            this.myTemplatePresentation = this.createPresentation();
        }
        return this.myTemplatePresentation;
    }

    public boolean isContentHighlighted() {
        return false;
    }

    public boolean isHighlightableContentNode(PresentableNodeDescriptor kid) {
        return true;
    }

    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        return null;
    }

    public boolean isParentOf(NodeDescriptor eachNode) {
        for (NodeDescriptor eachParent = eachNode.getParentDescriptor(); eachParent != null; eachParent = eachParent.getParentDescriptor()) {
            if (eachParent != this) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOrSelf(NodeDescriptor selectedNode) {
        for (NodeDescriptor node = selectedNode; node != null; node = node.getParentDescriptor()) {
            if (!this.equals(node)) continue;
            return true;
        }
        return false;
    }

    public Color getHighlightColor() {
        return UIUtil.isUnderDarcula() ? ColorUtil.shift((Color)UIUtil.getTreeBackground(), (double)1.1) : UIUtil.getTreeBackground().brighter();
    }

    public String getName() {
        if (!this.getPresentation().getColoredText().isEmpty()) {
            StringBuilder result = new StringBuilder("");
            for (ColoredFragment each : this.getPresentation().getColoredText()) {
                result.append(each.getText());
            }
            return result.toString();
        }
        return this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/PresentableNodeDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "postprocess";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ColoredFragment {
        private final String myText;
        private final String myToolTip;
        private final SimpleTextAttributes myAttributes;

        public ColoredFragment(String aText, SimpleTextAttributes aAttributes) {
            this(aText, null, aAttributes);
        }

        public ColoredFragment(String aText, String toolTip, SimpleTextAttributes aAttributes) {
            this.myText = aText == null ? "" : aText;
            this.myAttributes = aAttributes;
            this.myToolTip = toolTip;
        }

        public String getToolTip() {
            return this.myToolTip;
        }

        public String getText() {
            return this.myText;
        }

        public SimpleTextAttributes getAttributes() {
            return this.myAttributes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ColoredFragment that = (ColoredFragment)o;
            if (this.myAttributes != null ? !this.myAttributes.equals(that.myAttributes) : that.myAttributes != null) {
                return false;
            }
            if (this.myText != null ? !this.myText.equals(that.myText) : that.myText != null) {
                return false;
            }
            return !(this.myToolTip != null ? !this.myToolTip.equals(that.myToolTip) : that.myToolTip != null);
        }

        public int hashCode() {
            int result = this.myText != null ? this.myText.hashCode() : 0;
            result = 31 * result + (this.myToolTip != null ? this.myToolTip.hashCode() : 0);
            result = 31 * result + (this.myAttributes != null ? this.myAttributes.hashCode() : 0);
            return result;
        }
    }
}

