/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptorProvidingKey;
import com.intellij.ide.util.treeView.TreeRunnable;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class TreeState
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(TreeState.class);
    public static final Key<WeakReference<ActionCallback>> CALLBACK = Key.create((String)"Callback");
    public static final Key<Function<TreeVisitor, Promise<TreePath>>> VISIT = Key.create((String)"TreeVisit");
    private static final String EXPAND_TAG = "expand";
    private static final String SELECT_TAG = "select";
    private static final String PATH_TAG = "path";
    private final List<List<PathElement>> myExpandedPaths;
    private final List<List<PathElement>> mySelectedPaths;
    private boolean myScrollToSelection;

    private TreeState(List<List<PathElement>> expandedPaths, List<List<PathElement>> selectedPaths) {
        this.myExpandedPaths = expandedPaths;
        this.mySelectedPaths = selectedPaths;
        this.myScrollToSelection = true;
    }

    public boolean isEmpty() {
        return this.myExpandedPaths.isEmpty() && this.mySelectedPaths.isEmpty();
    }

    public void readExternal(Element element) throws InvalidDataException {
        TreeState.readExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.readExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void readExternal(Element root, List<List<PathElement>> list, String name) throws InvalidDataException {
        list.clear();
        for (Element element : root.getChildren(name)) {
            for (Element child : element.getChildren(PATH_TAG)) {
                Object[] path2 = (PathElement[])XmlSerializer.deserialize((Element)child, PathElement[].class);
                list.add((List<PathElement>)ContainerUtil.immutableList((Object[])path2));
            }
        }
    }

    @NotNull
    public static TreeState createOn(JTree tree, DefaultMutableTreeNode treeNode) {
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree, new TreePath(treeNode.getPath()))), TreeState.createPaths(tree, TreeUtil.collectSelectedPaths(tree, new TreePath(treeNode.getPath()))));
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(0);
        }
        return treeState;
    }

    @NotNull
    public static TreeState createOn(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(1);
        }
        TreeState treeState = new TreeState(TreeState.createPaths(tree, TreeUtil.collectExpandedPaths(tree)), new ArrayList<List<PathElement>>());
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(2);
        }
        return treeState;
    }

    @NotNull
    public static TreeState createFrom(@Nullable Element element) {
        TreeState state = new TreeState(new ArrayList<List<PathElement>>(), new ArrayList<List<PathElement>>());
        try {
            if (element != null) {
                state.readExternal(element);
            }
        }
        catch (InvalidDataException e) {
            LOG.warn((Throwable)e);
        }
        TreeState treeState = state;
        if (treeState == null) {
            TreeState.$$$reportNull$$$0(3);
        }
        return treeState;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        TreeState.writeExternal(element, this.myExpandedPaths, EXPAND_TAG);
        TreeState.writeExternal(element, this.mySelectedPaths, SELECT_TAG);
    }

    private static void writeExternal(Element element, List<List<PathElement>> list, String name) throws WriteExternalException {
        Element root = new Element(name);
        for (List<PathElement> path2 : list) {
            Element e = XmlSerializer.serialize((Object)path2.toArray());
            e.setName(PATH_TAG);
            root.addContent(e);
        }
        element.addContent(root);
    }

    private static List<List<PathElement>> createPaths(JTree tree, List<TreePath> paths) {
        ArrayList<List<PathElement>> result = new ArrayList<List<PathElement>>();
        for (TreePath path2 : paths) {
            if (!tree.isRootVisible() && path2.getPathCount() <= 1) continue;
            ContainerUtil.addIfNotNull(result, TreeState.createPath(tree.getModel(), path2));
        }
        return result;
    }

    @NotNull
    private static List<PathElement> createPath(@NotNull TreeModel model, @NotNull TreePath treePath) {
        if (model == null) {
            TreeState.$$$reportNull$$$0(4);
        }
        if (treePath == null) {
            TreeState.$$$reportNull$$$0(5);
        }
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        Object prev = null;
        for (int i2 = 0; i2 < treePath.getPathCount(); ++i2) {
            Object cur = treePath.getPathComponent(i2);
            Object userObject = TreeUtil.getUserObject(cur);
            int childIndex = prev == null ? 0 : model.getIndexOfChild(prev, cur);
            PathElement pe = new PathElement(TreeState.calcId(userObject), TreeState.calcType(userObject), childIndex, userObject);
            result.add(pe);
            prev = cur;
        }
        ArrayList<PathElement> arrayList = result;
        if (arrayList == null) {
            TreeState.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static String calcId(@Nullable Object userObject) {
        Object value;
        if (userObject == null) {
            if ("" == null) {
                TreeState.$$$reportNull$$$0(7);
            }
            return "";
        }
        Object object = userObject instanceof NodeDescriptorProvidingKey ? ((NodeDescriptorProvidingKey)userObject).getKey() : (value = userObject instanceof AbstractTreeNode ? ((AbstractTreeNode)userObject).getValue() : userObject);
        if (value instanceof NavigationItem) {
            String string;
            try {
                String name = ((NavigationItem)value).getName();
                string = name != null ? name : StringUtil.notNullize((String)value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                TreeState.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)userObject.toString());
        if (string == null) {
            TreeState.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String calcType(@Nullable Object userObject) {
        if (userObject == null) {
            if ("" == null) {
                TreeState.$$$reportNull$$$0(10);
            }
            return "";
        }
        String name = userObject.getClass().getName();
        String string = Integer.toHexString(StringHash.murmur((String)name, (int)31)) + ":" + StringUtil.getShortName((String)name);
        if (string == null) {
            TreeState.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void applyTo(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(12);
        }
        this.applyTo(tree, tree.getModel().getRoot());
    }

    public void applyTo(final @NotNull JTree tree, final @Nullable Object root) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(13);
        }
        if (this.visit(tree)) {
            return;
        }
        if (root == null) {
            return;
        }
        final TreeFacade facade = TreeFacade.getFacade(tree);
        ActionCallback callback = facade.getInitialized().doWhenDone(new TreeRunnable("TreeState.applyTo: on done facade init"){

            @Override
            public void perform() {
                facade.batch(indicator -> TreeState.this.applyExpandedTo(facade, new TreePath(root), indicator));
            }
        });
        if (tree.getSelectionCount() == 0) {
            callback.doWhenDone(new TreeRunnable("TreeState.applyTo: on done"){

                @Override
                public void perform() {
                    if (tree.getSelectionCount() == 0) {
                        TreeState.this.applySelectedTo(tree);
                    }
                }
            });
        }
    }

    private void applyExpandedTo(@NotNull TreeFacade tree, @NotNull TreePath rootPath, @NotNull ProgressIndicator indicator) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(14);
        }
        if (rootPath == null) {
            TreeState.$$$reportNull$$$0(15);
        }
        if (indicator == null) {
            TreeState.$$$reportNull$$$0(16);
        }
        indicator.checkCanceled();
        if (rootPath.getPathCount() <= 0) {
            return;
        }
        for (List<PathElement> path2 : this.myExpandedPaths) {
            int index;
            if (path2.isEmpty() || !path2.get(index = rootPath.getPathCount() - 1).isMatchTo(rootPath.getPathComponent(index))) continue;
            TreeState.expandImpl(0, path2, rootPath, tree, indicator);
        }
    }

    private void applySelectedTo(@NotNull JTree tree) {
        if (tree == null) {
            TreeState.$$$reportNull$$$0(17);
        }
        ArrayList selection = new ArrayList();
        for (List<PathElement> path2 : this.mySelectedPaths) {
            TreeModel model = tree.getModel();
            TreePath treePath = new TreePath(model.getRoot());
            for (int i2 = 1; treePath != null && i2 < path2.size(); ++i2) {
                treePath = TreeState.findMatchedChild(model, treePath, path2.get(i2));
            }
            ContainerUtil.addIfNotNull(selection, (Object)treePath);
        }
        if (selection.isEmpty()) {
            return;
        }
        for (TreePath treePath : selection) {
            tree.setSelectionPath(treePath);
        }
        if (this.myScrollToSelection) {
            TreeUtil.showRowCentered(tree, tree.getRowForPath((TreePath)selection.get(0)), true, true);
        }
    }

    @Nullable
    private static TreePath findMatchedChild(@NotNull TreeModel model, @NotNull TreePath treePath, @NotNull PathElement pathElement) {
        Object child;
        Object parent;
        int childCount;
        if (model == null) {
            TreeState.$$$reportNull$$$0(18);
        }
        if (treePath == null) {
            TreeState.$$$reportNull$$$0(19);
        }
        if (pathElement == null) {
            TreeState.$$$reportNull$$$0(20);
        }
        if ((childCount = model.getChildCount(parent = treePath.getLastPathComponent())) <= 0) {
            return null;
        }
        boolean idMatchedFound = false;
        Object idMatchedChild = null;
        for (int j = 0; j < childCount; ++j) {
            child = model.getChild(parent, j);
            Match match = pathElement.getMatchTo(child);
            if (match == Match.OBJECT) {
                return treePath.pathByAddingChild(child);
            }
            if (match != Match.ID_TYPE || idMatchedFound) continue;
            idMatchedChild = child;
            idMatchedFound = true;
        }
        if (idMatchedFound) {
            return treePath.pathByAddingChild(idMatchedChild);
        }
        int index = Math.max(0, Math.min(pathElement.index, childCount - 1));
        child = model.getChild(parent, index);
        return treePath.pathByAddingChild(child);
    }

    private static void expandImpl(final int positionInPath, final List<PathElement> path2, final TreePath treePath, final TreeFacade tree, final ProgressIndicator indicator) {
        tree.expand(treePath).doWhenDone(new TreeRunnable("TreeState.applyTo"){

            @Override
            public void perform() {
                PathElement next;
                indicator.checkCanceled();
                PathElement pathElement = next = positionInPath == path2.size() - 1 ? null : (PathElement)path2.get(positionInPath + 1);
                if (next == null) {
                    return;
                }
                Object parent = treePath.getLastPathComponent();
                TreeModel model = tree.tree.getModel();
                int childCount = model.getChildCount(parent);
                for (int j = 0; j < childCount; ++j) {
                    Object child = tree.tree.getModel().getChild(parent, j);
                    if (!next.isMatchTo(child)) continue;
                    TreeState.expandImpl(positionInPath + 1, path2, treePath.pathByAddingChild(child), tree, indicator);
                    break;
                }
            }
        });
    }

    public void setScrollToSelection(boolean scrollToSelection) {
        this.myScrollToSelection = scrollToSelection;
    }

    public String toString() {
        String content;
        Element st = new Element("TreeState");
        try {
            this.writeExternal(st);
            content = JDOMUtil.writeChildren((Element)st, (String)"\n");
        }
        catch (IOException e) {
            content = ExceptionUtil.getThrowableText((Throwable)e);
        }
        return "TreeState(" + this.myScrollToSelection + ")\n" + content;
    }

    private Promise<List<TreePath>> expand(@NotNull Function<TreeVisitor, Promise<TreePath>> visit, @NotNull JTree tree) {
        if (visit == null) {
            TreeState.$$$reportNull$$$0(21);
        }
        if (tree == null) {
            TreeState.$$$reportNull$$$0(22);
        }
        return Promises.collectResults(this.myExpandedPaths.stream().map(elements -> {
            if (tree == null) {
                TreeState.$$$reportNull$$$0(27);
            }
            return new Visitor((List)elements, tree::expandPath);
        }).map(visit).collect(Collectors.toList()));
    }

    private Promise<List<TreePath>> select(@NotNull Function<TreeVisitor, Promise<TreePath>> visit) {
        if (visit == null) {
            TreeState.$$$reportNull$$$0(23);
        }
        return Promises.collectResults(this.mySelectedPaths.stream().map(elements -> new Visitor((List)elements, null)).map(visit).collect(Collectors.toList()));
    }

    private boolean visit(@NotNull JTree tree) {
        Function visit;
        if (tree == null) {
            TreeState.$$$reportNull$$$0(24);
        }
        if ((visit = (Function)UIUtil.getClientProperty((Object)tree, VISIT)) == null) {
            return false;
        }
        this.expand(visit, tree).done((Consumer<List<TreePath>>)((Consumer)expanded -> {
            if (tree == null) {
                TreeState.$$$reportNull$$$0(25);
            }
            if (tree.getSelectionCount() == 0) {
                this.select(visit).done((Consumer<List<TreePath>>)((Consumer)selected -> {
                    if (tree == null) {
                        TreeState.$$$reportNull$$$0(26);
                    }
                    if (tree.getSelectionCount() == 0) {
                        for (TreePath path2 : selected) {
                            tree.addSelectionPath(path2);
                        }
                    }
                }));
            }
        }));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 4: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathElement";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createOn";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/treeView/TreeState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrom";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calcId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createOn";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applyExpandedTo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applySelectedTo";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedChild";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = EXPAND_TAG;
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = SELECT_TAG;
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$visit$3";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$expand$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Visitor
    implements TreeVisitor {
        private final List<PathElement> elements;
        private final java.util.function.Consumer<TreePath> consumer;

        private Visitor(List<PathElement> elements, java.util.function.Consumer<TreePath> consumer) {
            this.elements = elements;
            this.consumer = consumer;
        }

        @Override
        @NotNull
        public TreeVisitor.Action accept(@NotNull TreePath path2) {
            int count;
            if (path2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((count = path2.getPathCount()) > this.elements.size()) {
                TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
                if (action == null) {
                    Visitor.$$$reportNull$$$0(1);
                }
                return action;
            }
            boolean matches = this.elements.get(count - 1).isMatchTo(path2.getLastPathComponent());
            if (!matches) {
                TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
                if (action == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                return action;
            }
            if (this.consumer != null) {
                this.consumer.accept(path2);
            }
            TreeVisitor.Action action = count < this.elements.size() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT;
            if (action == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = TreeState.PATH_TAG;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/util/treeView/TreeState$Visitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/util/treeView/TreeState$Visitor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "accept";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BuilderFacade
    extends TreeFacade {
        private final AbstractTreeBuilder myBuilder;

        BuilderFacade(AbstractTreeBuilder builder) {
            super((JTree)ObjectUtils.notNull((Object)builder.getTree()));
            this.myBuilder = builder;
        }

        @Override
        public ActionCallback getInitialized() {
            return this.myBuilder.getReady(this);
        }

        @Override
        public void batch(Progressive progressive) {
            this.myBuilder.batch(progressive);
        }

        @Override
        public ActionCallback expand(TreePath treePath) {
            Object userObject = TreeUtil.getUserObject(treePath.getLastPathComponent());
            if (!(userObject instanceof NodeDescriptor)) {
                return ActionCallback.REJECTED;
            }
            NodeDescriptor desc = (NodeDescriptor)userObject;
            Object element = this.myBuilder.getTreeStructureElement(desc);
            ActionCallback result = new ActionCallback();
            this.myBuilder.expand(element, result.createSetDoneRunnable());
            return result;
        }
    }

    static class JTreeFacade
    extends TreeFacade {
        JTreeFacade(JTree tree) {
            super(tree);
        }

        @Override
        public ActionCallback expand(@NotNull TreePath treePath) {
            if (treePath == null) {
                JTreeFacade.$$$reportNull$$$0(0);
            }
            this.tree.expandPath(treePath);
            return ActionCallback.DONE;
        }

        @Override
        public ActionCallback getInitialized() {
            WeakReference ref = (WeakReference)UIUtil.getClientProperty((Object)this.tree, CALLBACK);
            ActionCallback callback = (ActionCallback)SoftReference.dereference((Reference)ref);
            if (callback != null) {
                return callback;
            }
            return ActionCallback.DONE;
        }

        @Override
        public void batch(Progressive progressive) {
            progressive.run(new EmptyProgressIndicator());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treePath", "com/intellij/ide/util/treeView/TreeState$JTreeFacade", TreeState.EXPAND_TAG));
        }
    }

    static abstract class TreeFacade {
        final JTree tree;

        TreeFacade(@NotNull JTree tree) {
            if (tree == null) {
                TreeFacade.$$$reportNull$$$0(0);
            }
            this.tree = tree;
        }

        abstract ActionCallback getInitialized();

        abstract ActionCallback expand(TreePath var1);

        abstract void batch(Progressive var1);

        static TreeFacade getFacade(JTree tree) {
            AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
            return builder != null ? new BuilderFacade(builder) : new JTreeFacade(tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/util/treeView/TreeState$TreeFacade", "<init>"));
        }
    }

    @Tag(value="item")
    static class PathElement {
        @Attribute(value="name")
        public String id;
        @Attribute(value="type")
        public String type;
        @Attribute(value="user")
        public String userStr;
        Object userObject;
        final int index;

        PathElement() {
            this(null, null, -1, null);
        }

        PathElement(String itemId, String itemType, int itemIndex, Object userObject) {
            this.id = itemId;
            this.type = itemType;
            this.index = itemIndex;
            this.userStr = userObject instanceof String ? (String)userObject : null;
            this.userObject = userObject;
        }

        public String toString() {
            return this.id + ": " + this.type;
        }

        private boolean isMatchTo(Object object) {
            return this.getMatchTo(object) != null;
        }

        private Match getMatchTo(Object object) {
            Object userObject = TreeUtil.getUserObject(object);
            if (this.userObject != null && this.userObject.equals(userObject)) {
                return Match.OBJECT;
            }
            return Comparing.equal((String)this.id, (String)TreeState.calcId(userObject)) && Comparing.equal((String)this.type, (String)TreeState.calcType(userObject)) ? Match.ID_TYPE : null;
        }
    }

    private static enum Match {
        OBJECT,
        ID_TYPE;

    }
}

