/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view.tree;

import com.intellij.ide.DataManager;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.ValidateableNode;
import com.intellij.jam.JamMessages;
import com.intellij.openapi.actionSystem.DataConstants;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.OpenSourceUtil;
import java.awt.Color;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JamNodeDescriptor<P>
extends SimpleNode
implements DataProvider,
ValidateableNode {
    public static final JamNodeDescriptor[] EMPTY_ARRAY = new JamNodeDescriptor[0];
    private final Object myParameters;
    private final P myElement;
    private String myTooltip;

    protected JamNodeDescriptor(Project project, NodeDescriptor parentDescriptor, Object parameters, P element) {
        super(project, parentDescriptor);
        this.myParameters = parameters;
        this.myElement = element;
    }

    @Override
    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            JamNodeDescriptor.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    protected void doUpdate() {
        this.setUniformIcon(this.getNewIcon());
        String nodeText = this.getNewNodeText();
        this.setNodeText(StringUtil.isNotEmpty((String)nodeText) ? nodeText : JamMessages.message("unnamed.element.presentable.name", new Object[0]), null, !this.isValid());
        this.myTooltip = this.getNewTooltip();
    }

    protected P updateElement() {
        return this.myElement;
    }

    @Nullable
    protected abstract String getNewNodeText();

    @Nullable
    protected Icon getNewIcon() {
        return this.getIcon();
    }

    protected Color getNewColor() {
        return this.myColor;
    }

    @Override
    public SimpleNode[] getChildren() {
        return EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public Object getData(String dataId) {
        return null;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    @Nullable
    public String getNewTooltip() {
        return this.getNewNodeText();
    }

    @Override
    public int getWeight() {
        return 0;
    }

    @Nullable
    protected DeleteProvider getDeleteProvider() {
        return null;
    }

    protected Object getParameters() {
        return this.myParameters;
    }

    @Nullable
    public final Object getDataForElement(String dataId) {
        if (DataConstants.DELETE_ELEMENT_PROVIDER.equals(dataId)) {
            return this.getDeleteProvider();
        }
        return this.getData(dataId);
    }

    @Override
    public final P getElement() {
        return this.myElement;
    }

    @Nullable
    public String getComment() {
        return null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void handleDoubleClickOrEnter(SimpleTree tree, InputEvent inputEvent) {
        OpenSourceUtil.openSourcesFrom(DataManager.getInstance().getDataContext(tree), false);
    }

    @Override
    public boolean isAlwaysLeaf() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/view/tree/JamNodeDescriptor", "getEqualityObjects"));
    }
}

