/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComboBoxAction
extends AnAction
implements CustomComponentAction {
    private static Icon myIcon = null;
    private static Icon myDisabledIcon = null;
    private boolean mySmallVariant = true;
    private String myPopupTitle;

    public static Icon getArrowIcon(boolean enabled) {
        Icon icon;
        if (UIUtil.isUnderWin10LookAndFeel()) {
            return IconLoader.getIcon((String)"/com/intellij/ide/ui/laf/icons/win10/comboDropTriangle.png");
        }
        Icon icon2 = icon = UIUtil.isUnderDarcula() ? AllIcons.General.ComboArrow : AllIcons.General.ComboBoxButtonArrow;
        if (myIcon != icon) {
            myIcon = icon;
            myDisabledIcon = IconLoader.getDisabledIcon((Icon)myIcon);
        }
        return enabled ? myIcon : myDisabledIcon;
    }

    protected ComboBoxAction() {
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (!(frame instanceof IdeFrame)) {
            return;
        }
        ListPopup popup = this.createActionPopup(e.getDataContext(), ((IdeFrame)((Object)frame)).getComponent(), null);
        popup.showCenteredInCurrentWindow(project);
    }

    @NotNull
    private ListPopup createActionPopup(@NotNull DataContext context, @NotNull JComponent component, @Nullable Runnable disposeCallback) {
        if (context == null) {
            ComboBoxAction.$$$reportNull$$$0(0);
        }
        if (component == null) {
            ComboBoxAction.$$$reportNull$$$0(1);
        }
        DefaultActionGroup group = this.createPopupActionGroup(component, context);
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(this.myPopupTitle, (ActionGroup)group, context, false, this.shouldShowDisabledActions(), false, disposeCallback, this.getMaxRows(), this.getPreselectCondition());
        popup.setMinimumSize(new Dimension(this.getMinWidth(), this.getMinHeight()));
        ListPopup listPopup = popup;
        if (listPopup == null) {
            ComboBoxAction.$$$reportNull$$$0(2);
        }
        return listPopup;
    }

    @Override
    public JComponent createCustomComponent(Presentation presentation) {
        JPanel panel = new JPanel(new GridBagLayout());
        ComboBoxButton button = this.createComboBoxButton(presentation);
        panel.add((Component)button, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insets((int)0, (int)3, (int)0, (int)3), 0, 0));
        return panel;
    }

    protected ComboBoxButton createComboBoxButton(Presentation presentation) {
        return new ComboBoxButton(presentation);
    }

    public boolean isSmallVariant() {
        return this.mySmallVariant;
    }

    public void setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
    }

    public void setPopupTitle(String popupTitle) {
        this.myPopupTitle = popupTitle;
    }

    @Override
    public void update(AnActionEvent e) {
    }

    protected boolean shouldShowDisabledActions() {
        return false;
    }

    @NotNull
    protected abstract DefaultActionGroup createPopupActionGroup(JComponent var1);

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button, @NotNull DataContext dataContext) {
        if (dataContext == null) {
            ComboBoxAction.$$$reportNull$$$0(3);
        }
        DefaultActionGroup defaultActionGroup = this.createPopupActionGroup(button);
        if (defaultActionGroup == null) {
            ComboBoxAction.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    protected int getMaxRows() {
        return 30;
    }

    protected int getMinHeight() {
        return 1;
    }

    protected int getMinWidth() {
        return 1;
    }

    protected Condition<AnAction> getPreselectCondition() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/ex/ComboBoxAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionPopup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createActionPopup";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class ComboBoxButton
    extends JButton
    implements UserActivityProviderComponent {
        private final Presentation myPresentation;
        private boolean myForcePressed = false;
        private PropertyChangeListener myButtonSynchronizer;
        private boolean myMouseInside = false;
        private JBPopup myPopup;
        private boolean myForceTransparent = false;

        public ComboBoxButton(Presentation presentation) {
            this.myPresentation = presentation;
            this.setModel(new MyButtonModel());
            this.getModel().setEnabled(this.myPresentation.isEnabled());
            this.setVisible(presentation.isVisible());
            this.setHorizontalAlignment(2);
            this.setFocusable(false);
            this.putClientProperty("styleCombo", Boolean.TRUE);
            Insets margins = this.getMargin();
            this.setMargin((Insets)JBUI.insets((int)margins.top, (int)2, (int)margins.bottom, (int)2));
            if (ComboBoxAction.this.isSmallVariant()) {
                if (!UIUtil.isUnderWin10LookAndFeel()) {
                    this.setBorder((Border)JBUI.Borders.empty((int)0, (int)2));
                }
                if (!UIUtil.isUnderGTKLookAndFeel()) {
                    this.setFont((Font)JBUI.Fonts.label((float)11.0f));
                }
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!ComboBoxButton.this.myForcePressed) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> ComboBoxButton.this.showPopup());
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    ComboBoxButton.this.myMouseInside = true;
                    ComboBoxButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ComboBoxButton.this.myMouseInside = false;
                    ComboBoxButton.this.repaint();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        e.consume();
                        ComboBoxButton.this.doClick();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ComboBoxButton.this.dispatchEventToPopup(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.mouseMoved(MouseEventAdapter.convert((MouseEvent)e, (Component)e.getComponent(), (int)503, (long)e.getWhen(), (int)(e.getModifiers() | e.getModifiersEx()), (int)e.getX(), (int)e.getY()));
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    ComboBoxButton.this.dispatchEventToPopup(e);
                }
            });
        }

        private void dispatchEventToPopup(MouseEvent e) {
            if (this.myPopup != null && this.myPopup.isVisible()) {
                MouseEvent event;
                Component component;
                JComponent content = this.myPopup.getContent();
                Rectangle rectangle = content.getBounds();
                Point location = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(location, content);
                Point eventPoint = e.getLocationOnScreen();
                rectangle.setLocation(location);
                if (rectangle.contains(eventPoint) && (component = SwingUtilities.getDeepestComponentAt(content, (event = SwingUtilities.convertMouseEvent(e.getComponent(), e, this.myPopup.getContent())).getX(), event.getY())) != null) {
                    component.dispatchEvent(event);
                }
            }
        }

        public void setForceTransparent(boolean transparent) {
            this.myForceTransparent = transparent;
        }

        @NotNull
        private Runnable setForcePressed() {
            this.myForcePressed = true;
            this.repaint();
            Runnable runnable = () -> {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myForcePressed = false;
                    this.myPopup = null;
                    this.repaint();
                }, ModalityState.any());
                this.repaint();
                this.fireStateChanged();
            };
            if (runnable == null) {
                ComboBoxButton.$$$reportNull$$$0(0);
            }
            return runnable;
        }

        @Override
        @Nullable
        public String getToolTipText() {
            return this.myForcePressed ? null : super.getToolTipText();
        }

        public void showPopup() {
            this.createPopup(this.setForcePressed()).showUnderneathOf(this);
        }

        protected JBPopup createPopup(Runnable onDispose) {
            return ComboBoxAction.this.createActionPopup(this.getDataContext(), this, onDispose);
        }

        private ComboBoxAction getMyAction() {
            return ComboBoxAction.this;
        }

        protected DataContext getDataContext() {
            return DataManager.getInstance().getDataContext(this);
        }

        @Override
        public void removeNotify() {
            if (this.myButtonSynchronizer != null) {
                this.myPresentation.removePropertyChangeListener(this.myButtonSynchronizer);
                this.myButtonSynchronizer = null;
            }
            super.removeNotify();
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (this.myButtonSynchronizer == null) {
                this.myButtonSynchronizer = new MyButtonSynchronizer();
                this.myPresentation.addPropertyChangeListener(this.myButtonSynchronizer);
            }
            this.initButton();
        }

        private void initButton() {
            this.setIcon(this.myPresentation.getIcon());
            this.setText(this.myPresentation.getText());
            this.updateTooltipText(this.myPresentation.getDescription());
            this.updateButtonSize();
        }

        private void updateTooltipText(String description) {
            String tooltip = KeymapUtil.createTooltipText(description, ComboBoxAction.this);
            this.setToolTipText(!tooltip.isEmpty() ? tooltip : null);
        }

        @Override
        public void updateUI() {
            super.updateUI();
        }

        @Override
        public Insets getInsets() {
            Insets insets = super.getInsets();
            insets.right += ComboBoxAction.getArrowIcon(this.isEnabled()).getIconWidth();
            return insets;
        }

        @Override
        public Insets getInsets(Insets insets) {
            Insets result = super.getInsets(insets);
            result.right += ComboBoxAction.getArrowIcon(this.isEnabled()).getIconWidth();
            return result;
        }

        @Override
        public boolean isOpaque() {
            return !ComboBoxAction.this.isSmallVariant();
        }

        @Override
        public Dimension getPreferredSize() {
            int width;
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            int n = width = isEmpty ? JBUI.scale((int)10) + ComboBoxAction.getArrowIcon(this.isEnabled()).getIconWidth() : super.getPreferredSize().width;
            if (ComboBoxAction.this.isSmallVariant() && !UIUtil.isUnderDefaultMacTheme()) {
                width += JBUI.scale((int)4);
                if (UIUtil.isUnderWin10LookAndFeel()) {
                    width += JBUI.scale((int)8);
                }
            }
            int height = UIUtil.isUnderWin10LookAndFeel() ? JBUI.scale((int)24) : JBUI.scale((int)19);
            return new Dimension(width, ComboBoxAction.this.isSmallVariant() ? height : super.getPreferredSize().height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(super.getMinimumSize().width, this.getPreferredSize().height);
        }

        @Override
        public Font getFont() {
            return SystemInfo.isMac && ComboBoxAction.this.isSmallVariant() ? UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL) : UIUtil.getLabelFont();
        }

        @Override
        public void paint(Graphics g) {
            Icon icon;
            Dimension size = this.getSize();
            if (UIUtil.isUnderDefaultMacTheme() || UIUtil.isUnderWin10LookAndFeel()) {
                super.paint(g);
            } else {
                Color textColor;
                UISettings.setupAntialiasing(g);
                GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g);
                Color color = textColor = this.isEnabled() ? UIManager.getColor("Panel.foreground") : UIUtil.getInactiveTextColor();
                if (this.myForceTransparent) {
                    icon = this.getIcon();
                    int x = 7;
                    if (icon != null) {
                        icon.paintIcon(this, g, x, (size.height - icon.getIconHeight()) / 2);
                        x += icon.getIconWidth() + 3;
                    }
                    if (!StringUtil.isEmpty((String)this.getText())) {
                        Font font = this.getFont();
                        g.setFont(font);
                        g.setColor(textColor);
                        UIUtil.drawCenteredString((Graphics2D)((Graphics2D)g), (Rectangle)new Rectangle(x, 0, Integer.MAX_VALUE, size.height), (String)this.getText(), (boolean)false, (boolean)true);
                    }
                } else if (ComboBoxAction.this.isSmallVariant()) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setColor(UIUtil.getControlColor());
                    int w = this.getWidth();
                    int h = this.getHeight();
                    if (this.getModel().isArmed() && this.getModel().isPressed()) {
                        g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)UIUtil.getControlColor(), (float)0.0f, (float)h, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)0.8)));
                    } else if (UIUtil.isUnderDarcula()) {
                        g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)1.1), (float)0.0f, (float)h, (Color)ColorUtil.shift((Color)UIUtil.getControlColor(), (double)0.9)));
                    } else {
                        g2.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)new JBColor((Color)(SystemInfo.isMac ? Gray._226 : Gray._245), (Color)Gray._131), (float)0.0f, (float)h, (Color)new JBColor((Color)(SystemInfo.isMac ? Gray._198 : Gray._208), (Color)Gray._128)));
                    }
                    g2.fillRoundRect(2, 0, w - 2, h, 5, 5);
                    JBColor borderColor = this.myMouseInside ? new JBColor((Color)Gray._111, (Color)Gray._118) : new JBColor((Color)Gray._151, (Color)Gray._95);
                    g2.setPaint((Paint)borderColor);
                    g2.drawRoundRect(2, 0, w - 3, h - 1, 5, 5);
                    Icon icon2 = this.getIcon();
                    int x = 7;
                    if (icon2 != null) {
                        icon2.paintIcon(this, g, x, (size.height - icon2.getIconHeight()) / 2);
                        x += icon2.getIconWidth() + 3;
                    }
                    if (!StringUtil.isEmpty((String)this.getText())) {
                        Font font = this.getFont();
                        g2.setFont(font);
                        g2.setColor(textColor);
                        UIUtil.drawCenteredString((Graphics2D)g2, (Rectangle)new Rectangle(x, 0, Integer.MAX_VALUE, size.height), (String)this.getText(), (boolean)false, (boolean)true);
                    }
                } else {
                    super.paint(g);
                }
            }
            Insets insets = super.getInsets();
            icon = ComboBoxAction.getArrowIcon(this.isEnabled());
            boolean isEmpty = this.getIcon() == null && StringUtil.isEmpty((String)this.getText());
            int x = size.width - icon.getIconWidth();
            if (isEmpty) {
                x /= 2;
            } else if (UIUtil.isUnderWin10LookAndFeel()) {
                x -= JBUI.scale((int)6);
                x -= JBUI.scale((int)(UIUtil.getParentOfType(ActionToolbar.class, (Component)this) != null ? 2 : 0));
            } else {
                x -= insets.right;
                if (ComboBoxAction.this.isSmallVariant()) {
                    x += JBUI.scale((int)1);
                    if (UIUtil.isUnderDefaultMacTheme()) {
                        x -= JBUI.scale((int)3);
                    }
                } else {
                    x += JBUI.scale((int)(UIUtil.isUnderNimbusLookAndFeel() ? -3 : 2));
                }
            }
            icon.paintIcon(null, g, x, (size.height - icon.getIconHeight()) / 2);
            g.setPaintMode();
        }

        protected void updateButtonSize() {
            this.invalidate();
            this.repaint();
            this.setSize(this.getPreferredSize());
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ComboBoxAction$ComboBoxButton", "setForcePressed"));
        }

        private class MyButtonSynchronizer
        implements PropertyChangeListener {
            private MyButtonSynchronizer() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("text".equals(propertyName)) {
                    ComboBoxButton.this.setText((String)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("description".equals(propertyName)) {
                    ComboBoxButton.this.updateTooltipText((String)evt.getNewValue());
                } else if ("icon".equals(propertyName)) {
                    ComboBoxButton.this.setIcon((Icon)evt.getNewValue());
                    ComboBoxButton.this.updateButtonSize();
                } else if ("enabled".equals(propertyName)) {
                    ComboBoxButton.this.setEnabled((Boolean)evt.getNewValue());
                }
            }
        }

        protected class MyButtonModel
        extends DefaultButtonModel {
            protected MyButtonModel() {
            }

            @Override
            public boolean isPressed() {
                return ComboBoxButton.this.myForcePressed || super.isPressed();
            }

            @Override
            public boolean isArmed() {
                return ComboBoxButton.this.myForcePressed || super.isArmed();
            }
        }
    }
}

