/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.UINumericRange;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Configurable
extends UnnamedConfigurable {
    public static final ExtensionPointName<ConfigurableEP<Configurable>> APPLICATION_CONFIGURABLE = ExtensionPointName.create((String)"com.intellij.applicationConfigurable");
    public static final ExtensionPointName<ConfigurableEP<Configurable>> PROJECT_CONFIGURABLE = ExtensionPointName.create((String)"com.intellij.projectConfigurable");

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName();

    @Nullable
    @NonNls
    default public String getHelpTopic() {
        return null;
    }

    default public boolean isModified(@NotNull JTextField textField, @NotNull String value) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(0);
        }
        if (value == null) {
            Configurable.$$$reportNull$$$0(1);
        }
        return !StringUtil.equals((CharSequence)textField.getText().trim(), (CharSequence)value);
    }

    default public boolean isModified(@NotNull JTextField textField, int value, @NotNull UINumericRange range) {
        if (textField == null) {
            Configurable.$$$reportNull$$$0(2);
        }
        if (range == null) {
            Configurable.$$$reportNull$$$0(3);
        }
        try {
            return range.fit(Integer.parseInt(textField.getText().trim())) != value;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    default public boolean isModified(@NotNull JToggleButton toggleButton, boolean value) {
        if (toggleButton == null) {
            Configurable.$$$reportNull$$$0(4);
        }
        return toggleButton.isSelected() != value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "textField";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "value";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "toggleButton";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/options/Configurable";
        objectArray[2] = "isModified";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface VariableProjectAppLevel {
        public boolean isProjectLevel();
    }

    public static interface NoMargin {
    }

    public static interface NoScroll {
    }

    public static interface Composite {
        public Configurable[] getConfigurables();
    }
}

