/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ObjectPattern<T, Self extends ObjectPattern<T, Self>>
implements Cloneable,
ElementPattern<T> {
    private InitialPatternCondition<T> myInitialCondition;
    private Object myConditions;

    protected ObjectPattern(@NotNull InitialPatternCondition<T> condition) {
        if (condition == null) {
            ObjectPattern.$$$reportNull$$$0(0);
        }
        this.myInitialCondition = condition;
        this.myConditions = null;
    }

    protected ObjectPattern(final Class<T> aClass) {
        this(new InitialPatternCondition<T>(aClass){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return aClass.isInstance(o);
            }
        });
    }

    @Override
    public final boolean accepts(@Nullable Object t) {
        return this.accepts(t, new ProcessingContext());
    }

    @Override
    public boolean accepts(@Nullable Object o, ProcessingContext context) {
        if (!this.myInitialCondition.accepts(o, context)) {
            return false;
        }
        if (this.myConditions == null) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.myConditions instanceof PatternCondition) {
            return ((PatternCondition)this.myConditions).accepts(o, context);
        }
        List list = (List)this.myConditions;
        int listSize = list.size();
        for (int i2 = 0; i2 < listSize; ++i2) {
            if (((PatternCondition)list.get(i2)).accepts(o, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public final ElementPatternCondition<T> getCondition() {
        if (this.myConditions == null) {
            ElementPatternCondition<T> elementPatternCondition = new ElementPatternCondition<T>(this.myInitialCondition);
            if (elementPatternCondition == null) {
                ObjectPattern.$$$reportNull$$$0(1);
            }
            return elementPatternCondition;
        }
        if (this.myConditions instanceof PatternCondition) {
            PatternCondition singleCondition = (PatternCondition)this.myConditions;
            ElementPatternCondition elementPatternCondition = new ElementPatternCondition(this.myInitialCondition, Collections.singletonList(singleCondition));
            if (elementPatternCondition == null) {
                ObjectPattern.$$$reportNull$$$0(2);
            }
            return elementPatternCondition;
        }
        ElementPatternCondition<T> elementPatternCondition = new ElementPatternCondition<T>(this.myInitialCondition, (List)this.myConditions);
        if (elementPatternCondition == null) {
            ObjectPattern.$$$reportNull$$$0(3);
        }
        return elementPatternCondition;
    }

    @NotNull
    public Self andNot(ElementPattern pattern) {
        Capture not = StandardPatterns.not(pattern);
        Self Self = this.and(not);
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(4);
        }
        return Self;
    }

    @NotNull
    public Self andOr(ElementPattern ... patterns) {
        if (patterns == null) {
            ObjectPattern.$$$reportNull$$$0(5);
        }
        ElementPattern or = StandardPatterns.or(patterns);
        Self Self = this.and(or);
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(6);
        }
        return Self;
    }

    @NotNull
    public Self and(ElementPattern pattern) {
        Self Self = this.with(new PatternConditionPlus<T, T>("and", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<T, ProcessingContext> processor) {
                return processor.process(t, (Object)context);
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(7);
        }
        return Self;
    }

    @NotNull
    public Self equalTo(final @NotNull T o) {
        if (o == null) {
            ObjectPattern.$$$reportNull$$$0(8);
        }
        Self Self = this.with(new ValuePatternCondition<T>("equalTo"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    3.$$$reportNull$$$0(0);
                }
                return t.equals(o);
            }

            @Override
            public Collection<T> getValues() {
                return Collections.singletonList(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$3", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(9);
        }
        return Self;
    }

    @NotNull
    public Self oneOf(T ... values) {
        int length = values.length;
        final Collection<T> list = length == 1 ? Collections.singletonList(values[0]) : (length >= 11 ? new HashSet<T>(Arrays.asList(values)) : Arrays.asList(values));
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return list;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    4.$$$reportNull$$$0(0);
                }
                return list.contains(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$4", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(10);
        }
        return Self;
    }

    @NotNull
    public Self oneOf(final Collection<T> set) {
        Self Self = this.with(new ValuePatternCondition<T>("oneOf"){

            @Override
            public Collection<T> getValues() {
                return set;
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    5.$$$reportNull$$$0(0);
                }
                return set.contains(t);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$5", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(11);
        }
        return Self;
    }

    @NotNull
    public Self isNull() {
        Self Self = this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o == null;
            }
        }));
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(12);
        }
        return Self;
    }

    @NotNull
    public Self notNull() {
        Self Self = this.adapt(new ElementPatternCondition(new InitialPatternCondition(Object.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o != null;
            }
        }));
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(13);
        }
        return Self;
    }

    @NotNull
    public Self save(final Key<? super T> key) {
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    8.$$$reportNull$$$0(0);
                }
                context.put(key, t);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$8", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(14);
        }
        return Self;
    }

    @NotNull
    public Self save(final @NonNls String key) {
        Self Self = this.with(new PatternCondition<T>("save"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                if (t == null) {
                    9.$$$reportNull$$$0(0);
                }
                context.put((Object)key, t);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/patterns/ObjectPattern$9", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(15);
        }
        return Self;
    }

    @NotNull
    public Self with(PatternCondition<? super T> pattern) {
        ElementPatternCondition<? super T> condition = this.getCondition().append(pattern);
        Self Self = this.adapt(condition);
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(16);
        }
        return Self;
    }

    @NotNull
    private Self adapt(ElementPatternCondition<T> condition) {
        ObjectPattern objectPattern;
        try {
            ObjectPattern s = (ObjectPattern)this.clone();
            s.myInitialCondition = condition.getInitialCondition();
            List<PatternCondition<T>> conditions = condition.getConditions();
            s.myConditions = conditions.isEmpty() ? null : (conditions.size() == 1 ? conditions.get(0) : conditions);
            objectPattern = s;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (objectPattern == null) {
            ObjectPattern.$$$reportNull$$$0(17);
        }
        return (Self)objectPattern;
    }

    @NotNull
    public Self without(final PatternCondition<? super T> pattern) {
        Self Self = this.with(new PatternCondition<T>("without"){

            @Override
            public boolean accepts(@NotNull T o, ProcessingContext context) {
                if (o == null) {
                    10.$$$reportNull$$$0(0);
                }
                return !pattern.accepts(o, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/patterns/ObjectPattern$10", "accepts"));
            }
        });
        if (Self == null) {
            ObjectPattern.$$$reportNull$$$0(18);
        }
        return Self;
    }

    public String toString() {
        return this.getCondition().toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/ObjectPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/ObjectPattern";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "andOr";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "equalTo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isNull";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "notNull";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "adapt";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "without";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "andOr";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Capture<T>
    extends ObjectPattern<T, Capture<T>> {
        public Capture(Class<T> aClass) {
            super(aClass);
        }

        public Capture(@NotNull InitialPatternCondition<T> condition) {
            if (condition == null) {
                Capture.$$$reportNull$$$0(0);
            }
            super(condition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/patterns/ObjectPattern$Capture", "<init>"));
        }
    }
}

