/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.Computable;
import com.intellij.psi.ForceableComparable;
import com.intellij.psi.Weigher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeighingComparable<T, Loc>
implements Comparable<WeighingComparable<T, Loc>>,
ForceableComparable {
    private static final Comparable NULL = new Comparable(){

        public int compareTo(Object o) {
            throw new UnsupportedOperationException("Method compareTo is not yet implemented in " + this.getClass().getName());
        }
    };
    @NotNull
    private Comparable[] myComputedWeighs;
    private final Computable<T> myElement;
    private final Loc myLocation;
    private final Weigher<T, Loc>[] myWeighers;

    public WeighingComparable(Computable<T> element, @Nullable Loc location, Weigher<T, Loc>[] weighers) {
        this.myElement = element;
        this.myLocation = location;
        this.myWeighers = weighers;
        this.myComputedWeighs = new Comparable[weighers.length];
    }

    @Override
    public void force() {
        for (int i2 = 0; i2 < this.myComputedWeighs.length; ++i2) {
            Comparable weight = this.getWeight(i2);
            if (!(weight instanceof ForceableComparable)) continue;
            ((ForceableComparable)((Object)weight)).force();
        }
    }

    @Override
    public int compareTo(@NotNull WeighingComparable<T, Loc> comparable) {
        if (comparable == null) {
            WeighingComparable.$$$reportNull$$$0(0);
        }
        if (this.myComputedWeighs == comparable.myComputedWeighs) {
            return 0;
        }
        for (int i2 = 0; i2 < this.myComputedWeighs.length; ++i2) {
            int result;
            Comparable weight2;
            Comparable weight1 = this.getWeight(i2);
            if (weight1 == null ^ (weight2 = super.getWeight(i2)) == null) {
                return weight1 == null ? -1 : 1;
            }
            if (weight1 == null || (result = weight1.compareTo(weight2)) == 0) continue;
            return result;
        }
        this.myComputedWeighs = comparable.myComputedWeighs;
        return 0;
    }

    @Nullable
    private Comparable getWeight(int index) {
        Comparable weight = this.myComputedWeighs[index];
        if (weight == null) {
            Object element = this.myElement.compute();
            Comparable comparable = weight = element == null ? NULL : this.myWeighers[index].weigh(element, this.myLocation);
            if (weight == null) {
                weight = NULL;
            }
            this.myComputedWeighs[index] = weight;
        }
        return weight == NULL ? null : weight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        for (int i2 = 0; i2 < this.myComputedWeighs.length; ++i2) {
            if (i2 != 0) {
                builder.append(", ");
            }
            builder.append(this.myWeighers[i2]);
            builder.append("=");
            builder.append(this.getWeight(i2));
        }
        return builder.append("]").toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparable", "com/intellij/psi/WeighingComparable", "compareTo"));
    }
}

