/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.module.impl.ModuleImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleTestCase
extends IdeaTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (!this.myModulesToDispose.isEmpty()) {
                SmartList errors = new SmartList();
                WriteAction.run(() -> this.lambda$tearDown$0((List)errors));
                CompoundRuntimeException.throwIfNotEmpty((List)errors);
            }
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    protected Module createModule(@NotNull File moduleFile) {
        if (moduleFile == null) {
            ModuleTestCase.$$$reportNull$$$0(0);
        }
        return this.createModule(moduleFile, StdModuleTypes.JAVA);
    }

    protected Module createModule(File moduleFile, ModuleType moduleType) {
        String path2 = moduleFile.getAbsolutePath();
        return this.createModule(path2, moduleType);
    }

    protected Module createModule(String path2, ModuleType moduleType) {
        Module module = (Module)WriteAction.compute(() -> ModuleManager.getInstance(this.myProject).newModule(path2, moduleType.getId()));
        this.myModulesToDispose.add(module);
        return module;
    }

    protected Module loadModule(@NotNull VirtualFile file) {
        if (file == null) {
            ModuleTestCase.$$$reportNull$$$0(1);
        }
        return this.loadModule(file.getPath());
    }

    protected Module loadModule(@NotNull String modulePath) {
        Module module;
        if (modulePath == null) {
            ModuleTestCase.$$$reportNull$$$0(2);
        }
        ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        try {
            module = (Module)ApplicationManager.getApplication().runWriteAction(() -> {
                if (modulePath == null) {
                    ModuleTestCase.$$$reportNull$$$0(5);
                }
                return moduleManager.loadModule(FileUtil.toSystemIndependentName((String)modulePath));
            });
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
        this.myModulesToDispose.add(module);
        return module;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        if (rootDir == null) {
            ModuleTestCase.$$$reportNull$$$0(3);
        }
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<Module> moduleConsumer) {
        if (rootDir == null) {
            ModuleTestCase.$$$reportNull$$$0(4);
        }
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively(rootDir, new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @Override
            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && file.getName().endsWith(".iml")) {
                    ModuleImpl module = (ModuleImpl)ModuleTestCase.this.loadModule(file);
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module);
                    }
                    result.setIfNull((Object)module);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/ModuleTestCase$1", "visitFile"));
            }
        });
        return (Module)result.get();
    }

    protected Module createModuleFromTestData(String dirInTestData, String newModuleFileName, ModuleType moduleType, boolean addSourceRoot) throws IOException {
        File dirInTestDataFile = new File(dirInTestData);
        ModuleTestCase.assertTrue((boolean)dirInTestDataFile.isDirectory());
        File moduleDir = this.createTempDirectory();
        FileUtil.copyDir((File)dirInTestDataFile, (File)moduleDir);
        Module module = this.createModule(moduleDir + "/" + newModuleFileName, moduleType);
        final VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
        ModuleTestCase.assertNotNull((Object)root);
        new WriteCommandAction.Simple(module.getProject(), new PsiFile[0]){

            @Override
            protected void run() throws Throwable {
                root.refresh(false, true);
            }
        }.execute().throwException();
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)root);
        } else {
            PsiTestUtil.addContentRoot((Module)module, (VirtualFile)root);
        }
        return module;
    }

    private /* synthetic */ void lambda$tearDown$0(List errors) throws RuntimeException {
        ModuleManager moduleManager = ModuleManager.getInstance(this.myProject);
        for (Module module : this.myModulesToDispose) {
            try {
                String moduleName = module.getName();
                if (moduleManager.findModuleByName(moduleName) == null) continue;
                moduleManager.disposeModule(module);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDir";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/ModuleTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadModule";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "loadAllModulesUnder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$loadModule$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

