/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PopupHandler
extends MouseAdapter {
    public abstract void invokePopup(Component var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public static void installPopupHandler(JComponent component, @NonNls String groupId, String place) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        PopupHandler.installPopupHandler(component, group, place, actionManager);
    }

    @NotNull
    public static MouseListener installPopupHandler(JComponent component, final @NotNull ActionGroup group, final String place, final ActionManager actionManager) {
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication() == null) {
            MouseAdapter mouseAdapter = new MouseAdapter(){};
            if (mouseAdapter == null) {
                PopupHandler.$$$reportNull$$$0(1);
            }
            return mouseAdapter;
        }
        PopupHandler popupHandler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                popupMenu.getComponent().show(comp, x, y);
            }
        };
        component.addMouseListener(popupHandler);
        PopupHandler popupHandler2 = popupHandler;
        if (popupHandler2 == null) {
            PopupHandler.$$$reportNull$$$0(2);
        }
        return popupHandler2;
    }

    public static MouseListener installFollowingSelectionTreePopup(final JTree tree, final @NotNull ActionGroup group, final String place, final ActionManager actionManager) {
        if (group == null) {
            PopupHandler.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler handler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                if (tree.getPathForLocation(x, y) != null && Arrays.binarySearch(tree.getSelectionRows(), tree.getRowForLocation(x, y)) > -1) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        };
        tree.addMouseListener(handler);
        return handler;
    }

    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group, ActionManager actionManager) {
        return PopupHandler.installPopupHandler(component, group, "unknown", actionManager);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/PopupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/PopupHandler";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "installPopupHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installPopupHandler";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installFollowingSelectionTreePopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

