/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SizedIcon
extends JBUI.CachingScalableJBIcon {
    private final int myWidth;
    private final int myHeight;
    private final Icon myDelegate;
    private Icon myScaledDelegate;

    public SizedIcon(Icon delegate, int width, int height) {
        this.myScaledDelegate = this.myDelegate = delegate;
        this.myWidth = width;
        this.myHeight = height;
    }

    protected SizedIcon(SizedIcon icon) {
        super((JBUI.CachingScalableJBIcon)icon);
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myDelegate = icon.myDelegate;
        this.myScaledDelegate = null;
    }

    @NotNull
    protected SizedIcon copy() {
        SizedIcon sizedIcon = new SizedIcon(this);
        if (sizedIcon == null) {
            SizedIcon.$$$reportNull$$$0(0);
        }
        return sizedIcon;
    }

    private Icon myScaledIcon() {
        if (this.myScaledDelegate != null) {
            return this.myScaledDelegate;
        }
        if (this.getScale() == 1.0f) {
            this.myScaledDelegate = this.myDelegate;
            return this.myScaledDelegate;
        }
        if (!(this.myDelegate instanceof ScalableIcon)) {
            this.myScaledDelegate = this.myDelegate;
            return this.myScaledDelegate;
        }
        this.myScaledDelegate = ((ScalableIcon)this.myDelegate).scale(this.getScale());
        return this.myScaledDelegate;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Icon icon = this.myScaledIcon();
        int dx = this.scaleVal(this.myWidth) - icon.getIconWidth();
        int dy = this.scaleVal(this.myHeight) - icon.getIconHeight();
        if (dx > 0 || dy > 0) {
            icon.paintIcon(c, g, x + dx / 2, y + dy / 2);
        } else {
            icon.paintIcon(c, g, x, y);
        }
    }

    public int getIconWidth() {
        return this.scaleVal(this.myWidth);
    }

    public int getIconHeight() {
        return this.scaleVal(this.myHeight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/SizedIcon", "copy"));
    }
}

