/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Expandable;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ExtendableTextField;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.EventHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class ExpandableTextField
extends ExtendableTextField
implements Expandable {
    private static final int MINIMAL_WIDTH = 50;
    private final Function<String, String> parser;
    private final Function<String, String> joiner;
    private JBPopup popup;
    private String title;

    public ExpandableTextField() {
        this((Function<String, List<String>>)ParametersListUtil.DEFAULT_LINE_PARSER, (Function<List<String>, String>)ParametersListUtil.DEFAULT_LINE_JOINER);
    }

    public ExpandableTextField(@NotNull Function<String, List<String>> parser, @NotNull Function<List<String>, String> joiner) {
        if (parser == null) {
            ExpandableTextField.$$$reportNull$$$0(0);
        }
        if (joiner == null) {
            ExpandableTextField.$$$reportNull$$$0(1);
        }
        this.parser = text -> {
            if (parser == null) {
                ExpandableTextField.$$$reportNull$$$0(3);
            }
            return StringUtil.join((Collection)((Collection)parser.fun(text)), (String)"\n");
        };
        this.joiner = text -> {
            if (joiner == null) {
                ExpandableTextField.$$$reportNull$$$0(2);
            }
            return (String)joiner.fun(Arrays.asList(StringUtil.splitByLines((String)text)));
        };
        this.addAncestorListener(EventHandler.create(AncestorListener.class, this, "collapse"));
        this.addComponentListener(EventHandler.create(ComponentListener.class, this, "collapse"));
        this.putClientProperty("monospaced", true);
        this.setExtensions(this.createExtensions());
    }

    protected List<ExtendableTextField.Extension> createExtensions() {
        return Collections.singletonList(new ExtendableTextField.Extension(){

            @Override
            public Icon getIcon(boolean hovered) {
                return hovered ? AllIcons.General.ExpandComponentHover : AllIcons.General.ExpandComponent;
            }

            @Override
            public Runnable getActionOnClick() {
                return ExpandableTextField.this::expand;
            }

            @Override
            public String getTooltip() {
                return KeymapUtil.createTooltipText("Expand", "ExpandExpandableComponent");
            }
        });
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (!enabled) {
            this.collapse();
        }
        super.setEnabled(enabled);
    }

    @Override
    public void collapse() {
        if (this.popup != null) {
            this.popup.cancel();
        }
    }

    @Override
    public boolean isExpanded() {
        return this.popup != null;
    }

    @Override
    public void expand() {
        if (this.popup != null || !this.isEnabled()) {
            return;
        }
        Font font = this.getFont();
        FontMetrics metrics = font == null ? null : this.getFontMetrics(font);
        int height = metrics == null ? 16 : metrics.getHeight();
        Dimension size = new Dimension(height * 32, height * 16);
        JTextArea area = new JTextArea((String)this.parser.fun((Object)this.getText()));
        area.setFont(font);
        area.setWrapStyleWord(true);
        area.setLineWrap(true);
        area.putClientProperty(Expandable.class, this);
        ExpandableTextField.copyCaretPosition(this, area);
        UIUtil.addUndoRedoActions((JTextComponent)area);
        JBScrollPane pane = new JBScrollPane(area);
        pane.setVerticalScrollBarPolicy(22);
        pane.getVerticalScrollBar().setBackground(area.getBackground());
        pane.getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", new JLabel(AllIcons.General.CollapseComponent){
            {
                this.setToolTipText(KeymapUtil.createTooltipText("Collapse", "CollapseExpandableComponent"));
                this.setCursor(Cursor.getPredefinedCursor(12));
                this.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)5, (int)5));
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponentHover);
                    }

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.setIcon(AllIcons.General.CollapseComponent);
                    }

                    @Override
                    public void mousePressed(MouseEvent event) {
                        ExpandableTextField.this.collapse();
                    }
                });
            }
        });
        Insets insets = this.getInsets();
        JBInsets.addTo((Dimension)size, (Insets)insets);
        JBInsets.addTo((Dimension)size, (Insets)pane.getInsets());
        if (size.width - 50 < this.getWidth()) {
            size.width = this.getWidth();
        }
        Point location = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location, this);
        Rectangle screen = ScreenUtil.getScreenRectangle(this);
        int bottom = screen.y - location.y + screen.height;
        if (bottom < size.height) {
            int top = location.y - screen.y + this.getHeight();
            if (top < bottom) {
                size.height = bottom;
            } else {
                if (size.height > top) {
                    size.height = top;
                }
                location.y -= size.height - this.getHeight();
            }
        }
        pane.setPreferredSize(size);
        pane.setViewportBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        this.popup = JBPopupFactory.getInstance().createComponentPopupBuilder(pane, area).setFocusable(true).setRequestFocus(true).setTitle(this.title).setLocateByContent(true).setCancelOnWindowDeactivation(false).setKeyboardActions(Collections.singletonList(Pair.create(event -> {
            this.collapse();
            Window window = UIUtil.getWindow((Component)this);
            if (window != null) {
                window.dispatchEvent(new KeyEvent(this, 401, System.currentTimeMillis(), 2, 10, '\r'));
            }
        }, (Object)KeyStroke.getKeyStroke(10, 2)))).setCancelCallback((Computable<Boolean>)((Computable)() -> {
            try {
                this.setText((String)this.joiner.fun((Object)area.getText()));
                ExpandableTextField.copyCaretPosition(area, this);
                this.popup = null;
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        })).createPopup();
        this.popup.show(new RelativePoint(location));
    }

    private static void copyCaretPosition(JTextComponent source, JTextComponent destination) {
        try {
            destination.setCaretPosition(source.getCaretPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "joiner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/ExpandableTextField";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

