/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.plaf.TextUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public class JBTextField
extends JTextField
implements ComponentWithEmptyText {
    private TextComponentEmptyText myEmptyText;

    public JBTextField() {
        this.init();
    }

    public JBTextField(int columns) {
        super(columns);
        this.init();
    }

    public JBTextField(String text) {
        super(text);
        this.init();
    }

    public JBTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    private void init() {
        UIUtil.addUndoRedoActions((JTextComponent)this);
        this.myEmptyText = new TextComponentEmptyText(this);
    }

    public void setTextToTriggerEmptyTextStatus(String t) {
        this.myEmptyText.setTextToTriggerStatus(t);
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        UIUtil.resetUndoRedoActions((JTextComponent)this);
    }

    @Override
    @NotNull
    public StatusText getEmptyText() {
        TextComponentEmptyText textComponentEmptyText = this.myEmptyText;
        if (textComponentEmptyText == null) {
            JBTextField.$$$reportNull$$$0(0);
        }
        return textComponentEmptyText;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.myEmptyText.getStatusTriggerText().isEmpty() && this.myEmptyText.isStatusVisible()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.getForeground());
        }
        this.myEmptyText.paintStatusText(g);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TextUI ui = this.getUI();
        String text = ui == null ? null : ui.getToolTipText(this, event.getPoint());
        return text != null ? text : this.getToolTipText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBTextField", "getEmptyText"));
    }
}

