/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import java.util.function.Function;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public interface TreeVisitor {
    @NotNull
    public Action accept(@NotNull TreePath var1);

    public static class PathFinder
    implements TreeVisitor {
        private final Function<Object, Object> converter;
        private final TreePath path;

        public PathFinder(@NotNull TreePath path2) {
            if (path2 == null) {
                PathFinder.$$$reportNull$$$0(0);
            }
            this(path2, object -> object);
        }

        public PathFinder(@NotNull TreePath path2, @NotNull Function<Object, Object> converter) {
            if (path2 == null) {
                PathFinder.$$$reportNull$$$0(1);
            }
            if (converter == null) {
                PathFinder.$$$reportNull$$$0(2);
            }
            this.converter = converter;
            this.path = path2;
        }

        @Override
        @NotNull
        public Action accept(@NotNull TreePath path2) {
            Object component;
            if (path2 == null) {
                PathFinder.$$$reportNull$$$0(3);
            }
            if ((component = this.converter.apply(path2.getLastPathComponent())) == null) {
                Action action = Action.SKIP_CHILDREN;
                if (action == null) {
                    PathFinder.$$$reportNull$$$0(4);
                }
                return action;
            }
            int pathCount = path2.getPathCount();
            int thisCount = this.path.getPathCount();
            if (thisCount < pathCount) {
                Action action = Action.SKIP_CHILDREN;
                if (action == null) {
                    PathFinder.$$$reportNull$$$0(5);
                }
                return action;
            }
            Action action = thisCount == pathCount ? Action.INTERRUPT : Action.CONTINUE;
            TreePath value = this.path;
            while (thisCount > pathCount) {
                --thisCount;
                if ((value = value.getParentPath()) != null) continue;
                Action action2 = Action.SKIP_CHILDREN;
                if (action2 == null) {
                    PathFinder.$$$reportNull$$$0(6);
                }
                return action2;
            }
            Action action3 = this.matches(component, value.getLastPathComponent()) ? action : Action.SKIP_CHILDREN;
            if (action3 == null) {
                PathFinder.$$$reportNull$$$0(7);
            }
            return action3;
        }

        protected boolean matches(@NotNull Object pathComponent, @NotNull Object thisComponent) {
            if (pathComponent == null) {
                PathFinder.$$$reportNull$$$0(8);
            }
            if (thisComponent == null) {
                PathFinder.$$$reportNull$$$0(9);
            }
            return pathComponent.equals(thisComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeVisitor$PathFinder";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pathComponent";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "thisComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeVisitor$PathFinder";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "accept";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "matches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class Finder
    implements TreeVisitor {
        @Override
        @NotNull
        public Action accept(@NotNull TreePath path2) {
            if (path2 == null) {
                Finder.$$$reportNull$$$0(0);
            }
            Action action = this.found(path2) ? Action.INTERRUPT : (this.contains(path2) ? Action.CONTINUE : Action.SKIP_CHILDREN);
            if (action == null) {
                Finder.$$$reportNull$$$0(1);
            }
            return action;
        }

        protected abstract boolean found(@NotNull TreePath var1);

        protected abstract boolean contains(@NotNull TreePath var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/TreeVisitor$Finder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/TreeVisitor$Finder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "accept";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Action {
        INTERRUPT,
        CONTINUE,
        SKIP_CHILDREN,
        SKIP_SIBLINGS;

    }
}

