/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageContextPanel;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageContextPanelBase;
import com.intellij.usages.impl.UsageViewImpl;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsagePreviewPanel
extends UsageContextPanelBase
implements DataProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usages.impl.UsagePreviewPanel");
    private Editor myEditor;
    private final boolean myIsEditor;
    private int myLineHeight;
    private List<UsageInfo> myCachedSelectedUsageInfos;
    private static final Key<Boolean> IN_PREVIEW_USAGE_FLAG = Key.create((String)"IN_PREVIEW_USAGE_FLAG");
    private static final Key<UsagePreviewPanel> PREVIEW_EDITOR_FLAG = Key.create((String)"PREVIEW_EDITOR_FLAG");

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation) {
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            UsagePreviewPanel.$$$reportNull$$$0(1);
        }
        this(project, presentation, false);
    }

    public UsagePreviewPanel(@NotNull Project project, @NotNull UsageViewPresentation presentation, boolean isEditor) {
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(2);
        }
        if (presentation == null) {
            UsagePreviewPanel.$$$reportNull$$$0(3);
        }
        super(project, presentation);
        this.myIsEditor = isEditor;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.EDITOR.getName().equals(dataId) && this.myEditor != null) {
            return this.myEditor;
        }
        return null;
    }

    private void resetEditor(@NotNull List<UsageInfo> infos) {
        if (infos == null) {
            UsagePreviewPanel.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiElement psiElement = infos.get(0).getElement();
        if (psiElement == null) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile == null) {
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(this.myProject).getInjectionHost(psiFile);
        if (host != null && (psiFile = host.getContainingFile()) == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance(psiFile.getProject()).getDocument(psiFile);
        if (document == null) {
            return;
        }
        if (this.myEditor == null || document != this.myEditor.getDocument()) {
            this.releaseEditor();
            this.removeAll();
            this.myEditor = this.createEditor(psiFile, document);
            if (this.myEditor == null) {
                return;
            }
            this.myLineHeight = this.myEditor.getLineHeight();
            this.myEditor.setBorder(null);
            this.add((Component)this.myEditor.getComponent(), "Center");
            this.invalidate();
            this.validate();
        }
        if (!Comparing.equal(infos, this.myCachedSelectedUsageInfos)) {
            UsagePreviewPanel.highlight(infos, this.myEditor, this.myProject, true, 3000);
            this.myCachedSelectedUsageInfos = infos;
        }
    }

    public int getLineHeight() {
        return this.myLineHeight;
    }

    public static void highlight(@NotNull List<UsageInfo> infos, @NotNull Editor editor, @NotNull Project project, boolean highlightOnlyNameElements, int highlightLayer) {
        if (infos == null) {
            UsagePreviewPanel.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            UsagePreviewPanel.$$$reportNull$$$0(6);
        }
        if (project == null) {
            UsagePreviewPanel.$$$reportNull$$$0(7);
        }
        LOG.assertTrue(!PsiDocumentManager.getInstance(project).hasUncommitedDocuments());
        MarkupModel markupModel = editor.getMarkupModel();
        for (RangeHighlighter highlighter : markupModel.getAllHighlighters()) {
            if (highlighter.getUserData(IN_PREVIEW_USAGE_FLAG) == null) continue;
            highlighter.dispose();
        }
        for (int i2 = infos.size() - 1; i2 >= 0; --i2) {
            PsiFile psiFile;
            PsiElement nameElement;
            TextRange textRange;
            UsageInfo info = infos.get(i2);
            PsiElement psiElement = info.getElement();
            if (psiElement == null || !psiElement.isValid()) continue;
            int offsetInFile = psiElement.getTextOffset();
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextRange elementRange = psiElement.getTextRange();
            ProperTextRange infoRange = info.getRangeInElement();
            TextRange textRange2 = textRange = infoRange == null || infoRange.getStartOffset() > elementRange.getLength() || infoRange.getEndOffset() > elementRange.getLength() ? null : elementRange.cutOut((TextRange)infoRange);
            if (textRange == null) {
                textRange = elementRange;
            }
            if (highlightOnlyNameElements && psiElement instanceof PsiNamedElement && !(psiElement instanceof PsiFile) && (nameElement = (psiFile = psiElement.getContainingFile()).findElementAt(offsetInFile)) != null) {
                textRange = nameElement.getTextRange();
            }
            textRange = InjectedLanguageManager.getInstance(project).injectedToHost(psiElement, textRange);
            RangeHighlighter highlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), highlightLayer, attributes, HighlighterTargetArea.EXACT_RANGE);
            highlighter.putUserData(IN_PREVIEW_USAGE_FLAG, Boolean.TRUE);
            editor.getCaretModel().moveToOffset(textRange.getEndOffset());
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    private Editor createEditor(PsiFile psiFile, Document document) {
        if (this.isDisposed) {
            return null;
        }
        Project project = psiFile.getProject();
        Editor editor = EditorFactory.getInstance().createEditor(document, project, psiFile.getVirtualFile(), !this.myIsEditor, EditorKind.PREVIEW);
        EditorSettings settings = editor.getSettings();
        this.customizeEditorSettings(settings);
        editor.putUserData(PREVIEW_EDITOR_FLAG, this);
        return editor;
    }

    protected void customizeEditorSettings(EditorSettings settings) {
        settings.setLineMarkerAreaShown(this.myIsEditor);
        settings.setFoldingOutlineShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setAnimatedScrolling(false);
    }

    @Override
    public void dispose() {
        this.isDisposed = true;
        this.releaseEditor();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            if (editor.getProject() != this.myProject || editor.getUserData(PREVIEW_EDITOR_FLAG) != this) continue;
            LOG.error("Editor was not released:" + editor);
        }
    }

    private void releaseEditor() {
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
            this.myEditor = null;
            this.myCachedSelectedUsageInfos = null;
        }
    }

    @Override
    public void updateLayoutLater(@Nullable List<UsageInfo> infos) {
        if (infos == null) {
            this.releaseEditor();
            this.removeAll();
            JLabel titleComp = new JLabel(UsageViewBundle.message("select.the.usage.to.preview", this.myPresentation.getUsagesWord()), 0);
            this.add((Component)titleComp, "Center");
            this.revalidate();
        } else {
            this.resetEditor(infos);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/usages/impl/UsagePreviewPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "highlight";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Provider
    implements UsageContextPanel.Provider {
        @Override
        @NotNull
        public UsageContextPanel create(@NotNull UsageView usageView) {
            if (usageView == null) {
                Provider.$$$reportNull$$$0(0);
            }
            UsagePreviewPanel usagePreviewPanel = new UsagePreviewPanel(((UsageViewImpl)usageView).getProject(), usageView.getPresentation(), true);
            if (usagePreviewPanel == null) {
                Provider.$$$reportNull$$$0(1);
            }
            return usagePreviewPanel;
        }

        @Override
        public boolean isAvailableFor(@NotNull UsageView usageView) {
            if (usageView == null) {
                Provider.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        @NotNull
        public String getTabTitle() {
            if ("Preview" == null) {
                Provider.$$$reportNull$$$0(3);
            }
            return "Preview";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageView";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/UsagePreviewPanel$Provider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/UsagePreviewPanel$Provider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailableFor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

