/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.Patches;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CountingGZIPInputStream;
import com.intellij.util.io.ProgressMonitorInputStream;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.UntrustedCertificateStrategy;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequests {
    private static final Logger LOG = Logger.getInstance(HttpRequests.class);
    private static final int BLOCK_SIZE = 16384;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([^;]+)");

    private HttpRequests() {
    }

    @NotNull
    public static RequestBuilder request(@NotNull String url) {
        if (url == null) {
            HttpRequests.$$$reportNull$$$0(0);
        }
        RequestBuilderImpl requestBuilderImpl = new RequestBuilderImpl(url);
        if (requestBuilderImpl == null) {
            HttpRequests.$$$reportNull$$$0(1);
        }
        return requestBuilderImpl;
    }

    @NotNull
    public static String createErrorMessage(@NotNull IOException e, @NotNull Request request, boolean includeHeaders) {
        if (e == null) {
            HttpRequests.$$$reportNull$$$0(2);
        }
        if (request == null) {
            HttpRequests.$$$reportNull$$$0(3);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cannot download '").append(request.getURL()).append("': ").append(e.getMessage());
        try {
            URLConnection connection = request.getConnection();
            if (includeHeaders) {
                builder.append("\n, headers: ").append(connection.getHeaderFields());
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                builder.append("\n, response: ").append(httpConnection.getResponseCode()).append(' ').append(httpConnection.getResponseMessage());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = builder.toString();
        if (string == null) {
            HttpRequests.$$$reportNull$$$0(4);
        }
        return string;
    }

    /*
     * Loose catch block
     */
    private static <T> T process(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        LOG.assertTrue(ApplicationManager.getApplication() == null || ApplicationManager.getApplication().isUnitTestMode() || !ApplicationManager.getApplication().isReadAccessAllowed(), (Object)"Network shouldn't be accessed in EDT or inside read action");
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null && HttpRequests.shouldOverrideContextClassLoader()) {
            try {
                T t;
                try (URLClassLoader cl = new URLClassLoader(new URL[0], contextLoader);){
                    Thread.currentThread().setContextClassLoader(cl);
                    t = HttpRequests.doProcess(builder, processor);
                }
                return t;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
        return HttpRequests.doProcess(builder, processor);
    }

    private static boolean shouldOverrideContextClassLoader() {
        return Patches.JDK_BUG_ID_8032832 && SystemProperties.getBooleanProperty((String)"http.requests.override.context.classloader", (boolean)true);
    }

    private static <T> T doProcess(RequestBuilderImpl builder, RequestProcessor<T> processor) throws IOException {
        CertificateManager manager = ApplicationManager.getApplication() != null ? CertificateManager.getInstance() : null;
        try (RequestImpl request = new RequestImpl(builder);){
            if (manager != null) {
                Object t = manager.runWithUntrustedCertificateStrategy(() -> processor.process(request), builder.myUntrustedCertificateStrategy);
                return t;
            }
            T t = processor.process(request);
            return t;
        }
    }

    private static Charset getCharset(Request request) throws IOException {
        Matcher m;
        String contentType = request.getConnection().getContentType();
        if (!StringUtil.isEmptyOrSpaces((String)contentType) && (m = CHARSET_PATTERN.matcher(contentType)).find()) {
            try {
                return Charset.forName(StringUtil.unquoteString((String)m.group(1)));
            }
            catch (IllegalArgumentException e) {
                throw new IOException("unknown charset (" + contentType + ")", e);
            }
        }
        return CharsetToolkit.UTF8_CHARSET;
    }

    private static URLConnection openConnection(RequestBuilderImpl builder, RequestImpl request) throws IOException {
        String url = request.myUrl;
        for (int i2 = 0; i2 < builder.myRedirectLimit; ++i2) {
            URLConnection connection;
            block18: {
                if (builder.myForceHttps && StringUtil.startsWith((CharSequence)url, (CharSequence)"http:")) {
                    url = "https:" + url.substring(5);
                    request.myUrl = url;
                }
                if ((connection = !builder.myUseProxy ? new URL(url).openConnection(Proxy.NO_PROXY) : (ApplicationManager.getApplication() == null ? new URL(url).openConnection() : HttpConfigurable.getInstance().openConnection(url))) instanceof HttpsURLConnection) {
                    if (ApplicationManager.getApplication() != null) {
                        try {
                            SSLContext context = CertificateManager.getInstance().getSslContext();
                            SSLSocketFactory factory = context.getSocketFactory();
                            if (factory != null) {
                                ((HttpsURLConnection)connection).setSSLSocketFactory(factory);
                                break block18;
                            }
                            LOG.info("SSLSocketFactory is not defined by IDE CertificateManager; Using default SSL configuration to connect to " + url);
                        }
                        catch (Throwable e) {
                            LOG.info("Problems configuring SSL connection to " + url, e);
                        }
                    } else {
                        LOG.info("Application is not initialized yet; Using default SSL configuration to connect to " + url);
                    }
                }
            }
            connection.setConnectTimeout(builder.myConnectTimeout);
            connection.setReadTimeout(builder.myTimeout);
            if (builder.myUserAgent != null) {
                connection.setRequestProperty("User-Agent", builder.myUserAgent);
            }
            if (builder.myHostnameVerifier != null && connection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)connection).setHostnameVerifier(builder.myHostnameVerifier);
            }
            if (builder.myGzip) {
                connection.setRequestProperty("Accept-Encoding", "gzip");
            }
            if (builder.myAccept != null) {
                connection.setRequestProperty("Accept", builder.myAccept);
            }
            connection.setUseCaches(false);
            if (builder.myTuner != null) {
                builder.myTuner.tune(connection);
            }
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("connecting to " + url);
                }
                int responseCode = httpURLConnection.getResponseCode();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("response: " + responseCode);
                }
                if (responseCode < 200 || responseCode >= 300 && responseCode != 304) {
                    httpURLConnection.disconnect();
                    if (responseCode == 301 || responseCode == 302) {
                        url = connection.getHeaderField("Location");
                        request.myUrl = url;
                        if (url != null) continue;
                    }
                    String message = IdeBundle.message("error.connection.failed.with.http.code.N", responseCode);
                    throw new HttpStatusException(message, responseCode, StringUtil.notNullize((String)url, (String)"Empty URL"));
                }
            }
            return connection;
        }
        throw new IOException(IdeBundle.message("error.connection.failed.redirects", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/HttpRequests";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "request";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RequestImpl
    implements Request,
    AutoCloseable {
        private final RequestBuilderImpl myBuilder;
        private String myUrl;
        private URLConnection myConnection;
        private InputStream myInputStream;
        private BufferedReader myReader;

        private RequestImpl(RequestBuilderImpl builder) {
            this.myBuilder = builder;
            this.myUrl = this.myBuilder.myUrl;
        }

        @Override
        @NotNull
        public String getURL() {
            String string = this.myUrl;
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public URLConnection getConnection() throws IOException {
            if (this.myConnection == null) {
                this.myConnection = HttpRequests.openConnection(this.myBuilder, this);
            }
            URLConnection uRLConnection = this.myConnection;
            if (uRLConnection == null) {
                RequestImpl.$$$reportNull$$$0(1);
            }
            return uRLConnection;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            if (this.myInputStream == null) {
                this.myInputStream = this.getConnection().getInputStream();
                if (this.myBuilder.myGzip && "gzip".equalsIgnoreCase(this.getConnection().getContentEncoding())) {
                    this.myInputStream = CountingGZIPInputStream.create(this.myInputStream);
                }
            }
            InputStream inputStream = this.myInputStream;
            if (inputStream == null) {
                RequestImpl.$$$reportNull$$$0(2);
            }
            return inputStream;
        }

        @Override
        @NotNull
        public BufferedReader getReader() throws IOException {
            BufferedReader bufferedReader = this.getReader(null);
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(3);
            }
            return bufferedReader;
        }

        @Override
        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator indicator) throws IOException {
            if (this.myReader == null) {
                int contentLength;
                InputStream inputStream = this.getInputStream();
                if (indicator != null && (contentLength = this.getConnection().getContentLength()) > 0) {
                    inputStream = new ProgressMonitorInputStream(indicator, inputStream, contentLength);
                }
                this.myReader = new BufferedReader(new InputStreamReader(inputStream, HttpRequests.getCharset(this)));
            }
            BufferedReader bufferedReader = this.myReader;
            if (bufferedReader == null) {
                RequestImpl.$$$reportNull$$$0(4);
            }
            return bufferedReader;
        }

        @Override
        public boolean isSuccessful() throws IOException {
            URLConnection connection = this.getConnection();
            return !(connection instanceof HttpURLConnection) || ((HttpURLConnection)connection).getResponseCode() == 200;
        }

        @Override
        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator indicator) throws IOException {
            int contentLength = this.getConnection().getContentLength();
            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
            NetUtils.copyStreamContent(indicator, this.getInputStream(), (OutputStream)out, contentLength);
            byte[] byArray = ArrayUtil.realloc((byte[])out.getInternalBuffer(), (int)out.size());
            if (byArray == null) {
                RequestImpl.$$$reportNull$$$0(5);
            }
            return byArray;
        }

        @Override
        @NotNull
        public String readString(@Nullable ProgressIndicator indicator) throws IOException {
            Charset cs = HttpRequests.getCharset(this);
            byte[] bytes = this.readBytes(indicator);
            String string = new String(bytes, cs);
            if (string == null) {
                RequestImpl.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        public File saveToFile(@NotNull File file, @Nullable ProgressIndicator indicator) throws IOException {
            if (file == null) {
                RequestImpl.$$$reportNull$$$0(7);
            }
            FileUtilRt.createParentDirs((File)file);
            boolean deleteFile = true;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
                NetUtils.copyStreamContent(indicator, this.getInputStream(), out, this.getConnection().getContentLength());
                deleteFile = false;
            }
            catch (IOException e) {
                throw new IOException(HttpRequests.createErrorMessage(e, this, false), e);
            }
            finally {
                if (deleteFile) {
                    FileUtilRt.delete((File)file);
                }
            }
            File file2 = file;
            if (file2 == null) {
                RequestImpl.$$$reportNull$$$0(8);
            }
            return file2;
        }

        @Override
        public void close() {
            StreamUtil.closeStream((Closeable)this.myInputStream);
            StreamUtil.closeStream((Closeable)this.myReader);
            if (this.myConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)this.myConnection).disconnect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getURL";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInputStream";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readBytes";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "readString";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestImpl";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "saveToFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "saveToFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RequestBuilderImpl
    extends RequestBuilder {
        private final String myUrl;
        private int myConnectTimeout;
        private int myTimeout;
        private int myRedirectLimit;
        private boolean myGzip;
        private boolean myForceHttps;
        private boolean myUseProxy;
        private HostnameVerifier myHostnameVerifier;
        private String myUserAgent;
        private String myAccept;
        private ConnectionTuner myTuner;
        private UntrustedCertificateStrategy myUntrustedCertificateStrategy;

        private RequestBuilderImpl(@NotNull String url) {
            if (url == null) {
                RequestBuilderImpl.$$$reportNull$$$0(0);
            }
            this.myConnectTimeout = HttpConfigurable.CONNECTION_TIMEOUT;
            this.myTimeout = HttpConfigurable.READ_TIMEOUT;
            this.myRedirectLimit = HttpConfigurable.REDIRECT_LIMIT;
            this.myGzip = true;
            this.myUseProxy = true;
            this.myUntrustedCertificateStrategy = UntrustedCertificateStrategy.ASK_USER;
            this.myUrl = url;
        }

        @Override
        public RequestBuilder connectTimeout(int value) {
            this.myConnectTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder readTimeout(int value) {
            this.myTimeout = value;
            return this;
        }

        @Override
        public RequestBuilder redirectLimit(int redirectLimit) {
            this.myRedirectLimit = redirectLimit;
            return this;
        }

        @Override
        public RequestBuilder gzip(boolean value) {
            this.myGzip = value;
            return this;
        }

        @Override
        public RequestBuilder forceHttps(boolean forceHttps) {
            this.myForceHttps = forceHttps;
            return this;
        }

        @Override
        public RequestBuilder useProxy(boolean useProxy) {
            this.myUseProxy = useProxy;
            return this;
        }

        @Override
        public RequestBuilder hostNameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
            this.myHostnameVerifier = hostnameVerifier;
            return this;
        }

        @Override
        public RequestBuilder userAgent(@Nullable String userAgent) {
            this.myUserAgent = userAgent;
            return this;
        }

        @Override
        public RequestBuilder productNameAsUserAgent() {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                String productName = ApplicationNamesInfo.getInstance().getFullProductName();
                String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
                return this.userAgent(productName + '/' + version);
            }
            return this.userAgent("IntelliJ");
        }

        @Override
        public RequestBuilder accept(@Nullable String mimeType) {
            this.myAccept = mimeType;
            return this;
        }

        @Override
        public RequestBuilder tuner(@Nullable ConnectionTuner tuner) {
            this.myTuner = tuner;
            return this;
        }

        @Override
        public RequestBuilder untrustedCertificateStrategy(@NotNull UntrustedCertificateStrategy strategy) {
            if (strategy == null) {
                RequestBuilderImpl.$$$reportNull$$$0(1);
            }
            this.myUntrustedCertificateStrategy = strategy;
            return this;
        }

        @Override
        public <T> T connect(@NotNull RequestProcessor<T> processor) throws IOException {
            if (processor == null) {
                RequestBuilderImpl.$$$reportNull$$$0(2);
            }
            return (T)HttpRequests.process(this, processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/HttpRequests$RequestBuilderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "untrustedCertificateStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "connect";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HttpStatusException
    extends IOException {
        private int myStatusCode;
        private String myUrl;

        public HttpStatusException(@NotNull String message, int statusCode, @NotNull String url) {
            if (message == null) {
                HttpStatusException.$$$reportNull$$$0(0);
            }
            if (url == null) {
                HttpStatusException.$$$reportNull$$$0(1);
            }
            super(message);
            this.myStatusCode = statusCode;
            this.myUrl = url;
        }

        public int getStatusCode() {
            return this.myStatusCode;
        }

        @NotNull
        public String getUrl() {
            String string = this.myUrl;
            if (string == null) {
                HttpStatusException.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public String getMessage() {
            return "Status: " + this.myStatusCode;
        }

        @Override
        public String toString() {
            return super.toString() + ". Status=" + this.myStatusCode + ", Url=" + this.myUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/io/HttpRequests$HttpStatusException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ConnectionTuner {
        public void tune(@NotNull URLConnection var1) throws IOException;
    }

    public static interface RequestProcessor<T> {
        public T process(@NotNull Request var1) throws IOException;
    }

    public static interface Request {
        @NotNull
        public String getURL();

        @NotNull
        public URLConnection getConnection() throws IOException;

        @NotNull
        public InputStream getInputStream() throws IOException;

        @NotNull
        public BufferedReader getReader() throws IOException;

        @NotNull
        public BufferedReader getReader(@Nullable ProgressIndicator var1) throws IOException;

        public boolean isSuccessful() throws IOException;

        @NotNull
        public File saveToFile(@NotNull File var1, @Nullable ProgressIndicator var2) throws IOException;

        @NotNull
        public byte[] readBytes(@Nullable ProgressIndicator var1) throws IOException;

        @NotNull
        public String readString(@Nullable ProgressIndicator var1) throws IOException;
    }
}

