/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.net.ssl.CertificateWrapper;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;

public class CertificateInfoPanel
extends JPanel {
    private static DateFormat DATE_FORMAT = DateFormat.getDateInstance(3);
    private final CertificateWrapper myCertificateWrapper;

    public CertificateInfoPanel(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateInfoPanel.$$$reportNull$$$0(0);
        }
        this.myCertificateWrapper = new CertificateWrapper(certificate);
        this.setLayout(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder();
        CertificateInfoPanel.updateBuilderWithTitle(builder, "Issued To");
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getSubjectFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder, "Issued By");
        CertificateInfoPanel.updateBuilderWithPrincipalData(builder, this.myCertificateWrapper.getIssuerFields());
        CertificateInfoPanel.updateBuilderWithTitle(builder, "Validity Period");
        String notBefore = DATE_FORMAT.format(this.myCertificateWrapper.getNotBefore());
        String notAfter = DATE_FORMAT.format(this.myCertificateWrapper.getNotAfter());
        builder = builder.setIndent(20).addLabeledComponent("Valid from:", CertificateInfoPanel.createColoredComponent(notBefore, "not yet valid", this.myCertificateWrapper.isNotYetValid())).addLabeledComponent("Valid until:", CertificateInfoPanel.createColoredComponent(notAfter, "expired", this.myCertificateWrapper.isExpired()));
        builder.setIndent(0);
        CertificateInfoPanel.updateBuilderWithTitle(builder, "Fingerprints");
        builder.setIndent(20);
        builder.addLabeledComponent("SHA-256:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha256Fingerprint())));
        builder.addLabeledComponent("SHA-1:", CertificateInfoPanel.getTextPane(CertificateInfoPanel.formatHex(this.myCertificateWrapper.getSha1Fingerprint())));
        this.add((Component)builder.getPanel(), "North");
    }

    @NotNull
    private static String formatHex(@NotNull String hex) {
        if (hex == null) {
            CertificateInfoPanel.$$$reportNull$$$0(1);
        }
        StringBuilder builder = new StringBuilder();
        for (int i2 = 0; i2 < hex.length(); i2 += 2) {
            if (i2 == 32) {
                builder.append('\n');
            }
            builder.append(hex.substring(i2, i2 + 2));
            builder.append(' ');
        }
        if (hex.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = builder.toString().toUpperCase();
        if (string == null) {
            CertificateInfoPanel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificateWrapper.getCertificate();
    }

    private static void updateBuilderWithPrincipalData(FormBuilder builder, Map<String, String> fields) {
        builder = builder.setIndent(20);
        for (CertificateWrapper.CommonField field : CertificateWrapper.CommonField.values()) {
            String value = fields.get(field.getShortName());
            if (value == null) continue;
            String label = String.format("<html>%s (<b>%s</b>)</html>", field.getShortName(), field.getLongName());
            builder = builder.addLabeledComponent(label, (JComponent)new JBLabel(value));
        }
        builder.setIndent(0);
    }

    private static void updateBuilderWithTitle(FormBuilder builder, String title) {
        builder.addComponent(new TitledSeparator(title), 7);
    }

    private static JComponent getTextPane(String text) {
        JTextPane pane = new JTextPane();
        pane.setOpaque(false);
        pane.setEditable(false);
        pane.setContentType("text/plain");
        pane.setText(text);
        return pane;
    }

    private static JComponent createColoredComponent(String mainText, String errorText, boolean hasError) {
        SimpleColoredComponent component = new SimpleColoredComponent();
        if (hasError) {
            component.append(mainText + " (" + errorText + ")", new SimpleTextAttributes(0, (Color)JBColor.RED));
        } else {
            component.append(mainText);
        }
        return component;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hex";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateInfoPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "formatHex";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

