/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Range;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.IndexTreePathState;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ui.tree.TreeUtil");
    @NonNls
    @NotNull
    private static final String TREE_UTIL_SCROLL_TIME_STAMP = "TreeUtil.scrollTimeStamp";

    private TreeUtil() {
    }

    @NotNull
    public static JBTreeTraverser<TreePath> treePathTraverser(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(0);
        }
        TreeModel model = tree.getModel();
        JBIterable numbers = JBIterable.generate((Object)0, i2 -> i2 + 1);
        Object root = model.getRoot();
        TreePath rootPath = root == null ? null : new TreePath(root);
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(o -> {
            Object parent = o.getLastPathComponent();
            int count = model.getChildCount(parent);
            return count == 0 ? JBIterable.empty() : numbers.take(count).map(index -> o.pathByAddingChild(model.getChild(parent, (int)index)));
        }).withRoot((Object)rootPath);
        if (jBTreeTraverser == null) {
            TreeUtil.$$$reportNull$$$0(1);
        }
        return jBTreeTraverser;
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(2);
        }
        List list = ((JBTreeTraverser)TreeUtil.treePathTraverser(tree).expandAndFilter(tree::isExpanded)).toList();
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static <T> T findObjectInPath(@Nullable TreePath path2, @NotNull Class<T> clazz) {
        if (clazz == null) {
            TreeUtil.$$$reportNull$$$0(4);
        }
        for (TreePath p = path2; p != null; p = p.getParentPath()) {
            Object o = TreeUtil.getUserObject(p.getLastPathComponent());
            if (!clazz.isInstance(o)) continue;
            return (T)o;
        }
        return null;
    }

    @NotNull
    public static <T> List<T> collectSelectedObjectsOfType(@NotNull JTree tree, @NotNull Class<T> clazz) {
        TreePath[] selections;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(5);
        }
        if (clazz == null) {
            TreeUtil.$$$reportNull$$$0(6);
        }
        if ((selections = tree.getSelectionPaths()) != null) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (TreePath selection : selections) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selection.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (!clazz.isInstance(userObject)) continue;
                result.add(userObject);
            }
            ArrayList<Object> arrayList = result;
            if (arrayList == null) {
                TreeUtil.$$$reportNull$$$0(7);
            }
            return arrayList;
        }
        List list = Collections.emptyList();
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static List<TreePath> collectExpandedPaths(@NotNull JTree tree, @NotNull TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(9);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(10);
        }
        List list = ((JBTreeTraverser)((JBTreeTraverser)TreeUtil.treePathTraverser(tree).expandAndFilter(tree::isExpanded)).withRoot((Object)path2)).toList();
        if (list == null) {
            TreeUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    public static void restoreExpandedPaths(@NotNull JTree tree, @NotNull List<TreePath> paths) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(12);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(13);
        }
        for (int i2 = paths.size() - 1; i2 >= 0; --i2) {
            tree.expandPath(paths.get(i2));
        }
    }

    @NotNull
    public static TreePath getPath(@NotNull TreeNode aRootNode, @NotNull TreeNode aNode) {
        if (aRootNode == null) {
            TreeUtil.$$$reportNull$$$0(14);
        }
        if (aNode == null) {
            TreeUtil.$$$reportNull$$$0(15);
        }
        Object[] nodes = TreeUtil.getPathFromRootTo(aRootNode, aNode, true);
        TreePath treePath = new TreePath(nodes);
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(16);
        }
        return treePath;
    }

    public static boolean isAncestor(@NotNull TreeNode ancestor, @NotNull TreeNode node) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(17);
        }
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(18);
        }
        for (TreeNode parent = node; parent != null; parent = parent.getParent()) {
            if (parent != ancestor) continue;
            return true;
        }
        return false;
    }

    private static boolean isAncestor(@NotNull TreePath ancestor, @NotNull TreePath path2) {
        if (ancestor == null) {
            TreeUtil.$$$reportNull$$$0(19);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(20);
        }
        if (path2.getPathCount() < ancestor.getPathCount()) {
            return false;
        }
        for (int i2 = 0; i2 < ancestor.getPathCount(); ++i2) {
            if (path2.getPathComponent(i2).equals(ancestor.getPathComponent(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDescendants(@NotNull TreePath path2, @NotNull TreePath[] paths) {
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(21);
        }
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(22);
        }
        for (TreePath ancestor : paths) {
            if (!TreeUtil.isAncestor(ancestor, path2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TreePath getPathFromRoot(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(23);
        }
        Object[] path2 = TreeUtil.getPathFromRootTo(null, node, false);
        TreePath treePath = new TreePath(path2);
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(24);
        }
        return treePath;
    }

    @NotNull
    private static TreeNode[] getPathFromRootTo(@Nullable TreeNode root, @NotNull TreeNode node, boolean includeRoot) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(25);
        }
        int height = 0;
        for (TreeNode n = node; n != root; n = n.getParent()) {
            ++height;
        }
        TreeNode[] path2 = new TreeNode[includeRoot ? height + 1 : height];
        int i2 = path2.length - 1;
        TreeNode n = node;
        while (i2 >= 0) {
            path2[i2--] = n;
            n = n.getParent();
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(26);
        }
        return path2;
    }

    @Nullable
    public static TreeNode findNodeWithObject(Object object, @NotNull TreeModel model, Object parent) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(27);
        }
        for (int i2 = 0; i2 < model.getChildCount(parent); ++i2) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)model.getChild(parent, i2);
            if (!childNode.getUserObject().equals(object)) continue;
            return childNode;
        }
        return null;
    }

    public static void removeSelected(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(28);
        }
        if ((paths = tree.getSelectionPaths()) == null) {
            return;
        }
        for (TreePath path2 : paths) {
            TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), path2).restoreSelection(tree);
        }
    }

    public static void removeLastPathComponent(@NotNull JTree tree, @NotNull TreePath pathToBeRemoved) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(29);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(30);
        }
        TreeUtil.removeLastPathComponent((DefaultTreeModel)tree.getModel(), pathToBeRemoved).restoreSelection(tree);
    }

    @Nullable
    public static DefaultMutableTreeNode findNodeWithObject(@NotNull DefaultMutableTreeNode aRoot, Object aObject) {
        if (aRoot == null) {
            TreeUtil.$$$reportNull$$$0(31);
        }
        if (Comparing.equal((Object)aRoot.getUserObject(), (Object)aObject)) {
            return aRoot;
        }
        for (int i2 = 0; i2 < aRoot.getChildCount(); ++i2) {
            DefaultMutableTreeNode candidate = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)aRoot.getChildAt(i2), aObject);
            if (null == candidate) continue;
            return candidate;
        }
        return null;
    }

    @NotNull
    public static TreePath findCommonPath(@NotNull TreePath[] treePaths) {
        if (treePaths == null) {
            TreeUtil.$$$reportNull$$$0(32);
        }
        LOG.assertTrue(TreeUtil.areComponentsEqual(treePaths, 0));
        TreePath result = new TreePath(treePaths[0].getPathComponent(0));
        int pathIndex = 1;
        while (TreeUtil.areComponentsEqual(treePaths, pathIndex)) {
            result = result.pathByAddingChild(treePaths[0].getPathComponent(pathIndex));
            ++pathIndex;
        }
        TreePath treePath = result;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(33);
        }
        return treePath;
    }

    @NotNull
    public static ActionCallback selectFirstNode(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(34);
        }
        TreePath selectionPath = TreeUtil.getFirstNodePath(tree);
        ActionCallback actionCallback = TreeUtil.selectPath(tree, selectionPath);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(35);
        }
        return actionCallback;
    }

    @NotNull
    public static TreePath getFirstNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(36);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        if (!tree.isRootVisible() && model.getChildCount(root) > 0) {
            selectionPath = selectionPath.pathByAddingChild(model.getChild(root, 0));
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(37);
        }
        return treePath;
    }

    @NotNull
    public static TreePath getFirstLeafNodePath(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(38);
        }
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        TreePath selectionPath = new TreePath(root);
        while (model.getChildCount(root) > 0) {
            Object child = model.getChild(root, 0);
            selectionPath = selectionPath.pathByAddingChild(child);
            root = child;
        }
        TreePath treePath = selectionPath;
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(39);
        }
        return treePath;
    }

    @NotNull
    private static IndexTreePathState removeLastPathComponent(@NotNull DefaultTreeModel model, @NotNull TreePath pathToBeRemoved) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(40);
        }
        if (pathToBeRemoved == null) {
            TreeUtil.$$$reportNull$$$0(41);
        }
        IndexTreePathState selectionState = new IndexTreePathState(pathToBeRemoved);
        if (((MutableTreeNode)pathToBeRemoved.getLastPathComponent()).getParent() == null) {
            IndexTreePathState indexTreePathState = selectionState;
            if (indexTreePathState == null) {
                TreeUtil.$$$reportNull$$$0(42);
            }
            return indexTreePathState;
        }
        model.removeNodeFromParent((MutableTreeNode)pathToBeRemoved.getLastPathComponent());
        IndexTreePathState indexTreePathState = selectionState;
        if (indexTreePathState == null) {
            TreeUtil.$$$reportNull$$$0(43);
        }
        return indexTreePathState;
    }

    private static boolean areComponentsEqual(@NotNull TreePath[] paths, int componentIndex) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(44);
        }
        if (paths[0].getPathCount() <= componentIndex) {
            return false;
        }
        Object pathComponent = paths[0].getPathComponent(componentIndex);
        for (TreePath treePath : paths) {
            if (treePath.getPathCount() <= componentIndex) {
                return false;
            }
            if (pathComponent.equals(treePath.getPathComponent(componentIndex))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static TreePath[] removeDuplicates(@NotNull TreePath[] paths) {
        if (paths == null) {
            TreeUtil.$$$reportNull$$$0(45);
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : paths) {
            if (result.contains(path2)) continue;
            result.add(path2);
        }
        TreePath[] treePathArray = result.toArray(new TreePath[result.size()]);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(46);
        }
        return treePathArray;
    }

    @NotNull
    public static TreePath[] selectMaximals(@Nullable TreePath[] paths) {
        if (paths == null) {
            TreePath[] treePathArray = new TreePath[]{};
            if (treePathArray == null) {
                TreeUtil.$$$reportNull$$$0(47);
            }
            return treePathArray;
        }
        TreePath[] noDuplicates = TreeUtil.removeDuplicates(paths);
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        for (TreePath path2 : noDuplicates) {
            ArrayList<TreePath> otherPaths = new ArrayList<TreePath>(Arrays.asList(noDuplicates));
            otherPaths.remove(path2);
            if (TreeUtil.isDescendants(path2, otherPaths.toArray(new TreePath[otherPaths.size()]))) continue;
            result.add(path2);
        }
        TreePath[] treePathArray = result.toArray(new TreePath[result.size()]);
        if (treePathArray == null) {
            TreeUtil.$$$reportNull$$$0(48);
        }
        return treePathArray;
    }

    public static void sort(@NotNull DefaultTreeModel model, @Nullable Comparator comparator) {
        if (model == null) {
            TreeUtil.$$$reportNull$$$0(49);
        }
        TreeUtil.sort((DefaultMutableTreeNode)model.getRoot(), comparator);
    }

    public static void sort(@NotNull DefaultMutableTreeNode node, @Nullable Comparator comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(50);
        }
        TreeUtil.sortRecursively(node, comparator);
    }

    public static <T extends MutableTreeNode> void sortRecursively(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(51);
        }
        TreeUtil.sortChildren(node, comparator);
        for (int i2 = 0; i2 < node.getChildCount(); ++i2) {
            TreeUtil.sortRecursively((MutableTreeNode)node.getChildAt(i2), comparator);
        }
    }

    public static <T extends MutableTreeNode> void sortChildren(@NotNull T node, @Nullable Comparator<? super T> comparator) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(52);
        }
        List<TreeNode> children = TreeUtil.listChildren(node);
        Collections.sort(children, comparator);
        for (int i2 = node.getChildCount() - 1; i2 >= 0; --i2) {
            node.remove(i2);
        }
        TreeUtil.addChildrenTo(node, children);
    }

    public static void addChildrenTo(@NotNull MutableTreeNode node, @NotNull List<? extends TreeNode> children) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(53);
        }
        if (children == null) {
            TreeUtil.$$$reportNull$$$0(54);
        }
        for (TreeNode treeNode : children) {
            MutableTreeNode child = (MutableTreeNode)treeNode;
            node.insert(child, node.getChildCount());
        }
    }

    public static boolean traverse(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(55);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(56);
        }
        int childCount = node.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            if (TreeUtil.traverse(node.getChildAt(i2), traverse)) continue;
            return false;
        }
        return traverse.accept(node);
    }

    public static boolean traverseDepth(@NotNull TreeNode node, @NotNull Traverse traverse) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(57);
        }
        if (traverse == null) {
            TreeUtil.$$$reportNull$$$0(58);
        }
        if (!traverse.accept(node)) {
            return false;
        }
        int childCount = node.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            if (TreeUtil.traverseDepth(node.getChildAt(i2), traverse)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(59);
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, path2, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(60);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectPath(@NotNull JTree tree, TreePath path2, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(61);
        }
        tree.makeVisible(path2);
        if (center) {
            ActionCallback actionCallback = TreeUtil.showRowCentred(tree, tree.getRowForPath(path2));
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(62);
            }
            return actionCallback;
        }
        int row = tree.getRowForPath(path2);
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, row - 2, row + 2, row, -1);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(63);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveDown(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(64);
        }
        int size = tree.getRowCount();
        int row = tree.getLeadSelectionRow();
        if (row < size - 1) {
            ActionCallback actionCallback = TreeUtil.showAndSelect(tree, ++row, row + 2, row, TreeUtil.getSelectedRow(tree), false, true, true);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(65);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(66);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback moveUp(@NotNull JTree tree) {
        int row;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(67);
        }
        if ((row = tree.getLeadSelectionRow()) > 0) {
            ActionCallback actionCallback = TreeUtil.showAndSelect(tree, --row - 2, row, row, TreeUtil.getSelectedRow(tree), false, true, true);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(68);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = ActionCallback.DONE;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(69);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageUp(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(70);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            ActionCallback actionCallback = TreeUtil.moveHome(tree);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(71);
            }
            return actionCallback;
        }
        int decrement = visible - 1;
        int row = Math.max(TreeUtil.getSelectedRow(tree) - decrement, 0);
        int top = TreeUtil.getFirstVisibleRow(tree) - decrement;
        int bottom = top + visible - 1;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, TreeUtil.getSelectedRow(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(72);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback movePageDown(@NotNull JTree tree) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(73);
        }
        if ((visible = TreeUtil.getVisibleRowCount(tree)) <= 0) {
            ActionCallback actionCallback = TreeUtil.moveEnd(tree);
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(74);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        int increment = visible - 1;
        int index = Math.min(TreeUtil.getSelectedRow(tree) + increment, size - 1);
        int top = TreeUtil.getFirstVisibleRow(tree) + increment;
        int bottom = top + visible - 1;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, index, TreeUtil.getSelectedRow(tree));
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(75);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback moveHome(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(76);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentred(tree, 0);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(77);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback moveEnd(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(78);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentred(tree, tree.getRowCount() - 1);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(79);
        }
        return actionCallback;
    }

    @NotNull
    private static ActionCallback showRowCentred(@NotNull JTree tree, int row) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(80);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentered(tree, row, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(81);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(82);
        }
        ActionCallback actionCallback = TreeUtil.showRowCentered(tree, row, centerHorizontally, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(83);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showRowCentered(@NotNull JTree tree, int row, boolean centerHorizontally, boolean scroll) {
        int visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(84);
        }
        int top = (visible = TreeUtil.getVisibleRowCount(tree)) > 0 ? row - (visible - 1) / 2 : row;
        int bottom = visible > 0 ? top + visible - 1 : row;
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, -1, false, scroll, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(85);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(86);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(87);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(88);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, true, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(89);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(90);
        }
        ActionCallback actionCallback = TreeUtil.showAndSelect(tree, top, bottom, row, previous, addToSelection, scroll, false);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(91);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback showAndSelect(@NotNull JTree tree, int top, int bottom, int row, int previous, boolean addToSelection, boolean scroll, boolean resetSelection) {
        Rectangle bottomBounds;
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(92);
        }
        if ((path2 = tree.getPathForRow(row)) == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(93);
            }
            return actionCallback;
        }
        int size = tree.getRowCount();
        if (size == 0) {
            tree.clearSelection();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(94);
            }
            return actionCallback;
        }
        if (top < 0) {
            top = 0;
        }
        if (bottom >= size) {
            bottom = size - 1;
        }
        if (row >= tree.getRowCount()) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(95);
            }
            return actionCallback;
        }
        boolean okToScroll = true;
        if (tree.isShowing()) {
            if (!tree.isValid()) {
                tree.validate();
            }
        } else {
            Application app = ApplicationManager.getApplication();
            if (app != null && app.isUnitTestMode()) {
                okToScroll = false;
            }
        }
        Runnable selectRunnable = () -> {
            if (tree == null) {
                TreeUtil.$$$reportNull$$$0(157);
            }
            if (!tree.isRowSelected(row)) {
                if (addToSelection) {
                    tree.getSelectionModel().addSelectionPath(tree.getPathForRow(row));
                } else {
                    tree.setSelectionRow(row);
                }
            } else if (resetSelection && !addToSelection) {
                tree.setSelectionRow(row);
            }
        };
        if (!okToScroll || !scroll) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(96);
            }
            return actionCallback;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        if (rowBounds == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(97);
            }
            return actionCallback;
        }
        Rectangle topBounds = tree.getRowBounds(top);
        if (topBounds == null) {
            topBounds = rowBounds;
        }
        if ((bottomBounds = tree.getRowBounds(bottom)) == null) {
            bottomBounds = rowBounds;
        }
        Rectangle bounds = topBounds.union(bottomBounds);
        bounds.x = rowBounds.x;
        bounds.width = rowBounds.width;
        Rectangle visible = tree.getVisibleRect();
        if (visible.contains(bounds)) {
            selectRunnable.run();
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(98);
            }
            return actionCallback;
        }
        Component comp = tree.getCellRenderer().getTreeCellRendererComponent(tree, path2.getLastPathComponent(), true, true, false, row, false);
        if (comp instanceof SimpleColoredComponent) {
            SimpleColoredComponent renderer = (SimpleColoredComponent)comp;
            Dimension scrollableSize = renderer.computePreferredSize(true);
            bounds.width = scrollableSize.width;
        }
        ActionCallback callback = new ActionCallback();
        selectRunnable.run();
        Range<Integer> range = TreeUtil.getExpandControlRange(tree, path2);
        if (range != null) {
            int delta = bounds.x - (Integer)range.getFrom();
            bounds.x -= delta;
            bounds.width -= delta;
        }
        if (visible.width < bounds.width) {
            bounds.width = visible.width;
        }
        if (tree instanceof Tree && !((Tree)tree).isHorizontalAutoScrollingEnabled()) {
            bounds.x = 0;
        }
        LOG.debug("tree scroll: ", new Object[]{path2});
        tree.scrollRectToVisible(bounds);
        Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
        long stamp = property instanceof Long ? (Long)property + 1L : Long.MIN_VALUE;
        tree.putClientProperty(TREE_UTIL_SCROLL_TIME_STAMP, stamp);
        int offset = rowBounds.y - bounds.y;
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(tree);
        TreeUtil.scrollToVisible(tree, path2, bounds, offset, stamp, callback::setDone, builder, 3);
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(99);
        }
        return actionCallback;
    }

    private static void scrollToVisible(JTree tree, TreePath path2, Rectangle bounds, int offset, long expected, Runnable done2, AbstractTreeBuilder builder, int attempt) {
        Runnable scroll = () -> {
            Rectangle pathBounds;
            Rectangle rectangle = pathBounds = attempt <= 0 ? null : tree.getPathBounds(path2);
            if (pathBounds != null) {
                Object property = tree.getClientProperty(TREE_UTIL_SCROLL_TIME_STAMP);
                long stamp = property instanceof Long ? (Long)property : Long.MAX_VALUE;
                LOG.debug("tree scroll ", new Object[]{attempt, stamp == expected ? ": try again: " : ": ignore: ", path2});
                if (stamp == expected) {
                    bounds.y = pathBounds.y - offset;
                    Rectangle visible = tree.getVisibleRect();
                    if (bounds.y < visible.y || bounds.y > visible.y + Math.max(0, visible.height - bounds.height)) {
                        tree.scrollRectToVisible(bounds);
                        TreeUtil.scrollToVisible(tree, path2, bounds, offset, expected, done2, builder, attempt - 1);
                        return;
                    }
                }
            }
            done2.run();
        };
        SwingUtilities.invokeLater(builder == null ? scroll : () -> builder.getReady(TreeUtil.class).doWhenDone(scroll));
    }

    private static int getSelectedRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(100);
        }
        return tree.getRowForPath(tree.getSelectionPath());
    }

    private static int getFirstVisibleRow(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(101);
        }
        Rectangle visible = tree.getVisibleRect();
        int row = -1;
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Rectangle bounds = tree.getRowBounds(i2);
            if (visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            row = i2;
            break;
        }
        return row;
    }

    public static int getVisibleRowCount(@NotNull JTree tree) {
        Rectangle visible;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(102);
        }
        if ((visible = tree.getVisibleRect()) == null) {
            return 0;
        }
        int count = 0;
        for (int i2 = 0; i2 < tree.getRowCount(); ++i2) {
            Rectangle bounds = tree.getRowBounds(i2);
            if (bounds == null || visible.y > bounds.y || visible.y + visible.height < bounds.y + bounds.height) continue;
            ++count;
        }
        return count;
    }

    public static int getVisibleRowCountForFixedRowHeight(@NotNull JTree tree) {
        Rectangle bounds;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(103);
        }
        int rowHeight = (bounds = tree.getRowBounds(0)) == null ? 0 : bounds.height;
        return rowHeight == 0 ? tree.getVisibleRowCount() : tree.getVisibleRect().height / rowHeight;
    }

    public static void installActions(final @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(104);
        }
        tree.getActionMap().put("scrollUpChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageUp(tree);
            }
        });
        tree.getActionMap().put("scrollDownChangeSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.movePageDown(tree);
            }
        });
        tree.getActionMap().put("selectPrevious", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveUp(tree);
            }
        });
        tree.getActionMap().put("selectNext", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreeUtil.moveDown(tree);
            }
        });
        TreeUtil.copyAction(tree, "selectLast", "selectLastChangeLead");
        TreeUtil.copyAction(tree, "selectFirst", "selectFirstChangeLead");
        InputMap inputMap = tree.getInputMap(0);
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollUpChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(33, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"scrollDownChangeSelection", (KeyStroke)KeyStroke.getKeyStroke(34, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectNext", (KeyStroke)KeyStroke.getKeyStroke(40, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectPrevious", (KeyStroke)KeyStroke.getKeyStroke(38, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectLast", (KeyStroke)KeyStroke.getKeyStroke(35, 0));
        UIUtil.maybeInstall((InputMap)inputMap, (String)"selectFirst", (KeyStroke)KeyStroke.getKeyStroke(36, 0));
    }

    private static void copyAction(@NotNull JTree tree, String original, String copyTo) {
        Action action;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(105);
        }
        if ((action = tree.getActionMap().get(original)) != null) {
            tree.getActionMap().put(copyTo, action);
        }
    }

    public static void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(106);
        }
        TreePath leadSelectionPath = tree.getLeadSelectionPath();
        for (int row = tree.getRowCount() - 1; row >= 0; --row) {
            tree.collapseRow(row);
        }
        Object root = tree.getModel().getRoot();
        if (root != null) {
            tree.expandPath(new TreePath(root));
        }
        if (leadSelectionPath != null) {
            Object[] path2 = leadSelectionPath.getPath();
            Object[] pathToSelect = new Object[path2.length > keepSelectionLevel && keepSelectionLevel >= 0 ? keepSelectionLevel : path2.length];
            System.arraycopy(path2, 0, pathToSelect, 0, pathToSelect.length);
            if (pathToSelect.length == 0) {
                return;
            }
            TreeUtil.selectPath(tree, new TreePath(pathToSelect));
        }
    }

    public static void selectNode(@NotNull JTree tree, TreeNode node) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(107);
        }
        TreeUtil.selectPath(tree, TreeUtil.getPathFromRoot(node));
    }

    public static void moveSelectedRow(@NotNull JTree tree, int direction) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(108);
        }
        TreePath selectionPath = tree.getSelectionPath();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
        int idx = parent.getIndex(treeNode);
        ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
        ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        TreeUtil.selectNode(tree, treeNode);
    }

    @NotNull
    public static ArrayList<TreeNode> childrenToArray(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(109);
        }
        ArrayList arrayList = (ArrayList)TreeUtil.listChildren(node);
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(110);
        }
        return arrayList;
    }

    @NotNull
    public static List<TreeNode> listChildren(@NotNull TreeNode node) {
        if (node == null) {
            TreeUtil.$$$reportNull$$$0(111);
        }
        int size = node.getChildCount();
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            TreeNode child = node.getChildAt(i2);
            LOG.assertTrue(child != null);
            result.add(child);
        }
        ArrayList<TreeNode> arrayList = result;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(112);
        }
        return arrayList;
    }

    public static void expandRootChildIfOnlyOne(@Nullable JTree tree) {
        if (tree == null) {
            return;
        }
        Runnable runnable = () -> {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
            tree.expandPath(new TreePath(new Object[]{root}));
            if (root.getChildCount() == 1) {
                TreeNode firstChild = root.getFirstChild();
                tree.expandPath(new TreePath(new Object[]{root, firstChild}));
            }
        };
        UIUtil.invokeLaterIfNeeded((Runnable)runnable);
    }

    public static void expandAll(@NotNull JTree tree) {
        int rowCount;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(113);
        }
        tree.expandPath(new TreePath(tree.getModel().getRoot()));
        int oldRowCount = 0;
        while ((rowCount = tree.getRowCount()) != oldRowCount) {
            oldRowCount = rowCount;
            for (int i2 = 0; i2 < rowCount; ++i2) {
                tree.expandRow(i2);
            }
        }
    }

    public static void expand(@NotNull JTree tree, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(114);
        }
        TreeUtil.expand(tree, new TreePath(tree.getModel().getRoot()), levels);
    }

    public static boolean expandWithResult(@NotNull JTree tree, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(115);
        }
        return TreeUtil.expand(tree, new TreePath(tree.getModel().getRoot()), levels);
    }

    private static boolean expand(@NotNull JTree tree, @NotNull TreePath path2, int levels) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(116);
        }
        if (path2 == null) {
            TreeUtil.$$$reportNull$$$0(117);
        }
        if (levels == 0) {
            return false;
        }
        tree.expandPath(path2);
        TreeNode node = (TreeNode)path2.getLastPathComponent();
        Enumeration<? extends TreeNode> children = node.children();
        boolean isReady = true;
        while (children.hasMoreElements()) {
            if (TreeUtil.expand(tree, path2.pathByAddingChild(children.nextElement()), levels - 1)) continue;
            isReady = false;
        }
        return isReady;
    }

    @NotNull
    public static ActionCallback selectInTree(DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(118);
        }
        ActionCallback actionCallback = TreeUtil.selectInTree(node, requestFocus, tree, true);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(119);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectInTree(@Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(120);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(121);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                if (tree == null) {
                    TreeUtil.$$$reportNull$$$0(156);
                }
                IdeFocusManager.getGlobalInstance().requestFocus(tree, true);
            });
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, treePath, center);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(122);
        }
        return actionCallback;
    }

    @NotNull
    public static ActionCallback selectInTree(Project project, @Nullable DefaultMutableTreeNode node, boolean requestFocus, @NotNull JTree tree, boolean center) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(123);
        }
        if (node == null) {
            ActionCallback actionCallback = ActionCallback.DONE;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(124);
            }
            return actionCallback;
        }
        TreePath treePath = new TreePath(node.getPath());
        tree.expandPath(treePath);
        if (requestFocus) {
            ActionCallback result = new ActionCallback(2);
            IdeFocusManager.getInstance(project).requestFocus(tree, true).notifyWhenDone(result);
            TreeUtil.selectPath(tree, treePath, center).notifyWhenDone(result);
            ActionCallback actionCallback = result;
            if (actionCallback == null) {
                TreeUtil.$$$reportNull$$$0(125);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = TreeUtil.selectPath(tree, treePath, center);
        if (actionCallback == null) {
            TreeUtil.$$$reportNull$$$0(126);
        }
        return actionCallback;
    }

    @NotNull
    public static List<TreePath> collectSelectedPaths(@NotNull JTree tree, @NotNull TreePath treePath) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(127);
        }
        if (treePath == null) {
            TreeUtil.$$$reportNull$$$0(128);
        }
        ArrayList<TreePath> result = new ArrayList<TreePath>();
        TreePath[] selections = tree.getSelectionPaths();
        if (selections != null) {
            for (TreePath selection : selections) {
                if (!treePath.isDescendant(selection)) continue;
                result.add(selection);
            }
        }
        ArrayList<TreePath> arrayList = result;
        if (arrayList == null) {
            TreeUtil.$$$reportNull$$$0(129);
        }
        return arrayList;
    }

    public static void unselectPath(@NotNull JTree tree, @Nullable TreePath path2) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(130);
        }
        if (path2 == null) {
            return;
        }
        TreePath[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        for (TreePath selectionPath : selectionPaths) {
            if (selectionPath.getPathCount() <= path2.getPathCount() || !path2.isDescendant(selectionPath)) continue;
            tree.removeSelectionPath(selectionPath);
        }
    }

    @Nullable
    public static Range<Integer> getExpandControlRange(@NotNull JTree aTree, @Nullable TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(131);
        }
        TreeModel treeModel = aTree.getModel();
        BasicTreeUI basicTreeUI = (BasicTreeUI)aTree.getUI();
        Icon expandedIcon = basicTreeUI.getExpandedIcon();
        Range box = null;
        if (path2 != null && !treeModel.isLeaf(path2.getLastPathComponent())) {
            Insets i2 = aTree.getInsets();
            int boxWidth = expandedIcon != null ? expandedIcon.getIconWidth() : 8;
            int boxLeftX = i2 != null ? i2.left : 0;
            boolean leftToRight = aTree.getComponentOrientation().isLeftToRight();
            int depthOffset = TreeUtil.getDepthOffset(aTree);
            int totalChildIndent = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            if (leftToRight) {
                boxLeftX += (path2.getPathCount() + depthOffset - 2) * totalChildIndent + basicTreeUI.getLeftChildIndent() - boxWidth / 2;
            }
            int boxRightX = boxLeftX + boxWidth;
            box = new Range((Comparable)Integer.valueOf(boxLeftX), (Comparable)Integer.valueOf(boxRightX));
        }
        return box;
    }

    public static int getDepthOffset(@NotNull JTree aTree) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(132);
        }
        if (aTree.isRootVisible()) {
            return aTree.getShowsRootHandles() ? 1 : 0;
        }
        return aTree.getShowsRootHandles() ? 0 : -1;
    }

    @NotNull
    public static RelativePoint getPointForSelection(@NotNull JTree aTree) {
        int[] rows;
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(133);
        }
        if ((rows = aTree.getSelectionRows()) == null || rows.length == 0) {
            RelativePoint relativePoint = RelativePoint.getCenterOf((JComponent)aTree);
            if (relativePoint == null) {
                TreeUtil.$$$reportNull$$$0(134);
            }
            return relativePoint;
        }
        RelativePoint relativePoint = TreeUtil.getPointForRow(aTree, rows[rows.length - 1]);
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(135);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForRow(@NotNull JTree aTree, int aRow) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(136);
        }
        RelativePoint relativePoint = TreeUtil.getPointForPath(aTree, aTree.getPathForRow(aRow));
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(137);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForPath(@NotNull JTree aTree, TreePath path2) {
        if (aTree == null) {
            TreeUtil.$$$reportNull$$$0(138);
        }
        Rectangle rowBounds = aTree.getPathBounds(path2);
        rowBounds.x += 20;
        RelativePoint relativePoint = TreeUtil.getPointForBounds(aTree, rowBounds);
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(139);
        }
        return relativePoint;
    }

    @NotNull
    public static RelativePoint getPointForBounds(JComponent aComponent, @NotNull Rectangle aBounds) {
        if (aBounds == null) {
            TreeUtil.$$$reportNull$$$0(140);
        }
        RelativePoint relativePoint = new RelativePoint((Component)aComponent, new Point(aBounds.x, (int)aBounds.getMaxY()));
        if (relativePoint == null) {
            TreeUtil.$$$reportNull$$$0(141);
        }
        return relativePoint;
    }

    public static boolean isOverSelection(@NotNull JTree tree, @NotNull Point point) {
        TreePath path2;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(142);
        }
        if (point == null) {
            TreeUtil.$$$reportNull$$$0(143);
        }
        return (path2 = tree.getPathForLocation(point.x, point.y)) != null && tree.getSelectionModel().isPathSelected(path2);
    }

    public static void dropSelectionButUnderPoint(@NotNull JTree tree, @NotNull Point treePoint) {
        TreePath toRetain;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(144);
        }
        if (treePoint == null) {
            TreeUtil.$$$reportNull$$$0(145);
        }
        if ((toRetain = tree.getPathForLocation(treePoint.x, treePoint.y)) == null) {
            return;
        }
        TreePath[] selection = tree.getSelectionModel().getSelectionPaths();
        for (TreePath each : selection = selection == null ? new TreePath[]{} : selection) {
            if (toRetain.equals(each)) continue;
            tree.getSelectionModel().removeSelectionPath(each);
        }
    }

    @Nullable
    public static Object getUserObject(@Nullable Object node) {
        return node instanceof DefaultMutableTreeNode ? ((DefaultMutableTreeNode)node).getUserObject() : node;
    }

    @Nullable
    public static TreePath getSelectedPathIfOne(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(146);
        }
        return (paths = tree.getSelectionPaths()) != null && paths.length == 1 ? paths[0] : null;
    }

    public static void ensureSelection(@NotNull JTree tree) {
        TreePath[] paths;
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(147);
        }
        if ((paths = tree.getSelectionPaths()) != null) {
            for (TreePath each : paths) {
                if (tree.getRowForPath(each) < 0 || !tree.isVisible(each)) continue;
                return;
            }
        }
        for (int eachRow = 0; eachRow < tree.getRowCount(); ++eachRow) {
            TreePath eachPath = tree.getPathForRow(eachRow);
            if (eachPath == null || !tree.isVisible(eachPath)) continue;
            tree.setSelectionPath(eachPath);
            break;
        }
    }

    public static <T extends MutableTreeNode> void insertNode(@NotNull T child, @NotNull T parent, @Nullable DefaultTreeModel model, @NotNull Comparator<? super T> comparator) {
        int index;
        if (child == null) {
            TreeUtil.$$$reportNull$$$0(148);
        }
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(149);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(150);
        }
        if ((index = TreeUtil.indexedBinarySearch(parent, child, comparator)) >= 0) {
            LOG.error("Node " + child + " is already added to " + parent);
            return;
        }
        int insertionPoint = -(index + 1);
        if (model != null) {
            model.insertNodeInto(child, parent, insertionPoint);
        } else {
            parent.insert(child, insertionPoint);
        }
    }

    public static <T extends TreeNode> int indexedBinarySearch(@NotNull T parent, @NotNull T key, @NotNull Comparator<? super T> comparator) {
        if (parent == null) {
            TreeUtil.$$$reportNull$$$0(151);
        }
        if (key == null) {
            TreeUtil.$$$reportNull$$$0(152);
        }
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(153);
        }
        int low = 0;
        int high = parent.getChildCount() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            TreeNode treeNode = parent.getChildAt(mid);
            int cmp = comparator.compare(treeNode, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @NotNull
    public static Comparator<TreePath> getDisplayOrderComparator(@NotNull JTree tree) {
        if (tree == null) {
            TreeUtil.$$$reportNull$$$0(154);
        }
        Comparator<TreePath> comparator = Comparator.comparingInt(tree::getRowForPath);
        if (comparator == null) {
            TreeUtil.$$$reportNull$$$0(155);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 129: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 155: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 129: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 155: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 129: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 10: 
            case 20: 
            case 21: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: 
            case 22: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRootNode";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aNode";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 18: 
            case 23: 
            case 25: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 57: 
            case 109: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 27: 
            case 40: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 30: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBeRemoved";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aRoot";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePaths";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traverse";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePath";
                break;
            }
            case 131: 
            case 132: 
            case 133: 
            case 136: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aTree";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aBounds";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePoint";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 149: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 150: 
            case 153: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/tree/TreeUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "treePathTraverser";
                break;
            }
            case 3: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExpandedPaths";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedObjectsOfType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRoot";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFromRootTo";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonPath";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFirstNode";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNodePath";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstLeafNodePath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "removeLastPathComponent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "selectMaximals";
                break;
            }
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "selectPath";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "moveDown";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "moveUp";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "movePageUp";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "movePageDown";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "moveHome";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "moveEnd";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "showRowCentred";
                break;
            }
            case 83: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "showRowCentered";
                break;
            }
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndSelect";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "childrenToArray";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "listChildren";
                break;
            }
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "selectInTree";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSelectedPaths";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForSelection";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForRow";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForPath";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointForBounds";
                break;
            }
            case 155: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrderComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treePathTraverser";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 129: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 155: {
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectExpandedPaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findObjectInPath";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedObjectsOfType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreExpandedPaths";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDescendants";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRoot";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPathFromRootTo";
                break;
            }
            case 27: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findNodeWithObject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "removeSelected";
                break;
            }
            case 29: 
            case 30: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "removeLastPathComponent";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findCommonPath";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "selectFirstNode";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNodePath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLeafNodePath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "areComponentsEqual";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "sortRecursively";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "sortChildren";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "traverseDepth";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "selectPath";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "movePageUp";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "movePageDown";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "moveHome";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "moveEnd";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentred";
                break;
            }
            case 82: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "showRowCentered";
                break;
            }
            case 86: 
            case 88: 
            case 90: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "showAndSelect";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRow";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getFirstVisibleRow";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCount";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleRowCountForFixedRowHeight";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "installActions";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "copyAction";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "collapseAll";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "selectNode";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "moveSelectedRow";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "childrenToArray";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "listChildren";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "expandAll";
                break;
            }
            case 114: 
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "expandWithResult";
                break;
            }
            case 118: 
            case 120: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "selectInTree";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "collectSelectedPaths";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "unselectPath";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getExpandControlRange";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "getDepthOffset";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "getPointForSelection";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getPointForRow";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "getPointForPath";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getPointForBounds";
                break;
            }
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "isOverSelection";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "dropSelectionButUnderPoint";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedPathIfOne";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "ensureSelection";
                break;
            }
            case 148: 
            case 149: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "insertNode";
                break;
            }
            case 151: 
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "indexedBinarySearch";
                break;
            }
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayOrderComparator";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "lambda$selectInTree$7";
                break;
            }
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showAndSelect$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 24: 
            case 26: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 60: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 71: 
            case 72: 
            case 74: 
            case 75: 
            case 77: 
            case 79: 
            case 81: 
            case 83: 
            case 85: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 110: 
            case 112: 
            case 119: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: 
            case 129: 
            case 134: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 155: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface Traverse {
        public boolean accept(Object var1);
    }
}

