/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.inspections.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.ws.SpringWebServicesBundle;
import com.intellij.spring.ws.inspections.jam.SpringWebServiceJamModelInspectionBase;
import com.intellij.spring.ws.jam.SpringWebServiceEndpoint;
import com.intellij.spring.ws.util.SpringWebServiceJamUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebServiceAnnotationsInconsistencyInspection
extends SpringWebServiceJamModelInspectionBase {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, ProblemsHolder holder) {
        SpringWebServiceEndpoint endpoint;
        if (aClass == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if ((endpoint = SpringWebServiceJamUtil.getEndpoint(aClass)) != null) {
            this.checkEndpoint(endpoint, holder);
        } else {
            SpringWebServiceAnnotationsInconsistencyInspection.checkClassContainsIllegalAnnotations(aClass, holder);
        }
    }

    private void checkEndpoint(@NotNull SpringWebServiceEndpoint endpoint, @NotNull ProblemsHolder holder) {
        if (endpoint == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(2);
        }
        for (PsiMethod psiMethod : endpoint.getPsiElement().getMethods()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)"org.springframework.ws.server.endpoint.annotation.PayloadRoot", (boolean)true)) continue;
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                SpringWebServiceAnnotationsInconsistencyInspection.checkPayLoadMethodAnnotations((PsiModifierListOwner)parameter, "org.springframework.ws.server.endpoint.annotation.XPathParam", holder);
            }
        }
    }

    private static void checkClassContainsIllegalAnnotations(PsiClass psiClass, ProblemsHolder holder) {
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            SpringWebServiceAnnotationsInconsistencyInspection.checkEndpointClassAnnotations((PsiModifierListOwner)psiMethod, "org.springframework.ws.server.endpoint.annotation.PayloadRoot", holder);
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                SpringWebServiceAnnotationsInconsistencyInspection.checkEndpointClassAnnotations((PsiModifierListOwner)parameter, "org.springframework.ws.server.endpoint.annotation.XPathParam", holder);
            }
        }
    }

    private static void checkEndpointClassAnnotations(@NotNull PsiModifierListOwner owner, @NotNull String incorrectAnnotation, @NotNull ProblemsHolder holder) {
        PsiAnnotation psiAnnotation;
        if (owner == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (incorrectAnnotation == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(5);
        }
        if ((psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{incorrectAnnotation})) != null) {
            holder.registerProblem((PsiElement)psiAnnotation, SpringWebServicesBundle.message("jam.name.annotation.must.be.defined.for.endpoints", StringUtil.getShortName((String)incorrectAnnotation)), new LocalQuickFix[0]);
        }
    }

    private static void checkPayLoadMethodAnnotations(@NotNull PsiModifierListOwner owner, @NotNull String incorrectAnnotation, @NotNull ProblemsHolder holder) {
        PsiAnnotation psiAnnotation;
        if (owner == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(6);
        }
        if (incorrectAnnotation == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(7);
        }
        if (holder == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(8);
        }
        if ((psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{incorrectAnnotation})) != null) {
            holder.registerProblem((PsiElement)psiAnnotation, SpringWebServicesBundle.message("jam.name.annotation.must.be.defined.for.payload.methods", StringUtil.getShortName((String)incorrectAnnotation)), new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringWebServiceAnnotationsInconsistencyInspection" == null) {
            SpringWebServiceAnnotationsInconsistencyInspection.$$$reportNull$$$0(9);
        }
        return "SpringWebServiceAnnotationsInconsistencyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endpoint";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incorrectAnnotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/ws/inspections/jam/SpringWebServiceAnnotationsInconsistencyInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkEndpoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkEndpointClassAnnotations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkPayLoadMethodAnnotations";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

