/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.execution.filters.AbstractFileHyperlinkFilter;
import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeConsoleAdditionalFilter
extends AbstractFileHyperlinkFilter
implements DumbAware {
    public static final FileHyperlinkRawDataFinder FINDER = new NodeAdditionalFinder();

    public NodeConsoleAdditionalFilter(@NotNull Project project, @Nullable String baseDir) {
        if (project == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(0);
        }
        super(project, baseDir);
    }

    public NodeConsoleAdditionalFilter(@NotNull Project project, @Nullable File baseDir) {
        if (project == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(1);
        }
        super(project, baseDir == null ? null : baseDir.getPath());
    }

    @NotNull
    public List<FileHyperlinkRawData> parse(@NotNull String line) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(2);
        }
        List list = FINDER.find(line);
        if (list == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLink(@NotNull String line) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(4);
        }
        int startIndex = line.indexOf("@(");
        while (startIndex >= 0) {
            FileHyperlinkRawData result = NodeConsoleAdditionalFilter.parseFirefoxLikeLinkAt(line, startIndex + 2);
            if (result != null) {
                return result;
            }
            startIndex = line.indexOf("@(", startIndex + 2);
        }
        return null;
    }

    @Nullable
    private static FileHyperlinkRawData parseFirefoxLikeLinkAt(@NotNull String line, int pathStartInd) {
        if (line == null) {
            NodeConsoleAdditionalFilter.$$$reportNull$$$0(5);
        }
        int length = line.length();
        int pathEndInd = line.indexOf(58, pathStartInd);
        if (pathEndInd > 0 && pathEndInd - pathStartInd > 3) {
            int lineStartInd;
            int lineEndInd;
            for (lineEndInd = lineStartInd = pathEndInd + 1; lineEndInd < length && Character.isDigit(line.charAt(lineEndInd)); ++lineEndInd) {
            }
            if (lineStartInd == lineEndInd) {
                return null;
            }
            int documentColumn = -1;
            int closeParenInd = lineEndInd;
            if (lineEndInd < length && line.charAt(lineEndInd) == ':') {
                int columnStartInd;
                int columnEndInd;
                for (columnEndInd = columnStartInd = lineEndInd + 1; columnEndInd < length && Character.isDigit(line.charAt(columnEndInd)); ++columnEndInd) {
                }
                if (columnStartInd == columnEndInd) {
                    return null;
                }
                documentColumn = StringUtil.parseInt((String)line.substring(columnStartInd, columnEndInd), (int)-1) - 1;
                closeParenInd = columnEndInd;
            }
            if (closeParenInd < length && line.charAt(closeParenInd) == ')') {
                int documentLine = StringUtil.parseInt((String)line.substring(lineStartInd, lineEndInd), (int)-1) - 1;
                return new FileHyperlinkRawData(line.substring(pathStartInd, pathEndInd), documentLine, documentColumn, pathStartInd, closeParenInd);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseFirefoxLikeLink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseFirefoxLikeLinkAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeAdditionalFinder
    implements FileHyperlinkRawDataFinder {
        private static final FileHyperlinkRawDataFinder PATTERN_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^(?:>> )?\\s*([/\\w].*?):(\\d+)(:\\d+)?(?:\\s|: |$)"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.PATH, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN})});

        private NodeAdditionalFinder() {
        }

        @NotNull
        public List<FileHyperlinkRawData> find(@NotNull String line) {
            FileHyperlinkRawData data;
            if (line == null) {
                NodeAdditionalFinder.$$$reportNull$$$0(0);
            }
            if ((data = NodeConsoleAdditionalFilter.parseFirefoxLikeLink(line)) != null) {
                List<FileHyperlinkRawData> list = Collections.singletonList(data);
                if (list == null) {
                    NodeAdditionalFinder.$$$reportNull$$$0(1);
                }
                return list;
            }
            List list = PATTERN_FINDER.find(line);
            if (list == null) {
                NodeAdditionalFinder.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/NodeConsoleAdditionalFilter$NodeAdditionalFinder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "find";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

