/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListUtil;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsInterpretersDialog
extends DialogWrapper {
    private static final String DIMENSION_SERVICE_KEY = "jetbrains.nodejs.interpreters-dialog";
    private static final String SPLITTER_KEY = "jetbrains.nodejs.interpreters-dialog";
    private static final String HELP_ID = "jetbrains.nodejs.interpreters-dialog.helpId";
    private final Project myProject;
    private final DefaultListModel<NodeJsInterpreter> myListModel;
    private final JBList<NodeJsInterpreter> myList;
    private final boolean myEnableRemote;
    private final EditInterpreterView myEditView;
    private final JComponent myCenterPanelComponent;
    private final boolean myProjectDefaultField;
    private NodeJsInterpreter myProjectDefaultInterpreter;
    private boolean myProjectDefaultInterpreterChanged;

    public NodeJsInterpretersDialog(@NotNull Project project, boolean projectDefaultField, boolean enableRemote) {
        if (project == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(0);
        }
        super(project, true);
        this.myProjectDefaultInterpreterChanged = false;
        this.myProject = project;
        this.myEnableRemote = enableRemote;
        this.myListModel = new DefaultListModel();
        this.myList = new JBList(this.myListModel);
        this.myList.setSelectionMode(2);
        this.myList.getEmptyText().setText(NodeJsInterpretersDialog.getEmptyText());
        this.myProjectDefaultField = projectDefaultField;
        if (!projectDefaultField) {
            this.myProjectDefaultInterpreter = NodeJsInterpreterManager.getInstance(project).getDefault();
        }
        this.myList.setCellRenderer((ListCellRenderer)new NodeJsInterpreterRenderer(false, (Predicate<NodeJsInterpreter>)((Predicate)input -> {
            if (input == null || projectDefaultField) {
                return false;
            }
            return input.equals(this.myProjectDefaultInterpreter);
        })));
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setAddAction(button -> this.performAddAction((AnActionButton)button)).setRemoveAction(button -> ListUtil.removeSelectedItems(this.myList)).setRemoveActionUpdater(e -> this.myList.getSelectedIndex() >= 0).setEditAction(button -> this.editSelectedIfInplaceEditorUnavailable()).setEditActionUpdater(e -> this.isInplaceEditorUnavailable()).disableUpDownActions();
        JPanel decoratorPanel = decorator.createPanel();
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getButton() == 1 && clickCount == 2 && NodeJsInterpretersDialog.this.isInplaceEditorUnavailable()) {
                    NodeJsInterpretersDialog.this.editSelectedIfInplaceEditorUnavailable();
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$1", "onClick"));
            }
        }.installOn(this.myList);
        decoratorPanel.setPreferredSize(new Dimension(JBUI.scale((int)550), JBUI.scale((int)300)));
        JScrollPane pane = JBScrollPane.findScrollPane(this.myList);
        if (pane != null) {
            pane.setHorizontalScrollBarPolicy(31);
        }
        this.myEditView = new EditInterpreterView();
        JBSplitter splitter = new JBSplitter("jetbrains.nodejs.interpreters-dialog", 0.7f);
        splitter.setOrientation(true);
        splitter.setFirstComponent((JComponent)decoratorPanel);
        splitter.setSecondComponent((JComponent)this.myEditView.getPanel());
        this.myCenterPanelComponent = splitter;
        this.setTitle("Node.js Interpreters");
        this.init();
        this.myList.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            NodeJsInterpreter selected = this.getSelectedInterpreter();
            this.myEditView.edit(selected);
        });
        this.configurePopupHandler();
        this.addInterpreters();
    }

    private void configurePopupHandler() {
        ArrayList actionList = ContainerUtil.newArrayList((Object[])new AnAction[]{new SetAsProjectInterpreterAction()});
        DefaultActionGroup actionGroup = new DefaultActionGroup((List)actionList);
        for (AnAction action : actionList) {
            ShortcutSet shortcutSet = action.getShortcutSet();
            if (shortcutSet == null) continue;
            action.registerCustomShortcutSet(shortcutSet, this.myList);
        }
        PopupHandler.installPopupHandler(this.myList, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @Nullable
    private NodeJsInterpreter getSelectedInterpreter() {
        if (this.myList.getMinSelectionIndex() != this.myList.getMaxSelectionIndex()) {
            return null;
        }
        return NodeJsInterpreter.tryCast(this.myList.getSelectedValue());
    }

    private boolean isInplaceEditorUnavailable() {
        NodeJsInterpreter interpreter = this.getSelectedInterpreter();
        return interpreter != null && !interpreter.getType().isInplaceEditorAvailable();
    }

    private void editSelectedIfInplaceEditorUnavailable() {
        NodeJsInterpreterType<? extends NodeJsInterpreter> interpreterType;
        NodeJsInterpreter interpreter;
        int selectedInd = this.myList.getSelectedIndex();
        if (selectedInd >= 0 && (interpreter = NodeJsInterpreter.tryCast(this.myListModel.getElementAt(selectedInd))) != null && !(interpreterType = interpreter.getType()).isInplaceEditorAvailable()) {
            NodeJsInterpreter newInterpreter = interpreterType.edit(this.myProject, interpreter);
            if (newInterpreter != null) {
                this.myListModel.setElementAt(newInterpreter, selectedInd);
            } else {
                NodeUIUtil.balloonInfo(this.myProject, "Can not edit selected Node.js interpreter", this.myList.getLocationOnScreen(), MessageType.ERROR);
            }
        }
    }

    private void addInterpreters() {
        List<NodeJsInterpreterType> types = this.enabledTypes();
        for (NodeJsInterpreterType type : types) {
            List interpreters = type.getInterpreters();
            for (NodeJsInterpreter interpreter : interpreters) {
                this.myListModel.addElement(interpreter);
            }
        }
    }

    @NotNull
    private static String getEmptyText() {
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            String string = "Add interpreter with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
            if (string == null) {
                NodeJsInterpretersDialog.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("No interpreters added" == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(2);
        }
        return "No interpreters added";
    }

    @NotNull
    protected DialogWrapper.DialogStyle getStyle() {
        DialogWrapper.DialogStyle dialogStyle = DialogWrapper.DialogStyle.COMPACT;
        if (dialogStyle == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(3);
        }
        return dialogStyle;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "jetbrains.nodejs.interpreters-dialog";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanelComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    @Nullable
    protected String getHelpId() {
        return HELP_ID;
    }

    @NotNull
    private List<NodeJsInterpreterType> enabledTypes() {
        List<NodeJsInterpreterType> list = NodeJsInterpretersDialog.enabledTypes(this.myEnableRemote);
        if (list == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    static List<NodeJsInterpreterType> enabledTypes(boolean enableRemote) {
        ArrayList enabledTypes = ContainerUtil.newArrayList();
        if (enableRemote) {
            enabledTypes.add(NodeJsRemoteInterpreterType.getInstance());
        }
        enabledTypes.add(NodeJsLocalInterpreterType.getInstance());
        ArrayList arrayList = enabledTypes;
        if (arrayList == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private int findInterpreterIndex(@NotNull NodeJsInterpreter interpreter) {
        if (interpreter == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            if (!interpreter.equals(this.myListModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    private List<NodeJsInterpreter> getInterpreters() {
        ArrayList interpreters = ContainerUtil.newArrayList();
        for (int i = 0; i < this.myListModel.size(); ++i) {
            NodeJsInterpreter interpreter = NodeJsInterpreter.tryCast(this.myListModel.elementAt(i));
            if (interpreter == null) continue;
            interpreters.add(interpreter);
        }
        ArrayList arrayList = interpreters;
        if (arrayList == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void performAddAction(@NotNull AnActionButton button) {
        if (button == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(8);
        }
        HashSet addedInterpreters = ContainerUtil.newHashSet(this.getInterpreters());
        JBPopup popup = NodeJsInterpretersDialog.createAddPopup(this.myProject, this.myEnableRemote, button.getDataContext(), (Consumer<NodeJsInterpreter>)((Consumer)this::addIfNeededAndSelect), addedInterpreters);
        RelativePoint point = button.getPreferredPopupPoint();
        if (point != null) {
            popup.show(point);
        } else {
            popup.showInBestPositionFor(button.getDataContext());
        }
    }

    @NotNull
    public static JBPopup createAddPopup(@NotNull Project project, boolean withRemote, @NotNull DataContext dataContext, @NotNull Consumer<NodeJsInterpreter> callback, @NotNull Set<NodeJsInterpreter> addedInterpreters) {
        if (project == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(10);
        }
        if (callback == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(11);
        }
        if (addedInterpreters == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(12);
        }
        ArrayList types = ContainerUtil.newArrayList((Object[])new NodeJsInterpreterType[]{NodeJsLocalInterpreterType.getInstance()});
        if (withRemote) {
            types.add(NodeJsRemoteInterpreterType.getInstance());
        }
        DefaultActionGroup group = new DefaultActionGroup();
        boolean separator = false;
        for (NodeJsInterpreterType type : types) {
            if (separator) {
                group.add((AnAction)Separator.getInstance());
            }
            group.add((AnAction)new AddInterpreterTypeAction(project, type, callback));
            List interpreters = type.getInterpretersSuggestedToAdd();
            ArrayList filtered = ContainerUtil.newArrayList(interpreters);
            filtered.removeAll(addedInterpreters);
            separator = !filtered.isEmpty();
            for (NodeJsInterpreter interpreter : filtered) {
                group.add((AnAction)new AddInterpreterAction(interpreter, callback));
            }
        }
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, false, true, true, null, -1, null);
        if (listPopup == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(13);
        }
        return listPopup;
    }

    protected void doOKAction() {
        this.myEditView.apply();
        super.doOKAction();
    }

    @NotNull
    public Pair<Boolean, NodeJsInterpreter> showAndGetSelected(@Nullable NodeJsInterpreter interpreterToAddAndSelect) {
        if (interpreterToAddAndSelect != null) {
            this.addIfNeededAndSelect(interpreterToAddAndSelect);
        } else {
            this.myList.clearSelection();
        }
        if (this.showAndGet()) {
            if (!this.myProjectDefaultField && this.myProjectDefaultInterpreterChanged) {
                NodeJsInterpreterManager.getInstance(this.myProject).setDefault(this.myProjectDefaultInterpreter);
            }
            MultiMap group = MultiMap.create();
            for (NodeJsInterpreterType nodeJsInterpreterType : this.enabledTypes()) {
                group.put((Object)nodeJsInterpreterType, (Collection)ContainerUtil.newArrayList());
            }
            List<NodeJsInterpreter> shownInterpreters = this.getInterpreters();
            for (NodeJsInterpreter interpreter : shownInterpreters) {
                NodeJsInterpreter defaultInterpreter;
                group.putValue(interpreter.getType(), (Object)interpreter);
                if (this.myProjectDefaultField || !interpreter.equals(defaultInterpreter = NodeJsInterpreterManager.getInstance(this.myProject).getDefault())) continue;
                NodeJsInterpreterManager.getInstance(this.myProject).setDefault(interpreter);
            }
            for (Map.Entry entry : group.entrySet()) {
                NodeJsInterpreterType type = (NodeJsInterpreterType)entry.getKey();
                type.setInterpreters(ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
            }
            NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreter.tryCast(this.myList.getSelectedValue());
            Pair pair = Pair.create((Object)true, (Object)nodeJsInterpreter);
            if (pair == null) {
                NodeJsInterpretersDialog.$$$reportNull$$$0(14);
            }
            return pair;
        }
        Pair pair = Pair.create((Object)false, null);
        if (pair == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(15);
        }
        return pair;
    }

    private void addIfNeededAndSelect(@NotNull NodeJsInterpreter interpreter) {
        int index;
        if (interpreter == null) {
            NodeJsInterpretersDialog.$$$reportNull$$$0(16);
        }
        if ((index = this.findInterpreterIndex(interpreter)) == -1) {
            this.myListModel.addElement(interpreter);
            index = this.myListModel.size() - 1;
        }
        this.myList.setSelectedIndex(index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyle";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "enabledTypes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddPopup";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "showAndGetSelected";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findInterpreterIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performAddAction";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createAddPopup";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addIfNeededAndSelect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SetAsProjectInterpreterAction
    extends DumbAwareAction {
        protected SetAsProjectInterpreterAction() {
            super("Set as Project Interpreter");
        }

        public void update(AnActionEvent e) {
            NodeJsInterpreter interpreter = NodeJsInterpretersDialog.this.getSelectedInterpreter();
            boolean enabled = !NodeJsInterpretersDialog.this.myProjectDefaultField && interpreter instanceof NodeJsLocalInterpreter;
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        public void actionPerformed(AnActionEvent e) {
            NodeJsInterpreter interpreter = NodeJsInterpretersDialog.this.getSelectedInterpreter();
            if (!NodeJsInterpretersDialog.this.myProjectDefaultField && interpreter instanceof NodeJsLocalInterpreter) {
                NodeJsInterpretersDialog.this.myProjectDefaultInterpreter = interpreter;
                NodeJsInterpretersDialog.this.myProjectDefaultInterpreterChanged = true;
                NodeJsInterpretersDialog.this.myList.repaint();
            }
        }
    }

    private class EditInterpreterView {
        private static final String NO_INTERPRETER_SELECTED = "No interpreter selected";
        private static final String MULTIPLE_INTERPRETERS_SELECTED = "Select a single interpreter for editing";
        private final BorderLayout myBorderLayout = new BorderLayout();
        private final JBPanelWithEmptyText myPanel = new JBPanelWithEmptyText((LayoutManager)this.myBorderLayout);
        private NodeJsInterpreter myInterpreter;
        private NodeJsInterpreterEditor myEditor;

        public EditInterpreterView() {
            this.myPanel.setBorder(DialogWrapper.ourDefaultBorder);
            this.updateEmptyText();
        }

        @NotNull
        public JPanel getPanel() {
            JBPanelWithEmptyText jBPanelWithEmptyText = this.myPanel;
            if (jBPanelWithEmptyText == null) {
                EditInterpreterView.$$$reportNull$$$0(0);
            }
            return jBPanelWithEmptyText;
        }

        private void setComponent(@Nullable Component component) {
            Component prevChild = this.myBorderLayout.getLayoutComponent("Center");
            if (prevChild != null) {
                this.myPanel.remove(prevChild);
            }
            if (component != null) {
                this.myPanel.add(component, (Object)"Center");
            }
            this.myPanel.revalidate();
            this.myPanel.repaint();
        }

        public void edit(@Nullable NodeJsInterpreter selected) {
            if (this.myInterpreter == selected) {
                return;
            }
            this.apply();
            if (selected == null) {
                this.setComponent(null);
            } else {
                NodeJsInterpreterType<? extends NodeJsInterpreter> oldType = this.myInterpreter != null ? this.myInterpreter.getType() : null;
                NodeJsInterpreterType<? extends NodeJsInterpreter> newType = selected.getType();
                if (newType != oldType) {
                    this.myEditor = newType.getEditor(NodeJsInterpretersDialog.this.myProject);
                    this.setComponent(this.myEditor.getEditorComponent());
                }
                this.myEditor.resetEditor(selected);
            }
            this.myInterpreter = selected;
            this.updateEmptyText();
        }

        private void updateEmptyText() {
            this.myPanel.getEmptyText().setText(NodeJsInterpretersDialog.this.myList.isSelectionEmpty() ? NO_INTERPRETER_SELECTED : MULTIPLE_INTERPRETERS_SELECTED);
        }

        private void apply() {
            int ind;
            if (this.myInterpreter != null && (ind = NodeJsInterpretersDialog.this.findInterpreterIndex(this.myInterpreter)) >= 0) {
                Object newInterpreter = this.myEditor.applyEditor();
                NodeJsInterpretersDialog.this.myListModel.set(ind, newInterpreter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$EditInterpreterView", "getPanel"));
        }
    }

    private static class AddInterpreterAction
    extends DumbAwareAction {
        private final NodeJsInterpreter myInterpreter;
        private final Consumer<NodeJsInterpreter> myCallback;

        public AddInterpreterAction(@NotNull NodeJsInterpreter interpreter, @NotNull Consumer<NodeJsInterpreter> callback) {
            if (interpreter == null) {
                AddInterpreterAction.$$$reportNull$$$0(0);
            }
            if (callback == null) {
                AddInterpreterAction.$$$reportNull$$$0(1);
            }
            super(interpreter.getPresentableName());
            this.myInterpreter = interpreter;
            this.myCallback = callback;
        }

        public void actionPerformed(AnActionEvent e) {
            this.myCallback.consume((Object)this.myInterpreter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AddInterpreterTypeAction
    extends DumbAwareAction {
        private final Project myProject;
        private final NodeJsInterpreterType myType;
        private final Consumer<NodeJsInterpreter> myCallback;

        public AddInterpreterTypeAction(@NotNull Project project, @NotNull NodeJsInterpreterType type, @NotNull Consumer<NodeJsInterpreter> callback) {
            if (project == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(0);
            }
            if (type == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                AddInterpreterTypeAction.$$$reportNull$$$0(2);
            }
            super("Add " + StringUtil.capitalize((String)type.getName()) + "...");
            this.myProject = project;
            this.myType = type;
            this.myCallback = callback;
        }

        public void actionPerformed(AnActionEvent e) {
            Object addedInterpreter = this.myType.showAddDialog(this.myProject);
            if (addedInterpreter != null) {
                this.myCallback.consume(addedInterpreter);
            }
        }

        public void update(AnActionEvent e) {
            boolean available = this.myType.isAvailable();
            e.getPresentation().setEnabledAndVisible(available);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpretersDialog$AddInterpreterTypeAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

