/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExportDefaultReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public ES6ExportDefaultReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        PsiElement element;
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((element = queryParameters.getElementToSearch()) instanceof JSElement)) {
            return;
        }
        SearchScope scope = queryParameters.getEffectiveSearchScope();
        if (scope instanceof LocalSearchScope) {
            return;
        }
        PsiElement exportElement = ES6ExportDefaultReferenceSearcher.getExportDefaultElement(element);
        if (exportElement != null) {
            ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(exportElement, queryParameters, new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession()), consumer);
        } else {
            if (!(element instanceof JSPsiNamedElementBase)) {
                return;
            }
            DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
            if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
                return;
            }
            String name = ((JSPsiNamedElementBase)element).getName();
            if (name != null) {
                SearchRequestCollector collector = queryParameters.getOptimizer();
                collector.searchWord(name, scope, (short)1, true, element, (RequestResultProcessor)new MyProcessor(queryParameters));
            }
        }
    }

    @Nullable
    private static PsiElement getExportDefaultElement(PsiElement element) {
        PsiElement exportElement = null;
        if (element instanceof ES6ExportDefaultAssignment || ES6ExportDefaultReferenceSearcher.isDefaultExportThroughSpecifier(element)) {
            exportElement = element;
        } else {
            PsiElement parent = element.getContext();
            if (parent instanceof ES6ExportDefaultAssignment) {
                exportElement = parent;
            }
        }
        return exportElement;
    }

    private static boolean isDefaultExportThroughSpecifier(PsiElement element) {
        if (!(element instanceof ES6ExportSpecifier)) {
            return false;
        }
        ES6ExportSpecifierAlias alias = ((ES6ExportSpecifier)element).getAlias();
        return alias != null && "default".equals(alias.getName());
    }

    private static void searchExportDefaultUsages(@NotNull PsiElement exportElement, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull SearchRequestCollector newCollector, @NotNull Processor<PsiReference> consumer) {
        JSElement container;
        if (exportElement == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (newCollector == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(5);
        }
        if ((container = ES6PsiUtil.getExportScope(exportElement)) == null && (container = PsiTreeUtil.getContextOfType((PsiElement)exportElement, (Class[])new Class[]{XmlFile.class})) == null) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        queryParameters.getOptimizer().searchQuery(new QuerySearchRequest(ReferencesSearch.search((PsiElement)container), newCollector, false, (fileReference, _collector) -> {
            PsiElement fileReferenceElement;
            if (queryParameters == null) {
                ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(27);
            }
            if (consumer == null) {
                ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(28);
            }
            if (!((fileReferenceElement = fileReference.getElement()) instanceof ES6FromClause)) {
                return true;
            }
            PsiElement importOrExportDeclaration = fileReferenceElement.getParent();
            if (!ES6ExportDefaultReferenceSearcher.processImportDeclaration(_collector, queryParameters, consumer, scope, importOrExportDeclaration)) {
                return false;
            }
            return ES6ExportDefaultReferenceSearcher.processExportDeclaration(_collector, queryParameters, consumer, scope, importOrExportDeclaration);
        }));
    }

    private static boolean processImportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement importDeclarationCandidate) {
        ES6ImportedBinding[] importedBindings;
        if (collector == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(9);
        }
        if (!(importDeclarationCandidate instanceof ES6ImportDeclaration)) {
            return true;
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)importDeclarationCandidate;
        for (ES6ImportedBinding eS6ImportedBinding : importedBindings = importDeclaration.getImportedBindings()) {
            PsiElement nameIdentifier;
            if (eS6ImportedBinding.isNamespaceImport() || (nameIdentifier = eS6ImportedBinding.getNameIdentifier()) == null) continue;
            ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameIdentifier, (PsiElement)eS6ImportedBinding);
            if (ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)eS6ImportedBinding)) continue;
            return false;
        }
        for (ES6ImportedBinding eS6ImportedBinding : importDeclaration.getImportSpecifiers()) {
            if (ES6ExportDefaultReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, (ES6ImportExportSpecifier)eS6ImportedBinding)) continue;
            return false;
        }
        return true;
    }

    private static boolean processSpecifier(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @NotNull ES6ImportExportSpecifier specifier) {
        if (collector == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(10);
        }
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(11);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(12);
        }
        if (scope == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(13);
        }
        if (specifier == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(14);
        }
        if (!specifier.isDefault()) {
            return true;
        }
        ES6ImportExportSpecifierAlias alias = specifier.getAlias();
        if (alias == null) {
            return true;
        }
        PsiElement nameElement = specifier.getReferenceNameElement();
        if (nameElement == null) {
            return true;
        }
        ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameElement, (PsiElement)specifier);
        return ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)alias);
    }

    private static boolean processExportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement exportDeclarationCandidate) {
        PsiElement nameIdentifier;
        if (collector == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(15);
        }
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(16);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(18);
        }
        if (!(exportDeclarationCandidate instanceof ES6ExportDeclaration)) {
            return true;
        }
        ES6ExportDeclaration exportDeclaration = (ES6ExportDeclaration)exportDeclarationCandidate;
        ES6ExportedDefaultBinding exportBinding = exportDeclaration.getExportedDefaultBinding();
        PsiElement psiElement = nameIdentifier = exportBinding == null ? null : exportBinding.getNameIdentifier();
        if (nameIdentifier != null) {
            ES6ExportDefaultReferenceSearcher.addExplicitReference(queryParameters, consumer, nameIdentifier, (PsiElement)exportBinding);
            if (!ES6ExportDefaultReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, (PsiNamedElement)exportBinding)) {
                return false;
            }
        }
        for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
            if (ES6ExportDefaultReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, (ES6ImportExportSpecifier)specifier)) continue;
            return false;
        }
        return true;
    }

    private static boolean searchAdditionalReferences(@NotNull SearchRequestCollector collector, @NotNull Processor<PsiReference> consumer, @NotNull SearchScope scope, @NotNull PsiNamedElement elementToSearch) {
        String name;
        if (collector == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(19);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(20);
        }
        if (scope == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(21);
        }
        if (elementToSearch == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(22);
        }
        if ((name = elementToSearch.getName()) != null) {
            ReferencesSearch.searchOptimized((PsiElement)elementToSearch, (SearchScope)scope.intersectWith(elementToSearch.getUseScope()), (boolean)false, (SearchRequestCollector)collector, consumer);
        }
        return true;
    }

    private static void addExplicitReference(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer, @NotNull PsiElement nameIdentifier, @NotNull PsiElement parent) {
        if (queryParameters == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(23);
        }
        if (consumer == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(24);
        }
        if (nameIdentifier == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(25);
        }
        if (parent == null) {
            ES6ExportDefaultReferenceSearcher.$$$reportNull$$$0(26);
        }
        TextRange nameRange = ES6ExportDefaultReferenceSearcher.getRangeInParentElement(parent, nameIdentifier);
        PsiReferenceBase.Immediate ref = new PsiReferenceBase.Immediate(parent, nameRange, queryParameters.getElementToSearch());
        consumer.process((Object)ref);
    }

    private static TextRange getRangeInParentElement(PsiElement importedBinding, PsiElement nameIdentifier) {
        return nameIdentifier.getTextRange().shiftRight(-importedBinding.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 17: 
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCollector";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "searchExportDefaultUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processImportDeclaration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processSpecifier";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "processExportDeclaration";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "searchAdditionalReferences";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "addExplicitReference";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$searchExportDefaultUsages$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final ReferencesSearch.SearchParameters myQueryParameters;
        private final SearchRequestCollector myOwnCollector;

        MyProcessor(@NotNull ReferencesSearch.SearchParameters queryParameters) {
            if (queryParameters == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            super(new Object[0]);
            this.myQueryParameters = queryParameters;
            this.myOwnCollector = new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession());
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<PsiReference> consumer) {
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression reference = (JSReferenceExpression)element;
            if (!reference.isReferenceTo(this.myQueryParameters.getElementToSearch())) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof ES6ExportDefaultAssignment) {
                ES6ExportDefaultReferenceSearcher.searchExportDefaultUsages(parent, this.myQueryParameters, this.myOwnCollector, (Processor<PsiReference>)consumer);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/findUsages/ES6ExportDefaultReferenceSearcher$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

