/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportExportSpecifierBase;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ImportSpecifierStub;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSReferenceExpressionResolver;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportSpecifierImpl
extends ES6ImportExportSpecifierBase<ES6ImportSpecifierStub>
implements ES6ImportSpecifier,
BindablePsiReference,
HighlightSeverityHolder {
    public ES6ImportSpecifierImpl(ASTNode node) {
        super(node);
    }

    public ES6ImportSpecifierImpl(ES6ImportSpecifierStub stub) {
        super(stub, (IStubElementType)ES6ElementTypes.IMPORT_SPECIFIER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitImportSpecifier((ES6ImportSpecifier)this);
        } else {
            super.accept(visitor);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(3);
        }
        ES6ImportSpecifierAlias alias = this.getAlias();
        if (place == this) {
            return true;
        }
        return alias != null ? alias.processDeclarations(processor, state, lastParent, place) : processor.execute((PsiElement)this, state);
    }

    @Nullable
    public ES6ImportSpecifierAlias getAlias() {
        return (ES6ImportSpecifierAlias)this.getStubOrPsiChild((IStubElementType)ES6ElementTypes.IMPORT_SPECIFIER_ALIAS);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, (specifier, incompleteCode1) -> ES6ImportSpecifierImpl.resolveImportSpecifier(this), true, incompleteCode);
        if (resolveResultArray == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @NotNull
    private static ResolveResult[] resolveImportSpecifier(@NotNull ES6ImportSpecifier specifier) {
        if (specifier == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(5);
        }
        if (specifier.isDefault()) {
            ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveDefaultExport((ES6ImportExportSpecifierBase)specifier);
            if (resolveResultArray == null) {
                ES6ImportSpecifierImpl.$$$reportNull$$$0(6);
            }
            return resolveResultArray;
        }
        String name = specifier.getReferenceName();
        if (name == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ES6ImportSpecifierImpl.$$$reportNull$$$0(7);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResultSink sink = new ResolveResultSink((PsiElement)specifier, name, true);
        List<JSType> innerAliases = ES6PsiUtil.processSpecifier((ES6ImportExportSpecifier)specifier, sink);
        ResolveResult[] results = sink.getResultsAsResolveResults();
        if (Arrays.stream(results).noneMatch(ResolveResult::isValidResult) && !innerAliases.isEmpty()) {
            ResolveResult[] resolveResultArray = ES6ImportSpecifierImpl.resolveWithInnerAliases((ES6ImportExportSpecifier)specifier, innerAliases);
            if (resolveResultArray == null) {
                ES6ImportSpecifierImpl.$$$reportNull$$$0(8);
            }
            return resolveResultArray;
        }
        if (results == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(9);
        }
        return results;
    }

    public static ResolveResult[] resolveWithInnerAliases(@NotNull ES6ImportExportSpecifier specifier, @NotNull List<JSType> innerAliases) {
        if (specifier == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(10);
        }
        if (innerAliases == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(11);
        }
        if (DialectDetector.isTypeScript((PsiElement)specifier)) {
            return ResolveResult.EMPTY_ARRAY;
        }
        String name = specifier.getReferenceName();
        if (name == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        WalkUpResolveProcessor processor = new WalkUpResolveProcessor(name, specifier.getContainingFile(), (PsiElement)specifier);
        ES6PsiUtil.addInnerAliases(innerAliases, processor);
        processor.setAddOnlyCompleteMatches(true);
        JSReferenceExpressionResolver.processAllSymbols(processor);
        return processor.getResults();
    }

    @Nullable
    public ES6ImportDeclaration getDeclaration() {
        return (ES6ImportDeclaration)super.getDeclaration();
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(12);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void delete() throws IncorrectOperationException {
        ES6ImportDeclaration declaration = this.getDeclaration();
        if (declaration == null) {
            super.delete();
            return;
        }
        ES6ImportSpecifier[] specifiers = declaration.getImportSpecifiers();
        ES6ImportedBinding[] bindings = declaration.getImportedBindings();
        if (specifiers.length == 1) {
            if (bindings.length == 0) {
                declaration.delete();
            } else {
                boolean result = ES6ImportSpecifierImpl.deleteSpecifierAndKeepBinding((ES6ImportExportDeclaration)declaration);
                if (!result) {
                    super.delete();
                }
            }
        } else {
            assert (specifiers.length > 1);
            JSChangeUtil.removeRangeWithRemovalOfCommas(this.getNode(), declaration.getNode());
        }
    }

    public static boolean deleteSpecifierAndKeepBinding(@NotNull ES6ImportExportDeclaration declaration) {
        ASTNode startRange;
        if (declaration == null) {
            ES6ImportSpecifierImpl.$$$reportNull$$$0(13);
        }
        if ((startRange = declaration.getNode().findChildByType(JSTokenTypes.COMMA)) == null) {
            startRange = declaration.getNode().findChildByType(JSTokenTypes.LBRACE);
        }
        ASTNode endRange = declaration.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (startRange == null || endRange == null) {
            return false;
        }
        declaration.getNode().removeRange(startRange, endRange.getTreeNext());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerAliases";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/ES6ImportSpecifierImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveImportSpecifier";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveImportSpecifier";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveWithInnerAliases";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteSpecifierAndKeepBinding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

