/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceExpressionsInfo {
    public static final ES6ReferenceExpressionsInfo EMPTY = new ES6ReferenceExpressionsInfo(ContainerUtil.emptyList(), ContainerUtil.emptyList(), ContainerUtil.newHashMap());
    @NotNull
    private final Collection<PsiElement> myLocals;
    @NotNull
    private final Collection<PsiElement> myExportedLocals;
    @NotNull
    private final Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> myImports;

    @NotNull
    public static ES6ReferenceExpressionsInfo getInfo(final @NotNull JSPsiElementBase element) {
        PsiElement module;
        if (element == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(0);
        }
        if ((module = ES6PsiUtil.findExternalModule((PsiElement)element)) == null) {
            ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = EMPTY;
            if (eS6ReferenceExpressionsInfo == null) {
                ES6ReferenceExpressionsInfo.$$$reportNull$$$0(1);
            }
            return eS6ReferenceExpressionsInfo;
        }
        final ArrayList locals = ContainerUtil.newArrayList();
        final ArrayList exportedLocals = ContainerUtil.newArrayList();
        final LinkedHashMap imports = ContainerUtil.newLinkedHashMap();
        element.acceptChildren((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                ResolveResult[] results;
                super.visitJSReferenceExpression(node);
                if (node.getQualifier() != null) {
                    return;
                }
                String referenceName = node.getReferenceName();
                if (StringUtil.isEmpty((String)referenceName)) {
                    return;
                }
                for (ResolveResult result : results = node.multiResolve(false)) {
                    Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> info;
                    PsiElement resultElement = result.getElement();
                    if (!result.isValidResult() || resultElement == null) continue;
                    PsiElement resultModule = ES6PsiUtil.findExternalModule(resultElement);
                    if (module.isEquivalentTo(resultModule) && !(resultElement instanceof ES6ImportedBinding) && !(resultElement instanceof ES6ImportSpecifierAlias)) {
                        if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)resultElement, (boolean)false)) continue;
                        List toProcess = ES6ImportHandler.isExportedWithNameOrDefault(resultElement) ? exportedLocals : locals;
                        toProcess.add(resultElement);
                        continue;
                    }
                    if (!(result instanceof JSResolveResult) || (info = ES6ReferenceExpressionsInfo.getImportInfo(referenceName, (JSResolveResult)result, module)) == null) continue;
                    imports.put(info.second, info.first);
                }
            }
        });
        ES6ReferenceExpressionsInfo eS6ReferenceExpressionsInfo = new ES6ReferenceExpressionsInfo(locals, exportedLocals, imports);
        if (eS6ReferenceExpressionsInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(2);
        }
        return eS6ReferenceExpressionsInfo;
    }

    @Nullable
    public static Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> getImportInfo(@NotNull String referenceName, @NotNull JSResolveResult jsResolveResult, @Nullable PsiElement filterModule) {
        ES6ImportExportDeclaration es6Import;
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(3);
        }
        if (jsResolveResult == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(4);
        }
        PsiElement resultElement = jsResolveResult.getElement();
        if (!jsResolveResult.isValidResult() || resultElement == null) {
            return null;
        }
        ES6ImportExportDeclarationPart importPart = jsResolveResult.getES6Import();
        ES6ImportExportDeclaration eS6ImportExportDeclaration = es6Import = importPart == null ? null : importPart.getDeclaration();
        if (es6Import == null) {
            if (resultElement instanceof ES6ImportedBinding) {
                JSElement defaultElement;
                Collection elements = ((ES6ImportedBinding)resultElement).findReferencedElements();
                PsiElement item = (PsiElement)ContainerUtil.getFirstItem((Collection)elements);
                if (item instanceof ES6ExportDefaultAssignment && (defaultElement = ((ES6ExportDefaultAssignment)item).getStubSafeElement()) instanceof JSQualifiedNamedElement) {
                    item = defaultElement;
                }
                if (item != null) {
                    return ES6ReferenceExpressionsInfo.createForBinding(referenceName, item, (ES6ImportedBinding)resultElement);
                }
                return null;
            }
            if (resultElement instanceof ES6ImportSpecifierAlias) {
                ES6ImportSpecifierAlias alias = (ES6ImportSpecifierAlias)resultElement;
                PsiElement resolvedElement = alias.findAliasedElement();
                ES6ImportExportSpecifier specifierElement = alias.findSpecifierElement();
                if (resolvedElement != null && specifierElement != null) {
                    ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, (ES6ImportSpecifier)specifierElement, alias);
                    return Pair.create((Object)resolvedElement, (Object)info);
                }
                return null;
            }
        } else {
            if (!(es6Import instanceof ES6ImportDeclaration) || filterModule != null && !filterModule.isEquivalentTo(ES6PsiUtil.findExternalModule((PsiElement)es6Import))) {
                return null;
            }
            if (importPart instanceof ES6ImportSpecifier) {
                ES6ImportSpecifier specifier = (ES6ImportSpecifier)importPart;
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                ES6ImportPsiUtil.CreateImportExportInfo info = ES6ReferenceExpressionsInfo.createImportInfoForSpecifier(referenceName, specifier, alias);
                return Pair.create((Object)resultElement, (Object)info);
            }
            if (importPart instanceof ES6ImportedBinding) {
                return ES6ReferenceExpressionsInfo.createForBinding(referenceName, resultElement, (ES6ImportedBinding)importPart);
            }
        }
        return null;
    }

    @NotNull
    private static Pair<PsiElement, ES6ImportPsiUtil.CreateImportExportInfo> createForBinding(@NotNull String referenceName, @NotNull PsiElement resultElement, @NotNull ES6ImportedBinding binding) {
        if (referenceName == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(5);
        }
        if (resultElement == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(6);
        }
        if (binding == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(7);
        }
        Pair pair = Pair.create((Object)resultElement, (Object)ES6ReferenceExpressionsInfo.createImportInfoForBinding(referenceName, binding));
        if (pair == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(8);
        }
        return pair;
    }

    public ES6ReferenceExpressionsInfo(@NotNull Collection<PsiElement> locals, @NotNull Collection<PsiElement> exportedLocals, @NotNull Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> imports) {
        if (locals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(9);
        }
        if (exportedLocals == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(10);
        }
        if (imports == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(11);
        }
        this.myLocals = locals;
        this.myExportedLocals = exportedLocals;
        this.myImports = imports;
    }

    @NotNull
    public Collection<PsiElement> getLocalReferencedElements() {
        Collection<PsiElement> collection = this.myLocals;
        if (collection == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForBinding(String referenceName, ES6ImportedBinding binding) {
        ES6ImportPsiUtil.ImportExportType importType = binding.isNamespaceImport() ? ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL : ES6ImportPsiUtil.ImportExportType.DEFAULT;
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, importType);
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(13);
        }
        return createImportExportInfo;
    }

    @NotNull
    private static ES6ImportPsiUtil.CreateImportExportInfo createImportInfoForSpecifier(String referenceName, ES6ImportSpecifier specifier, ES6ImportSpecifierAlias alias) {
        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = alias == null ? new ES6ImportPsiUtil.CreateImportExportInfo(referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER) : new ES6ImportPsiUtil.CreateImportExportInfo(specifier.getCanonicalText(), referenceName, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
        if (createImportExportInfo == null) {
            ES6ReferenceExpressionsInfo.$$$reportNull$$$0(14);
        }
        return createImportExportInfo;
    }

    public Map<ES6ImportPsiUtil.CreateImportExportInfo, PsiElement> getReferencedImports() {
        return this.myImports;
    }

    public Collection<PsiElement> getExportedLocalReferencedElements() {
        return this.myExportedLocals;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsResolveResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedLocals";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6ReferenceExpressionsInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createForBinding";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferencedElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForBinding";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createImportInfoForSpecifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getImportInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createForBinding";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

