/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript._JavaScriptLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergeFunction;
import com.intellij.lexer.MergingLexerAdapterBase;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class JSFlexAdapter
extends MergingLexerAdapterBase {
    private static final int NESTED_BLOCKS_COUNT_SHIFT = 5;
    private static final int BASE_STATE_MASK = 31;
    public static final MyMergeFunction MERGE_FUNCTION = new MyMergeFunction();

    public JSFlexAdapter(@NotNull DialectOptionHolder optionHolder) {
        if (optionHolder == null) {
            JSFlexAdapter.$$$reportNull$$$0(0);
        }
        this(optionHolder, false);
    }

    public JSFlexAdapter(@NotNull DialectOptionHolder optionHolder, boolean highlightMode) {
        if (optionHolder == null) {
            JSFlexAdapter.$$$reportNull$$$0(1);
        }
        super((Lexer)new FlexAdapter((FlexLexer)new _JavaScriptLexer(null, highlightMode, optionHolder){

            @Override
            protected boolean doShouldLexTag() throws IOException {
                IElementType next = this.skipCommentsAndWhitespaces();
                if (next == JSTokenTypes.PLUS || next == JSTokenTypes.MINUS) {
                    return false;
                }
                if (!JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
                    return true;
                }
                next = this.skipCommentsAndWhitespaces();
                if (next == JSTokenTypes.EXTENDS_KEYWORD) {
                    next = this.skipCommentsAndWhitespaces();
                    return next == JSTokenTypes.EQ;
                }
                if (next == JSTokenTypes.COLON || next == JSTokenTypes.EQ || next == JSTokenTypes.COMMA) {
                    return false;
                }
                if (next == JSTokenTypes.GT) {
                    next = this.skipCommentsAndWhitespaces();
                    return next != JSTokenTypes.LPAR;
                }
                return true;
            }

            private IElementType skipCommentsAndWhitespaces() throws IOException {
                IElementType next = this.advance();
                while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
                    next = this.advance();
                }
                return next;
            }
        }));
    }

    private _JavaScriptLexer getFlex() {
        return (_JavaScriptLexer)((FlexAdapter)this.getOriginal()).getFlex();
    }

    public MergeFunction getMergeFunction() {
        return MERGE_FUNCTION;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            JSFlexAdapter.$$$reportNull$$$0(2);
        }
        super.start(buffer, startOffset, endOffset, initialState & 0x1F);
        this.getFlex().clearState(initialState >> 5);
    }

    public int getState() {
        return super.getState() + (this.getFlex().getNestedBlocksCount() << 5);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/JSFlexAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyMergeFunction
    implements MergeFunction {
        private MyMergeFunction() {
        }

        public IElementType merge(IElementType type, Lexer originalLexer) {
            if (type != JSTokenTypes.XML_JS_SCRIPT) {
                if (type == JSTokenTypes.STRING_LITERAL_PART) {
                    if (originalLexer.getTokenType() == type) {
                        originalLexer.advance();
                    }
                    return JSTokenTypes.STRING_LITERAL;
                }
                if (type == JSTokenTypes.HEREDOC_BODY || type == JSTokenTypes.XML_TAG_CONTENT || type == JSTokenTypes.STRING_TEMPLATE_PART) {
                    while (originalLexer.getTokenType() == type) {
                        originalLexer.advance();
                    }
                }
                return type;
            }
            int braceBalance = 1;
            do {
                IElementType tokenType = originalLexer.getTokenType();
                String text = originalLexer.getTokenText();
                if (tokenType != JSTokenTypes.XML_JS_SCRIPT) break;
                originalLexer.advance();
                if ("{".equals(text)) {
                    ++braceBalance;
                }
                if (!"}".equals(text)) continue;
                --braceBalance;
            } while (braceBalance != 0);
            return type;
        }
    }
}

