/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileFromImportsHelper
extends FileReferenceHelper {
    private static final Iterable<String> acceptedExtensions = ContainerUtil.map((Collection)ContainerUtil.newArrayList((Object[])new String[]{"ts", "tsx", "jsx", "js.flow", "js"}), s -> "." + s);

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(0);
        }
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(1);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        String fileNameToCreate = reference.getFileNameToCreate();
        if (!ContainerUtil.or(acceptedExtensions, extension -> fileNameToCreate.endsWith((String)extension))) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiDirectory parentDirectory = JSFileFromImportsHelper.getParentDirectoryOrNull(reference);
        if (!PathUtil.isValidFileName((String)fileNameToCreate, (boolean)true) || JSFileFromImportsHelper.isDirectoryReference(reference) || parentDirectory == null || !JSFileFromImportsHelper.canCreateFile(parentDirectory, fileNameToCreate)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<Symbol> symbols = JSFileFromImportsHelper.getSymbolsToGenerate(reference);
        if (symbols.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<MyQuickFix> list = Collections.singletonList(new MyQuickFix(fileNameToCreate, parentDirectory, symbols));
        if (list == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Nullable
    private static PsiDirectory getParentDirectoryOrNull(FileReference fileReference) {
        int index = fileReference.getIndex();
        FileReferenceSet fileReferenceSet = fileReference.getFileReferenceSet();
        if (index <= 0) {
            return fileReference.getElement().getContainingFile().getContainingDirectory();
        }
        FileReference directoryReference = fileReferenceSet.getReference(index - 1);
        PsiFileSystemItem resolved = directoryReference.resolve();
        if (resolved == null || !resolved.isDirectory()) {
            return null;
        }
        return resolved.getManager().findDirectory(resolved.getVirtualFile());
    }

    private static boolean canCreateFile(PsiDirectory psiDirectory, String fileName) {
        try {
            psiDirectory.checkCreateFile(fileName);
            return true;
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
    }

    private static boolean isDirectoryReference(FileReference reference) {
        return !reference.isLast();
    }

    private static List<Symbol> getSymbolsToGenerate(FileReference reference) {
        ES6ImportDeclaration es6ImportDeclaration;
        JSElement referenceParent = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)reference.getElement(), (Class[])new Class[]{ES6ImportDeclaration.class, TypeScriptExternalModuleReference.class});
        if (referenceParent == null) {
            return ContainerUtil.emptyList();
        }
        ES6ImportDeclaration eS6ImportDeclaration = es6ImportDeclaration = referenceParent instanceof ES6ImportDeclaration ? (ES6ImportDeclaration)referenceParent : null;
        if (es6ImportDeclaration != null) {
            Stream<Symbol> defaultImport = JSFileFromImportsHelper.getIdentifierChildrenOfType(es6ImportDeclaration, ES6ImportedBinding.class).map(NavigationItem::getName).filter(i -> i != null).map(name -> new Symbol((String)name, ExportedSymbolType.Default));
            Stream<Symbol> namedImports = JSFileFromImportsHelper.getIdentifierChildrenOfType(es6ImportDeclaration, ES6ImportExportSpecifier.class).map(JSPsiReferenceElement::getReferenceName).filter(i -> i != null).map(name -> new Symbol((String)name, ExportedSymbolType.Standard));
            return Stream.concat(defaultImport, namedImports).collect(Collectors.toList());
        }
        TypeScriptImportStatement importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceParent, TypeScriptImportStatement.class);
        if (importStatement != null) {
            return ContainerUtil.list((Object[])new Symbol[]{new Symbol(importStatement.getName(), ExportedSymbolType.TypescriptLegacy)});
        }
        return ContainerUtil.emptyList();
    }

    private static <T extends PsiElement> Stream<T> getIdentifierChildrenOfType(ES6ImportDeclaration importDeclaration, Class<T> clazz) {
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)importDeclaration, clazz).stream().filter(specifier -> JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(specifier.getFirstChild().getNode().getElementType()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Symbol {
        public String name;
        public boolean isFunction;
        public ExportedSymbolType type;

        public Symbol(String name, ExportedSymbolType type) {
            this.name = name;
            this.isFunction = Symbol.isFunctionName(name);
            this.type = type;
        }

        private static boolean isFunctionName(String name) {
            return name != null && name.length() > 0 && Character.isLowerCase(name.charAt(0));
        }
    }

    private static enum ExportedSymbolType {
        Standard,
        Default,
        TypescriptLegacy;

    }

    private static class MyQuickFix
    extends CreateFileFix {
        private List<Symbol> symbols;
        private String myNewFileName;

        public MyQuickFix(@NotNull String newFileName, @NotNull PsiDirectory directory, List<Symbol> classNames) {
            if (newFileName == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            if (directory == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            super(false, newFileName, directory);
            this.myNewFileName = newFileName;
            this.symbols = classNames;
        }

        @NotNull
        public String getText() {
            StringBuilder result = new StringBuilder(String.format("Create file '%s' with ", this.myNewFileName));
            List functions = ContainerUtil.filter(this.symbols, t -> t.isFunction);
            List classes = ContainerUtil.filter(this.symbols, t -> !t.isFunction);
            if (classes.size() > 0) {
                result.append(classes.size() == 1 ? "class " : "classes ");
                result.append(MyQuickFix.getCommaSeparatedNames(classes));
                if (functions.size() > 0) {
                    result.append(" and ");
                }
            }
            if (functions.size() > 0) {
                result.append(functions.size() == 1 ? "function " : "functions ");
                result.append(MyQuickFix.getCommaSeparatedNames(functions));
            }
            String string = result.toString();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        protected String getFileText() {
            String symbolsText = StringUtil.join((Collection)ContainerUtil.map(this.symbols, MyQuickFix::getSymbolText), (String)"\n\n");
            if (this.symbols.size() == 1 && this.symbols.get((int)0).type == ExportedSymbolType.TypescriptLegacy) {
                return String.format("%s\n\nexport = %s", symbolsText, this.symbols.get((int)0).name);
            }
            return symbolsText;
        }

        private static String getSymbolText(Symbol symbol) {
            String classTemplate = "%s class %s\n{\n\n}";
            String functionTemplate = "%s function %s() {\n  \n}";
            String template = symbol.isFunction ? functionTemplate : classTemplate;
            String modifier = "";
            switch (symbol.type) {
                case Default: {
                    modifier = "export default";
                    break;
                }
                case Standard: {
                    modifier = "export";
                    break;
                }
                case TypescriptLegacy: {
                    modifier = "";
                }
            }
            return String.format(template, modifier, symbol.name);
        }

        @NotNull
        private static String getCommaSeparatedNames(List<Symbol> symbols) {
            String string = StringUtil.join((Collection)ContainerUtil.map(symbols, t -> "'" + t.name + "'"), (String)", ");
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommaSeparatedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

