/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.arrangement;

import com.intellij.lang.javascript.arrangement.JSArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSElementArrangementEntry;
import com.intellij.lang.javascript.arrangement.JSSectionArrangementEntry;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.group.ArrangementGroupingRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSectionRuleAwareSettings;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsAware;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSRearrangerBase
implements Rearranger<JSArrangementEntry>,
ArrangementStandardSettingsAware,
ArrangementSectionRuleAwareSettings {
    private static final Logger LOG = Logger.getInstance((String)JSRearrangerBase.class.getName());
    public static boolean dumpArrangementEntries = false;

    @Nullable
    public Pair<JSArrangementEntry, List<JSArrangementEntry>> parseWithNew(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull PsiElement element, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(1);
        }
        if (element == null) {
            JSRearrangerBase.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(root instanceof JSClass, (Object)String.format("Expected instance of JSClass but was %s", root.getClass().getName()));
        List<JSArrangementEntry> newEntries = this.processPsiElement(element, document, ContainerUtil.list((Object[])new TextRange[]{element.getTextRange()}), settings);
        JSArrangementEntry newEntry = (JSArrangementEntry)ContainerUtil.getFirstItem(newEntries);
        if (newEntry == null) {
            return null;
        }
        return Pair.create((Object)newEntry, this.processPsiElement(root, document, ranges, settings));
    }

    @NotNull
    public List<JSArrangementEntry> parse(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(4);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(5);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(6);
        }
        if (!(root instanceof JSFile)) {
            List<JSArrangementEntry> list = Collections.emptyList();
            if (list == null) {
                JSRearrangerBase.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<JSArrangementEntry> list = this.processPsiElement(root, document, ranges, settings);
        if (list == null) {
            JSRearrangerBase.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private List<JSArrangementEntry> processPsiElement(@NotNull PsiElement root, @Nullable Document document, @NotNull Collection<TextRange> ranges, @NotNull ArrangementSettings settings) {
        if (root == null) {
            JSRearrangerBase.$$$reportNull$$$0(9);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(11);
        }
        ArrangementInfo arrangementInfo = new ArrangementInfo(ranges, document, settings);
        root.accept((PsiElementVisitor)this.createVisitor(arrangementInfo));
        if (ApplicationManager.getApplication().isUnitTestMode() && dumpArrangementEntries) {
            JSRearrangerBase.dumpArrangementEntries(document, arrangementInfo.getTopLevelEntries());
        }
        List<JSArrangementEntry> list = arrangementInfo.getTopLevelEntries();
        if (list == null) {
            JSRearrangerBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedGroupingTokens() {
        return Collections.singletonList(new CompositeArrangementSettingsToken(StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER));
    }

    public boolean isEnabled(@NotNull ArrangementSettingsToken token, @Nullable ArrangementMatchCondition current) {
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(13);
        }
        if (current == null) {
            return true;
        }
        ArrangementSettingsToken type = ArrangementUtil.parseType((ArrangementMatchCondition)current);
        Map currentTokens = ArrangementUtil.extractTokens((ArrangementMatchCondition)current);
        if (StdArrangementTokens.Regexp.NAME.equals((Object)token) || StdArrangementTokens.Order.KEEP.equals((Object)token) || StdArrangementTokens.Order.BY_NAME.equals((Object)token)) {
            return type != StdArrangementTokens.EntryType.CONSTRUCTOR && type != StdArrangementTokens.EntryType.STATIC_INIT;
        }
        if (type == null) {
            return true;
        }
        if (currentTokens.containsKey(StdArrangementTokens.Modifier.OVERRIDDEN)) {
            return token == StdArrangementTokens.EntryType.FIELD || token == StdArrangementTokens.EntryType.METHOD || token == StdArrangementTokens.EntryType.PROPERTY || token == StdArrangementTokens.Modifier.OVERRIDDEN;
        }
        if (ContainerUtil.or(currentTokens.keySet(), currentToken -> this.getVisibilityModifiers().contains(currentToken)) && token == StdArrangementTokens.Modifier.OVERRIDDEN) {
            return false;
        }
        if (this.getSupportedTypes().contains(token)) {
            return true;
        }
        return this.isModifierEnabled(token, type, currentTokens.keySet());
    }

    @NotNull
    public Collection<Set<ArrangementSettingsToken>> getMutexes() {
        ArrayList result = ContainerUtil.newArrayList();
        result.add(this.getSupportedTypes());
        LinkedHashSet exclusiveModifiers = ContainerUtil.newLinkedHashSet(this.getVisibilityModifiers());
        exclusiveModifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
        result.add(exclusiveModifiers);
        ArrayList arrayList = result;
        if (arrayList == null) {
            JSRearrangerBase.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Nullable
    public List<CompositeArrangementSettingsToken> getSupportedMatchingTokens() {
        return ContainerUtil.newArrayList((Object[])new CompositeArrangementSettingsToken[]{new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, this.getSupportedTypes()), new CompositeArrangementSettingsToken(StdArrangementTokens.General.MODIFIER, this.getSupportedModifiers()), new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME), new CompositeArrangementSettingsToken(StdArrangementTokens.General.ORDER, new ArrangementSettingsToken[]{StdArrangementTokens.Order.KEEP, StdArrangementTokens.Order.BY_NAME})});
    }

    @NotNull
    protected Visitor createVisitor(@NotNull ArrangementInfo arrangementInfo) {
        if (arrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(15);
        }
        Visitor visitor = new Visitor(arrangementInfo);
        if (visitor == null) {
            JSRearrangerBase.$$$reportNull$$$0(16);
        }
        return visitor;
    }

    protected void postprocessClassMembers(@NotNull JSClass jsClass, @NotNull ClassArrangementInfo classArrangementInfo, @NotNull ArrangementInfo arrangementInfo) {
        if (jsClass == null) {
            JSRearrangerBase.$$$reportNull$$$0(17);
        }
        if (classArrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(18);
        }
        if (arrangementInfo == null) {
            JSRearrangerBase.$$$reportNull$$$0(19);
        }
        for (Map.Entry<JSFunction, JSElementArrangementEntry> mapEntry : classArrangementInfo.methodToEntry.entrySet()) {
            JSFunction function = mapEntry.getKey();
            String name = function.getName();
            if (!function.isSetProperty() || name == null) continue;
            JSElementArrangementEntry setterEntry = mapEntry.getValue();
            JSFunction getter = jsClass.findFunctionByNameAndKind(name, JSFunction.FunctionKind.GETTER);
            JSElementArrangementEntry getterEntry = classArrangementInfo.methodToEntry.get(getter);
            if (getterEntry == null) continue;
            setterEntry.addDependency(getterEntry);
        }
        if (JSRearrangerBase.hasGroupingRule(arrangementInfo.getSettings(), StdArrangementTokens.Grouping.GROUP_PROPERTY_FIELD_WITH_GETTER_SETTER)) {
            JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)jsClass);
            for (Map.Entry<JSVariable, JSElementArrangementEntry> mapEntry : classArrangementInfo.fieldToEntry.entrySet()) {
                JSElementArrangementEntry propertyEntry;
                JSVariable jsVar = mapEntry.getKey();
                JSElementArrangementEntry varEntry = mapEntry.getValue();
                if (!StringUtil.startsWith((CharSequence)StringUtil.notNullize((String)jsVar.getName()), (CharSequence)codeStyleSettings.FIELD_PREFIX)) continue;
                String propertyName = JSRefactoringUtil.transformVarNameToAccessorName(jsVar.getName(), jsClass.getProject());
                JSFunction getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.GETTER);
                if (getterOrSetter == null) {
                    getterOrSetter = jsClass.findFunctionByNameAndKind(propertyName, JSFunction.FunctionKind.SETTER);
                }
                if ((propertyEntry = getterOrSetter == null ? null : classArrangementInfo.methodToEntry.get(getterOrSetter)) == null || propertyEntry.getType() == null) continue;
                varEntry.setType(propertyEntry.getType());
                varEntry.setModifiers(propertyEntry.getModifiers());
                propertyEntry.addDependency(varEntry);
            }
        }
    }

    @NotNull
    protected ArrangementSettingsToken detectFieldType(JSVariable variable) {
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.FIELD;
        if (arrangementSettingsToken == null) {
            JSRearrangerBase.$$$reportNull$$$0(20);
        }
        return arrangementSettingsToken;
    }

    protected abstract boolean isModifierEnabled(@NotNull ArrangementSettingsToken var1, @NotNull ArrangementSettingsToken var2, @NotNull Set<ArrangementSettingsToken> var3);

    @NotNull
    protected ArrangementSettingsToken detectFunctionType(@NotNull JSFunction function) {
        if (function == null) {
            JSRearrangerBase.$$$reportNull$$$0(21);
        }
        if (function.isConstructor()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.CONSTRUCTOR;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(22);
            }
            return arrangementSettingsToken;
        }
        if (function.isGetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(23);
            }
            return arrangementSettingsToken;
        }
        if (function.isSetProperty()) {
            ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.PROPERTY;
            if (arrangementSettingsToken == null) {
                JSRearrangerBase.$$$reportNull$$$0(24);
            }
            return arrangementSettingsToken;
        }
        ArrangementSettingsToken arrangementSettingsToken = StdArrangementTokens.EntryType.METHOD;
        if (arrangementSettingsToken == null) {
            JSRearrangerBase.$$$reportNull$$$0(25);
        }
        return arrangementSettingsToken;
    }

    @NotNull
    protected abstract Set<ArrangementSettingsToken> detectModifiers(@NotNull JSAttributeListOwner var1);

    protected List<OverrideInfo> detectOverrides(@NotNull JSQualifiedNamedElement member) {
        if (member == null) {
            JSRearrangerBase.$$$reportNull$$$0(26);
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedTypes();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getVisibilityModifiers();

    @NotNull
    protected abstract Set<ArrangementSettingsToken> getSupportedModifiers();

    @NotNull
    public ArrangementEntryMatcher buildMatcher(@NotNull ArrangementMatchCondition condition) throws IllegalArgumentException {
        if (condition == null) {
            JSRearrangerBase.$$$reportNull$$$0(27);
        }
        throw new IllegalArgumentException("Can't build a matcher for condition " + condition);
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document, List<T> entries) {
        StringBuilder builder = new StringBuilder();
        JSRearrangerBase.dumpArrangementEntries(document, entries, 0, builder);
        LOG.debug(builder.toString());
    }

    private static <T extends ArrangementEntry> void dumpArrangementEntries(@Nullable Document document, List<T> entries, int level, StringBuilder stringBuilder) {
        for (ArrangementEntry entry : entries) {
            stringBuilder.append(StringUtil.repeat((String)"\t", (int)level)).append(entry.toString()).append("\n").append(document != null ? document.getText(TextRange.create((int)entry.getStartOffset(), (int)entry.getEndOffset())) + "\n" : "");
            JSRearrangerBase.dumpArrangementEntries(document, entry.getChildren(), level + 1, stringBuilder);
        }
    }

    protected static boolean hasGroupingRule(@NotNull ArrangementSettings settings, @NotNull ArrangementSettingsToken token) {
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(28);
        }
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(29);
        }
        return JSRearrangerBase.findGroupingRule(settings, token) != null;
    }

    @Nullable
    protected static ArrangementGroupingRule findGroupingRule(@NotNull ArrangementSettings settings, @NotNull ArrangementSettingsToken token) {
        if (settings == null) {
            JSRearrangerBase.$$$reportNull$$$0(30);
        }
        if (token == null) {
            JSRearrangerBase.$$$reportNull$$$0(31);
        }
        return (ArrangementGroupingRule)ContainerUtil.find((Iterable)settings.getGroupings(), rule -> {
            if (token == null) {
                JSRearrangerBase.$$$reportNull$$$0(36);
            }
            return rule.getGroupingType() == token;
        });
    }

    protected static void addRule(List<StdArrangementMatchRule> rules, ArrangementSettingsToken ... conditions) {
        if (conditions == null) {
            JSRearrangerBase.$$$reportNull$$$0(32);
        }
        if (conditions.length == 1) {
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition(conditions[0]))));
            return;
        }
        ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
        for (ArrangementSettingsToken condition : conditions) {
            composite.addOperand((ArrangementMatchCondition)new ArrangementAtomMatchCondition(condition));
        }
        rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)composite)));
    }

    private static boolean isWithinBounds(@NotNull TextRange range, @NotNull Collection<TextRange> ranges) {
        if (range == null) {
            JSRearrangerBase.$$$reportNull$$$0(33);
        }
        if (ranges == null) {
            JSRearrangerBase.$$$reportNull$$$0(34);
        }
        return ContainerUtil.or(ranges, range1 -> {
            if (range == null) {
                JSRearrangerBase.$$$reportNull$$$0(35);
            }
            return range1.intersects(range);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase";
                break;
            }
            case 13: 
            case 29: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrangementInfo";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classArrangementInfo";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processPsiElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutexes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFieldType";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFunctionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseWithNew";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processPsiElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "postprocessClassMembers";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "detectFunctionType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "detectOverrides";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildMatcher";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasGroupingRule";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findGroupingRule";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addRule";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isWithinBounds";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isWithinBounds$2";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findGroupingRule$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class OverrideInfo {
        public final JSPsiElementBase superMember;
        public final JSQualifiedNamedElement member;

        public OverrideInfo(JSQualifiedNamedElement member, JSPsiElementBase superMember) {
            this.superMember = superMember;
            this.member = member;
        }
    }

    protected static class ArrangementInfo {
        private final Collection<TextRange> allowedRanges;
        private final Document document;
        private final ArrangementSettings mySettings;
        private final Stack<JSElementArrangementEntry> stack;
        private final Set<PsiComment> mySectionComments;
        private final List<JSArrangementEntry> topLevelEntries;
        private final ArrangementSectionDetector mySectionDetector;

        public ArrangementInfo(@NotNull Collection<TextRange> allowedRanges, @Nullable Document document, @NotNull ArrangementSettings settings) {
            if (allowedRanges == null) {
                ArrangementInfo.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                ArrangementInfo.$$$reportNull$$$0(1);
            }
            this.mySectionComments = ContainerUtil.newHashSet();
            this.topLevelEntries = ContainerUtil.newArrayList();
            this.allowedRanges = allowedRanges;
            this.document = document;
            this.mySettings = settings;
            this.stack = new Stack();
            this.mySectionDetector = new ArrangementSectionDetector(this.document, this.mySettings, data -> {
                JSElementArrangementEntry parent = this.getCurrentEntry();
                this.addEntry(parent, new JSSectionArrangementEntry(parent, data.getTextRange(), data.getToken(), data.getText()));
            });
        }

        public <T extends JSElement> void processWithCurrentEntry(@NotNull JSElementArrangementEntry entry, @NotNull T element, @NotNull Consumer<T> consumer) {
            if (entry == null) {
                ArrangementInfo.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(3);
            }
            if (consumer == null) {
                ArrangementInfo.$$$reportNull$$$0(4);
            }
            this.stack.push(entry);
            consumer.consume(element);
            this.stack.pop();
        }

        @NotNull
        public List<JSArrangementEntry> getTopLevelEntries() {
            List<JSArrangementEntry> list = this.topLevelEntries;
            if (list == null) {
                ArrangementInfo.$$$reportNull$$$0(5);
            }
            return list;
        }

        @NotNull
        public ArrangementSettings getSettings() {
            ArrangementSettings arrangementSettings = this.mySettings;
            if (arrangementSettings == null) {
                ArrangementInfo.$$$reportNull$$$0(6);
            }
            return arrangementSettings;
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromPsi(@NotNull JSElement element, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(7);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(8);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(9);
            }
            return this.addEntryFromRange((PsiElement)element, (PsiElement)element, type, modifiers, name);
        }

        @Nullable
        public JSElementArrangementEntry addContainerEntry(@NotNull PsiElement element, @NotNull ArrangementSettingsToken type) {
            if (element == null) {
                ArrangementInfo.$$$reportNull$$$0(10);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(11);
            }
            return this.addEntryFromRange(element, element, ContainerUtil.set((Object[])new ArrangementSettingsToken[]{type}), Collections.emptySet(), null);
        }

        @Nullable
        public JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull ArrangementSettingsToken type, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (startElement == null) {
                ArrangementInfo.$$$reportNull$$$0(12);
            }
            if (endElement == null) {
                ArrangementInfo.$$$reportNull$$$0(13);
            }
            if (type == null) {
                ArrangementInfo.$$$reportNull$$$0(14);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(15);
            }
            return this.addEntryFromRange(startElement, endElement, ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{type}), modifiers, name);
        }

        @Nullable
        private JSElementArrangementEntry addEntryFromRange(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull Set<ArrangementSettingsToken> types, @NotNull Set<ArrangementSettingsToken> modifiers, @Nullable String name) {
            if (startElement == null) {
                ArrangementInfo.$$$reportNull$$$0(16);
            }
            if (endElement == null) {
                ArrangementInfo.$$$reportNull$$$0(17);
            }
            if (types == null) {
                ArrangementInfo.$$$reportNull$$$0(18);
            }
            if (modifiers == null) {
                ArrangementInfo.$$$reportNull$$$0(19);
            }
            PsiComment leadingComment = this.processSectionComment(JSPsiImplUtils.findLeadingComment(startElement));
            PsiComment trailingComment = this.processSectionComment(JSPsiImplUtils.findTrailingEndOfLineComment(endElement));
            TextRange textRange = new TextRange(leadingComment != null ? leadingComment.getTextRange().getStartOffset() : startElement.getTextRange().getStartOffset(), trailingComment != null ? trailingComment.getTextRange().getEndOffset() : endElement.getTextRange().getEndOffset());
            TextRange range = this.document == null ? textRange : ArrangementUtil.expandToLineIfPossible((TextRange)textRange, (Document)this.document);
            JSElementArrangementEntry parent = this.getCurrentEntry();
            return this.addEntry(parent, new JSElementArrangementEntry(parent, name, types, modifiers, range));
        }

        @Nullable
        public PsiComment processSectionComment(@Nullable PsiComment comment) {
            if (comment == null || this.mySectionComments.contains(comment)) {
                return null;
            }
            if (this.mySectionDetector.processComment(comment)) {
                this.mySectionComments.add(comment);
                return null;
            }
            return comment;
        }

        @Nullable
        public <T extends JSArrangementEntry> T addEntry(@Nullable JSElementArrangementEntry parent, @NotNull T entry) {
            if (entry == null) {
                ArrangementInfo.$$$reportNull$$$0(20);
            }
            if (!JSRearrangerBase.isWithinBounds(new TextRange(entry.getStartOffset(), entry.getEndOffset()), this.allowedRanges)) {
                return null;
            }
            if (parent != null) {
                parent.addChild(entry);
            } else {
                this.topLevelEntries.add(entry);
            }
            return entry;
        }

        @Nullable
        private JSElementArrangementEntry getCurrentEntry() {
            return this.stack.isEmpty() ? null : this.stack.peek();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allowedRanges";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 20: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: 
                case 7: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo";
                    break;
                }
                case 8: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 9: 
                case 15: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiers";
                    break;
                }
                case 12: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 13: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ArrangementInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTopLevelEntries";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processWithCurrentEntry";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntryFromPsi";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addContainerEntry";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntryFromRange";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "addEntry";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class ClassArrangementInfo {
        public final Map<JSVariable, JSElementArrangementEntry> fieldToEntry = new THashMap();
        public final Map<JSFunction, JSElementArrangementEntry> methodToEntry = new THashMap();
        public final MultiMap<JSClass, OverrideInfo> overrides = new MultiMap();

        protected ClassArrangementInfo() {
        }

        public void registerOverridden(@NotNull List<OverrideInfo> overrideInfos) {
            if (overrideInfos == null) {
                ClassArrangementInfo.$$$reportNull$$$0(0);
            }
            for (OverrideInfo info : overrideInfos) {
                this.overrides.putValue((Object)JSUtils.getMemberContainingClass((PsiElement)info.superMember), (Object)info);
            }
        }

        @NotNull
        public Map<JSQualifiedNamedElement, JSElementArrangementEntry> getEntries() {
            Map map = ContainerUtil.union(this.fieldToEntry, this.methodToEntry);
            if (map == null) {
                ClassArrangementInfo.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "overrideInfos";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ClassArrangementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$ClassArrangementInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEntries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "registerOverridden";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class Visitor
    extends JSRecursiveElementVisitor {
        protected ArrangementInfo myArrangementInfo;
        private ClassArrangementInfo myClassArrangementInfo;

        public Visitor(ArrangementInfo arrangementInfo) {
            this.myArrangementInfo = arrangementInfo;
        }

        public void visitJSClass(JSClass jsClass) {
            JSElementArrangementEntry classEntry = this.myArrangementInfo.addContainerEntry((PsiElement)jsClass, StdArrangementTokens.EntryType.CLASS);
            if (classEntry == null) {
                return;
            }
            ClassArrangementInfo previousClassInfo = this.myClassArrangementInfo;
            this.myClassArrangementInfo = new ClassArrangementInfo();
            this.visitWithCurrentEntry((JSElement)jsClass, classEntry);
            JSRearrangerBase.this.postprocessClassMembers(jsClass, this.myClassArrangementInfo, this.myArrangementInfo);
            this.myClassArrangementInfo = previousClassInfo;
        }

        public void visitJSVarStatement(JSVarStatement varStatement) {
            JSElementArrangementEntry entry;
            if (!this.isClassMember((JSElement)varStatement)) {
                super.visitJSVarStatement(varStatement);
                return;
            }
            JSVariable variable = (JSVariable)ArrayUtil.getFirstElement((Object[])varStatement.getVariables());
            if (variable == null) {
                return;
            }
            ArrangementSettingsToken type = JSRearrangerBase.this.detectFieldType(variable);
            Set<ArrangementSettingsToken> modifiers = JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)variable);
            List<OverrideInfo> overrides = JSRearrangerBase.this.detectOverrides((JSQualifiedNamedElement)variable);
            if (!overrides.isEmpty()) {
                modifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
                this.myClassArrangementInfo.registerOverridden(overrides);
            }
            if ((entry = this.myArrangementInfo.addEntryFromPsi((JSElement)varStatement, type, modifiers, variable.getName())) != null) {
                this.visitWithCurrentEntry((JSElement)varStatement, entry);
                JSVariable[] variables = varStatement.getVariables();
                if (variables.length == 1 && !variables[0].isConst() && this.myClassArrangementInfo != null) {
                    this.myClassArrangementInfo.fieldToEntry.put(variables[0], entry);
                }
            }
        }

        public void visitJSFunctionDeclaration(JSFunction function) {
            JSElementArrangementEntry entry;
            if (!this.isClassMember((JSElement)function)) {
                super.visitJSFunctionDeclaration(function);
                return;
            }
            List<OverrideInfo> overrides = JSRearrangerBase.this.detectOverrides((JSQualifiedNamedElement)function);
            Set<ArrangementSettingsToken> modifiers = JSRearrangerBase.this.detectModifiers((JSAttributeListOwner)function);
            if (!overrides.isEmpty()) {
                modifiers.add(StdArrangementTokens.Modifier.OVERRIDDEN);
                this.myClassArrangementInfo.registerOverridden(overrides);
            }
            if ((entry = this.myArrangementInfo.addEntryFromPsi((JSElement)function, JSRearrangerBase.this.detectFunctionType(function), modifiers, function.getName())) != null && this.myClassArrangementInfo != null) {
                this.myClassArrangementInfo.methodToEntry.put(function, entry);
                this.visitWithCurrentEntry((JSElement)function, entry);
            }
        }

        public void visitJSBlock(JSBlockStatement initializer) {
            if (!this.isClassMember((JSElement)initializer)) {
                super.visitJSBlock(initializer);
                return;
            }
            JSElementArrangementEntry entry = this.myArrangementInfo.addEntryFromPsi((JSElement)initializer, StdArrangementTokens.EntryType.STATIC_INIT, Collections.emptySet(), null);
            if (entry != null) {
                this.visitWithCurrentEntry((JSElement)initializer, entry);
            }
        }

        public void visitComment(PsiComment comment) {
            this.myArrangementInfo.processSectionComment(comment);
        }

        private boolean isClassMember(@NotNull JSElement element) {
            if (element == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            return element.getParent() instanceof JSClass;
        }

        protected void visitWithCurrentEntry(@NotNull JSElement varStatement, @NotNull JSElementArrangementEntry entry) {
            if (varStatement == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (entry == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.myArrangementInfo.processWithCurrentEntry(entry, varStatement, theEntry -> theEntry.acceptChildren((PsiElementVisitor)this));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varStatement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/arrangement/JSRearrangerBase$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isClassMember";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitWithCurrentEntry";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

