/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.bower;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.bower.BowerCommandLineUtil;
import com.intellij.lang.javascript.bower.BowerPackagesView;
import com.intellij.lang.javascript.bower.BowerSettings;
import com.intellij.lang.javascript.bower.BowerValidationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BowerView {
    private final Project myProject;
    private final JPanel myComponent;
    private final NodeJsInterpreterField myNodeInterpreterField;
    private final TextFieldWithHistoryWithBrowseButton myBowerExecutableCombobox;
    private final TextFieldWithBrowseButton myBowerJsonField;
    private final BowerPackagesView myPackagesView;
    private final List<Pair<JTextField, String>> myValidationList;
    private final Color myNormalForeground;
    private volatile boolean myTrackChanges;

    public BowerView(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(0);
        }
        this.myTrackChanges = true;
        this.myProject = project;
        this.myBowerExecutableCombobox = BowerView.createBowerExecutable(project);
        this.myNodeInterpreterField = new NodeJsInterpreterField(project, false);
        this.myBowerJsonField = BowerView.createBowerJsonField(project);
        this.myPackagesView = new BowerPackagesView(project);
        this.myValidationList = ContainerUtil.newArrayList((Object[])new Pair[]{Pair.create((Object)((TextFieldWithHistory)this.myBowerExecutableCombobox.getChildComponent()).getTextEditor(), (Object)"Bower executable"), Pair.create((Object)this.myBowerJsonField.getChildComponent(), (Object)"bower.json")});
        this.myNormalForeground = ((JTextField)this.myBowerJsonField.getChildComponent()).getForeground();
        JPanel panel = FormBuilder.createFormBuilder().setAlignLabelOnRight(true).addLabeledComponent("&Node interpreter:", (JComponent)((Object)this.myNodeInterpreterField)).addLabeledComponent("&Bower executable:", (JComponent)this.myBowerExecutableCombobox).addLabeledComponent("b&ower.json:", (JComponent)this.myBowerJsonField).getPanel();
        this.myNodeInterpreterField.addChangeListener(new NodeJsInterpreterChangeListener(){

            @Override
            public void interpreterChanged(@Nullable NodeJsInterpreter newInterpreter) {
                if (BowerView.this.myTrackChanges) {
                    BowerView.this.updateLaterInEDT();
                }
            }
        });
        this.listenForChanges(this.myBowerExecutableCombobox);
        this.listenForChanges((JTextComponent)this.myBowerJsonField.getChildComponent());
        this.myComponent = BowerView.createResult(panel, this.myPackagesView.getComponent());
    }

    private static JPanel createResult(@NotNull JComponent top, @NotNull JComponent bottom) {
        if (top == null) {
            BowerView.$$$reportNull$$$0(1);
        }
        if (bottom == null) {
            BowerView.$$$reportNull$$$0(2);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)top, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bottom, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private void listenForChanges(@NotNull TextFieldWithHistoryWithBrowseButton component) {
        if (component == null) {
            BowerView.$$$reportNull$$$0(3);
        }
        this.listenForChanges(((TextFieldWithHistory)component.getChildComponent()).getTextEditor());
    }

    private void listenForChanges(@NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            BowerView.$$$reportNull$$$0(4);
        }
        textComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (BowerView.this.myTrackChanges) {
                    BowerView.this.updateLaterInEDT();
                }
            }
        });
    }

    private void updateLaterInEDT() {
        UIUtil.invokeLaterIfNeeded(() -> this.update());
    }

    private void update() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        BowerSettings.Builder builder = new BowerSettings.Builder(this.myProject);
        builder.setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef());
        builder.setBowerExecutablePath(StringUtil.notNullize((String)this.myBowerExecutableCombobox.getText()));
        builder.setBowerJsonPath(StringUtil.notNullize((String)((JTextField)this.myBowerJsonField.getChildComponent()).getText()));
        List<BowerValidationInfo> validationInfos = this.validate();
        this.myPackagesView.onSettingsChanged(builder.build(), validationInfos);
    }

    @NotNull
    private List<BowerValidationInfo> validate() {
        ArrayList infos = ContainerUtil.newArrayList();
        for (Pair<JTextField, String> pair : this.myValidationList) {
            JTextField textField = (JTextField)pair.getFirst();
            BowerValidationInfo info = BowerView.validateFilePathField(textField, textField.getText(), (String)pair.getSecond());
            this.processValidationInfo(infos, textField, info);
        }
        BowerValidationInfo info = this.validateNodeInterpreter();
        this.processValidationInfo(infos, (Component)((Object)this.myNodeInterpreterField), info);
        ArrayList arrayList = infos;
        if (arrayList == null) {
            BowerView.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private void processValidationInfo(@NotNull List<BowerValidationInfo> infos, @NotNull Component component, @Nullable BowerValidationInfo info) {
        if (infos == null) {
            BowerView.$$$reportNull$$$0(6);
        }
        if (component == null) {
            BowerView.$$$reportNull$$$0(7);
        }
        if (info != null) {
            infos.add(info);
        }
        if (component instanceof JTextComponent) {
            component.setForeground((Color)(info != null ? JBColor.RED : this.myNormalForeground));
        }
    }

    @Nullable
    private BowerValidationInfo validateNodeInterpreter() {
        NodeJsInterpreter interpreter = this.myNodeInterpreterField.getInterpreter();
        String nodeInterpreterErrorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter);
        if (nodeInterpreterErrorMessage != null) {
            return new BowerValidationInfo((Component)((Object)this.myNodeInterpreterField), "Please correct path to {{LINK}}", "Node interpreter");
        }
        return null;
    }

    @Nullable
    private static BowerValidationInfo validateFilePathField(@NotNull Component component, @NotNull String path, @NotNull String exeFileType) {
        File file;
        if (component == null) {
            BowerView.$$$reportNull$$$0(8);
        }
        if (path == null) {
            BowerView.$$$reportNull$$$0(9);
        }
        if (exeFileType == null) {
            BowerView.$$$reportNull$$$0(10);
        }
        if ((file = new File(path)).isFile()) {
            return null;
        }
        return new BowerValidationInfo(component, "Please correct path to {{LINK}}", exeFileType);
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createBowerExecutable(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(11);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)"Select Bower executable", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            if (project == null) {
                BowerView.$$$reportNull$$$0(20);
            }
            return BowerView.calcPossibleBowerExecutableFiles(project);
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            BowerView.$$$reportNull$$$0(12);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static List<String> calcPossibleBowerExecutableFiles(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(13);
        }
        ArrayList paths = ContainerUtil.newArrayList();
        String basename = BowerCommandLineUtil.getBowerExecutableFilename();
        List files = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)basename);
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        ArrayList infos = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesWithName((List<CompletionModuleInfo>)infos, "bower", project.getBaseDir(), null, false);
        for (CompletionModuleInfo info : infos) {
            File exe;
            File bowerPackageDir;
            String path = info.getAbsolutePath();
            if (info.getType() != ModuleType.NODE_MODULES_DIR || path == null || !(bowerPackageDir = new File(FileUtil.toSystemDependentName((String)path))).isDirectory() || !(exe = new File(bowerPackageDir, "bin" + File.separator + basename)).isFile()) continue;
            paths.add(exe.getAbsolutePath());
        }
        ArrayList arrayList = paths;
        if (arrayList == null) {
            BowerView.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static TextFieldWithBrowseButton createBowerJsonField(@NotNull Project project) {
        if (project == null) {
            BowerView.$$$reportNull$$$0(15);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)"Select bower.json", (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            BowerView.$$$reportNull$$$0(16);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            BowerView.$$$reportNull$$$0(17);
        }
        return jPanel;
    }

    @NotNull
    public BowerSettings getSettings() {
        BowerSettings bowerSettings = new BowerSettings.Builder(this.myProject).setInterpreterRef(this.myNodeInterpreterField.getInterpreterRef()).setBowerExecutablePath(StringUtil.notNullize((String)this.myBowerExecutableCombobox.getText())).setBowerJsonPath(StringUtil.notNullize((String)this.myBowerJsonField.getText())).build();
        if (bowerSettings == null) {
            BowerView.$$$reportNull$$$0(18);
        }
        return bowerSettings;
    }

    public void setSettings(@NotNull BowerSettings settings) {
        if (settings == null) {
            BowerView.$$$reportNull$$$0(19);
        }
        this.myTrackChanges = false;
        try {
            this.myNodeInterpreterField.setInterpreterRef(settings.getInterpreterRef());
            this.myBowerExecutableCombobox.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)settings.getBowerExecutablePath()));
            this.myBowerJsonField.setText(FileUtil.toSystemDependentName((String)settings.getBowerJsonPath()));
            this.updateLaterInEDT();
        }
        finally {
            this.myTrackChanges = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "top";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bottom";
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/bower/BowerView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exeFileType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/bower/BowerView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createBowerExecutable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPossibleBowerExecutableFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createBowerJsonField";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createResult";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listenForChanges";
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processValidationInfo";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validateFilePathField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createBowerExecutable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcPossibleBowerExecutableFiles";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBowerJsonField";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createBowerExecutable$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

