/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionCompletionContributor
extends CompletionContributor {
    private final boolean isUnitTest;
    public static final Key<Boolean> TEST_MARKER = new Key("JSFunctionCompletionContributor.tests.marker");
    LookupElementWeigher myWeigher = new LookupElementWeigher("priority"){

        @NotNull
        public Double weigh(@NotNull LookupElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            Double d = element instanceof LookupItem ? ((LookupItem)element).getPriority() : (element instanceof PrioritizedLookupElement ? ((PrioritizedLookupElement)element).getPriority() : 0.0);
            if (d == null) {
                1.$$$reportNull$$$0(1);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "weigh";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "weigh";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final InsertHandler<LookupElement> FUNCTION_EXPRESSION_INSERT_HANDLER = (context, item) -> {
        String lookupString = item.getLookupString();
        int lBraceIndex = lookupString.indexOf(123);
        if (lBraceIndex < 0) {
            return;
        }
        int caretPosition = lBraceIndex + (lBraceIndex < lookupString.length() - 1 && Character.isWhitespace(lookupString.charAt(lBraceIndex + 1)) ? 2 : 1);
        if (caretPosition < lookupString.length()) {
            CaretModel caretModel = context.getEditor().getCaretModel();
            caretModel.moveToOffset(caretModel.getOffset() - lookupString.length() + caretPosition);
        }
    };

    public JSFunctionCompletionContributor(Application application) {
        this.isUnitTest = application.isUnitTestMode();
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        int i;
        JSExpression contextExpression;
        if (parameters == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(1);
        }
        super.fillCompletionVariants(parameters, result);
        PsiElement parent = JSUtils.getParentSkipParentheses(parameters.getPosition());
        JSExpression jSExpression = contextExpression = parent instanceof JSExpression ? (JSExpression)parent : null;
        if (!(contextExpression instanceof JSReferenceExpression) || ((JSReferenceExpression)contextExpression).getQualifier() != null) {
            return;
        }
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType(contextExpression);
        if (expectedType == null || !expectedType.getSource().isExplicitlyDeclared() && !(expectedType instanceof JSCompositeTypeImpl)) {
            return;
        }
        JSFunctionTypeImpl jsFunctionType = JSFunctionCompletionContributor.getFunctionTypeOrNull(expectedType);
        if (jsFunctionType == null) {
            return;
        }
        result = result.withRelevanceSorter(CompletionSorter.emptySorter().weigh(this.myWeigher));
        CommonCodeStyleSettings commonSettings = JSCodeStyleSettings.getCommonSettings(parameters.getPosition());
        JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(parameters.getPosition());
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(parameters.getPosition());
        boolean generateArrowFunction = dialect != null && dialect.hasFeature(JSLanguageFeature.ARROW_FUNCTIONS);
        List<String> functionParams = JSFunctionCompletionContributor.getParameterNames((PsiElement)contextExpression, jsFunctionType);
        int n = i = functionParams.isEmpty() ? 0 : 1;
        while (i <= functionParams.size()) {
            this.addSignature(result, functionParams.subList(0, i), commonSettings, jsCodeStyleSettings, generateArrowFunction, i);
            ++i;
        }
    }

    @NotNull
    private static List<String> getParameterNames(@NotNull PsiElement scope, @NotNull JSFunctionTypeImpl functionType) {
        if (scope == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(2);
        }
        if (functionType == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(3);
        }
        HashSet usedParameterNames = ContainerUtil.newHashSet();
        ArrayList parameters = ContainerUtil.newArrayList();
        int index = 0;
        for (Pair<String, JSParameterTypeDecorator> pair : functionType.getParametersWithName()) {
            ++index;
            if (!StringUtil.isEmpty((String)((String)pair.first))) {
                String variableName = BasicIntroducedEntityInfoProvider.generateUniqueVariableName((String)pair.first, scope, usedParameterNames, false);
                usedParameterNames.add(variableName);
                parameters.add(variableName);
                continue;
            }
            if (((JSParameterTypeDecorator)pair.second).getType() == null) continue;
            List<String> candidates = BasicIntroducedEntityInfoProvider.generateVariableNamesFromType(((JSParameterTypeDecorator)pair.second).getType(), scope, usedParameterNames);
            String usedName = (String)ContainerUtil.getFirstItem(candidates);
            usedName = !StringUtil.isEmpty((String)usedName) ? usedName : "p" + index;
            usedParameterNames.add(usedName);
            parameters.add(usedName);
        }
        ArrayList arrayList = parameters;
        if (arrayList == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void addSignature(@NotNull CompletionResultSet result, @NotNull List<String> parameterNames, CommonCodeStyleSettings commonSettings, JSCodeStyleSettings jsCodeStyleSettings, boolean generateArrowFunction, int localOrder) {
        if (result == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(5);
        }
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(6);
        }
        if (generateArrowFunction) {
            String signature = JSFunctionCompletionContributor.getLambdaSignature(parameterNames, jsCodeStyleSettings);
            result.addElement(this.createLookupElement(signature, (Function<LookupElementBuilder, LookupElementBuilder>)((Function)builder -> builder.withPresentableText(builder.getLookupString() + "{}")), localOrder));
        } else {
            String signature = JSFunctionCompletionContributor.getAnonymousFunctionSignature(parameterNames, commonSettings, jsCodeStyleSettings);
            result.addElement(this.createLookupElement(signature, (Function<LookupElementBuilder, LookupElementBuilder>)((Function)builder -> builder.withInsertHandler(FUNCTION_EXPRESSION_INSERT_HANDLER)), localOrder));
        }
    }

    @Nullable
    private static JSFunctionTypeImpl getFunctionTypeOrNull(@Nullable JSType expectedType) {
        JSGenericTypeImpl genericType;
        List functionTypes = JSTypeUtils.getFunctionType(expectedType, false).collect(Collectors.toList());
        JSType functionType = (JSType)ContainerUtil.getFirstItem(functionTypes);
        if (functionType == null) {
            return null;
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = functionType instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)functionType : null;
        if (genericType != null) {
            functionType = genericType.getType();
        }
        return functionType instanceof JSFunctionTypeImpl ? (JSFunctionTypeImpl)functionType : null;
    }

    @NotNull
    private LookupElement createLookupElement(@NotNull String signature, @NotNull Function<LookupElementBuilder, LookupElementBuilder> configureBuilder, int localOrder) {
        if (signature == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(7);
        }
        if (configureBuilder == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(8);
        }
        LookupElementBuilder elementBuilder = LookupElementBuilder.create((String)signature).withIcon(AllIcons.Nodes.Function);
        LookupElement element = (LookupElement)configureBuilder.fun((Object)elementBuilder);
        element = PrioritizedLookupElement.withPriority((LookupElement)element, (double)localOrder);
        if (this.isUnitTest) {
            element.putUserData(TEST_MARKER, (Object)true);
        }
        LookupElement lookupElement = element;
        if (lookupElement == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(9);
        }
        return lookupElement;
    }

    @NotNull
    private static String getAnonymousFunctionSignature(@NotNull List<String> parameterNames, @NotNull CommonCodeStyleSettings commonCodeStyleSettings, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(10);
        }
        if (commonCodeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(11);
        }
        if (jsCodeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(12);
        }
        StringBuilder builder = new StringBuilder("function");
        if (jsCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH) {
            builder.append(' ');
        }
        builder.append('(');
        String separator = commonCodeStyleSettings.SPACE_AFTER_COMMA ? ", " : ",";
        String parametersStr = StringUtil.join(parameterNames, (String)separator);
        builder.append(parametersStr);
        builder.append(')');
        if (commonCodeStyleSettings.SPACE_BEFORE_METHOD_LBRACE) {
            builder.append(' ');
        }
        builder.append("{  }");
        String string = builder.toString();
        if (string == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    private static String getLambdaSignature(@NotNull List<String> parameterNames, @NotNull JSCodeStyleSettings codeStyleSettings) {
        if (parameterNames == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(14);
        }
        if (codeStyleSettings == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(15);
        }
        String parametersStr = StringUtil.join(parameterNames, (String)", ");
        StringBuilder builder = new StringBuilder();
        if (parameterNames.size() != 1) {
            builder.append('(');
        }
        builder.append(parametersStr);
        if (parameterNames.size() != 1) {
            builder.append(')');
        }
        builder.append(codeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? " => " : "=>");
        String string = builder.toString();
        if (string == null) {
            JSFunctionCompletionContributor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configureBuilder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonCodeStyleSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsCodeStyleSettings";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/completion/JSFunctionCompletionContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousFunctionSignature";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLambdaSignature";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNames";
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addSignature";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousFunctionSignature";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

