/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSDocParamReferenceCompletion;
import com.intellij.lang.javascript.completion.JSReferenceCompletionUtil;
import com.intellij.lang.javascript.completion.JSTextReferenceCompletion;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNamespaceImpl;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocParamReference;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompletionProcessor;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IdIterator;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSReferenceCompletionContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(1);
        }
        LegacyCompletionContributor.processReferences((CompletionParameters)parameters, (CompletionResultSet)result, (reference, set) -> {
            if (reference instanceof JSTextReference) {
                JSTextReferenceCompletion.addVariants((JSTextReference)reference, set);
            } else if (reference instanceof JSDocParamReference) {
                set.addAllElements(JSDocParamReferenceCompletion.getVariants((JSDocParamReference)reference));
            } else if (reference instanceof JSPropertyNameReference) {
                JSReferenceCompletionContributor.calcPropertyNameReferenceVariants((JSPropertyNameReference)reference, set);
            }
        });
    }

    public static void calcPropertyNameReferenceVariants(@NotNull JSPropertyNameReference reference, @NotNull CompletionResultSet resultSet) {
        boolean tooMuch;
        if (reference == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(2);
        }
        if (resultSet == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(3);
        }
        JSProperty property = reference.getElement();
        VariantsProcessor processor = new VariantsProcessor(property.getContainingFile(), (PsiElement)property, resultSet);
        if (property instanceof ES6Property && ((ES6Property)property).isShorthanded() && property.getValue() instanceof JSReferenceExpression && DialectDetector.isES6((PsiElement)property) && !processor.getTypeInfo().hasExplicitNamespace()) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)property.getValue();
            CompletionResultSink sink = new CompletionResultSink((PsiElement)referenceExpression);
            SinkResolveProcessor<CompletionResultSink> localProcessor = new SinkResolveProcessor<CompletionResultSink>(sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)referenceExpression, null, localProcessor, false, true, null);
            List<PsiElement> processorResults = sink.getResults();
            if (processorResults != null) {
                processor.populateCompletionList(sink.resultsToLookupElements(processorResults), false, resultSet);
            }
        }
        boolean bl = tooMuch = !JSReferenceCompletionContributor.processIndexedSymbols((PsiElement)reference.getElement(), processor);
        if (tooMuch) {
            JSReferenceCompletionUtil.handleOverflow(resultSet);
        }
        Collection<? extends LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(results, false, resultSet);
    }

    public static boolean processIndexedSymbols(PsiElement referenceElement, JSCompletionProcessor processor) {
        return JSReferenceCompletionContributor.processIndexedSymbols(referenceElement, processor, false);
    }

    public static boolean processIndexedSymbols(@NotNull PsiElement referenceElement, JSCompletionProcessor processor, boolean skipSymbolIndex) {
        if (referenceElement == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(4);
        }
        Project project = referenceElement.getProject();
        PsiFile file = referenceElement.getContainingFile();
        if (!JSReferenceCompletionContributor.processElementsInInjectedContext(processor, file)) {
            return false;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(referenceElement);
        if (!skipSymbolIndex && !JSReferenceCompletionContributor.processAllIndexedSymbols(processor, project, scope)) {
            return false;
        }
        if (DialectDetector.isActionScript(referenceElement)) {
            return true;
        }
        return JSReferenceCompletionContributor.processImplicitElements(processor, project, scope);
    }

    public static boolean processElementsInInjectedContext(JSCompletionProcessor processor, PsiFile file) {
        return JSResolveUtil.tryProcessAllElementsInInjectedContext(file, (Processor<JSPsiElementBase>)((Processor)base -> processor.doAdd((JSPsiElementBase)base)));
    }

    public static boolean processImplicitElements(JSCompletionProcessor processor, Project project, GlobalSearchScope scope) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        FileBasedIndex.ValueProcessor implicitElementsProcessor = (file, value) -> {
            PsiFile psiFile = psiManager.findFile(file);
            if (psiFile != null) {
                for (JSImplicitElementsIndex.JSElementProxy proxy : value) {
                    if (processor.doAdd((JSPsiElementBase)proxy.toOffsetBasedImplicitElement(psiFile))) continue;
                    return false;
                }
            }
            return true;
        };
        Collection implicitKeys = FileBasedIndex.getInstance().getAllKeys(JSImplicitElementsIndex.INDEX_ID, project);
        for (String key : implicitKeys) {
            if (FileBasedIndex.getInstance().processValues(JSImplicitElementsIndex.INDEX_ID, (Object)key, null, implicitElementsProcessor, scope)) continue;
            return false;
        }
        return true;
    }

    public static boolean processCompeteMatchedElements(@NotNull VariantsProcessor processor) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(5);
        }
        JSTypeInfo typeInfo = processor.getTypeInfo();
        boolean globalAdded = false;
        for (JSContextLevel level : typeInfo.myContextLevels) {
            globalAdded |= level.myNamespace.getQualifiedName() == null;
        }
        ArrayList contextLevels = typeInfo.myContextLevels;
        if (!globalAdded && typeInfo.isGlobalStatusHint()) {
            contextLevels = ContainerUtil.newArrayList(contextLevels);
            JSNamespaceImpl namespace = new JSNamespaceImpl(JSQualifiedNameImpl.create("", null), JSContext.UNKNOWN, true);
            contextLevels.add(new JSContextLevel(namespace, 0));
        }
        if (typeInfo.isGlobalStatusHint() && typeInfo.isEmpty()) {
            processor.setAddOnlyCompleteMatches(true);
            for (String name : BaseJSSymbolProcessor.GLOBAL_OBJECT_NAMES) {
                contextLevels.add(new JSContextLevel(new JSNamespaceImpl(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, true), 0));
            }
            for (String name : BaseJSSymbolProcessor.GLOBAL_TYPE_NAMES) {
                contextLevels.add(new JSContextLevel(new JSNamespaceImpl(JSQualifiedNameImpl.create(name, null), JSContext.INSTANCE, true), 0));
            }
        }
        GlobalSearchScope allScope = JSResolveUtil.getResolveScope(processor.getContext());
        THashSet visitedNamespaces = new THashSet();
        for (JSContextLevel level : contextLevels) {
            String namespace;
            JSQualifiedName name = level.myNamespace.getQualifiedName();
            String string = namespace = name != null ? name.getQualifiedName() : "";
            if (level.myJSModule == null && !visitedNamespaces.add(namespace)) continue;
            GlobalSearchScope scope = level.adjustScope(allScope);
            Collection<JSPsiElementBase> namespaceMembers = JSClassResolver.getInstance().findNamespaceMembers(namespace, scope, scope != allScope);
            for (JSPsiElementBase element : namespaceMembers) {
                if (!processor.acceptsFile(element.getContainingFile()) || processor.doAdd(element, (JSTypeSubstitutor)level.myNamespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY))) continue;
                return false;
            }
        }
        return true;
    }

    private static TIntHashSet filterIds(Project project, GlobalSearchScope scope, PrefixMatcher matcher) {
        if (matcher.getPrefix().isEmpty()) {
            return null;
        }
        HashSet keys = new HashSet();
        StubIndex.getInstance().processAllKeys(JSSymbolIndex2.KEY, project, arg_0 -> JSReferenceCompletionContributor.lambda$filterIds$3(matcher, (Set)keys, arg_0));
        TIntHashSet ids = new TIntHashSet();
        for (String key : keys) {
            IdIterator iterator = StubIndex.getInstance().getContainingIds(JSSymbolIndex2.KEY, (Object)key, project, scope);
            while (iterator.hasNext()) {
                ids.add(iterator.next());
            }
        }
        return ids;
    }

    private static boolean processAllIndexedSymbols(@NotNull JSCompletionProcessor processor, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(8);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PrefixMatcher matcher = processor.getPrefixMatcher();
        TIntHashSet ids = JSReferenceCompletionContributor.filterIds(project, scope, matcher);
        MyJSRecursiveWalkingElementVisitor visitor = new MyJSRecursiveWalkingElementVisitor(processor);
        PsiFile targetFile = processor.getTargetFile();
        JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, targetFile);
        for (FileType fileType : JavaScriptIndex.getFileTypesForJSCompletion()) {
            for (VirtualFile vFile : FileTypeIndex.getFiles((FileType)fileType, (GlobalSearchScope)scope)) {
                PsiFile psi;
                if (!JavaScriptIndex.isAcceptableFile(vFile) || !StubUpdatingIndex.canHaveStub((VirtualFile)vFile) || ids != null && vFile instanceof VirtualFileWithId && !ids.contains(((VirtualFileWithId)vFile).getId()) || (psi = psiManager.findFile(vFile)) == null || psi == targetFile || !processor.acceptsFile(psi) || JSReferenceCompletionContributor.processSymbolsInPsiFile(processor, visitor, psi)) continue;
                return false;
            }
        }
        return true;
    }

    protected static boolean processSymbolsInPsiFile(@NotNull JSCompletionProcessor processor, MyJSRecursiveWalkingElementVisitor visitor, PsiFile psi) {
        if (processor == null) {
            JSReferenceCompletionContributor.$$$reportNull$$$0(9);
        }
        List stubbedRoots = StubTreeBuilder.getStubbedRoots((FileViewProvider)psi.getViewProvider());
        for (Pair stubbedRoot : stubbedRoots) {
            PsiFile root = (PsiFile)stubbedRoot.second;
            StubTree tree = ((PsiFileImpl)root).getStubTree();
            if (tree != null) {
                for (StubElement stubElement : tree.getPlainList()) {
                    PsiElement psiElement;
                    IStubElementType type = stubElement.getStubType();
                    if (!(type instanceof JSStubElementType) || JSReferenceCompletionContributor.processElement(processor, (JSElement)(psiElement = stubElement.getPsi()), (JSStubElementType)type)) continue;
                    return false;
                }
                continue;
            }
            root.accept((PsiElementVisitor)visitor);
        }
        return true;
    }

    private static <PsiT extends JSElement> boolean processElement(JSCompletionProcessor processor, PsiT element, JSStubElementType<?, PsiT> type) {
        if (element instanceof JSFunctionExpression) {
            return true;
        }
        if (element instanceof JSPsiElementBase && !StringUtil.isEmpty((String)element.getName()) && type.shouldIndexSymbol(element) && !processor.doAdd((JSPsiElementBase)element)) {
            return false;
        }
        if (element instanceof JSImplicitElementProvider) {
            Collection elements;
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = elements = data != null ? data.getImplicitElements() : null;
            if (elements != null) {
                for (JSImplicitElement implicitElement : elements) {
                    if (JSElementIndexingDataStructureImpl.indexImplicitElement(implicitElement.getStructure(), null) || processor.doAdd((JSPsiElementBase)implicitElement)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$filterIds$3(PrefixMatcher matcher, Set keys, String s) {
        if (matcher.prefixMatches(s)) {
            keys.add(s);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 5: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSReferenceCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcPropertyNameReferenceVariants";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processIndexedSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processCompeteMatchedElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllIndexedSymbols";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "processSymbolsInPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyJSRecursiveWalkingElementVisitor
    extends JSRecursiveWalkingElementVisitor {
        private final JSCompletionProcessor myProcessor;

        public MyJSRecursiveWalkingElementVisitor(JSCompletionProcessor processor) {
            this.myProcessor = processor;
        }

        public void visitElement(PsiElement element) {
            IElementType type;
            ASTNode node = element.getNode();
            IElementType iElementType = type = node != null ? node.getElementType() : null;
            if (type instanceof JSStubElementType && ((JSStubElementType)type).shouldCreateStub(node) && !JSReferenceCompletionContributor.processElement(this.myProcessor, (JSElement)element, (JSStubElementType)type)) {
                this.stopWalking();
            }
            super.visitElement(element);
        }
    }
}

