/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.ASTNode;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationBuilder;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.library.JSLibraryExtDocProviderFactory;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.impl.util.CssDocumentationProvider;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.Processor;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocumentationProvider
implements CodeDocumentationProvider,
ExternalDocumentationProvider {
    public static final String DEFAULT_CLASS_NAME = "class";
    @NonNls
    private static final String OBJECT_NAME = "Object";
    private static final String RETURN_TAG_PROPERTY = "javascript.return.tag";
    protected static final String SEE_PLAIN_TEXT_CHARS = "\t \"-\\/<>*";
    private final boolean myShowNamedItem;
    private final JSLibraryExtDocProviderFactory myLibraryDocProviderFactory = new JSLibraryExtDocProviderFactory();

    public JSDocumentationProvider() {
        this(true);
    }

    public JSDocumentationProvider(boolean showNamedItem) {
        this.myShowNamedItem = showNamedItem;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof JSOffsetBasedImplicitElement) {
            element = ((JSOffsetBasedImplicitElement)element).getElementAtOffset();
        }
        if (element == null) {
            return null;
        }
        if ((element = element.getNavigationElement()) instanceof JSFunction) {
            return this.createQuickNavigateForFunction((JSFunction)element, originalElement);
        }
        if (element instanceof JSClass) {
            return this.createQuickNavigateForJSClass((JSClass)element, originalElement);
        }
        if (element instanceof JSFieldVariable) {
            return this.createQuickNavigateForVariableOrField((JSFieldVariable)element, originalElement);
        }
        if (element instanceof JSAttributeNameValuePair) {
            return this.createQuickNavigateForAnnotationDerived(element);
        }
        if (element instanceof XmlToken) {
            String xmlAttributeDoc = JSDocumentationProvider.checkAndGetXmlAttributeQuickNavigate(element);
            if (xmlAttributeDoc != null) {
                return xmlAttributeDoc;
            }
            JSTagContextBuilder builder = new JSTagContextBuilder(element, "XmlTag");
            return StringUtil.unquoteString((String)element.getText()) + ":" + builder.typeName;
        }
        if (element instanceof JSNamespaceDeclaration) {
            return JSDocumentationProvider.createQuickNavigateForNamespace((JSNamespaceDeclaration)element);
        }
        return null;
    }

    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls) {
        for (String docUrl : docUrls) {
            ExternalDocumentationProvider provider;
            if (docUrl == null || (provider = this.myLibraryDocProviderFactory.getProvider(docUrl)) == null) continue;
            ArrayList<String> urlsToHandle = new ArrayList<String>();
            urlsToHandle.add(docUrl);
            String result = provider.fetchExternalDocumentation(project, element, urlsToHandle);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)this, (PsiElement)element, (PsiElement)originalElement);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    @Nullable
    private static String checkAndGetXmlAttributeQuickNavigate(PsiElement element) {
        PsiElement xmlAttribute;
        String xmlAttributeDoc = null;
        Object object = element.getParent() instanceof XmlAttribute ? element.getParent() : (xmlAttribute = element.getParent() instanceof XmlAttributeValue && element.getParent().getParent() instanceof XmlAttribute ? element.getParent().getParent() : null);
        if (xmlAttribute != null) {
            String value = StringUtil.unquoteString((String)StringUtil.notNullize((String)((XmlAttribute)xmlAttribute).getValue()));
            xmlAttributeDoc = ((XmlAttribute)xmlAttribute).getName() + " " + value;
        }
        return xmlAttributeDoc;
    }

    private String createQuickNavigateForAnnotationDerived(PsiElement element) {
        JSAttributeNameValuePair valuePair = (JSAttributeNameValuePair)element;
        JSAttribute parent = (JSAttribute)valuePair.getParent();
        StringBuilder builder = new StringBuilder();
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)valuePair, JSClass.class);
        this.appendParentInfo((PsiElement)(clazz != null ? clazz : parent.getContainingFile()), builder, (PsiNamedElement)parent, JSTypeSubstitutor.EMPTY);
        builder.append(parent.getName()).append(" ").append(valuePair.getSimpleValue());
        return builder.toString();
    }

    @Nullable
    protected String createQuickNavigateForFunction(@NotNull JSFunction function, PsiElement originalElement) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(0);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)function);
        StringBuilder result = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)function, originalElement);
        this.appendParentInfo(parent, result, (PsiNamedElement)function, substitutor);
        this.appendFunctionAttributesAndName(function, result, substitutor);
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        if (!get && !set) {
            result.append('(');
            JSParameterList jsParameterList = function.getParameterList();
            if (jsParameterList != null) {
                int start = result.length();
                for (JSParameterListElement p : jsParameterList.getParameters()) {
                    String typeText;
                    if (start != result.length()) {
                        result.append(", ");
                    }
                    result.append(p.getName());
                    if (p.isOptional()) {
                        result.append("?");
                    }
                    if ((typeText = this.getTypeTextForQuickNavigate(p.getType(), substitutor)) == null) continue;
                    this.appendType((PsiElement)p, result, typeText);
                }
            }
            result.append(')');
        }
        String varType = this.getReturnTypeTextForQuickNavigate(function, get, set, substitutor);
        this.appendType((PsiElement)function, result, varType);
        return result.toString();
    }

    @Nullable
    protected String getReturnTypeTextForQuickNavigate(@NotNull JSFunction function, boolean get, boolean set, @NotNull JSTypeSubstitutor substitutor) {
        JSParameterListElement[] jsParameters;
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (substitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (get || !set) {
            JSType type = function.getReturnType();
            if (type instanceof JSUndefinedType) {
                return null;
            }
            return this.getTypeTextForQuickNavigate(type, substitutor);
        }
        JSParameterList jsParameterList = function.getParameterList();
        if (jsParameterList != null && (jsParameters = jsParameterList.getParameters()).length > 0) {
            return this.getTypeTextForQuickNavigate(jsParameters[0].getType(), substitutor);
        }
        return null;
    }

    protected void appendFunctionAttributesAndName(@NotNull JSFunction function, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            JSDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (substitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(5);
        }
        boolean get = function.isGetProperty();
        boolean set = function.isSetProperty();
        this.appendAttrList((JSAttributeListOwner)function, result);
        result.append(this.getFunctionPrefix(function, get, set));
        result.append(StringUtil.notNullize((String)function.getName()));
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutor(@NotNull JSElement function, @NotNull PsiElement originalElement) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (originalElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(7);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(8);
        }
        return jSTypeSubstitutor;
    }

    @Nullable
    protected String getTypeTextForQuickNavigate(@Nullable JSType rawType, @NotNull JSTypeSubstitutor substitutor) {
        JSType type;
        if (substitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(9);
        }
        return (type = JSTypeUtils.applyGenericArguments(rawType, (Map<String, JSType>)substitutor)) != null ? type.getTypeText(JSType.TypeTextFormat.PRESENTABLE) : null;
    }

    @NotNull
    protected String getTypeTextForGenerateDoc(@NotNull JSType rawType) {
        if (rawType == null) {
            JSDocumentationProvider.$$$reportNull$$$0(10);
        }
        String string = rawType.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected String getFunctionPrefix(@NotNull JSFunction function, boolean get, boolean set) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(12);
        }
        String string = get || set ? "property " : "function ";
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(13);
        }
        return string;
    }

    protected void appendParentInfo(@Nullable PsiElement parent, @NotNull StringBuilder builder, @NotNull PsiNamedElement element, @NotNull JSTypeSubstitutor substitutor) {
        if (builder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (substitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (parent instanceof JSClass) {
            String className = StringUtil.notNullize((String)((JSClass)parent).getQualifiedName(), (String)DEFAULT_CLASS_NAME);
            builder.append(className).append("\n");
        } else if (parent instanceof JSFile && parent.getContext() == null) {
            builder.append(parent.getContainingFile().getName()).append("\n");
        }
    }

    @Nullable
    protected String createQuickNavigateForVariableOrField(@NotNull JSFieldVariable variableOrField, PsiElement originalElement) {
        if (variableOrField == null) {
            JSDocumentationProvider.$$$reportNull$$$0(17);
        }
        PsiElement parent = JSResolveUtil.findParent((PsiElement)variableOrField);
        StringBuilder result = new StringBuilder();
        JSTypeSubstitutor substitutor = this.getTypeSubstitutor((JSElement)variableOrField, originalElement);
        this.appendParentInfo(parent, result, (PsiNamedElement)variableOrField, substitutor);
        this.appendAttrList((JSAttributeListOwner)variableOrField, result);
        if (variableOrField instanceof JSVariable) {
            result.append(this.getVarPrefix((JSVariable)variableOrField));
        }
        result.append(variableOrField.getName());
        this.appendVariableOrFieldType(variableOrField, originalElement, result, substitutor);
        if (variableOrField instanceof JSVariable && ((JSVariable)variableOrField).hasInitializer()) {
            this.appendVariableInitializer((JSVariable)variableOrField, result);
        }
        return result.toString();
    }

    protected void appendVariableOrFieldType(@NotNull JSFieldVariable variableOrField, @Nullable PsiElement originalElement, @NotNull StringBuilder result, @NotNull JSTypeSubstitutor substitutor) {
        if (variableOrField == null) {
            JSDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (result == null) {
            JSDocumentationProvider.$$$reportNull$$$0(19);
        }
        if (substitutor == null) {
            JSDocumentationProvider.$$$reportNull$$$0(20);
        }
        String typeForDocumentation = this.getTypeTextForQuickNavigate(this.getVariableOrFieldType((JSTypeDeclarationOwner)variableOrField), substitutor);
        this.appendType((PsiElement)variableOrField, result, typeForDocumentation);
    }

    protected JSType getVariableOrFieldType(@NotNull JSTypeDeclarationOwner variable) {
        if (variable == null) {
            JSDocumentationProvider.$$$reportNull$$$0(21);
        }
        return variable.getType();
    }

    protected void appendVariableInitializer(@NotNull JSVariable variable, StringBuilder result) {
        JSExpression initializer;
        String initializerText;
        if (variable == null) {
            JSDocumentationProvider.$$$reportNull$$$0(22);
        }
        if ((initializerText = variable.getLiteralOrReferenceInitializerText()) == null && (initializer = variable.getInitializer()) != null) {
            initializerText = initializer.getText();
        }
        if (initializerText != null) {
            int maxInitStringLengthToShow = 50;
            if (initializerText.length() > maxInitStringLengthToShow) {
                initializerText = initializerText.substring(0, maxInitStringLengthToShow) + "...";
            }
            result.append(" = ").append(StringUtil.escapeXml((String)initializerText));
        }
    }

    @NotNull
    protected String getVarPrefix(@NotNull JSVariable variable) {
        JSVarStatement statement;
        if (variable == null) {
            JSDocumentationProvider.$$$reportNull$$$0(23);
        }
        JSVarStatement.VarKeyword keyword = (statement = variable.getStatement()) != null ? statement.getVarKeyword() : null;
        String string = keyword != null ? keyword.getText() + " " : "";
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(24);
        }
        return string;
    }

    protected void appendType(@NotNull PsiElement context, StringBuilder builder, String varType) {
        if (context == null) {
            JSDocumentationProvider.$$$reportNull$$$0(25);
        }
        if (!StringUtil.isEmpty((String)varType)) {
            JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
            String before = settings.SPACE_BEFORE_TYPE_COLON ? " " : "";
            String after = settings.SPACE_AFTER_TYPE_COLON ? " " : "";
            builder.append(before).append(':').append(after).append(StringUtil.escapeXml((String)varType));
        }
    }

    @Nullable
    protected String createQuickNavigateForJSClass(@NotNull JSClass jsClass, PsiElement originalElement) {
        String qName;
        if (jsClass == null) {
            JSDocumentationProvider.$$$reportNull$$$0(26);
        }
        if ((qName = jsClass.getQualifiedName()) == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result.append(packageName).append("\n");
        }
        this.appendClassAttributesAndName(jsClass, originalElement, result);
        this.appendClassExtendsAndImplements(jsClass, packageName, result);
        return result.toString();
    }

    protected void appendClassAttributesAndName(@NotNull JSClass jsClass, PsiElement originalElement, StringBuilder result) {
        if (jsClass == null) {
            JSDocumentationProvider.$$$reportNull$$$0(27);
        }
        this.appendAttrList((JSAttributeListOwner)jsClass, result);
        if (jsClass.isInterface()) {
            result.append("interface");
        } else {
            result.append(DEFAULT_CLASS_NAME);
        }
        result.append(" ").append(jsClass.getName());
    }

    protected void appendClassExtendsAndImplements(@NotNull JSClass jsClass, String packageName, StringBuilder result) {
        String s;
        if (jsClass == null) {
            JSDocumentationProvider.$$$reportNull$$$0(28);
        }
        if ((s = JSDocumentationProvider.generateReferenceTargetList(jsClass.getExtendsList(), packageName)) == null && !OBJECT_NAME.equals(jsClass.getName())) {
            s = OBJECT_NAME;
        }
        if (s != null) {
            result.append(" extends ").append(s);
        }
        if ((s = JSDocumentationProvider.generateReferenceTargetList(jsClass.getImplementsList(), packageName)) != null) {
            result.append("\nimplements ").append(s);
        }
    }

    @Nullable
    private static String createQuickNavigateForNamespace(JSNamespaceDeclaration ns) {
        String qName = ns.getQualifiedName();
        if (qName == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String packageName = StringUtil.getPackageName((String)qName);
        if (packageName.length() > 0) {
            result.append(packageName).append("\n");
        }
        result.append("namespace");
        String name = ns.getName();
        result.append(" ").append(name);
        String s = ns.getInitialValueString();
        if (s != null) {
            result.append(" = ").append(s);
        }
        return result.toString();
    }

    protected void appendAttrList(JSAttributeListOwner owner, StringBuilder result) {
        JSAttributeList attributeList = owner.getAttributeList();
        if (attributeList != null) {
            JSVisibilityUtil.PresentableAccessModifier modifier;
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.OVERRIDE);
            String ns = JSResolveUtil.getNamespaceValue(attributeList);
            if (ns == null && (modifier = JSVisibilityUtil.getPresentableAccessModifier((JSElement)owner)) != null) {
                ns = modifier.getText();
            }
            if (ns != null) {
                result.append(ns);
                result.append(" ");
            }
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.STATIC);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.FINAL);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.DYNAMIC);
            JSDocumentationProvider.appendModifier(result, attributeList, JSAttributeList.ModifierType.NATIVE);
        }
    }

    protected static void appendModifier(StringBuilder result, JSAttributeList attributeList, JSAttributeList.ModifierType modifier) {
        if (attributeList.hasModifier(modifier)) {
            result.append(modifier.keyword).append(" ");
        }
    }

    @Nullable
    private static String generateReferenceTargetList(@Nullable JSReferenceList implementsList, @NotNull String packageName) {
        String[] referenceExpressionTexts;
        if (packageName == null) {
            JSDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (implementsList == null) {
            return null;
        }
        StringBuilder result = null;
        for (String refExprText : referenceExpressionTexts = implementsList.getReferenceTexts()) {
            refExprText = JSImportHandlingUtil.resolveTypeName(refExprText, (PsiElement)implementsList);
            if (result == null) {
                result = new StringBuilder();
            } else {
                result.append(",");
            }
            String referencedPackageName = StringUtil.getPackageName((String)refExprText);
            result.append(referencedPackageName.equals(packageName) ? refExprText.substring(refExprText.lastIndexOf(46) + 1) : refExprText);
        }
        return result == null ? null : result.toString();
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        String possibleCssName = JSDocumentationProvider.findPossibleCssName(element);
        List cssUrls = possibleCssName != null ? Arrays.asList(CssDocumentationProvider.getUrlsFor((String)possibleCssName, (PsiElement)element)) : Collections.emptyList();
        return cssUrls.isEmpty() ? JSDocumentationProvider.collectExternalUrls(element) : cssUrls;
    }

    @Nullable
    private static List<String> collectExternalUrls(PsiElement element) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (dialect == null || !dialect.isJavaScript()) {
            return null;
        }
        ArrayList<String> urls = new ArrayList<String>();
        Project project = element.getProject();
        List<PsiElement> candidateElements = JSDocumentationUtils.getElementsForExternalDocumentation(element);
        ScriptingLibraryManager libManager = (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
        for (PsiElement docElement : candidateElements) {
            VirtualFile libFile = docElement.getContainingFile().getVirtualFile();
            if (libFile == null) continue;
            for (String baseUrl : libManager.getDocUrlsFor(libFile)) {
                String elementFQN = docElement instanceof JSPsiElementBase ? ((JSPsiElementBase)docElement).getQualifiedName() : null;
                if (elementFQN == null) continue;
                if (libFile.getPath().contains("nodejs")) {
                    elementFQN = JSDocumentationProvider.patchNodejsFQN(elementFQN, libFile);
                    String parameterSignature = JSDocumentationProvider.getParameterSignature(docElement);
                    elementFQN = elementFQN + parameterSignature;
                }
                String relativeUrl = JSDocumentationUtils.getLibDocRelativeUrl(baseUrl, elementFQN);
                urls.add(baseUrl + (baseUrl.endsWith("/") || StringUtil.isEmpty((String)relativeUrl) ? "" : "/") + relativeUrl);
            }
        }
        return urls.isEmpty() ? null : urls;
    }

    private static String patchNodejsFQN(@NotNull String fqn, @NotNull VirtualFile libFile) {
        if (fqn == null) {
            JSDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (libFile == null) {
            JSDocumentationProvider.$$$reportNull$$$0(31);
        }
        String fileName = libFile.getName();
        fileName = StringUtil.trimEnd((String)fileName, (String)".js");
        if (fqn.startsWith("exports.")) {
            return fqn.replaceAll("^exports", fileName);
        }
        if (fqn.startsWith(fileName)) {
            return fqn;
        }
        return fileName + "." + fqn;
    }

    private static String getParameterSignature(PsiElement element) {
        StringBuilder parameterBuf = new StringBuilder();
        if (element instanceof JSFunction) {
            JSFunction function = (JSFunction)element;
            for (JSParameter parameter : function.getParameterVariables()) {
                parameterBuf.append('%').append(parameter.getName());
            }
        }
        return parameterBuf.toString();
    }

    public String generateDoc(PsiElement _element, PsiElement originalElement) {
        String cssDoc;
        String possibleCssName;
        if (_element instanceof JSImplicitElement) {
            return this.getDocumentationForImplicitElement((JSImplicitElement)_element);
        }
        if (_element.getParent() instanceof PsiComment) {
            _element = _element.getParent();
        }
        if (_element instanceof PsiComment) {
            return this.doGetCommentTextFromComment((PsiComment)_element, originalElement);
        }
        if (_element instanceof JSReferenceExpression) {
            StringBuilder buffer = null;
            JSReferenceExpression expression = (JSReferenceExpression)_element;
            ResolveResult[] results = JSTargetElementEvaluator.resolveReferenceExpressionWithAllResolveResults((JSReferenceExpressionImpl)expression);
            JSResolveUtil.stableResolveOrder(results);
            int linkCount = 0;
            String linkedDoc = null;
            for (ResolveResult r : results) {
                String _linkedDoc;
                PsiElement element = r.getElement();
                if (element == _element || element == null || (_linkedDoc = this.generateDoc(element, originalElement)) == null || _linkedDoc.trim().isEmpty()) continue;
                linkedDoc = _linkedDoc;
                ItemPresentation presentation = ((NavigationItem)element).getPresentation();
                if (presentation == null) continue;
                if (buffer == null) {
                    buffer = new StringBuilder();
                }
                JSDocumentationUtils.appendHyperLinkToElement(element, expression.getReferenceName(), buffer, presentation.getPresentableText(), presentation.getLocationString());
                buffer.append("<br/>\n");
                ++linkCount;
            }
            if (linkedDoc != null && linkCount == 1) {
                return linkedDoc;
            }
            if (buffer == null) {
                return results.length == 0 ? "Can not find source for " + expression.getText() : "No documentation found in source code.";
            }
            return buffer.toString();
        }
        _element = _element.getNavigationElement();
        PsiElement element = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(_element);
        boolean parameterDoc = element instanceof JSParameter;
        if (element != null) {
            ASTNode initialComment;
            PsiComment docComment = JSDocumentationUtils.findDocComment(element, (PsiElement)(_element instanceof JSAttributeNameValuePair ? originalElement : null), (Ref<PsiElement>)Ref.create(null));
            if (docComment == null) {
                PsiComment scopeComment;
                String name;
                PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(element);
                docComment = JSDocumentationUtils.findDocComment(meaningfulElement);
                if (docComment != null) {
                    element = meaningfulElement;
                } else if (_element instanceof JSPsiNamedElementBase && (name = ((JSPsiNamedElementBase)_element).getName()) != null && (scopeComment = JSDocumentationUtils.findScopeComment((JSElement)((JSPsiNamedElementBase)_element))) instanceof JSDocComment) {
                    Ref result = Ref.create();
                    JSClassResolver.processImplicitElements(name, (Processor<? super JSImplicitElement>)((Processor)e -> {
                        result.set((Object)this.getDocumentationForImplicitElement((JSImplicitElement)e));
                        return false;
                    }), (JSImplicitElementProvider)((JSDocComment)scopeComment));
                    if (!result.isNull()) {
                        return (String)result.get();
                    }
                }
            }
            if (docComment != null) {
                docComment = JSDocumentationProvider.findFirstDocComment((PsiElement)docComment);
                element = JSDocumentationProvider.findTargetElement(_element, element);
                JSType elementType = JSTypeUtils.getTypeOfElement(element);
                boolean isTypeOnlyComment = docComment instanceof PsiComment && elementType != null && elementType.isEquivalentTo(JSDocumentationUtils.tryCreateTypeFromComment(docComment, true, true, false), null);
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, this.myShowNamedItem, this);
                if (!isTypeOnlyComment) {
                    JSDocumentationUtils.processDocumentationTextFromComment(docComment.getNode(), builder);
                }
                builder.addEvaluatedType();
                return parameterDoc ? builder.getParameterDoc((JSParameter)_element, (PsiElement)docComment) : builder.getDoc();
            }
            if ((element = JSDocumentationProvider.findTargetElement(_element, element)) instanceof JSFunction && ((initialComment = JSDocumentationUtils.findLeadingCommentInFunctionBody(element)) != null || DialectDetector.isTypeScript(element))) {
                JSDocumentationBuilder builder = new JSDocumentationBuilder(element, originalElement, true, this);
                if (initialComment != null) {
                    JSDocumentationUtils.processDocumentationTextFromComment(initialComment, builder);
                }
                builder.addEvaluatedType();
                return builder.getDoc();
            }
        }
        if ((possibleCssName = JSDocumentationProvider.findPossibleCssName(_element)) != null && (cssDoc = CssDocumentationProvider.generateDoc((String)possibleCssName, (PsiElement)_element, null)) != null) {
            return cssDoc;
        }
        if (element == null) {
            return null;
        }
        JSDocumentationBuilder builder = this.createDocumentationBuilder(element, null, false);
        return builder.addEvaluatedType() ? builder.getDoc() : null;
    }

    @NotNull
    protected JSDocumentationBuilder createDocumentationBuilder(@NotNull PsiElement element, PsiElement _contextElement, boolean showNamedItem) {
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(32);
        }
        JSDocumentationBuilder jSDocumentationBuilder = new JSDocumentationBuilder(element, _contextElement, showNamedItem, this);
        if (jSDocumentationBuilder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(33);
        }
        return jSDocumentationBuilder;
    }

    @Nullable
    protected String doGetCommentTextFromComment(@NotNull PsiComment _element, PsiElement originalElement) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(34);
        }
        JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)_element, originalElement, true, this);
        JSDocumentationUtils.processDocumentationTextFromComment(_element.getNode(), builder);
        return builder.getDoc();
    }

    @Nullable
    private String getDocumentationForImplicitElement(@NotNull JSImplicitElement element) {
        PsiElement comment;
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(35);
        }
        if ((comment = JSDocumentationUtils.findCommentForImplicitElement((PsiElement)element)) instanceof PsiComment) {
            JSDocumentationBuilder builder = new JSDocumentationBuilder((PsiElement)element, (PsiElement)element, true, this);
            JSDocumentationUtils.processDocumentationTextFromComment(comment.getNode(), builder);
            return builder.getDoc();
        }
        return null;
    }

    @NotNull
    private static PsiElement findTargetElement(@NotNull PsiElement _element, @NotNull PsiElement element) {
        if (_element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(36);
        }
        if (element == null) {
            JSDocumentationProvider.$$$reportNull$$$0(37);
        }
        if (_element instanceof JSDefinitionExpression) {
            PsiElement parentElement = _element.getParent();
            if (parentElement instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)parentElement).getROperand();
                element = rOperand instanceof JSFunctionExpression ? rOperand : _element;
            }
        } else if (_element instanceof JSFunctionExpression) {
            element = _element;
        } else if (_element instanceof JSProperty) {
            JSExpression expression = ((JSProperty)_element).getValue();
            if (expression instanceof JSFunction) {
                element = expression;
            }
        } else if (_element instanceof JSVariable) {
            JSFunction function;
            if (_element instanceof JSParameter && (function = ((JSParameter)_element).getDeclaringFunction()) != null) {
                JSFunction jSFunction = function;
                if (jSFunction == null) {
                    JSDocumentationProvider.$$$reportNull$$$0(38);
                }
                return jSFunction;
            }
            element = _element;
        } else if (_element instanceof JSAttributeNameValuePair) {
            PsiElement psiElement = _element;
            if (psiElement == null) {
                JSDocumentationProvider.$$$reportNull$$$0(39);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(40);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement findFirstDocComment(@NotNull PsiElement docComment) {
        if (docComment == null) {
            JSDocumentationProvider.$$$reportNull$$$0(41);
        }
        if (docComment.getNode().getElementType() == JSTokenTypes.END_OF_LINE_COMMENT) {
            while (true) {
                PsiElement prev;
                if ((prev = docComment.getPrevSibling()) instanceof PsiWhiteSpace) {
                    prev = prev.getPrevSibling();
                }
                if (prev == null || prev.getNode().getElementType() != JSTokenTypes.END_OF_LINE_COMMENT) break;
                docComment = prev;
            }
        }
        PsiElement psiElement = docComment;
        if (psiElement == null) {
            JSDocumentationProvider.$$$reportNull$$$0(42);
        }
        return psiElement;
    }

    @Nullable
    private static String findPossibleCssName(PsiElement _element) {
        JSExpression expression;
        if (_element instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)_element).getExpression()) instanceof JSReferenceExpression) {
            String text = ((JSReferenceExpression)expression).getReferenceName();
            if (text == null) {
                return null;
            }
            if (text.length() > 0 && Character.isUpperCase(text.charAt(0))) {
                return null;
            }
            StringBuilder buf = new StringBuilder(text.length());
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isUpperCase(ch)) {
                    buf.append('-').append(Character.toLowerCase(ch));
                    continue;
                }
                buf.append(ch);
            }
            return buf.toString();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof LookupItem) {
            object = ((LookupItem)object).getObject();
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        PsiElement resolve;
        PsiReference[] references;
        int delimiterIndex = link.lastIndexOf("%");
        if (delimiterIndex != -1) {
            return JSDocumentationProvider.resolveDocumentLink(psiManager, link, delimiterIndex);
        }
        if (context != null && (references = new JSDocReferenceSet(context, link, 0, false).getReferences()).length > 0 && (resolve = references[references.length - 1].resolve()) != null) {
            return resolve;
        }
        return null;
    }

    protected static PsiElement resolveDocumentLink(PsiManager psiManager, String link, int namespaceDelimiterIndex) {
        Project project = psiManager.getProject();
        int filenameDelimiterIndex = link.lastIndexOf("%", namespaceDelimiterIndex - 1);
        if (filenameDelimiterIndex == -1) {
            return null;
        }
        String fileName = link.substring(0, filenameDelimiterIndex).replace('\\', '/');
        String name = link.substring(filenameDelimiterIndex + 1, namespaceDelimiterIndex);
        String qualifier = link.substring(namespaceDelimiterIndex + 1);
        boolean isGlobal = "null".equals(qualifier);
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)fileName, null);
        if (relativeFile == null) {
            relativeFile = JSResolveUtil.findPredefinedOrLibraryFile(project, fileName);
        }
        Ref result = new Ref();
        if (relativeFile != null) {
            GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)project, (VirtualFile)relativeFile);
            String qName = isGlobal ? name : qualifier + "." + name;
            JSClassResolver.getInstance().processElementsByQNameIncludingImplicit(qName, fileScope, (Processor<JSPsiElementBase>)((Processor)base -> {
                result.set(base);
                return false;
            }));
        }
        return (PsiElement)result.get();
    }

    public static PsiElement findElementForWhichPreviousCommentWillBeSearched(Object object) {
        if (object instanceof JSFunction) {
            PsiElement psiElement = (PsiElement)object;
            PsiElement parent = psiElement.getParent();
            if (parent instanceof JSNewExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof JSProperty) {
                psiElement = parent;
            } else if (parent instanceof JSAssignmentExpression) {
                psiElement = parent.getParent();
            }
            JSFunction function = (JSFunction)object;
            if (function.isSetProperty() || function.isGetProperty()) {
                for (PsiElement el = function.getPrevSibling(); el != null; el = el.getPrevSibling()) {
                    PsiComment doc;
                    JSFunction prevFunction;
                    String name;
                    if (el instanceof PsiWhiteSpace || el instanceof PsiComment) continue;
                    if (!(el instanceof JSFunction) || (name = (prevFunction = (JSFunction)el).getName()) == null || !name.equals(function.getName()) || (!prevFunction.isGetProperty() || !function.isSetProperty()) && (!prevFunction.isSetProperty() || !function.isGetProperty()) || (doc = JSDocumentationUtils.findDocComment((PsiElement)prevFunction)) == null) break;
                    return prevFunction;
                }
            }
            return psiElement;
        }
        if (object instanceof JSProperty || object instanceof JSStatement || object instanceof JSClass) {
            return (PsiElement)object;
        }
        if (object instanceof PsiElement) {
            PsiElement parent = ((PsiElement)object).getParent();
            if (parent instanceof JSAssignmentExpression) {
                return SharedImplUtil.getParent((ASTNode)parent.getNode());
            }
            if (parent instanceof JSAttribute) {
                PsiElement grandParent = parent.getParent();
                if (grandParent.getFirstChild() == parent) {
                    PsiElement element = grandParent.getParent();
                    if (element instanceof JSFile) {
                        return grandParent;
                    }
                    return element;
                }
                return parent;
            }
            return (PsiElement)object;
        }
        return null;
    }

    @Nullable
    public PsiComment findExistingDocComment(PsiComment contextElement) {
        return contextElement;
    }

    @Nullable
    public Pair<PsiElement, PsiComment> parseContext(@NotNull PsiElement startPoint) {
        JSElement context;
        if (startPoint == null) {
            JSDocumentationProvider.$$$reportNull$$$0(43);
        }
        if ((context = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)startPoint, (Class[])new Class[]{JSProperty.class, JSFunction.class, JSExpressionStatement.class, JSVarStatement.class})) != null) {
            return Pair.create((Object)context, (Object)JSDocumentationUtils.findDocComment((PsiElement)context));
        }
        return null;
    }

    @Nullable
    public String generateDocumentationContentStub(PsiComment contextComment) {
        PsiElement el = JSDocumentationUtils.findAttachedElementFromComment(contextComment);
        if (el instanceof JSFunction) {
            return this.doGenerateDoc((JSFunction)el);
        }
        if (el instanceof JSProperty) {
            JSExpression propertyValue = ((JSProperty)el).getValue();
            if (propertyValue instanceof JSFunction) {
                return this.doGenerateDoc((JSFunction)propertyValue);
            }
        } else if (el instanceof JSDefinitionExpression) {
            PsiElement expression = el.getParent();
            if (expression instanceof JSAssignmentExpression) {
                JSExpression rOperand = ((JSAssignmentExpression)expression).getROperand();
                if (rOperand instanceof JSFunctionExpression) {
                    return this.doGenerateDoc((JSFunction)rOperand);
                }
                return this.doGenerateDoc(rOperand);
            }
        } else if (el instanceof JSVariable) {
            JSExpression expression = ((JSVariable)el).getInitializer();
            if (expression instanceof JSFunctionExpression) {
                return this.doGenerateDoc((JSFunction)expression);
            }
            return this.doGenerateDoc(expression);
        }
        return null;
    }

    @Nullable
    private String doGenerateDoc(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)expression.getProject());
        if (dumbService.isDumb()) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        if (jsType == null || jsType instanceof JSVoidType || jsType instanceof JSAnyType && !jsType.getSource().isExplicitlyDeclared()) {
            return null;
        }
        String type = this.getTypeTextForGenerateDoc(jsType);
        type = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(type);
        StringBuilder builder = new StringBuilder();
        builder.append("* @type {").append(type).append("}\n");
        String name = null;
        PsiElement parent = expression.getParent();
        if (parent instanceof JSNamedElement) {
            name = ((JSNamedElement)parent).getName();
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression operand = ((JSAssignmentExpression)parent).getLOperand();
            if (operand instanceof JSDefinitionExpression) {
                operand = ((JSDefinitionExpression)operand).getExpression();
            }
            if (operand instanceof JSReferenceExpression) {
                name = ((JSReferenceExpression)operand).getReferenceName();
            }
        }
        if (!StringUtil.isEmpty((String)name)) {
            JSDocumentationProvider.appendPrivate(builder, name);
        }
        return builder.toString();
    }

    @NotNull
    private String doGenerateDoc(@NotNull JSFunction function) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(44);
        }
        StringBuilder builder = new StringBuilder();
        JSParameterList parameterList = function.getParameterList();
        if (parameterList != null) {
            for (JSParameter parameter : parameterList.getParameterVariables()) {
                this.appendParameterDoc(builder, parameter);
                builder.append("\n");
            }
        }
        if (DumbService.isDumb((Project)function.getProject())) {
            String string = builder.toString();
            if (string == null) {
                JSDocumentationProvider.$$$reportNull$$$0(45);
            }
            return string;
        }
        this.appendFunctionInfoDoc(function, builder);
        String string = builder.toString();
        if (string == null) {
            JSDocumentationProvider.$$$reportNull$$$0(46);
        }
        return string;
    }

    protected void appendFunctionInfoDoc(@NotNull JSFunction function, @NotNull StringBuilder builder) {
        JSQualifiedNamedElement initializedElement;
        JSType returnType;
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (builder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(48);
        }
        if ((returnType = this.getFunctionReturnTypeForInfoDoc(function)) != null && !(returnType instanceof JSVoidType)) {
            String typeString = JSTypeUtils.transformActionScriptSpecificTypesIntoEcma(this.getTypeTextForGenerateDoc(returnType));
            builder.append("* @").append(JSDocumentationProvider.getReturnTag()).append(" {").append(typeString).append("}\n");
        }
        String name = function.getName();
        if (function instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)function)) != null) {
            name = initializedElement.getName();
        }
        if (!StringUtil.isEmpty((String)name)) {
            if (Character.isUpperCase(name.charAt(0))) {
                builder.append("* @constructor\n");
            }
            JSDocumentationProvider.appendPrivate(builder, name);
        }
    }

    @Nullable
    protected JSType getFunctionReturnTypeForInfoDoc(@NotNull JSFunction function) {
        if (function == null) {
            JSDocumentationProvider.$$$reportNull$$$0(49);
        }
        return TypeFromUsageDetector.detectTypeFromUsage((PsiElement)function, function.getContainingFile());
    }

    protected void appendParameterDoc(@NotNull StringBuilder builder, @NotNull JSParameter parameter) {
        if (builder == null) {
            JSDocumentationProvider.$$$reportNull$$$0(50);
        }
        if (parameter == null) {
            JSDocumentationProvider.$$$reportNull$$$0(51);
        }
        builder.append("* @param ").append(parameter.getName());
    }

    public static String getReturnTag() {
        return PropertiesComponent.getInstance().getValue(RETURN_TAG_PROPERTY, "returns");
    }

    public static void setReturnTag(String returnTag) {
        PropertiesComponent.getInstance().setValue(RETURN_TAG_PROPERTY, returnTag);
    }

    private static void appendPrivate(StringBuilder builder, String name) {
        if (name.endsWith("_") || name.startsWith("_")) {
            builder.append("* @private\n");
        }
    }

    @Nullable
    public String tryGetSeeAlsoLink(String remainingLineContent, PsiElement element) {
        PsiElement resolvedElement = this.getDocumentationElementForLink(element.getManager(), remainingLineContent, element);
        if (resolvedElement != null) {
            return remainingLineContent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElement";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawType";
                break;
            }
            case 14: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 15: 
            case 32: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableOrField";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFile";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_element";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocumentationProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeTextForGenerateDoc";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionPrefix";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVarPrefix";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocumentationBuilder";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findTargetElement";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findFirstDocComment";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "doGenerateDoc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForFunction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeTextForQuickNavigate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionAttributesAndName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForQuickNavigate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTypeTextForGenerateDoc";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionPrefix";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendParentInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForVariableOrField";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableOrFieldType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVariableOrFieldType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableInitializer";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVarPrefix";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createQuickNavigateForJSClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "appendClassAttributesAndName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsAndImplements";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "generateReferenceTargetList";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "patchNodejsFQN";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createDocumentationBuilder";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "doGetCommentTextFromComment";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentationForImplicitElement";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findFirstDocComment";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseContext";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateDoc";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionInfoDoc";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionReturnTypeForInfoDoc";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterDoc";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 24: 
            case 33: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 45: 
            case 46: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

