/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import org.jetbrains.annotations.NotNull;

public class JSSymbolPresentationUtils {
    public static String buildFunctionSignaturePresentation(@NotNull JSFunctionItem psiElement) {
        JSTypeSource source;
        JSParameterItem[] parameterList;
        if (psiElement == null) {
            JSSymbolPresentationUtils.$$$reportNull$$$0(0);
        }
        String name = "(";
        for (JSParameterItem p : parameterList = psiElement.getParameters()) {
            JSType variableType;
            if (!name.endsWith("(")) {
                name = name + ", ";
            }
            name = name + p.getName();
            if (p.isOptional() && p.getTypeDecorator().isExplicitlyDeclared()) {
                name = name + "?";
            }
            if ((variableType = p.getType()) == null) continue;
            name = name + ":" + variableType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        name = name + ")";
        JSType returnType = psiElement.getReturnType();
        JSTypeSource jSTypeSource = source = returnType != null ? returnType.getSource() : null;
        if (returnType != null && !(returnType instanceof JSTypeofTypeImpl) && source.isExplicitlyDeclared()) {
            name = name + ":" + returnType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/documentation/JSSymbolPresentationUtils", "buildFunctionSignaturePresentation"));
    }
}

