/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.openapi.util.text.StringUtil;
import java.text.DecimalFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConstantValueImpl
implements EnumConstantValue {
    @Nullable
    private final String unparsedValue;
    private String stringValue = null;
    private boolean stringValueComputed = false;
    private Double numericValue = null;
    private boolean numericValueComputed = false;
    private int numericDelta = 0;

    public EnumConstantValueImpl(@Nullable String unparsedValue) {
        this.unparsedValue = unparsedValue;
    }

    public synchronized String getStringValue() {
        if (!this.stringValueComputed) {
            if (this.unparsedValue != null && StringUtil.isQuotedString((String)this.unparsedValue) && this.numericDelta == 0) {
                this.stringValue = JSStringUtil.unquoteAndUnescapeString(this.unparsedValue);
            }
            this.stringValueComputed = true;
        }
        return this.stringValue;
    }

    public synchronized Double getNumericValue() {
        if (!this.numericValueComputed) {
            Double numericValue;
            if (this.unparsedValue != null && JSStringUtil.isNumericValueStart(this.unparsedValue, true) && (numericValue = JSNumberParser.tryParseNumericValue(this.unparsedValue)) != null) {
                this.numericValue = numericValue + (double)this.numericDelta;
            }
            this.numericValueComputed = true;
        }
        return this.numericValue;
    }

    @NotNull
    public EnumConstantValueImpl increaseNumericDelta(int delta) {
        EnumConstantValueImpl newEnum = new EnumConstantValueImpl(this.unparsedValue);
        newEnum.numericDelta += delta;
        EnumConstantValueImpl enumConstantValueImpl = newEnum;
        if (enumConstantValueImpl == null) {
            EnumConstantValueImpl.$$$reportNull$$$0(0);
        }
        return enumConstantValueImpl;
    }

    @Nullable
    public String getSerializedString() {
        return this.unparsedValue;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public String getDescription() {
        String stringValue = this.getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        Double doubleValue = this.getNumericValue();
        if (doubleValue != null) {
            return new DecimalFormat("#.######").format(doubleValue);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ecmascript6/EnumConstantValueImpl", "increaseNumericDelta"));
    }
}

