/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(1);
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, false, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(3);
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(4);
        }
        if (source == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(5);
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, true, (Set<Pair<JSQualifiedName, PsiElement>>)new THashSet());
        if (jSTypeResolveResult == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(6);
        }
        return jSTypeResolveResult;
    }

    @NotNull
    public static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, boolean includeAugmentations, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        PsiElement source;
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(7);
        }
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(8);
        }
        if (visited == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(9);
        }
        if ((source = TypeScriptImportHandler.getSourceElement(sourceRaw)) == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(10);
            }
            return jSTypeResolveResult;
        }
        List elements = TypeScriptImportHandler.resolveTypeElements(type, source, visited, typeContext, includeAugmentations);
        PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, element -> TypeScriptConfigService.Provider.isAccessible(finalSource, element) && TypeScriptImportHandler.checkModulesAccess(finalSource, element))).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(11);
            }
            return jSTypeResolveResult;
        }
        String qName = TypeScriptImportHandler.getQualifiedName(elements);
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(12);
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static String getQualifiedName(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(13);
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || TypeScriptPsiUtil.isFromAugmentationModule(psiElement)) continue;
            String string = StringUtil.notNullize((String)((JSQualifiedNamedElement)psiElement).getQualifiedName());
            if (string == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(14);
            }
            return string;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = element instanceof JSQualifiedNamedElement ? StringUtil.notNullize((String)((JSQualifiedNamedElement)element).getQualifiedName()) : "";
        if (string == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        PsiElement type;
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(16);
        }
        if ((type = PsiTreeUtil.getContextOfType((PsiElement)sourceRaw, (boolean)false, (Class[])new Class[]{JSSourceElement.class})) instanceof TypeScriptType) {
            type = TypeScriptImportHandler.getSourceElement(sourceRaw.getParent());
        }
        if (type instanceof TypeScriptModule || type instanceof JSFile || type == null) {
            return type;
        }
        PsiElement parent = type.getContext();
        if (type instanceof JSBlockStatement) {
            if (parent instanceof JSFunction) {
                return parent;
            }
            return type;
        }
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @Override
    public String getQualifiedNameResolvedType(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(17);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(18);
        }
        return new TypeScriptQualifiedNameResolver(context, true, true, (Set<Pair<JSQualifiedName, PsiElement>>)ContainerUtil.newTroveSet()).resolveName(type);
    }

    @NotNull
    private static Collection<PsiElement> resolveTypeElements(@NotNull String qName, @NotNull PsiElement source, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited, boolean typeContext, boolean includeAugmentations) {
        if (qName == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(19);
        }
        if (source == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(20);
        }
        if (visited == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(21);
        }
        Collection<PsiElement> collection = new TypeScriptQualifiedNameResolver(source, typeContext, includeAugmentations, visited).resolveQualifiedName(qName);
        if (collection == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(22);
        }
        return collection;
    }

    public static boolean checkModulesAccess(PsiElement source, PsiElement element) {
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRaw";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameImpl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMainElementName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameImpl";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameResolvedType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

