/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.Option;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInlayParameterHintsProvider
implements InlayParameterHintsProvider {
    private static final Option NAMES_FOR_ALL_ARGS = new Option("js.show.names.for.all.args", "Show name for all arguments", false);
    private static final Set<String> DEFAULT_BLACKLIST = ContainerUtil.immutableSet((Object[])new String[]{"(begin*, end*)", "(start*, end*)", "(first*, last*)", "(first*, second*)", "(from*, to*)", "(min*, max*)", "(key, value)", "(format, arg*)", "(message)", "(message, error)", "*.set*(*)", "*.add(*)", "*.push(*)", "*.concat(*)", "*.join(*)", "*.forEach(*)", "*.map(*)", "*.reduce(*, *)", "*.set(*,*)", "*.filter(*)", "*.get(*)", "*.create(*)", "*.log(*)", "*.log(*, *)", "*.error(*)", "*.error(*, *)", "*.debug(*)", "*.debug(*, *)", "*.append(*)", "*.charAt(*)", "*.charCodeAt(*)", "*.indexOf(*, *)", "*.lastIndexOf(*, *)", "*.contains(*)", "*.startsWith(*)", "*.startsWith(*, *)", "*.endsWith(*)", "*.endsWith(*, *)"});

    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element) {
        JSFunction psiElement;
        if (element == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(0);
        }
        if ((psiElement = this.resolveFunction(element)) == null) {
            return null;
        }
        JSParameterListElement[] parameters = psiElement.getParameters();
        if (parameters.length == 0) {
            return null;
        }
        List parameterNames = Arrays.stream(parameters).map(el -> el.getName()).collect(Collectors.toList());
        String qName = psiElement.getQualifiedName();
        if (qName != null) {
            return new HintInfo.MethodInfo(qName, parameterNames);
        }
        return null;
    }

    @Nullable
    public JSFunction resolveFunction(@Nullable PsiElement element) {
        if (!(element instanceof JSCallExpression)) {
            return null;
        }
        if (element.getParent() instanceof ES6Decorator) {
            return null;
        }
        JSExpression expression = ((JSCallExpression)element).getMethodExpression();
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        ResolveResult[] results = ((JSReferenceExpression)expression).multiResolve(false);
        PsiElement resolve = JSResolveResult.resolve(results);
        if (resolve == null) {
            return null;
        }
        PsiElement psiElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement(resolve);
        return psiElement instanceof JSFunction ? (JSFunction)psiElement : null;
    }

    @NotNull
    public List<Option> getSupportedOptions() {
        List list = ContainerUtil.list((Object[])new Option[]{NAMES_FOR_ALL_ARGS});
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof JSCallExpression)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        boolean showAll = NAMES_FOR_ALL_ARGS.get();
        JSCallExpression callExpression = (JSCallExpression)element;
        JSFunction function = this.resolveFunction(element);
        if (function != null) {
            JSExpression[] arguments = callExpression.getArguments();
            JSParameterListElement[] parameters = function.getParameters();
            if (parameters.length == 0) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(4);
                }
                return list;
            }
            int toStop = Math.min(arguments.length, parameters.length);
            ArrayList list = ContainerUtil.newArrayListWithCapacity((int)toStop);
            for (int i = 0; i < toStop; ++i) {
                JSExpression argument = arguments[i];
                JSParameterListElement parameter = parameters[i];
                if (!TypeScriptInlayParameterHintsProvider.shouldInlineParameterName((PsiElement)argument, parameter, showAll)) continue;
                list.add(this.createInlayInfo(argument, parameter));
            }
            ArrayList arrayList = list;
            if (arrayList == null) {
                TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(5);
            }
            return arrayList;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public InlayInfo createInlayInfo(JSExpression argument, JSParameterListElement parameter) {
        InlayInfo inlayInfo = new InlayInfo(StringUtil.notNullize((String)parameter.getName()), argument.getTextOffset());
        if (inlayInfo == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(7);
        }
        return inlayInfo;
    }

    static boolean isLiteralOrUndefined(@Nullable PsiElement argument) {
        return argument instanceof JSLiteralExpression || argument instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, "undefined");
    }

    private static boolean shouldInlineParameterName(@NotNull PsiElement argument, @NotNull JSParameterListElement parameter, boolean showAll) {
        if (argument == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(9);
        }
        if (parameter instanceof JSDestructuringParameter) {
            return false;
        }
        String name = parameter.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (argument instanceof JSReferenceExpression && JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)argument, name)) {
            return false;
        }
        if (showAll) {
            return true;
        }
        if (argument instanceof JSBinaryExpression || argument instanceof JSConditionalExpression || argument instanceof JSObjectLiteralExpression || argument instanceof JSArrayLiteralExpression || argument instanceof JSFunctionExpression && ((JSFunctionExpression)argument).getName() == null) {
            return true;
        }
        return TypeScriptInlayParameterHintsProvider.isLiteralOrUndefined(argument);
    }

    public String getBlacklistExplanationHTML() {
        return JSBundle.message((String)"ts.inlay.hints.blacklist.pattern.explanation", (Object[])new Object[0]);
    }

    @NotNull
    public Set<String> getDefaultBlackList() {
        Set<String> set = DEFAULT_BLACKLIST;
        if (set == null) {
            TypeScriptInlayParameterHintsProvider.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/editing/TypeScriptInlayParameterHintsProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedOptions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterHints";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlayInfo";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBlackList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHintInfo";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParameterHints";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineParameterName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

