/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.annotations.NotNull;

public class FlowJSSettings {
    private final boolean isTypeCheckingEnabled;
    @NotNull
    private final String myFlowPath;
    private final boolean isOtherServicesEnabled;
    private final boolean isFlowResolveEnable;
    private final boolean isAutoSaveEnabled;
    public static final FlowJSSettings DEFAULT = new Builder().build();

    public FlowJSSettings(@NotNull Builder builder) {
        if (builder == null) {
            FlowJSSettings.$$$reportNull$$$0(0);
        }
        this.isTypeCheckingEnabled = builder.isTypeCheckingEnabled;
        this.myFlowPath = FileUtil.toSystemIndependentName((String)builder.myFlowPath);
        this.isOtherServicesEnabled = builder.isOtherServicesEnabled;
        this.isFlowResolveEnable = builder.isFlowResolveEnable;
        this.isAutoSaveEnabled = builder.isAutoSaveEnabled;
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder().setTypeCheckingEnabled(this.isTypeCheckingEnabled).setFlowExecutablePath(this.myFlowPath).setOtherServicesEnabled(this.isOtherServicesEnabled).setFlowResolveEnable(this.isFlowResolveEnable).setAutoSaveEnabled(this.isAutoSaveEnabled);
        if (builder == null) {
            FlowJSSettings.$$$reportNull$$$0(1);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowJSSettings settings = (FlowJSSettings)o;
        if (!this.myFlowPath.equals(settings.myFlowPath)) {
            return false;
        }
        if (this.isTypeCheckingEnabled != settings.isTypeCheckingEnabled) {
            return false;
        }
        if (this.isOtherServicesEnabled != settings.isOtherServicesEnabled) {
            return false;
        }
        if (this.isFlowResolveEnable != settings.isFlowResolveEnable) {
            return false;
        }
        return this.isAutoSaveEnabled == settings.isAutoSaveEnabled;
    }

    public int hashCode() {
        int result = this.myFlowPath.hashCode();
        result = 31 * result + (this.isTypeCheckingEnabled ? 1 : 0);
        result = 31 * result + (this.isOtherServicesEnabled ? 1 : 0);
        result = 31 * result + (this.isFlowResolveEnable ? 1 : 0);
        result = 31 * result + (this.isAutoSaveEnabled ? 0 : 1);
        return result;
    }

    public String toString() {
        return "FlowSettings{myFlowPath='" + this.myFlowPath + '\'' + '}';
    }

    public boolean isTypeCheckingEnabled() {
        return this.isTypeCheckingEnabled;
    }

    public boolean isOtherServicesEnabled() {
        return this.isOtherServicesEnabled;
    }

    @NotNull
    public String getFlowExecutablePath() {
        String string = this.myFlowPath;
        if (string == null) {
            FlowJSSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isResolveByServerEnabled() {
        return this.isFlowResolveEnable;
    }

    public boolean isAutoSaveEnabled() {
        return this.isAutoSaveEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private String myFlowPath = "";
        private boolean isTypeCheckingEnabled = true;
        private boolean isOtherServicesEnabled = true;
        private boolean isFlowResolveEnable = false;
        private boolean isAutoSaveEnabled = true;

        @NotNull
        public Builder setFlowExecutablePath(@NotNull String flowPath) {
            if (flowPath == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myFlowPath = flowPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setFlowResolveEnable(boolean isFlowResolveEnable) {
            this.isFlowResolveEnable = isFlowResolveEnable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setTypeCheckingEnabled(boolean isEnabled) {
            this.isTypeCheckingEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setOtherServicesEnabled(boolean isEnabled) {
            this.isOtherServicesEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder setAutoSaveEnabled(boolean isEnabled) {
            this.isAutoSaveEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder;
        }

        @NotNull
        public FlowJSSettings build() {
            FlowJSSettings flowJSSettings = new FlowJSSettings(this);
            if (flowJSSettings == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return flowJSSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flowPath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFlowExecutablePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFlowResolveEnable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTypeCheckingEnabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOtherServicesEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAutoSaveEnabled";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setFlowExecutablePath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

