/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMethodsFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class OverrideMethodsFix
extends BaseCreateMethodsFix<JSFunction> {
    public OverrideMethodsFix(JSClass jsClass) {
        super(jsClass);
    }

    @Override
    protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSFunction func) {
        return OverrideMethodsFix.buildDelegatingText(retType, parameterList, func, "super", (PsiElement)(this.anchor != null ? this.anchor : this.myJsClass));
    }

    public static String buildDelegatingText(String retType, JSParameterList parameterList, JSFunction func, String qualifier, @NotNull PsiElement anchor) {
        if (anchor == null) {
            OverrideMethodsFix.$$$reportNull$$$0(0);
        }
        StringBuilder functionText = new StringBuilder();
        functionText.append("{\n");
        OverrideMethodsFix.addText(retType, parameterList, func, qualifier, anchor, functionText);
        functionText.append("}");
        return functionText.toString();
    }

    private static void addText(String retType, JSParameterList parameterList, JSFunction func, String qualifier, @NotNull PsiElement anchor, StringBuilder functionText) {
        if (anchor == null) {
            OverrideMethodsFix.$$$reportNull$$$0(1);
        }
        boolean isVoid = "void".equals(retType);
        JSAttributeList attributeList = func.getAttributeList();
        if (attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.ABSTRACT) && !isVoid) {
            TypeScriptImplementMethodsFix.appendEmptyBodyWithReturn((PsiElement)func, functionText);
            return;
        }
        if (!isVoid) {
            functionText.append("return");
        }
        functionText.append(" ").append(qualifier);
        String name = func.getName();
        boolean indexer = false;
        if (!name.startsWith("[Symbol.")) {
            if (!JSSymbolUtil.isValidPropertyName(name)) {
                functionText.append("[");
                indexer = true;
            } else {
                functionText.append(".");
            }
        }
        if (attributeList != null && attributeList.getNamespace() != null) {
            functionText.append(OverrideMethodsFix.calcNamespaceId(attributeList, JSResolveUtil.getNamespaceValue(attributeList), anchor)).append("::");
        }
        functionText.append(JSSymbolUtil.handleSpecialPropertyNames(name, JSCodeStyleSettings.getQuoteChar((PsiElement)func)));
        if (indexer) {
            functionText.append("]");
        }
        if (!func.isGetProperty()) {
            if (func.isSetProperty()) {
                functionText.append("=").append(parameterList.getParameters()[0].getName());
            } else {
                functionText.append("(");
                boolean first = true;
                for (JSParameterListElement param : parameterList.getParameters()) {
                    if (!first) {
                        functionText.append(",");
                    }
                    first = false;
                    functionText.append(param.getName());
                }
                functionText.append(")");
            }
        }
        functionText.append(JSCodeStyleSettings.getSemicolon(func.getContainingFile()));
    }

    @Override
    protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSFunction function) {
        super.adjustAttributeList(attributeListWrapper, function);
        if (DialectDetector.isActionScript((PsiElement)this.myJsClass)) {
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.DYNAMIC, false);
            PsiElement element = JSResolveUtil.findParent((PsiElement)function);
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, element instanceof JSClass && !JSResolveUtil.isObjectClass((JSClass)element));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "anchor";
        objectArray2[1] = "com/intellij/lang/javascript/generation/OverrideMethodsFix";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDelegatingText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addText";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

