/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSModuleImportOptimizerBase
implements ImportOptimizer {
    @NotNull
    public Runnable processFile(PsiFile file) {
        if (!JSOptimizeImportUtil.isAvailable(file)) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(0);
            }
            return runnable;
        }
        Collection<UnusedModuleInfo> infos = this.getModulesInfo(file);
        if (infos.isEmpty()) {
            Runnable runnable = EmptyRunnable.INSTANCE;
            if (runnable == null) {
                JSModuleImportOptimizerBase.$$$reportNull$$$0(1);
            }
            return runnable;
        }
        Runnable runnable = () -> {
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)file)) {
                return;
            }
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)file.getProject());
            Document document = manager.getDocument(file);
            if (document != null) {
                manager.commitDocument(document);
            }
            Project project = file.getProject();
            infos.forEach(info -> this.processModule(document, project, (UnusedModuleInfo)info));
        };
        if (runnable == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(2);
        }
        return runnable;
    }

    public void processModule(Document document, Project project, UnusedModuleInfo info) {
        List<PsiElement> oldImports = info.getOldImports();
        HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> commentInfos = JSModuleImportOptimizerBase.getCommentInfos(oldImports, document);
        List<String> importTexts = info.getImportTexts();
        PsiElement anchor = info.getAnchor();
        if (anchor == null) {
            return;
        }
        if (!importTexts.isEmpty()) {
            JSOptimizeImportUtil.addNewImportTexts(importTexts, project, document, anchor);
        }
        this.removeOldImports(oldImports, commentInfos);
    }

    protected void removeOldImports(@NotNull List<PsiElement> oldImports, @NotNull Map<PsiElement, JSOptimizeImportUtil.CommentHolder> comments) {
        if (oldImports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(3);
        }
        if (comments == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < oldImports.size(); ++i) {
            boolean isFirst = i == 0;
            PsiElement declaration = oldImports.get(i);
            JSOptimizeImportUtil.CommentHolder pair = comments.get(declaration);
            List<PsiElement> prevComments = pair.prevComments;
            PsiElement sameLineEndComment = pair.lineComment;
            boolean hasComments = prevComments.size() > 0;
            PsiElement beforeElement = hasComments ? prevComments.get(0) : declaration;
            PsiElement afterElement = sameLineEndComment != null ? sameLineEndComment : declaration;
            JSOptimizeImportUtil.deleteSiblingWhitespaceBetweenImports(beforeElement, afterElement, !isFirst);
            if (hasComments || sameLineEndComment != null) {
                declaration.getParent().deleteChildRange(beforeElement, afterElement);
                continue;
            }
            declaration.delete();
        }
    }

    @NotNull
    private static HashMap<PsiElement, JSOptimizeImportUtil.CommentHolder> getCommentInfos(@NotNull List<PsiElement> imports, @Nullable Document document) {
        if (imports == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(5);
        }
        HashMap prevDeclarations = ContainerUtil.newHashMap();
        for (PsiElement declaration : imports) {
            prevDeclarations.put(declaration, new JSOptimizeImportUtil.CommentHolder(JSOptimizeImportUtil.getPrevComments(document, declaration), JSOptimizeImportUtil.getLineComment(document, declaration)));
        }
        HashMap hashMap = prevDeclarations;
        if (hashMap == null) {
            JSModuleImportOptimizerBase.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    @NotNull
    public abstract Collection<UnusedModuleInfo> getModulesInfo(PsiFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldImports";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/JSModuleImportOptimizerBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeOldImports";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCommentInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface UnusedModuleInfo {
        public List<String> getImportTexts();

        @Nullable
        public PsiElement getAnchor();

        public List<PsiElement> getOldImports();
    }
}

