/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.imports;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JSOptimizeImportUtil {
    public static void addSameLineComments(Document document, @NotNull PsiElement context, @NotNull StringBuilder importBody) {
        if (context == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(0);
        }
        if (importBody == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(1);
        }
        JSOptimizeImportUtil.addSameLineComments(importBody, JSOptimizeImportUtil.getPsiElementsAsStrings(ContainerUtil.createMaybeSingletonList((Object)JSOptimizeImportUtil.getLineComment(document, context))));
    }

    public static void addSameLineComments(@NotNull StringBuilder importBody, @NotNull Collection<String> sameLineComments) {
        if (importBody == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(2);
        }
        if (sameLineComments == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(3);
        }
        if (!sameLineComments.isEmpty()) {
            importBody.append(" ");
            importBody.append(StringUtil.join(sameLineComments, (String)" "));
        }
    }

    public static void fillImportsWithNewLines(@NotNull List<String> importsResult, @NotNull PsiElement context, @NotNull List<String> elements) {
        if (importsResult == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(5);
        }
        if (elements == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(6);
        }
        if (elements.isEmpty()) {
            return;
        }
        if (importsResult.size() > 0) {
            List<PsiElement> whitespaces = JSOptimizeImportUtil.getWhitespacesBeforePrevImport(context);
            if (whitespaces.size() > 0) {
                importsResult.addAll(JSOptimizeImportUtil.getPsiElementsAsStrings(whitespaces));
            } else {
                importsResult.add("\n");
            }
        }
        for (int i = 0; i < elements.size(); ++i) {
            String current = elements.get(i);
            if (i > 0) {
                importsResult.add("\n");
            }
            importsResult.add(current);
        }
    }

    public static boolean isAvailable(@NotNull PsiFile file) {
        DirectoryInfo directoryInfo;
        if (file == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(7);
        }
        if (!file.isValid() || DumbService.getInstance((Project)file.getProject()).isDumb()) {
            return false;
        }
        DirectoryIndex directoryIndex = DirectoryIndex.getInstance((Project)file.getProject());
        JpsModuleSourceRootType sourceRootType = directoryIndex.getSourceRootType(directoryInfo = directoryIndex.getInfoForFile(file.getVirtualFile()));
        return !JavaResourceRootType.TEST_RESOURCE.equals(sourceRootType);
    }

    public static void deleteSiblingWhitespaceBetweenImports(PsiElement beforeElement, PsiElement after, boolean deleteBefore) {
        PsiElement sibling;
        if (deleteBefore) {
            sibling = beforeElement;
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                PsiElement prev = sibling.getPrevSibling();
                if (!JSOptimizeImportUtil.prevIsAcceptable(prev)) continue;
                sibling.delete();
            }
        }
        sibling = after;
        while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
            PsiElement nextSibling = sibling.getNextSibling();
            if (!JSOptimizeImportUtil.nextIsAcceptable(nextSibling)) continue;
            sibling.delete();
        }
    }

    public static boolean prevIsAcceptable(PsiElement prev) {
        return prev == null || JSOptimizeImportUtil.isImport(prev) || prev instanceof PsiWhiteSpace || prev instanceof PsiComment;
    }

    public static boolean isImport(PsiElement prev) {
        return prev instanceof ES6ImportDeclaration || prev instanceof TypeScriptImportStatement || prev instanceof JSImportStatement;
    }

    public static List<String> getPsiElementsAsStrings(@NotNull Collection<PsiElement> toProcess) {
        if (toProcess == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(8);
        }
        return toProcess.stream().map(el -> el.getText()).collect(Collectors.toList());
    }

    public static List<PsiElement> getWhitespacesBeforePrevImport(@NotNull PsiElement importDeclaration) {
        if (importDeclaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(9);
        }
        PsiElement sibling = importDeclaration;
        ArrayList siblings = ContainerUtil.newArrayList();
        while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
            siblings.add(0, sibling);
            PsiElement prev = sibling.getPrevSibling();
            if (!JSOptimizeImportUtil.isImport(prev)) continue;
            return siblings;
        }
        return ContainerUtil.emptyList();
    }

    public static boolean nextIsAcceptable(PsiElement next) {
        return next == null || JSOptimizeImportUtil.isImport(next) || next instanceof PsiWhiteSpace;
    }

    public static boolean isSameLineElement(@NotNull Document document, @NotNull PsiElement startElement, @NotNull PsiElement endElement, int offsetLine) {
        if (document == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(10);
        }
        if (startElement == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(11);
        }
        if (endElement == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(12);
        }
        int startElementEndOffset = document.getLineNumber(startElement.getTextRange().getEndOffset());
        int endElementStartOffset = document.getLineNumber(endElement.getTextRange().getStartOffset());
        return endElementStartOffset == offsetLine + startElementEndOffset;
    }

    public static PsiElement getLineComment(@Nullable Document document, @NotNull PsiElement declaration) {
        if (declaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(13);
        }
        if (document == null) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)declaration);
        if (next instanceof PsiComment) {
            boolean isSameLineElements = JSOptimizeImportUtil.isSameLineElement(document, declaration, next, 0);
            return isSameLineElements ? next : null;
        }
        return null;
    }

    @NotNull
    public static List<PsiElement> getPrevComments(@Nullable Document document, @NotNull PsiElement declaration) {
        PsiElement nextPrev;
        if (declaration == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(14);
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)declaration);
        if (document == null || prev == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (!JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 1) && !JSOptimizeImportUtil.isSameLineElement(document, prev, declaration, 0)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSOptimizeImportUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        ArrayList comments = ContainerUtil.newArrayList();
        while (prev instanceof PsiComment && ((nextPrev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prev)) == null || nextPrev instanceof PsiComment || !JSOptimizeImportUtil.isSameLineElement(document, prev, nextPrev, 0))) {
            comments.add(0, prev);
            prev = nextPrev;
        }
        ArrayList arrayList = comments;
        if (arrayList == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    public static void addNewImportTexts(@NotNull List<String> importTexts, @NotNull Project project, @Nullable Document document, @NotNull PsiElement context) {
        if (importTexts == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(18);
        }
        if (project == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(19);
        }
        if (context == null) {
            JSOptimizeImportUtil.$$$reportNull$$$0(20);
        }
        String text = StringUtil.join(importTexts, (String)"");
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement(context);
        if (dialect == null) {
            dialect = JavascriptLanguage.INSTANCE;
        }
        PsiFile newFile = PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)dialect, (CharSequence)text, true, true);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        newFile = codeStyleManager.reformat((PsiElement)newFile);
        List<PsiElement> comments = JSOptimizeImportUtil.getPrevComments(document, context);
        PsiElement anchor = context;
        if (comments.size() > 0) {
            anchor = comments.get(0);
        }
        PsiElement siblingBeforeAnchor = PsiTreeUtil.skipWhitespacesBackward((PsiElement)anchor);
        PsiElement parent = anchor.getParent();
        PsiElement element = SharedImplUtil.addRange((PsiElement)parent, (PsiElement)newFile.getFirstChild(), (PsiElement)newFile.getLastChild(), (ASTNode)anchor.getNode(), (Boolean)Boolean.TRUE);
        if (element instanceof PsiComment && !(siblingBeforeAnchor instanceof PsiComment)) {
            JSChangeUtil.addWs(parent.getNode(), element.getNode(), "\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importBody";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameLineComments";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importsResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/imports/JSOptimizeImportUtil";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importTexts";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/imports/JSOptimizeImportUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrevComments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSameLineComments";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillImportsWithNewLines";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementsAsStrings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWhitespacesBeforePrevImport";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSameLineElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLineComment";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComments";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addNewImportTexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CommentHolder {
        public final List<PsiElement> prevComments;
        public final PsiElement lineComment;

        public CommentHolder(List<PsiElement> prevComments, PsiElement lineComment) {
            this.prevComments = prevComments;
            this.lineComment = lineComment;
        }
    }
}

