/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSSymbolNamespaceImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSDefinitionExpressionImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSGlobalTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNamespaceEvaluationResult
extends JSSymbolNamespaceImpl {
    @Nullable
    final JSElement mySource;
    private final boolean myInheritsFunction;

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, @Nullable JSElement source) {
        if (jsContext == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(0);
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, false, source);
    }

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, boolean inheritsFunction, @Nullable JSElement source) {
        if (jsContext == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(1);
        }
        this(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, false, inheritsFunction, source);
    }

    public JSNamespaceEvaluationResult(@Nullable JSQualifiedName qualifiedName, @NotNull JSContext jsContext, boolean isExplicitlyDeclared, boolean isDeclaration, boolean isLocal, boolean inheritsFunction, @Nullable JSElement source) {
        if (jsContext == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(2);
        }
        super(qualifiedName, jsContext, isExplicitlyDeclared, isDeclaration, isLocal);
        this.mySource = source;
        this.myInheritsFunction = inheritsFunction;
    }

    @Nullable
    public static JSNamespaceEvaluationResult fromType(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        if ((type = JSTypeUtils.getNamedType(type)) == null) {
            return null;
        }
        String typeText = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (typeText == null) {
            return null;
        }
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(typeText);
        JSTypeContext typeContext = ((JSNamedType)type).getTypeContext();
        JSContext context = typeContext.toJSContext();
        boolean isDeclaration = typeContext != JSTypeContext.INSTANCE;
        PsiElement element = type.getSource().getSourceElement();
        JSElement source = element instanceof JSElement ? (JSElement)element : null;
        return new JSNamespaceEvaluationResult((JSQualifiedName)name, context, type.getSource().isExplicitlyDeclared(), isDeclaration, source);
    }

    @Nullable
    public static JSNamespaceEvaluationResult buildProvidedNamespace(@NotNull JSElementBase element, boolean isExplicitlyDeclared, @Nullable Set<PsiElement> visited) {
        JSContext jsContext;
        JSQualifiedName qName;
        JSNamespace ns;
        String name;
        if (element == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(name = element.getName()))) {
            return null;
        }
        Object object = ns = visited != null && element instanceof JSDefinitionExpressionImpl ? ((JSDefinitionExpressionImpl)element).calculateSymbolNamespace(visited) : element.getJSNamespace();
        if ("prototype".equals(name)) {
            qName = ns.getQualifiedName();
            jsContext = JSContext.INSTANCE;
        } else {
            qName = JSQualifiedNameImpl.create(name, ns.getQualifiedName());
            jsContext = JSContext.STATIC;
        }
        return new JSNamespaceEvaluationResult(qName, jsContext, ns.isExplicitlyDeclared() && isExplicitlyDeclared, true, ns.isLocal(), false, element instanceof JSElement ? (JSElement)element : null);
    }

    @Nullable
    public JSElement getSource() {
        return this.mySource;
    }

    @Override
    @NotNull
    public JSType toType(@Nullable PsiElement defaultSource) {
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)(this.mySource != null ? this.mySource : defaultSource), this.isExplicitlyDeclared());
        JSQualifiedName name = this.getQualifiedName();
        JSGlobalTypeImpl jSGlobalTypeImpl = name == null ? new JSGlobalTypeImpl(typeSource) : JSNamedType.createType(name.getQualifiedName(), typeSource, JSTypeContext.fromJSContext(this.getJSContext(), this.isDeclaration()), this.myInheritsFunction);
        if (jSGlobalTypeImpl == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(4);
        }
        return jSGlobalTypeImpl;
    }

    @NotNull
    public JSNamespaceEvaluationResult withExplicitlyDeclared(boolean explicitlyDeclared) {
        JSNamespaceEvaluationResult jSNamespaceEvaluationResult = explicitlyDeclared == this.isExplicitlyDeclared() ? this : new JSNamespaceEvaluationResult(this.getQualifiedName(), this.getJSContext(), explicitlyDeclared, this.isDeclaration(), this.isLocal(), this.inheritsFunction(), this.getSource());
        if (jSNamespaceEvaluationResult == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(5);
        }
        return jSNamespaceEvaluationResult;
    }

    @NotNull
    public JSNamespaceEvaluationResult withJSContext(@NotNull JSContext context) {
        if (context == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(6);
        }
        JSNamespaceEvaluationResult jSNamespaceEvaluationResult = context == this.getJSContext() ? this : new JSNamespaceEvaluationResult(this.getQualifiedName(), context, this.isExplicitlyDeclared(), this.isDeclaration(), this.isLocal(), this.inheritsFunction(), this.getSource());
        if (jSNamespaceEvaluationResult == null) {
            JSNamespaceEvaluationResult.$$$reportNull$$$0(7);
        }
        return jSNamespaceEvaluationResult;
    }

    @Nullable
    public static String getQualifiedName(@Nullable JSNamespaceEvaluationResult ns) {
        if (ns == null) {
            return null;
        }
        JSQualifiedName qName = ns.getQualifiedName();
        return qName != null ? qName.getQualifiedName() : null;
    }

    public boolean inheritsFunction() {
        return this.myInheritsFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSNamespaceEvaluationResult";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withExplicitlyDeclared";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withJSContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildProvidedNamespace";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withJSContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

